/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionBase;
import com.aelitis.azureus.core.networkmanager.RateHandler;
import com.aelitis.azureus.core.networkmanager.impl.RateControlledEntity;
import java.io.IOException;
import java.util.ArrayList;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;

public class MultiPeerDownloader
implements RateControlledEntity {
    private volatile ArrayList connections_cow = new ArrayList();
    private final AEMonitor connections_mon = new AEMonitor("MultiPeerDownloader");
    private final RateHandler main_handler;
    private int next_position = 0;

    public MultiPeerDownloader(RateHandler rateHandler) {
        this.main_handler = rateHandler;
    }

    @Override
    public RateHandler getRateHandler() {
        return this.main_handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPeerConnection(NetworkConnectionBase networkConnectionBase) {
        try {
            this.connections_mon.enter();
            ArrayList<NetworkConnectionBase> arrayList = new ArrayList<NetworkConnectionBase>(this.connections_cow.size() + 1);
            arrayList.addAll(this.connections_cow);
            arrayList.add(networkConnectionBase);
            this.connections_cow = arrayList;
        }
        finally {
            this.connections_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePeerConnection(NetworkConnectionBase networkConnectionBase) {
        try {
            this.connections_mon.enter();
            ArrayList arrayList = new ArrayList(this.connections_cow);
            boolean bl = arrayList.remove(networkConnectionBase);
            if (!bl) {
                boolean bl2 = false;
                return bl2;
            }
            this.connections_cow = arrayList;
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.connections_mon.exit();
        }
    }

    @Override
    public boolean canProcess(EventWaiter eventWaiter) {
        return this.main_handler.getCurrentNumBytesAllowed() >= 1;
    }

    @Override
    public long getBytesReadyToWrite() {
        return 0L;
    }

    @Override
    public int getConnectionCount() {
        return this.connections_cow.size();
    }

    @Override
    public int getReadyConnectionCount(EventWaiter eventWaiter) {
        int n = 0;
        for (NetworkConnectionBase networkConnectionBase : this.connections_cow) {
            if (networkConnectionBase.getTransportBase().isReadyForRead(eventWaiter) != 0L) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int doProcessing(EventWaiter eventWaiter, int n) {
        int n2 = this.main_handler.getCurrentNumBytesAllowed();
        if (n2 < 1) {
            return 0;
        }
        if (n > 0 && n < n2) {
            n2 = n;
        }
        ArrayList arrayList = this.connections_cow;
        int n3 = 0;
        int n4 = n2;
        while (n4 > 0 && n3 < arrayList.size()) {
            this.next_position = this.next_position >= arrayList.size() ? 0 : this.next_position;
            NetworkConnectionBase networkConnectionBase = (NetworkConnectionBase)arrayList.get(this.next_position);
            ++this.next_position;
            ++n3;
            long l = networkConnectionBase.getTransportBase().isReadyForRead(eventWaiter);
            if (l != 0L) continue;
            int n5 = networkConnectionBase.getMssSize();
            int n6 = n4 > n5 ? n5 : n4;
            int n7 = 0;
            try {
                n7 = networkConnectionBase.getIncomingMessageQueue().receiveFromTransport(n6);
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof IOException)) {
                    Debug.printStackTrace(throwable);
                }
                networkConnectionBase.notifyOfException(throwable);
            }
            n4 -= n7;
        }
        int n8 = n2 - n4;
        if (n8 > 0) {
            this.main_handler.bytesProcessed(n8);
            return n8;
        }
        return 0;
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public boolean getPriorityBoost() {
        return false;
    }

    @Override
    public String getString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MPD (" + this.connections_cow.size() + "): ");
        int n = 0;
        for (NetworkConnectionBase networkConnectionBase : this.connections_cow) {
            if (n++ > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(networkConnectionBase.getString());
        }
        return stringBuffer.toString();
    }
}

