/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.udp;

import com.aelitis.azureus.core.networkmanager.impl.udp.UDPConnectionSet;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPSelector;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPTransportHelper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.gudy.azureus2.core3.util.AESemaphore;

public class UDPConnection {
    private UDPConnectionSet set;
    private int id;
    private UDPTransportHelper transport;
    private List read_buffers = new LinkedList();
    private AESemaphore read_buffer_sem = new AESemaphore("UDPConnection", 64);
    private volatile boolean connected = true;

    protected UDPConnection(UDPConnectionSet uDPConnectionSet, int n, UDPTransportHelper uDPTransportHelper) {
        this.set = uDPConnectionSet;
        this.id = n;
        this.transport = uDPTransportHelper;
    }

    protected UDPConnection(UDPConnectionSet uDPConnectionSet, int n) {
        this.set = uDPConnectionSet;
        this.id = n;
    }

    protected UDPSelector getSelector() {
        return this.set.getSelector();
    }

    protected int getID() {
        return this.id;
    }

    protected void setID(int n) {
        this.id = n;
    }

    public boolean isIncoming() {
        return this.transport.isIncoming();
    }

    protected void setSecret(byte[] byArray) {
        this.set.setSecret(this, byArray);
    }

    protected void setTransport(UDPTransportHelper uDPTransportHelper) {
        this.transport = uDPTransportHelper;
    }

    protected UDPTransportHelper getTransport() {
        return this.transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receive(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.remaining();
        if (n < 256) {
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray);
            byteBuffer = ByteBuffer.wrap(byArray);
        }
        this.read_buffer_sem.reserve();
        if (!this.connected) {
            throw new IOException("Transport closed");
        }
        boolean bl = false;
        List list = this.read_buffers;
        synchronized (list) {
            bl = this.read_buffers.size() == 0;
            this.read_buffers.add(byteBuffer);
        }
        if (bl) {
            this.transport.canRead();
        }
    }

    protected void sent() {
        this.transport.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean canRead() {
        List list = this.read_buffers;
        synchronized (list) {
            return this.read_buffers.size() > 0;
        }
    }

    protected boolean canWrite() {
        return this.set.canWrite(this);
    }

    protected int write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        int n3 = this.set.write(this, byteBufferArray, n, n2);
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int read(ByteBuffer byteBuffer) throws IOException {
        int n = 0;
        List list = this.read_buffers;
        synchronized (list) {
            int n2;
            while (this.read_buffers.size() > 0 && (n2 = byteBuffer.remaining()) != 0) {
                ByteBuffer byteBuffer2 = (ByteBuffer)this.read_buffers.get(0);
                int n3 = byteBuffer2.limit();
                if (byteBuffer2.remaining() > n2) {
                    byteBuffer2.limit(byteBuffer2.position() + n2);
                }
                byteBuffer.put(byteBuffer2);
                byteBuffer2.limit(n3);
                n += n2 - byteBuffer.remaining();
                if (byteBuffer2.hasRemaining()) break;
                this.read_buffers.remove(0);
                this.read_buffer_sem.release();
            }
        }
        return n;
    }

    protected void close(String string) {
        if (this.transport != null) {
            this.transport.close(string);
        } else {
            this.closeSupport(string);
        }
    }

    protected void failed(Throwable throwable) {
        if (this.transport != null) {
            this.transport.failed(throwable);
        } else {
            this.failedSupport(throwable);
        }
    }

    protected void closeSupport(String string) {
        this.connected = false;
        this.read_buffer_sem.releaseForever();
        this.set.close(this, string);
    }

    protected void failedSupport(Throwable throwable) {
        this.connected = false;
        this.read_buffer_sem.releaseForever();
        this.set.failed(this, throwable);
    }

    protected boolean isConnected() {
        return this.connected;
    }

    protected void poll() {
        if (this.transport != null) {
            this.transport.poll();
        }
    }
}

