/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.udp;

import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPConnectionManager;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class UDPSelector {
    private static final int POLL_FREQUENCY = 100;
    private List ready_set = new LinkedList();
    private AESemaphore ready_sem = new AESemaphore("UDPSelector");
    private volatile boolean destroyed;

    protected UDPSelector(final UDPConnectionManager uDPConnectionManager) {
        new AEThread2("UDPSelector", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean bl = false;
                long l = 0L;
                while (!bl) {
                    Object[] objectArray;
                    long l2;
                    if (UDPSelector.this.destroyed) {
                        bl = true;
                    }
                    if ((l2 = SystemTime.getCurrentTime()) < l || l2 - l >= 100L) {
                        uDPConnectionManager.poll();
                        l = l2;
                    }
                    if (!UDPSelector.this.ready_sem.reserve(50L)) continue;
                    Object object = UDPSelector.this.ready_set;
                    synchronized (object) {
                        if (UDPSelector.this.ready_set.size() == 0) {
                            continue;
                        }
                        objectArray = (Object[])UDPSelector.this.ready_set.remove(0);
                    }
                    object = (TransportHelper)objectArray[0];
                    TransportHelper.selectListener selectListener2 = (TransportHelper.selectListener)objectArray[1];
                    if (selectListener2 == null) {
                        Debug.out("Null listener");
                        continue;
                    }
                    Object object2 = objectArray[2];
                    try {
                        if (objectArray.length == 3) {
                            selectListener2.selectSuccess((TransportHelper)object, object2);
                            continue;
                        }
                        selectListener2.selectFailure((TransportHelper)object, object2, (Throwable)objectArray[3]);
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        List list = this.ready_set;
        synchronized (list) {
            this.destroyed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ready(TransportHelper transportHelper, TransportHelper.selectListener selectListener2, Object object) {
        boolean bl = false;
        List list = this.ready_set;
        synchronized (list) {
            if (this.destroyed) {
                Debug.out("Selector has been destroyed");
                throw new RuntimeException("Selector has been destroyed");
            }
            Iterator iterator = this.ready_set.iterator();
            while (iterator.hasNext()) {
                Object[] objectArray = (Object[])iterator.next();
                if (objectArray[1] != selectListener2) continue;
                iterator.remove();
                bl = true;
                break;
            }
            this.ready_set.add(new Object[]{transportHelper, selectListener2, object});
        }
        if (!bl) {
            this.ready_sem.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ready(TransportHelper transportHelper, TransportHelper.selectListener selectListener2, Object object, Throwable throwable) {
        boolean bl = false;
        List list = this.ready_set;
        synchronized (list) {
            if (this.destroyed) {
                Debug.out("Selector has been destroyed");
                throw new RuntimeException("Selector has been destroyed");
            }
            Iterator iterator = this.ready_set.iterator();
            while (iterator.hasNext()) {
                Object[] objectArray = (Object[])iterator.next();
                if (objectArray[1] != selectListener2) continue;
                iterator.remove();
                bl = true;
                break;
            }
            this.ready_set.add(new Object[]{transportHelper, selectListener2, object, throwable});
        }
        if (!bl) {
            this.ready_sem.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel(TransportHelper transportHelper, TransportHelper.selectListener selectListener2) {
        List list = this.ready_set;
        synchronized (list) {
            Iterator iterator = this.ready_set.iterator();
            while (iterator.hasNext()) {
                Object[] objectArray = (Object[])iterator.next();
                if (objectArray[0] != transportHelper || objectArray[1] != selectListener2) continue;
                iterator.remove();
                break;
            }
        }
    }
}

