/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager;

import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.IncomingConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.peermanager.PeerManagerRegistration;
import com.aelitis.azureus.core.peermanager.PeerManagerRegistrationAdapter;
import com.aelitis.azureus.core.peermanager.PeerManagerRoutingListener;
import com.aelitis.azureus.core.peermanager.messaging.MessageManager;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamEncoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamFactory;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessageDecoder;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessageEncoder;
import com.aelitis.azureus.core.peermanager.piecepicker.util.BitFlags;
import com.aelitis.azureus.core.stats.AzureusCoreStats;
import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerListener;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransportFactory;
import org.gudy.azureus2.core3.peer.util.PeerIdentityManager;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SystemTime;

public class PeerManager
implements AzureusCoreStatsProvider {
    private static final LogIDs LOGID = LogIDs.PEER;
    private static final PeerManager instance = new PeerManager();
    private static final int PENDING_TIMEOUT = 10000;
    private static final AEMonitor timer_mon = new AEMonitor("PeerManager:timeouts");
    private static AEThread2 timer_thread;
    private static Set timer_targets;
    private final Map registered_legacy_managers = new HashMap();
    private final Map registered_links = new HashMap();
    private final ByteBuffer legacy_handshake_header;
    private final AEMonitor managers_mon = new AEMonitor("PeerManager:managers");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void registerForTimeouts(PeerManagerRegistrationImpl peerManagerRegistrationImpl) {
        try {
            timer_mon.enter();
            timer_targets.add(peerManagerRegistrationImpl);
            if (timer_thread == null) {
                timer_thread = new AEThread2("PeerManager:timeouts", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        int n = 0;
                        block6: while (true) {
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                timer_mon.enter();
                                if (timer_targets.size() == 0) {
                                    if ((n += 5000) < 30000) continue;
                                    timer_thread = null;
                                    break;
                                }
                                n = 0;
                                Iterator iterator = timer_targets.iterator();
                                while (true) {
                                    if (!iterator.hasNext()) continue block6;
                                    PeerManagerRegistrationImpl peerManagerRegistrationImpl = (PeerManagerRegistrationImpl)iterator.next();
                                    if (peerManagerRegistrationImpl.timeoutCheck()) continue;
                                    iterator.remove();
                                }
                            }
                            finally {
                                timer_mon.exit();
                                continue;
                            }
                            break;
                        }
                    }
                };
                timer_thread.start();
            }
        }
        finally {
            timer_mon.exit();
        }
    }

    public static PeerManager getSingleton() {
        return instance;
    }

    private PeerManager() {
        this.legacy_handshake_header = ByteBuffer.allocate(20);
        this.legacy_handshake_header.put((byte)"BitTorrent protocol".length());
        this.legacy_handshake_header.put("BitTorrent protocol".getBytes());
        this.legacy_handshake_header.flip();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("peer.manager.count");
        hashSet.add("peer.manager.peer.count");
        hashSet.add("peer.manager.peer.snubbed.count");
        hashSet.add("peer.manager.peer.stalled.disk.count");
        AzureusCoreStats.registerProvider(hashSet, this);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStats(Set set, Map map) {
        if (set.contains("peer.manager.count")) {
            map.put("peer.manager.count", new Long(this.registered_legacy_managers.size()));
        }
        if (set.contains("peer.manager.peer.count") || set.contains("peer.manager.peer.snubbed.count") || set.contains("peer.manager.peer.stalled.disk.count")) {
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            try {
                this.managers_mon.enter();
                for (List list : this.registered_legacy_managers.values()) {
                    for (PeerManagerRegistrationImpl peerManagerRegistrationImpl : list) {
                        PEPeerControl pEPeerControl = peerManagerRegistrationImpl.getActiveControl();
                        if (pEPeerControl == null) continue;
                        l += (long)pEPeerControl.getNbPeers();
                        l2 += (long)pEPeerControl.getNbPeersSnubbed();
                        l3 += (long)pEPeerControl.getNbPeersStalledPendingLoad();
                    }
                }
            }
            finally {
                this.managers_mon.exit();
            }
            if (set.contains("peer.manager.peer.count")) {
                map.put("peer.manager.peer.count", new Long(l));
            }
            if (set.contains("peer.manager.peer.snubbed.count")) {
                map.put("peer.manager.peer.snubbed.count", new Long(l2));
            }
            if (set.contains("peer.manager.peer.stalled.disk.count")) {
                map.put("peer.manager.peer.stalled.disk.count", new Long(l3));
            }
        }
    }

    protected void init() {
        MessageManager.getSingleton().initialize();
        NetworkManager.ByteMatcher byteMatcher = new NetworkManager.ByteMatcher(){

            @Override
            public int matchThisSizeOrBigger() {
                return 48;
            }

            @Override
            public int maxSize() {
                return 48;
            }

            @Override
            public int minSize() {
                return 20;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object matches(TransportHelper transportHelper, ByteBuffer byteBuffer, int n) {
                InetSocketAddress inetSocketAddress = transportHelper.getAddress();
                int n2 = byteBuffer.limit();
                int n3 = byteBuffer.position();
                byteBuffer.limit(n3 + 20);
                PeerManagerRegistrationImpl peerManagerRegistrationImpl = null;
                if (byteBuffer.equals(PeerManager.this.legacy_handshake_header)) {
                    byteBuffer.limit(n3 + 48);
                    byteBuffer.position(n3 + 28);
                    byte[] byArray = new byte[byteBuffer.remaining()];
                    byteBuffer.get(byArray);
                    try {
                        PeerManager.this.managers_mon.enter();
                        List list = (List)PeerManager.this.registered_legacy_managers.get(new HashWrapper(byArray));
                        if (list != null) {
                            peerManagerRegistrationImpl = (PeerManagerRegistrationImpl)list.get(0);
                        }
                    }
                    finally {
                        PeerManager.this.managers_mon.exit();
                    }
                }
                byteBuffer.limit(n2);
                byteBuffer.position(n3);
                if (peerManagerRegistrationImpl != null && !peerManagerRegistrationImpl.isActive()) {
                    if (peerManagerRegistrationImpl.isKnownSeed(inetSocketAddress)) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "Activation request from " + inetSocketAddress + " denied as known seed"));
                        }
                        peerManagerRegistrationImpl = null;
                    } else if (!peerManagerRegistrationImpl.getAdapter().activateRequest(inetSocketAddress)) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "Activation request from " + inetSocketAddress + " denied by rules"));
                        }
                        peerManagerRegistrationImpl = null;
                    }
                }
                return peerManagerRegistrationImpl;
            }

            @Override
            public Object minMatches(TransportHelper transportHelper, ByteBuffer byteBuffer, int n) {
                boolean bl = false;
                int n2 = byteBuffer.limit();
                int n3 = byteBuffer.position();
                byteBuffer.limit(n3 + 20);
                if (byteBuffer.equals(PeerManager.this.legacy_handshake_header)) {
                    bl = true;
                }
                byteBuffer.limit(n2);
                byteBuffer.position(n3);
                return bl ? "" : null;
            }

            @Override
            public byte[][] getSharedSecrets() {
                return null;
            }

            @Override
            public int getSpecificPort() {
                return -1;
            }
        };
        NetworkManager.getSingleton().requestIncomingConnectionRouting(byteMatcher, new NetworkManager.RoutingListener(){

            @Override
            public void connectionRouted(NetworkConnection networkConnection, Object object) {
                PeerManagerRegistrationImpl peerManagerRegistrationImpl = (PeerManagerRegistrationImpl)object;
                peerManagerRegistrationImpl.route(networkConnection, null);
            }

            @Override
            public boolean autoCryptoFallback() {
                return false;
            }
        }, new MessageStreamFactory(){

            @Override
            public MessageStreamEncoder createEncoder() {
                return new BTMessageEncoder();
            }

            @Override
            public MessageStreamDecoder createDecoder() {
                return new BTMessageDecoder();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerManagerRegistration manualMatchHash(InetSocketAddress inetSocketAddress, byte[] byArray) {
        PeerManagerRegistrationImpl peerManagerRegistrationImpl = null;
        try {
            this.managers_mon.enter();
            List list = (List)this.registered_legacy_managers.get(new HashWrapper(byArray));
            if (list != null) {
                peerManagerRegistrationImpl = (PeerManagerRegistrationImpl)list.get(0);
            }
        }
        finally {
            this.managers_mon.exit();
        }
        if (peerManagerRegistrationImpl != null && !peerManagerRegistrationImpl.isActive()) {
            if (peerManagerRegistrationImpl.isKnownSeed(inetSocketAddress)) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Activation request from " + inetSocketAddress + " denied as known seed"));
                }
                peerManagerRegistrationImpl = null;
            } else if (!peerManagerRegistrationImpl.getAdapter().activateRequest(inetSocketAddress)) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Activation request from " + inetSocketAddress + " denied by rules"));
                }
                peerManagerRegistrationImpl = null;
            }
        }
        return peerManagerRegistrationImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerManagerRegistration manualMatchLink(InetSocketAddress inetSocketAddress, String string) {
        byte[] byArray;
        try {
            this.managers_mon.enter();
            PeerManagerRegistrationImpl peerManagerRegistrationImpl = (PeerManagerRegistrationImpl)this.registered_links.get(string);
            if (peerManagerRegistrationImpl == null) {
                PeerManagerRegistration peerManagerRegistration = null;
                return peerManagerRegistration;
            }
            byArray = peerManagerRegistrationImpl.getHash();
        }
        finally {
            this.managers_mon.exit();
        }
        return this.manualMatchHash(inetSocketAddress, byArray);
    }

    public void manualRoute(PeerManagerRegistration peerManagerRegistration, NetworkConnection networkConnection, PeerManagerRoutingListener peerManagerRoutingListener) {
        PeerManagerRegistrationImpl peerManagerRegistrationImpl = (PeerManagerRegistrationImpl)peerManagerRegistration;
        peerManagerRegistrationImpl.route(networkConnection, peerManagerRoutingListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerManagerRegistration registerLegacyManager(HashWrapper hashWrapper, PeerManagerRegistrationAdapter peerManagerRegistrationAdapter) {
        try {
            this.managers_mon.enter();
            ArrayList<PeerManagerRegistrationImpl> arrayList = (ArrayList<PeerManagerRegistrationImpl>)this.registered_legacy_managers.get(hashWrapper);
            byte[][] byArray = peerManagerRegistrationAdapter.getSecrets();
            if (arrayList == null) {
                arrayList = new ArrayList<PeerManagerRegistrationImpl>(1);
                this.registered_legacy_managers.put(hashWrapper, arrayList);
                IncomingConnectionManager.getSingleton().addSharedSecrets(byArray);
            }
            PeerManagerRegistrationImpl peerManagerRegistrationImpl = new PeerManagerRegistrationImpl(hashWrapper, peerManagerRegistrationAdapter);
            arrayList.add(peerManagerRegistrationImpl);
            PeerManagerRegistrationImpl peerManagerRegistrationImpl2 = peerManagerRegistrationImpl;
            return peerManagerRegistrationImpl2;
        }
        finally {
            this.managers_mon.exit();
        }
    }

    static {
        timer_targets = new HashSet();
    }

    private class PeerManagerRegistrationImpl
    implements PeerManagerRegistration {
        private HashWrapper hash;
        private PeerManagerRegistrationAdapter adapter;
        private PEPeerControl download;
        private volatile PEPeerControl active_control;
        private List pending_connections;
        private BloomFilter known_seeds;
        private Map links;

        protected PeerManagerRegistrationImpl(HashWrapper hashWrapper, PeerManagerRegistrationAdapter peerManagerRegistrationAdapter) {
            this.hash = hashWrapper;
            this.adapter = peerManagerRegistrationAdapter;
        }

        protected PeerManagerRegistrationAdapter getAdapter() {
            return this.adapter;
        }

        protected byte[] getHash() {
            return this.hash.getBytes();
        }

        @Override
        public synchronized TOTorrentFile getLink(String string) {
            if (this.links == null) {
                return null;
            }
            return (TOTorrentFile)this.links.get(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addLink(String string, TOTorrentFile tOTorrentFile) throws Exception {
            try {
                PeerManager.this.managers_mon.enter();
                if (PeerManager.this.registered_links.get(string) != null) {
                    throw new Exception("Duplicate link '" + string + "'");
                }
                PeerManager.this.registered_links.put(string, this);
                System.out.println("Added link '" + string + "'");
            }
            finally {
                PeerManager.this.managers_mon.exit();
            }
            PeerManagerRegistrationImpl peerManagerRegistrationImpl = this;
            synchronized (peerManagerRegistrationImpl) {
                if (this.links == null) {
                    this.links = new HashMap();
                }
                this.links.put(string, tOTorrentFile);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeLink(String string) {
            try {
                PeerManager.this.managers_mon.enter();
                PeerManager.this.registered_links.remove(string);
            }
            finally {
                PeerManager.this.managers_mon.exit();
            }
            PeerManagerRegistrationImpl peerManagerRegistrationImpl = this;
            synchronized (peerManagerRegistrationImpl) {
                if (this.links != null) {
                    this.links.remove(string);
                }
            }
        }

        public boolean isActive() {
            return this.active_control != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void activate(PEPeerControl pEPeerControl) {
            List list = null;
            try {
                PeerManager.this.managers_mon.enter();
                this.active_control = pEPeerControl;
                if (this.download != null) {
                    Debug.out("Already activated");
                }
                this.download = pEPeerControl;
                list = this.pending_connections;
                this.pending_connections = null;
            }
            finally {
                PeerManager.this.managers_mon.exit();
            }
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Object[] objectArray = (Object[])list.get(i);
                    NetworkConnection networkConnection = (NetworkConnection)objectArray[0];
                    PeerManagerRoutingListener peerManagerRoutingListener = (PeerManagerRoutingListener)objectArray[2];
                    this.route(pEPeerControl, networkConnection, true, peerManagerRoutingListener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deactivate() {
            try {
                PeerManager.this.managers_mon.enter();
                if (this.download == null) {
                    Debug.out("Already deactivated");
                } else {
                    this.download = null;
                }
                this.active_control = null;
                if (this.pending_connections != null) {
                    for (int i = 0; i < this.pending_connections.size(); ++i) {
                        Object[] objectArray = (Object[])this.pending_connections.get(i);
                        NetworkConnection networkConnection = (NetworkConnection)objectArray[0];
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, 1, "Incoming connection from [" + networkConnection + "] closed due to deactivation"));
                        }
                        networkConnection.close();
                    }
                    this.pending_connections = null;
                }
            }
            finally {
                PeerManager.this.managers_mon.exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unregister() {
            try {
                List list;
                PeerManager.this.managers_mon.enter();
                if (this.active_control != null) {
                    Debug.out("Not deactivated");
                    this.deactivate();
                }
                if ((list = (List)PeerManager.this.registered_legacy_managers.get(this.hash)) == null) {
                    Debug.out("manager already deregistered");
                } else if (list.remove(this)) {
                    if (list.size() == 0) {
                        IncomingConnectionManager.getSingleton().removeSharedSecrets(this.adapter.getSecrets());
                        PeerManager.this.registered_legacy_managers.remove(this.hash);
                    }
                } else {
                    Debug.out("manager already deregistered");
                }
                if (this.links != null) {
                    Iterator iterator = this.links.keySet().iterator();
                    while (iterator.hasNext()) {
                        PeerManager.this.registered_links.remove(iterator.next());
                    }
                }
            }
            finally {
                PeerManager.this.managers_mon.exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean isKnownSeed(InetSocketAddress inetSocketAddress) {
            try {
                PeerManager.this.managers_mon.enter();
                if (this.known_seeds == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this.known_seeds.contains(inetSocketAddress.getAddress().getAddress());
                return bl;
            }
            finally {
                PeerManager.this.managers_mon.exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setKnownSeed(InetSocketAddress inetSocketAddress) {
            try {
                PeerManager.this.managers_mon.enter();
                if (this.known_seeds == null) {
                    this.known_seeds = BloomFilterFactory.createAddOnly(1024);
                }
                this.known_seeds.add(inetSocketAddress.getAddress().getAddress());
            }
            finally {
                PeerManager.this.managers_mon.exit();
            }
        }

        protected PEPeerControl getActiveControl() {
            return this.active_control;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void route(NetworkConnection networkConnection, PeerManagerRoutingListener peerManagerRoutingListener) {
            PEPeerControl pEPeerControl;
            if (this.adapter.manualRoute(networkConnection)) {
                return;
            }
            if (!this.adapter.isPeerSourceEnabled("Incoming")) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 1, "Incoming connection from [" + networkConnection + "] to " + this.adapter.getDescription() + " dropped as peer source disabled"));
                }
                networkConnection.close();
                return;
            }
            boolean bl = false;
            try {
                PeerManager.this.managers_mon.enter();
                pEPeerControl = this.active_control;
                if (pEPeerControl == null) {
                    if (this.pending_connections != null && this.pending_connections.size() > 10) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, 1, "Incoming connection from [" + networkConnection + "] to " + this.adapter.getDescription() + " dropped too many pending activations"));
                        }
                        networkConnection.close();
                        return;
                    }
                    if (this.pending_connections == null) {
                        this.pending_connections = new ArrayList();
                    }
                    this.pending_connections.add(new Object[]{networkConnection, new Long(SystemTime.getCurrentTime()), peerManagerRoutingListener});
                    if (this.pending_connections.size() == 1) {
                        bl = true;
                    }
                }
            }
            finally {
                PeerManager.this.managers_mon.exit();
            }
            if (bl) {
                PeerManager.registerForTimeouts(this);
            }
            if (pEPeerControl != null) {
                this.route(pEPeerControl, networkConnection, false, peerManagerRoutingListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean timeoutCheck() {
            try {
                PeerManager.this.managers_mon.enter();
                if (this.pending_connections == null) {
                    boolean bl = false;
                    return bl;
                }
                Iterator iterator = this.pending_connections.iterator();
                long l = SystemTime.getCurrentTime();
                while (iterator.hasNext()) {
                    Object[] objectArray = (Object[])iterator.next();
                    long l2 = (Long)objectArray[1];
                    if (l < l2) {
                        objectArray[1] = new Long(l);
                        continue;
                    }
                    if (l - l2 <= 10000L) continue;
                    iterator.remove();
                    NetworkConnection networkConnection = (NetworkConnection)objectArray[0];
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 1, "Incoming connection from [" + networkConnection + "] to " + this.adapter.getDescription() + " closed due to activation timeout"));
                    }
                    networkConnection.close();
                }
                if (this.pending_connections.size() == 0) {
                    this.pending_connections = null;
                }
                boolean bl = this.pending_connections != null;
                return bl;
            }
            finally {
                PeerManager.this.managers_mon.exit();
            }
        }

        protected void route(PEPeerControl pEPeerControl, final NetworkConnection networkConnection, boolean bl, PeerManagerRoutingListener peerManagerRoutingListener) {
            boolean bl2;
            String string = networkConnection.getEndpoint().getNotionalAddress().getAddress().getHostAddress();
            boolean bl3 = bl2 = COConfigurationManager.getBooleanParameter("Allow Same IP Peers") || string.equals("127.0.0.1");
            if (!bl2 && PeerIdentityManager.containsIPAddress(pEPeerControl.getPeerIdentityDataID(), string)) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 1, "Incoming connection from [" + networkConnection + "] dropped as IP address already " + "connected for [" + pEPeerControl.getDisplayName() + "]"));
                }
                networkConnection.close();
                return;
            }
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Incoming connection from [" + networkConnection + "] routed to legacy download [" + pEPeerControl.getDisplayName() + "]"));
            }
            PEPeerTransport pEPeerTransport = PEPeerTransportFactory.createTransport(pEPeerControl, "Incoming", networkConnection, null);
            if (peerManagerRoutingListener != null) {
                boolean bl4 = false;
                try {
                    if (peerManagerRoutingListener.routed(pEPeerTransport)) {
                        bl4 = true;
                    }
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
                if (!bl4) {
                    networkConnection.close();
                    return;
                }
            }
            pEPeerTransport.start();
            if (bl) {
                pEPeerTransport.addListener(new PEPeerListener(){

                    @Override
                    public void stateChanged(PEPeer pEPeer, int n) {
                        if (n == 40 && pEPeer.isSeed()) {
                            InetSocketAddress inetSocketAddress = networkConnection.getEndpoint().getNotionalAddress();
                            PeerManagerRegistrationImpl.this.setKnownSeed(inetSocketAddress);
                            PeerManagerRegistrationImpl.this.adapter.deactivateRequest(inetSocketAddress);
                        }
                    }

                    @Override
                    public void sentBadChunk(PEPeer pEPeer, int n, int n2) {
                    }

                    @Override
                    public void addAvailability(PEPeer pEPeer, BitFlags bitFlags) {
                    }

                    @Override
                    public void removeAvailability(PEPeer pEPeer, BitFlags bitFlags) {
                    }
                });
            }
            pEPeerControl.addPeerTransport(pEPeerTransport);
        }

        @Override
        public String getDescription() {
            PEPeerControl pEPeerControl = this.active_control;
            return ByteFormatter.encodeString(this.hash.getBytes()) + ", control=" + (pEPeerControl == null ? null : pEPeerControl.getDisplayName()) + ": " + this.adapter.getDescription();
        }
    }
}

