/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessagingUtil;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep.LTMessage;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Map;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class LTHandshake
implements LTMessage {
    private Map data_dict;
    private byte[] bencoded_data;
    private String bencoded_string;
    private String description;
    private byte version;
    private DirectByteBuffer[] buffer_array;

    public LTHandshake(Map map, byte by) {
        this.data_dict = map == null ? Collections.EMPTY_MAP : map;
        this.version = by;
    }

    @Override
    public Message deserialize(DirectByteBuffer directByteBuffer, byte by) throws MessageException {
        if (directByteBuffer == null) {
            throw new MessageException("[" + this.getID() + "] decode error: data == null");
        }
        if (directByteBuffer.remaining((byte)11) < 1) {
            throw new MessageException("[" + this.getID() + "] decode error: less than 1 byte in payload");
        }
        Map map = MessagingUtil.convertBencodedByteStreamToPayload(directByteBuffer, 1, this.getID());
        LTHandshake lTHandshake = new LTHandshake(map, this.version);
        return lTHandshake;
    }

    @Override
    public DirectByteBuffer[] getData() {
        if (this.buffer_array == null) {
            DirectByteBuffer directByteBuffer;
            this.buffer_array = new DirectByteBuffer[1];
            this.buffer_array[0] = directByteBuffer = DirectByteBufferPool.getBuffer((byte)28, this.getBencodedData().length);
            directByteBuffer.put((byte)11, this.getBencodedData());
            directByteBuffer.flip((byte)11);
        }
        return this.buffer_array;
    }

    @Override
    public void destroy() {
        this.data_dict = null;
        this.bencoded_data = null;
        this.description = null;
        if (this.buffer_array != null) {
            this.buffer_array[0].returnToPool();
        }
        this.buffer_array = null;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            this.description = "lt_handshake".toUpperCase() + ": " + this.getBencodedString();
        }
        return this.description;
    }

    public String getBencodedString() {
        if (this.bencoded_string == null) {
            try {
                this.bencoded_string = new String(this.getBencodedData(), "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.bencoded_string = "";
                Debug.printStackTrace(unsupportedEncodingException);
            }
        }
        return this.bencoded_string;
    }

    public byte[] getBencodedData() {
        if (this.bencoded_data == null) {
            try {
                this.bencoded_data = BEncoder.encode(this.data_dict);
            }
            catch (IOException iOException) {
                this.bencoded_data = new byte[0];
                Debug.printStackTrace(iOException);
            }
        }
        return this.bencoded_data;
    }

    public Map getDataMap() {
        return this.data_dict;
    }

    public String getClientName() {
        byte[] byArray = (byte[])this.data_dict.get("v");
        if (byArray == null) {
            return null;
        }
        try {
            return new String(byArray, "UTF8");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean isUploadOnly() {
        Long l = (Long)this.data_dict.get("upload_only");
        return l != null && l > 0L;
    }

    public InetAddress getIPv6() {
        byte[] byArray = (byte[])this.data_dict.get("ipv6");
        if (byArray != null && byArray.length == 16) {
            try {
                return InetAddress.getByAddress(byArray);
            }
            catch (UnknownHostException unknownHostException) {
                unknownHostException.printStackTrace();
            }
        }
        return null;
    }

    public int getTCPListeningPort() {
        Long l = (Long)this.data_dict.get("p");
        if (l == null) {
            return 0;
        }
        int n = l.intValue();
        if (n <= 65535 && n > 0) {
            return n;
        }
        return 0;
    }

    public Boolean isCryptoRequested() {
        Long l = (Long)this.data_dict.get("e");
        if (l == null) {
            return null;
        }
        return l == 1L;
    }

    public Map getExtensionMapping() {
        Map map = (Map)this.data_dict.get("m");
        return map == null ? Collections.EMPTY_MAP : map;
    }

    @Override
    public String getFeatureID() {
        return "LT1";
    }

    @Override
    public int getFeatureSubID() {
        return 0;
    }

    @Override
    public String getID() {
        return "lt_handshake";
    }

    @Override
    public byte[] getIDBytes() {
        return ID_LT_HANDSHAKE_BYTES;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public byte getVersion() {
        return this.version;
    }
}

