/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.subs.impl;

import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.util.ImportExportUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class SubscriptionResultFilter {
    private String[] textFilters;
    private Pattern[] textFilterPatterns;
    private String[] excludeTextFilters;
    private Pattern[] excludeTextFilterPatterns;
    private String regexFilter;
    private long minSeeds = -1L;
    private long minSize = -1L;
    private long maxSize = -1L;
    private String categoryFilter = null;
    private static Pattern[] NO_PATTERNS = new Pattern[0];

    public String getString() {
        String string = this.addString("", "+", this.getString(this.textFilters));
        string = this.addString(string, "-", this.getString(this.excludeTextFilters));
        string = this.addString(string, "regex=", this.regexFilter);
        string = this.addString(string, "cat=", this.categoryFilter);
        return string;
    }

    private String addString(String string, String string2, String string3) {
        if (string3 == null || string3.length() == 0) {
            return string;
        }
        String string4 = string2 + string3;
        if (string == null || string.length() == 0) {
            return string4;
        }
        return string + "," + string4;
    }

    private String getString(String[] stringArray) {
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + (i == 0 ? "" : "&") + stringArray[i];
        }
        return string;
    }

    public SubscriptionResultFilter(Map map) {
        try {
            this.textFilters = this.importStrings(map, "text_filter", " ");
            this.textFilterPatterns = this.getPatterns(this.textFilters);
            this.excludeTextFilters = this.importStrings(map, "text_filter_out", " ");
            this.excludeTextFilterPatterns = this.getPatterns(this.excludeTextFilters);
            this.regexFilter = ImportExportUtils.importString(map, "text_filter_regex");
            this.minSize = ImportExportUtils.importLong(map, "min_size", -1L);
            this.maxSize = ImportExportUtils.importLong(map, "max_size", -1L);
            this.minSeeds = ImportExportUtils.importLong(map, "min_seeds", -1L);
            String string = ImportExportUtils.importString(map, "category");
            if (string != null) {
                this.categoryFilter = string.toLowerCase();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Pattern[] getPatterns(String[] stringArray) {
        if (stringArray.length == 0) {
            return NO_PATTERNS;
        }
        Pattern[] patternArray = new Pattern[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                patternArray[i] = Pattern.compile(stringArray[i].trim());
                continue;
            }
            catch (Throwable throwable) {
                System.out.println("Failed to compile pattern '" + stringArray[i]);
            }
        }
        return patternArray;
    }

    private String[] importStrings(Map map, String string, String string2) throws IOException {
        String string3 = ImportExportUtils.importString(map, string);
        if (string3 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, string2);
            String[] stringArray = new String[stringTokenizer.countTokens()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringTokenizer.nextToken().toLowerCase();
            }
            return stringArray;
        }
        return new String[0];
    }

    public Result[] filter(Result[] resultArray) {
        ArrayList<Result> arrayList = new ArrayList<Result>(resultArray.length);
        for (int i = 0; i < resultArray.length; ++i) {
            String string;
            Pattern pattern;
            int n;
            Result result = resultArray[i];
            String string2 = result.getName();
            if (string2 == null) continue;
            string2 = string2.toLowerCase();
            boolean bl = true;
            for (n = 0; n < this.textFilters.length; ++n) {
                if (string2.indexOf(this.textFilters[n]) != -1 || (pattern = this.textFilterPatterns[n]) != null && pattern.matcher(string2).find()) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            for (n = 0; n < this.excludeTextFilters.length; ++n) {
                if (string2.indexOf(this.excludeTextFilters[n]) != -1) {
                    bl = false;
                    break;
                }
                pattern = this.excludeTextFilterPatterns[n];
                if (pattern == null || !pattern.matcher(string2).find()) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            long l = result.getSize();
            if (this.minSize > -1L && this.minSize > l || this.maxSize > -1L && this.maxSize < l || this.minSeeds > -1L && this.minSeeds < (long)result.getNbSeeds() || this.categoryFilter != null && ((string = result.getCategory()) == null || !string.equalsIgnoreCase(this.categoryFilter))) continue;
            arrayList.add(result);
        }
        Result[] resultArray2 = arrayList.toArray(new Result[arrayList.size()]);
        return resultArray2;
    }
}

