/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;

public class AEThreadMonitor {
    private static boolean disable_getThreadCpuTime = false;

    public static void initialise() {
        String string = System.getProperty("java.runtime.version");
        disable_getThreadCpuTime = Constants.isOSX && string.startsWith("1.5.0_06");
        AEDiagnostics.addEvidenceGenerator(new EvidenceGenerateor());
        if (!disable_getThreadCpuTime) {
            AEThread aEThread = new AEThread("AEThreadMonitor"){

                @Override
                public void runSupport() {
                    try {
                        try {
                            Class.forName("java.lang.management.ManagementFactory");
                            AEThreadMonitor.monitor15();
                        }
                        catch (Throwable throwable) {}
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            };
            aEThread.setPriority(10);
            aEThread.setDaemon(true);
            aEThread.start();
        }
    }

    private static void monitor14() {
        AEDiagnosticsLogger aEDiagnosticsLogger = AEDiagnostics.getLogger("thread");
        int n = Runtime.getRuntime().availableProcessors();
        if (n < 1) {
            n = 1;
        }
        aEDiagnosticsLogger.log("Monitoring starts [1.4] (processors =" + n + ")");
        block4: while (true) {
            try {
                Thread.sleep(10000L);
            }
            catch (Throwable throwable) {
                aEDiagnosticsLogger.log(throwable);
            }
            try {
                ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                Thread[] threadArray = new Thread[threadGroup.activeCount()];
                threadGroup.enumerate(threadArray);
                int n2 = 0;
                while (true) {
                    if (n2 >= threadArray.length) continue block4;
                    Thread thread = threadArray[n2];
                    if (thread != null && thread.getName().equals("Thread-2")) {
                        thread.dumpStack();
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    private static void monitor15() {
        AEDiagnosticsLogger aEDiagnosticsLogger = AEDiagnostics.getLogger("thread");
        int n = Runtime.getRuntime().availableProcessors();
        if (n < 1) {
            n = 1;
        }
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        aEDiagnosticsLogger.log("Monitoring starts (processors =" + n + ")");
        if (!threadMXBean.isThreadCpuTimeSupported()) {
            aEDiagnosticsLogger.log("ThreadCpuTime not supported");
            return;
        }
        if (!threadMXBean.isThreadCpuTimeEnabled()) {
            aEDiagnosticsLogger.log("Enabling ThreadCpuTime");
            threadMXBean.setThreadCpuTimeEnabled(true);
        }
        HashMap hashMap = new HashMap();
        long l = 10000L;
        while (true) {
            Comparable<Long> comparable;
            long l2 = System.currentTimeMillis();
            try {
                Thread.sleep(l);
            }
            catch (Throwable throwable) {
                aEDiagnosticsLogger.log(throwable);
            }
            long l3 = System.currentTimeMillis();
            long l4 = l3 - l2;
            long[] lArray = threadMXBean.getAllThreadIds();
            long[] lArray2 = new long[lArray.length];
            long l5 = 0L;
            long l6 = 0L;
            int n2 = 0;
            HashMap<Long, Long> hashMap2 = new HashMap<Long, Long>();
            for (int i = 0; i < lArray.length; ++i) {
                long l7 = lArray[i];
                long l8 = threadMXBean.getThreadCpuTime(l7) / 1000000L;
                comparable = (Long)hashMap.get(l7);
                if (comparable != null) {
                    long l9 = l8 - (Long)comparable;
                    if (l9 > l6) {
                        l6 = l9;
                        n2 = i;
                    }
                    lArray2[i] = l9;
                    l5 += l9;
                }
                hashMap2.put(l7, l8);
            }
            ThreadInfo threadInfo = threadMXBean.getThreadInfo(lArray[n2]);
            String string = threadInfo == null ? "<dead>" : threadInfo.getThreadName();
            int n3 = (int)(100L * l6 / l);
            Runtime runtime = Runtime.getRuntime();
            aEDiagnosticsLogger.log("Thread state: elapsed=" + l4 + ",cpu=" + l5 + ",max=" + string + "(" + l6 + "/" + n3 + "%),mem:max=" + runtime.maxMemory() / 1024L + ",tot=" + runtime.totalMemory() / 1024L + ",free=" + runtime.freeMemory() / 1024L);
            if (l6 > l / 4L) {
                threadInfo = threadMXBean.getThreadInfo(lArray[n2], 255);
                if (threadInfo == null) {
                    aEDiagnosticsLogger.log("    no info for max thread");
                } else {
                    StackTraceElement[] stackTraceElementArray = threadInfo.getStackTrace();
                    comparable = new StringBuilder(stackTraceElementArray.length * 20);
                    ((StringBuilder)comparable).append("    ");
                    for (int i = 0; i < stackTraceElementArray.length; ++i) {
                        if (i != 0) {
                            ((StringBuilder)comparable).append(", ");
                        }
                        ((StringBuilder)comparable).append(stackTraceElementArray[i]);
                    }
                    aEDiagnosticsLogger.log(((StringBuilder)comparable).toString());
                }
            }
            hashMap = hashMap2;
        }
    }

    public static void dumpThreads() {
        StringWriter stringWriter = new StringWriter();
        IndentWriter indentWriter = new IndentWriter(new PrintWriter(stringWriter));
        AEThreadMonitor.dumpThreads(indentWriter);
        indentWriter.close();
        Debug.out(stringWriter.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpThreads(IndentWriter indentWriter) {
        ThreadInfo threadInfo;
        int n;
        final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        long[] lArray = threadMXBean.getAllThreadIds();
        indentWriter.println("Threads " + lArray.length);
        indentWriter.indent();
        ArrayList<ThreadInfo> arrayList = new ArrayList<ThreadInfo>(lArray.length);
        for (n = 0; n < lArray.length; ++n) {
            threadInfo = threadMXBean.getThreadInfo(lArray[n], 32);
            if (threadInfo == null) continue;
            arrayList.add(threadInfo);
        }
        if (!disable_getThreadCpuTime) {
            Collections.sort(arrayList, new Comparator<ThreadInfo>(){

                @Override
                public int compare(ThreadInfo threadInfo, ThreadInfo threadInfo2) {
                    long l = threadMXBean.getThreadCpuTime(threadInfo2.getThreadId()) - threadMXBean.getThreadCpuTime(threadInfo.getThreadId());
                    if (l == 0L) {
                        return threadInfo.getThreadName().compareToIgnoreCase(threadInfo2.getThreadName());
                    }
                    return l > 0L ? 1 : -1;
                }
            });
        }
        for (n = 0; n < arrayList.size(); ++n) {
            try {
                String string;
                long l;
                threadInfo = (ThreadInfo)arrayList.get(n);
                long l2 = l = disable_getThreadCpuTime ? -1L : threadMXBean.getThreadCpuTime(threadInfo.getThreadId());
                if (l == 0L) break;
                switch (threadInfo.getThreadState()) {
                    case BLOCKED: {
                        string = "Blocked";
                        break;
                    }
                    case RUNNABLE: {
                        string = "Runnable";
                        break;
                    }
                    case NEW: {
                        string = "New";
                        break;
                    }
                    case TERMINATED: {
                        string = "Terminated";
                        break;
                    }
                    case TIMED_WAITING: {
                        string = "Timed Waiting";
                        break;
                    }
                    case WAITING: {
                        string = "Waiting";
                        break;
                    }
                    default: {
                        string = "" + (Object)((Object)threadInfo.getThreadState());
                    }
                }
                String string2 = threadInfo.getThreadName();
                String string3 = threadInfo.getLockName();
                indentWriter.println(string2 + ": " + string + ", " + l / 1000000L + "ms CPU, " + "B/W: " + threadInfo.getBlockedCount() + "/" + threadInfo.getWaitedCount() + (string3 == null ? "" : "; Locked by " + string3 + "/" + threadInfo.getLockOwnerName()));
                indentWriter.indent();
                try {
                    StackTraceElement[] stackTraceElementArray = threadInfo.getStackTrace();
                    for (int i = 0; i < stackTraceElementArray.length; ++i) {
                        indentWriter.println(stackTraceElementArray[i].toString());
                    }
                    continue;
                }
                finally {
                    indentWriter.exdent();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        indentWriter.exdent();
    }

    private static class EvidenceGenerateor
    implements AEDiagnosticsEvidenceGenerator {
        private EvidenceGenerateor() {
        }

        @Override
        public void generate(IndentWriter indentWriter) {
            AEThreadMonitor.dumpThreads(indentWriter);
        }
    }
}

