/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import com.aelitis.azureus.core.versioncheck.VersionCheckClient;

public class FeatureAvailability {
    private static final long FT_DISABLE_REQUEST_LIMITING = 1L;
    private static final long FT_DISABLE_PEER_GENERAL_RECONNECT = 2L;
    private static final long FT_DISABLE_PEER_UDP_RECONNECT = 4L;
    private static final long FT_AUTO_SPEED_DEFAULT_CLASSIC = 8L;
    private static final long FT_DISABLE_RCM = 16L;
    private static final long FT_DISABLE_DHT_REP_V2 = 32L;
    private static final long FT_DISABLE_MAGNET_SL = 64L;
    private static final long FT_ENABLE_ALL_FE_CLIENTS = 128L;
    private static final long FT_ENABLE_INTERNAL_FEATURES = 256L;
    private static final long FT_TRIGGER_SPEED_TEST_V1 = 512L;
    private static VersionCheckClient vcc = VersionCheckClient.getSingleton();

    public static boolean areInternalFeaturesEnabled() {
        boolean bl = (vcc.getFeatureFlags() & 0x100L) != 0L;
        return bl;
    }

    public static boolean isRequestLimitingEnabled() {
        boolean bl = (vcc.getFeatureFlags() & 1L) == 0L;
        return bl;
    }

    public static boolean isGeneralPeerReconnectEnabled() {
        boolean bl = (vcc.getFeatureFlags() & 2L) == 0L;
        return bl;
    }

    public static boolean isUDPPeerReconnectEnabled() {
        boolean bl = (vcc.getFeatureFlags() & 4L) == 0L;
        return bl;
    }

    public static boolean isAutoSpeedDefaultClassic() {
        boolean bl = (vcc.getFeatureFlags() & 8L) != 0L;
        return bl;
    }

    public static boolean isRCMEnabled() {
        boolean bl = (vcc.getFeatureFlags() & 0x10L) == 0L;
        return bl;
    }

    public static boolean isDHTRepV2Enabled() {
        boolean bl = (vcc.getFeatureFlags() & 0x20L) == 0L;
        return bl;
    }

    public static boolean isMagnetSLEnabled() {
        boolean bl = (vcc.getFeatureFlags() & 0x40L) == 0L;
        return bl;
    }

    public static boolean allowAllFEClients() {
        boolean bl = (vcc.getFeatureFlags() & 0x80L) != 0L;
        return bl;
    }

    public static boolean triggerSpeedTestV1() {
        boolean bl = (vcc.getFeatureFlags() & 0x200L) != 0L;
        return bl;
    }
}

