/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.magnet.metadata;

import com.aelitis.azureus.plugins.magnet.MagnetPluginProgressListener;
import com.aelitis.azureus.plugins.magnet.metadata.ByteUtils;
import com.aelitis.azureus.plugins.magnet.metadata.MetadataDiskManager;
import com.aelitis.azureus.plugins.magnet.metadata.MetadataPeerListener;
import com.aelitis.azureus.plugins.magnet.metadata.MetadataPeerManagerAdapter;
import com.aelitis.azureus.plugins.magnet.metadata.MetadataTrackerAnnouncerDataProvider;
import com.aelitis.azureus.plugins.magnet.metadata.MetadataTrackerAnnouncerListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerManagerFactory;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentMetadata;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerFactory;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.UrlUtils;

public class MetadataPeerRequester {
    private final MagnetPluginProgressListener listener;
    private final byte[] hash;
    private final String args;
    private final long timeout;
    private byte[] torrentBytes;

    public MetadataPeerRequester(MagnetPluginProgressListener magnetPluginProgressListener, byte[] byArray, String string, long l) {
        this.listener = magnetPluginProgressListener;
        this.hash = byArray;
        this.args = string;
        this.timeout = l;
    }

    public byte[] request() {
        try {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            URL[] uRLArray = this.getTrackers();
            if (uRLArray.length == 0) {
                return null;
            }
            String string = this.getPeerInternalHostPort();
            String string2 = null;
            int n = -1;
            if (string != null) {
                string2 = string.split(":")[0];
                n = Integer.parseInt(string.split(":")[1]);
            }
            ArrayList<Torrent> arrayList = new ArrayList<Torrent>();
            for (URL uRL : uRLArray) {
                Torrent torrent = this.requestSupport(uRL, uRLArray, string2, n, countDownLatch);
                if (torrent == null) continue;
                arrayList.add(torrent);
            }
            countDownLatch.await(this.timeout, TimeUnit.MILLISECONDS);
            for (Torrent torrent : arrayList) {
                torrent.stop();
            }
            if (this.torrentBytes != null) {
                this.listener.reportCompleteness(100);
            }
            return this.torrentBytes;
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return null;
        }
    }

    private Torrent requestSupport(URL uRL, final URL[] uRLArray, String string, int n, final CountDownLatch countDownLatch) {
        try {
            this.listener.reportActivity("Try to request metadata from peers in tracker: " + uRL);
            Torrent torrent = new Torrent(this.hash, "", new URL[]{uRL}, string, n){

                @Override
                public void notifyComplete() {
                    try {
                        if (MetadataPeerRequester.this.torrentBytes == null) {
                            this.setAnnounceUrlGroup(uRLArray);
                            MetadataPeerRequester.access$002(MetadataPeerRequester.this, this.serialiseToByteArray());
                        }
                    }
                    catch (TOTorrentException tOTorrentException) {
                        Debug.printStackTrace(tOTorrentException);
                    }
                    countDownLatch.countDown();
                }
            };
            MetadataTrackerAnnouncerListener metadataTrackerAnnouncerListener = new MetadataTrackerAnnouncerListener();
            TRTrackerAnnouncer tRTrackerAnnouncer = TRTrackerAnnouncerFactory.create((TOTorrent)torrent, null);
            tRTrackerAnnouncer.addListener(metadataTrackerAnnouncerListener);
            tRTrackerAnnouncer.setAnnounceDataProvider(new MetadataTrackerAnnouncerDataProvider());
            torrent.setTrackerAnnouncer(tRTrackerAnnouncer);
            MetadataPeerManagerAdapter metadataPeerManagerAdapter = new MetadataPeerManagerAdapter(new MetadataPeerListener());
            PEPeerManager pEPeerManager = PEPeerManagerFactory.create(tRTrackerAnnouncer.getPeerId(), metadataPeerManagerAdapter, new MetadataDiskManager(torrent));
            torrent.setPeerManager(pEPeerManager);
            metadataPeerManagerAdapter.setPeerManager(pEPeerManager);
            metadataTrackerAnnouncerListener.setPeerManager(pEPeerManager);
            pEPeerManager.start();
            pEPeerManager.setSuperSeedMode(true);
            if (string != null && n != -1) {
                pEPeerManager.addPeer(string, n, 0, false, new HashMap());
            }
            tRTrackerAnnouncer.update(true);
            return torrent;
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return null;
        }
    }

    private URL[] getTrackers() {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (String string : this.args.split("&")) {
            if (!string.startsWith("tr=")) continue;
            try {
                arrayList.add(new URL(UrlUtils.decode(string.substring(3))));
            }
            catch (MalformedURLException malformedURLException) {
                Debug.printStackTrace(malformedURLException);
            }
        }
        return arrayList.toArray(new URL[0]);
    }

    private String getPeerInternalHostPort() {
        for (String string : this.args.split("&")) {
            if (!string.startsWith("iipp=")) continue;
            return MetadataPeerRequester.convertHexToIPPort(string.substring("iipp=".length()));
        }
        return null;
    }

    public static String convertIPPortToHex(String string, int n) {
        String[] stringArray = string.split("\\.");
        byte[] byArray = new byte[6];
        int n2 = 0;
        for (String string2 : stringArray) {
            byArray[n2++] = (byte)Integer.parseInt(string2);
        }
        byte[] byArray2 = ByteUtils.smallIntToByteArray(n);
        byArray[4] = byArray2[0];
        byArray[5] = byArray2[1];
        return ByteUtils.encodeHex(byArray);
    }

    public static String convertHexToIPPort(String string) {
        if (string.length() != 12) {
            return null;
        }
        byte[] byArray = ByteUtils.decodeHex(string);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(byArray[0] & 0xFF);
        stringBuilder.append(".");
        stringBuilder.append(byArray[1] & 0xFF);
        stringBuilder.append(".");
        stringBuilder.append(byArray[2] & 0xFF);
        stringBuilder.append(".");
        stringBuilder.append(byArray[3] & 0xFF);
        stringBuilder.append(":");
        int n = ByteUtils.byteArrayToSmallInt(byArray, 4);
        stringBuilder.append(n);
        return stringBuilder.toString();
    }

    static /* synthetic */ byte[] access$002(MetadataPeerRequester metadataPeerRequester, byte[] byArray) {
        metadataPeerRequester.torrentBytes = byArray;
        return byArray;
    }

    private static class Torrent
    extends TOTorrentMetadata {
        private TRTrackerAnnouncer trackerAnnouncer;
        private PEPeerManager peerManager;
        private String peerInternalIP;
        private int peerInternalPort;

        public Torrent(byte[] byArray, String string, URL[] uRLArray, String string2, int n) {
            super(byArray, string, uRLArray);
            this.peerInternalIP = string2;
            this.peerInternalPort = n;
        }

        public TRTrackerAnnouncer getTrackerAnnouncer() {
            return this.trackerAnnouncer;
        }

        public void setTrackerAnnouncer(TRTrackerAnnouncer tRTrackerAnnouncer) {
            this.trackerAnnouncer = tRTrackerAnnouncer;
        }

        public PEPeerManager getPeerManager() {
            return this.peerManager;
        }

        public void setPeerManager(PEPeerManager pEPeerManager) {
            this.peerManager = pEPeerManager;
        }

        public void stop() {
            try {
                if (this.trackerAnnouncer != null) {
                    this.trackerAnnouncer.stop(false);
                }
                if (this.peerManager != null) {
                    this.peerManager.stopAll();
                }
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }

        @Override
        public Map serialiseToMap() throws TOTorrentException {
            Map map = super.serialiseToMap();
            if (this.peerInternalIP != null && this.peerInternalPort != -1) {
                map.put("peerInternalIP", this.peerInternalIP);
                map.put("peerInternalPort", this.peerInternalPort);
            }
            return map;
        }
    }
}

