/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.buddy;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.plugins.net.buddy.BuddyPlugin;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddy;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddyMessage;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddyMessageListener;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddyReplyListener;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginException;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginPasswordException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class BuddyPluginBuddyMessageHandler {
    private BuddyPluginBuddy buddy;
    private File store;
    private Map config_map;
    private int message_count;
    private int pending_deletes;
    private int next_message_id;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private BuddyPluginBuddyMessage active_message;
    private long last_failure;
    private long last_pending_success;

    protected BuddyPluginBuddyMessageHandler(BuddyPluginBuddy buddyPluginBuddy, File file) {
        this.buddy = buddyPluginBuddy;
        this.store = file;
        this.loadConfig();
        if (this.message_count > 0) {
            this.buddy.persistentDispatchPending();
        }
    }

    public BuddyPluginBuddy getBuddy() {
        return this.buddy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuddyPluginBuddyMessage queueMessage(int n, Map map, int n2) throws BuddyPluginException {
        boolean bl;
        BuddyPluginBuddyMessage buddyPluginBuddyMessage;
        Object object = this;
        synchronized (object) {
            int n3 = this.next_message_id++;
            buddyPluginBuddyMessage = new BuddyPluginBuddyMessage(this, n3, n, map, n2, SystemTime.getCurrentTime());
            this.storeMessage(buddyPluginBuddyMessage);
            bl = this.message_count == 1;
        }
        object = this.listeners.iterator();
        while (object.hasNext()) {
            try {
                ((BuddyPluginBuddyMessageListener)object.next()).messageQueued(buddyPluginBuddyMessage);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        if (bl) {
            this.buddy.persistentDispatchPending();
        }
        return buddyPluginBuddyMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPersistentDispatch() {
        boolean bl = false;
        BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = this;
        synchronized (buddyPluginBuddyMessageHandler) {
            long l = SystemTime.getCurrentTime();
            if (l < this.last_failure) {
                this.last_failure = l;
            }
            if (l < this.last_pending_success) {
                this.last_pending_success = l;
            }
            if (this.last_pending_success > 0L && l - this.last_pending_success >= 300000L) {
                bl = true;
            } else if (this.active_message == null && this.message_count != 0 && this.last_failure != 0L) {
                bl = l - this.last_failure >= 300000L;
            }
        }
        if (bl) {
            this.buddy.persistentDispatchPending();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistentDispatch() {
        Object object;
        Object object2;
        this.checkPendingSuccess();
        BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = this;
        synchronized (buddyPluginBuddyMessageHandler) {
            if (this.active_message != null || this.message_count == 0) {
                return;
            }
            object2 = (List)this.config_map.get("messages");
            object = (Map)object2.get(0);
            try {
                this.active_message = this.restoreMessage((Map)object);
            }
            catch (Throwable throwable) {
                Debug.out("Failed to restore message, deleting it", throwable);
                object2.remove(0);
                try {
                    this.saveConfig();
                }
                catch (Throwable throwable2) {
                    this.buddy.log("Config save failed during delete of bad message", throwable2);
                }
            }
        }
        boolean bl = false;
        try {
            object2 = this.active_message.getRequest();
            bl = true;
            this.buddy.sendMessage(this.active_message.getSubsystem(), (Map)object2, this.active_message.getTimeout(), new BuddyPluginBuddyReplyListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void replyReceived(BuddyPluginBuddy buddyPluginBuddy, Map map) {
                    boolean bl;
                    BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler;
                    BuddyPluginBuddyMessage buddyPluginBuddyMessage = BuddyPluginBuddyMessageHandler.this.active_message;
                    Iterator iterator = BuddyPluginBuddyMessageHandler.this.listeners.iterator();
                    boolean bl2 = true;
                    try {
                        buddyPluginBuddyMessageHandler = BuddyPluginBuddyMessageHandler.this;
                        synchronized (buddyPluginBuddyMessageHandler) {
                            BuddyPluginBuddyMessageHandler.this.pending_deletes++;
                        }
                        while (iterator.hasNext()) {
                            try {
                                if (((BuddyPluginBuddyMessageListener)iterator.next()).deliverySucceeded(buddyPluginBuddyMessage, map)) continue;
                                bl2 = false;
                            }
                            catch (Throwable throwable) {
                                Debug.printStackTrace(throwable);
                            }
                        }
                    }
                    finally {
                        buddyPluginBuddyMessageHandler = BuddyPluginBuddyMessageHandler.this;
                        synchronized (buddyPluginBuddyMessageHandler) {
                            BuddyPluginBuddyMessageHandler.this.pending_deletes--;
                        }
                    }
                    if (bl2) {
                        buddyPluginBuddyMessage.delete();
                    } else {
                        buddyPluginBuddyMessageHandler = BuddyPluginBuddyMessageHandler.this;
                        synchronized (buddyPluginBuddyMessageHandler) {
                            boolean bl3 = false;
                            List list = (List)BuddyPluginBuddyMessageHandler.this.config_map.get("messages");
                            if (list != null) {
                                for (int i = 0; i < list.size(); ++i) {
                                    Map map2 = (Map)list.get(i);
                                    if (buddyPluginBuddyMessage.getID() != ((Long)map2.get("id")).intValue()) continue;
                                    bl3 = true;
                                    list.remove(i);
                                    try {
                                        BuddyPluginBuddyMessageHandler.this.writeReply(buddyPluginBuddyMessage, map);
                                        ArrayList<Map> arrayList = (ArrayList<Map>)BuddyPluginBuddyMessageHandler.this.config_map.get("pending_success");
                                        if (arrayList == null) {
                                            arrayList = new ArrayList<Map>();
                                            BuddyPluginBuddyMessageHandler.this.config_map.put("pending_success", arrayList);
                                        }
                                        arrayList.add(map2);
                                        BuddyPluginBuddyMessageHandler.this.last_pending_success = SystemTime.getCurrentTime();
                                        BuddyPluginBuddyMessageHandler.this.buddy.log("Message moved to pending success queue after listener failed");
                                        BuddyPluginBuddyMessageHandler.this.saveConfig();
                                    }
                                    catch (Throwable throwable) {
                                        BuddyPluginBuddyMessageHandler.this.buddy.log("Config save failed during message pending queueing", throwable);
                                    }
                                    break;
                                }
                            }
                            if (!bl3) {
                                BuddyPluginBuddyMessageHandler.this.buddy.log("Failed to find message " + buddyPluginBuddyMessage.getID());
                            }
                        }
                    }
                    BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler2 = BuddyPluginBuddyMessageHandler.this;
                    synchronized (buddyPluginBuddyMessageHandler2) {
                        BuddyPluginBuddyMessageHandler.this.active_message = null;
                        bl = BuddyPluginBuddyMessageHandler.this.message_count > 0;
                        BuddyPluginBuddyMessageHandler.this.last_failure = 0L;
                    }
                    if (bl) {
                        BuddyPluginBuddyMessageHandler.this.buddy.persistentDispatchPending();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void sendFailed(BuddyPluginBuddy buddyPluginBuddy, BuddyPluginException buddyPluginException) {
                    BuddyPluginBuddyMessage buddyPluginBuddyMessage = BuddyPluginBuddyMessageHandler.this.active_message;
                    BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = BuddyPluginBuddyMessageHandler.this;
                    synchronized (buddyPluginBuddyMessageHandler) {
                        BuddyPluginBuddyMessageHandler.this.active_message = null;
                        BuddyPluginBuddyMessageHandler.this.last_failure = SystemTime.getCurrentTime();
                    }
                    BuddyPluginBuddyMessageHandler.this.reportFailed(buddyPluginBuddyMessage, buddyPluginException, true);
                }
            });
        }
        catch (Throwable throwable) {
            object = this.active_message;
            BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler2 = this;
            synchronized (buddyPluginBuddyMessageHandler2) {
                this.active_message = null;
                this.last_failure = SystemTime.getCurrentTime();
            }
            boolean bl2 = true;
            if (!bl && !(throwable instanceof BuddyPluginPasswordException)) {
                this.buddy.logMessage("Message request unavailable, deleting message");
                ((BuddyPluginBuddyMessage)object).delete();
                boolean bl3 = false;
                BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler3 = this;
                synchronized (buddyPluginBuddyMessageHandler3) {
                    this.last_failure = 0L;
                    bl3 = this.message_count > 0;
                }
                if (bl3) {
                    bl2 = false;
                    this.buddy.persistentDispatchPending();
                }
            }
            this.reportFailed((BuddyPluginBuddyMessage)object, throwable, bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reportFailed(BuddyPluginBuddyMessage buddyPluginBuddyMessage, Throwable throwable, boolean bl) {
        BuddyPluginException buddyPluginException = throwable instanceof BuddyPluginException ? (BuddyPluginException)throwable : new BuddyPluginException("Failed to send message", throwable);
        this.reportFailedSupport(buddyPluginBuddyMessage, buddyPluginException);
        if (bl) {
            ArrayList<BuddyPluginBuddyMessage> arrayList = new ArrayList<BuddyPluginBuddyMessage>();
            Object object = this;
            synchronized (object) {
                List list = (List)this.config_map.get("messages");
                for (int i = 0; i < list.size(); ++i) {
                    try {
                        BuddyPluginBuddyMessage buddyPluginBuddyMessage2 = this.restoreMessage((Map)list.get(i));
                        if (buddyPluginBuddyMessage2.getID() == buddyPluginBuddyMessage.getID()) continue;
                        arrayList.add(buddyPluginBuddyMessage2);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
            }
            if (arrayList.size() > 0) {
                object = new BuddyPluginException("Reporting probable failure to subsequent messages");
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.reportFailedSupport((BuddyPluginBuddyMessage)arrayList.get(i), (BuddyPluginException)object);
                }
            }
        }
    }

    protected void reportFailedSupport(BuddyPluginBuddyMessage buddyPluginBuddyMessage, BuddyPluginException buddyPluginException) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((BuddyPluginBuddyMessageListener)iterator.next()).deliveryFailed(buddyPluginBuddyMessage, buddyPluginException);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPendingSuccess() {
        Object object;
        Object object2;
        Object object3;
        this.last_pending_success = 0L;
        ArrayList<BuddyPluginBuddyMessage> arrayList = new ArrayList<BuddyPluginBuddyMessage>();
        boolean bl = false;
        BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = this;
        synchronized (buddyPluginBuddyMessageHandler) {
            object3 = (List)this.config_map.get("pending_success");
            if (object3 == null || object3.size() == 0) {
                return;
            }
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (Map)object2.next();
                try {
                    arrayList.add(this.restoreMessage((Map)object));
                }
                catch (Throwable throwable) {
                    this.buddy.log("Failed to restore message from pending success queue", throwable);
                    object2.remove();
                    bl = true;
                }
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            object3 = (BuddyPluginBuddyMessage)arrayList.get(i);
            try {
                object2 = ((BuddyPluginBuddyMessage)object3).getReply();
                object = this.listeners.iterator();
                boolean bl2 = true;
                while (object.hasNext()) {
                    try {
                        if (((BuddyPluginBuddyMessageListener)object.next()).deliverySucceeded((BuddyPluginBuddyMessage)object3, (Map)object2)) continue;
                        bl2 = false;
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
                if (bl2) {
                    ((BuddyPluginBuddyMessage)object3).delete();
                    continue;
                }
                BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler2 = this;
                synchronized (buddyPluginBuddyMessageHandler2) {
                    this.last_pending_success = SystemTime.getCurrentTime();
                    continue;
                }
            }
            catch (BuddyPluginPasswordException buddyPluginPasswordException) {
                this.buddy.log("Failed to restore message reply", buddyPluginPasswordException);
                continue;
            }
            catch (Throwable throwable) {
                this.buddy.log("Failed to restore message reply - deleting message", throwable);
                ((BuddyPluginBuddyMessage)object3).delete();
            }
        }
        if (bl) {
            try {
                this.saveConfig();
            }
            catch (Throwable throwable) {
                this.buddy.log("Save failed during pending success processing", throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessageCount() {
        BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = this;
        synchronized (buddyPluginBuddyMessageHandler) {
            return this.message_count - this.pending_deletes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteMessage(BuddyPluginBuddyMessage buddyPluginBuddyMessage) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((BuddyPluginBuddyMessageListener)iterator.next()).messageDeleted(buddyPluginBuddyMessage);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = this;
        synchronized (buddyPluginBuddyMessageHandler) {
            String[] stringArray = new String[]{"messages", "pending_success", "explicit"};
            for (int i = 0; i < stringArray.length; ++i) {
                List list = (List)this.config_map.get(stringArray[i]);
                if (list == null) continue;
                boolean bl = false;
                for (int j = 0; j < list.size(); ++j) {
                    Map map = (Map)list.get(j);
                    if (buddyPluginBuddyMessage.getID() != ((Long)map.get("id")).intValue()) continue;
                    list.remove(j);
                    bl = true;
                    break;
                }
                if (!bl) continue;
                this.deleteRequest(buddyPluginBuddyMessage);
                this.deleteReply(buddyPluginBuddyMessage);
                try {
                    this.saveConfig();
                }
                catch (Throwable throwable) {
                    this.buddy.log("Config save failed during message delete", throwable);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = this;
        synchronized (buddyPluginBuddyMessageHandler) {
            this.config_map.clear();
            try {
                this.saveConfig();
            }
            catch (Throwable throwable) {
                this.buddy.log("Config save failed during destroy", throwable);
            }
        }
    }

    protected void writeRequest(BuddyPluginBuddyMessage buddyPluginBuddyMessage, Map map) throws BuddyPluginException {
        this.writeContent(buddyPluginBuddyMessage.getID() + ".req.dat", map);
    }

    protected Map readRequest(BuddyPluginBuddyMessage buddyPluginBuddyMessage) throws BuddyPluginException {
        return this.readContent(buddyPluginBuddyMessage.getID() + ".req.dat");
    }

    protected void writeReply(BuddyPluginBuddyMessage buddyPluginBuddyMessage, Map map) throws BuddyPluginException {
        this.writeContent(buddyPluginBuddyMessage.getID() + ".rep.dat", map);
    }

    protected Map readReply(BuddyPluginBuddyMessage buddyPluginBuddyMessage) throws BuddyPluginException {
        return this.readContent(buddyPluginBuddyMessage.getID() + ".rep.dat");
    }

    protected void writeContent(String string, Map map) throws BuddyPluginException {
        if (!this.store.exists() && !this.store.mkdirs()) {
            throw new BuddyPluginException("Failed to create " + this.store);
        }
        File file = new File(this.store, string);
        try {
            BuddyPlugin.cryptoResult cryptoResult2 = this.buddy.encrypt(BEncoder.encode(map));
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("pk", this.buddy.getPlugin().getPublicKey());
            hashMap.put("data", cryptoResult2.getPayload());
            if (!this.buddy.writeConfigFile(file, hashMap)) {
                throw new BuddyPluginException("failed to write " + file);
            }
        }
        catch (BuddyPluginException buddyPluginException) {
            throw buddyPluginException;
        }
        catch (Throwable throwable) {
            throw new BuddyPluginException("Failed to write message", throwable);
        }
    }

    protected Map readContent(String string) throws BuddyPluginException {
        File file = new File(this.store, string);
        if (!file.exists()) {
            throw new BuddyPluginException("Failed to read persisted message - " + file + " doesn't exist");
        }
        Map map = this.buddy.readConfigFile(file);
        if (map.size() == 0) {
            throw new BuddyPluginException("Failed to read persisted message file " + file);
        }
        try {
            String string2 = new String((byte[])map.get("pk"));
            if (!string2.equals(this.buddy.getPlugin().getPublicKey())) {
                throw new BuddyPluginException("Can't decrypt message as key changed");
            }
            byte[] byArray = (byte[])map.get("data");
            return BDecoder.decode(this.buddy.decrypt(byArray).getPayload());
        }
        catch (BuddyPluginException buddyPluginException) {
            throw buddyPluginException;
        }
        catch (Throwable throwable) {
            throw new BuddyPluginException("Failed to read message", throwable);
        }
    }

    protected void deleteRequest(BuddyPluginBuddyMessage buddyPluginBuddyMessage) {
        this.deleteRequest(buddyPluginBuddyMessage.getID());
    }

    protected void deleteRequest(int n) {
        File file = new File(this.store, n + ".req.dat");
        if (file.exists() && !file.delete()) {
            Debug.out("Failed to delete " + file);
        }
    }

    protected void deleteReply(BuddyPluginBuddyMessage buddyPluginBuddyMessage) {
        this.deleteReply(buddyPluginBuddyMessage.getID());
    }

    protected void deleteReply(int n) {
        File file = new File(this.store, n + ".rep.dat");
        if (file.exists() && !file.delete()) {
            Debug.out("Failed to delete " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuddyPluginBuddyMessage storeExplicitMessage(int n, Map map) {
        BuddyPluginBuddyMessage buddyPluginBuddyMessage;
        BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = this;
        synchronized (buddyPluginBuddyMessageHandler) {
            int n2 = this.next_message_id++;
            try {
                buddyPluginBuddyMessage = new BuddyPluginBuddyMessage(this, n2, 1024 + n, map, 0, SystemTime.getCurrentTime());
                this.storeExplicitMessage(buddyPluginBuddyMessage);
            }
            catch (Throwable throwable) {
                this.buddy.log("Failed to store explicit message", throwable);
                return null;
            }
        }
        return buddyPluginBuddyMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BuddyPluginBuddyMessage> retrieveExplicitMessages(int n) {
        ArrayList<BuddyPluginBuddyMessage> arrayList = new ArrayList<BuddyPluginBuddyMessage>();
        BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = this;
        synchronized (buddyPluginBuddyMessageHandler) {
            List list = (List)this.config_map.get("explicit");
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    try {
                        BuddyPluginBuddyMessage buddyPluginBuddyMessage = this.restoreMessage((Map)list.get(i));
                        if (buddyPluginBuddyMessage.getSubsystem() != 1024 + n) continue;
                        arrayList.add(buddyPluginBuddyMessage);
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.buddy.log("Failed to restore message", throwable);
                    }
                }
            }
        }
        return arrayList;
    }

    protected void storeExplicitMessage(BuddyPluginBuddyMessage buddyPluginBuddyMessage) throws BuddyPluginException {
        this.storeMessageSupport(buddyPluginBuddyMessage, "explicit");
    }

    protected void storeMessage(BuddyPluginBuddyMessage buddyPluginBuddyMessage) throws BuddyPluginException {
        this.storeMessageSupport(buddyPluginBuddyMessage, "messages");
    }

    protected void storeMessageSupport(BuddyPluginBuddyMessage buddyPluginBuddyMessage, String string) throws BuddyPluginException {
        ArrayList arrayList = (ArrayList)this.config_map.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.config_map.put(string, arrayList);
        }
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put("id", new Long(buddyPluginBuddyMessage.getID()));
        hashMap.put("ss", new Long(buddyPluginBuddyMessage.getSubsystem()));
        hashMap.put("to", new Long(buddyPluginBuddyMessage.getTimeout()));
        hashMap.put("cr", new Long(buddyPluginBuddyMessage.getCreateTime()));
        arrayList.add(hashMap);
        this.saveConfig();
    }

    protected BuddyPluginBuddyMessage restoreMessage(Map map) throws BuddyPluginException {
        int n = ((Long)map.get("id")).intValue();
        int n2 = ((Long)map.get("ss")).intValue();
        int n3 = ((Long)map.get("to")).intValue();
        long l = (Long)map.get("cr");
        return new BuddyPluginBuddyMessage(this, n, n2, null, n3, l);
    }

    protected void loadConfig() {
        int n;
        List list;
        int n2;
        Object object;
        File file = new File(this.store, "messages.dat");
        this.config_map = file.exists() ? this.buddy.readConfigFile(file) : new HashMap();
        List list2 = (List)this.config_map.get("messages");
        if (list2 != null) {
            this.message_count = list2.size();
            if (this.message_count > 0) {
                object = (Map)list2.get(this.message_count - 1);
                this.next_message_id = ((Long)object.get("id")).intValue() + 1;
            }
        }
        if ((object = (List)this.config_map.get("pending_success")) != null && (n2 = object.size()) > 0) {
            Map map = (Map)object.get(n2 - 1);
            this.next_message_id = Math.max(this.next_message_id, ((Long)map.get("id")).intValue() + 1);
            this.last_pending_success = SystemTime.getCurrentTime();
        }
        if ((list = (List)this.config_map.get("explicit")) != null && (n = list.size()) > 0) {
            Map map = (Map)list.get(n - 1);
            this.next_message_id = Math.max(this.next_message_id, ((Long)map.get("id")).intValue() + 1);
        }
    }

    protected void saveConfig() throws BuddyPluginException {
        File file = new File(this.store, "messages.dat");
        List list = (List)this.config_map.get("messages");
        List list2 = (List)this.config_map.get("pending_success");
        List list3 = (List)this.config_map.get("explicit");
        if (!(list != null && list.size() != 0 || list2 != null && list2.size() != 0 || list3 != null && list3.size() != 0)) {
            if (this.store.exists()) {
                File[] fileArray = this.store.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    fileArray[i].delete();
                }
                this.store.delete();
            }
            this.message_count = 0;
            this.next_message_id = 0;
        } else {
            if (!this.store.exists() && !this.store.mkdirs()) {
                throw new BuddyPluginException("Failed to create " + this.store);
            }
            if (!this.buddy.writeConfigFile(file, this.config_map)) {
                throw new BuddyPluginException("Failed to write" + file);
            }
            this.message_count = list == null ? 0 : list.size();
        }
    }

    public void addListener(BuddyPluginBuddyMessageListener buddyPluginBuddyMessageListener) {
        this.listeners.add(buddyPluginBuddyMessageListener);
    }

    public void removeListener(BuddyPluginBuddyMessageListener buddyPluginBuddyMessageListener) {
        this.listeners.remove(buddyPluginBuddyMessageListener);
    }
}

