/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.upnp;

import com.aelitis.azureus.plugins.upnp.UPnPMapping;
import com.aelitis.azureus.plugins.upnp.UPnPMappingListener;
import com.aelitis.azureus.plugins.upnp.UPnPMappingManager;
import com.aelitis.azureus.plugins.upnp.UPnPMappingManagerListener;
import com.aelitis.azureus.plugins.upnp.UPnPPluginService;
import com.aelitis.net.natpmp.NATPMPDeviceAdapter;
import com.aelitis.net.natpmp.NatPMPDeviceFactory;
import com.aelitis.net.natpmp.upnp.NatPMPUPnP;
import com.aelitis.net.natpmp.upnp.NatPMPUPnPFactory;
import com.aelitis.net.upnp.UPnP;
import com.aelitis.net.upnp.UPnPAdapter;
import com.aelitis.net.upnp.UPnPDevice;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPFactory;
import com.aelitis.net.upnp.UPnPListener;
import com.aelitis.net.upnp.UPnPLogListener;
import com.aelitis.net.upnp.UPnPRootDevice;
import com.aelitis.net.upnp.UPnPRootDeviceListener;
import com.aelitis.net.upnp.UPnPService;
import com.aelitis.net.upnp.services.UPnPWANConnection;
import com.aelitis.net.upnp.services.UPnPWANConnectionListener;
import com.aelitis.net.upnp.services.UPnPWANConnectionPortMapping;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.config.ActionParameter;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.LabelParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.UTTimer;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;

public class UPnPPlugin
implements Plugin,
UPnPListener,
UPnPMappingListener,
UPnPWANConnectionListener {
    private static final String UPNP_PLUGIN_CONFIGSECTION_ID = "UPnP";
    private static final String NATPMP_PLUGIN_CONFIGSECTION_ID = "NATPMP";
    private static final String STATS_DISCOVER = "discover";
    private static final String STATS_FOUND = "found";
    private static final String STATS_READ_OK = "read_ok";
    private static final String STATS_READ_BAD = "read_bad";
    private static final String STATS_MAP_OK = "map_ok";
    private static final String STATS_MAP_BAD = "map_bad";
    private static final String[] STATS_KEYS = new String[]{"discover", "found", "read_ok", "read_bad", "map_ok", "map_bad"};
    private PluginInterface plugin_interface;
    private LoggerChannel log;
    private UPnPMappingManager mapping_manager = UPnPMappingManager.getSingleton(this);
    private UPnP upnp;
    private UPnPLogListener upnp_log_listener;
    private NatPMPUPnP nat_pmp_upnp;
    private BooleanParameter natpmp_enable_param;
    private StringParameter nat_pmp_router;
    private BooleanParameter upnp_enable_param;
    private BooleanParameter trace_to_log;
    private BooleanParameter alert_success_param;
    private BooleanParameter grab_ports_param;
    private BooleanParameter alert_other_port_param;
    private BooleanParameter alert_device_probs_param;
    private BooleanParameter release_mappings_param;
    private StringParameter selected_interfaces_param;
    private StringParameter selected_addresses_param;
    private BooleanParameter ignore_bad_devices;
    private LabelParameter ignored_devices_list;
    private List<UPnPMapping> mappings = new ArrayList<UPnPMapping>();
    private List<UPnPPluginService> services = new ArrayList<UPnPPluginService>();
    private Map<URL, String> root_info_map = new HashMap<URL, String>();
    private Map<String, String> log_no_repeat_map = new HashMap<String, String>();
    protected AEMonitor this_mon = new AEMonitor("UPnPPlugin");

    public static void load(PluginInterface pluginInterface) {
        pluginInterface.getPluginProperties().setProperty("plugin.version", "1.0");
        pluginInterface.getPluginProperties().setProperty("plugin.name", "Universal Plug and Play (UPnP)");
    }

    @Override
    public void initialize(PluginInterface pluginInterface) {
        this.plugin_interface = pluginInterface;
        this.log = this.plugin_interface.getLogger().getTimeStampedChannel(UPNP_PLUGIN_CONFIGSECTION_ID);
        UIManager uIManager = this.plugin_interface.getUIManager();
        final BasicPluginViewModel basicPluginViewModel = uIManager.createBasicPluginViewModel(UPNP_PLUGIN_CONFIGSECTION_ID);
        basicPluginViewModel.setConfigSectionID(UPNP_PLUGIN_CONFIGSECTION_ID);
        BasicPluginConfigModel basicPluginConfigModel = uIManager.createBasicPluginConfigModel("plugins", UPNP_PLUGIN_CONFIGSECTION_ID);
        BasicPluginConfigModel basicPluginConfigModel2 = uIManager.createBasicPluginConfigModel(UPNP_PLUGIN_CONFIGSECTION_ID, NATPMP_PLUGIN_CONFIGSECTION_ID);
        basicPluginConfigModel2.addLabelParameter2("natpmp.info");
        ActionParameter actionParameter = basicPluginConfigModel2.addActionParameter2("Utils.link.visit", "MainWindow.about.internet.wiki");
        actionParameter.setStyle(2);
        actionParameter.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter parameter) {
                try {
                    UPnPPlugin.this.plugin_interface.getUIManager().openURL(new URL("http://wiki.vuze.com/w/NATPMP"));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        });
        this.natpmp_enable_param = basicPluginConfigModel2.addBooleanParameter2("natpmp.enable", "natpmp.enable", false);
        this.nat_pmp_router = basicPluginConfigModel2.addStringParameter2("natpmp.routeraddress", "natpmp.routeraddress", "");
        this.natpmp_enable_param.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter parameter) {
                UPnPPlugin.this.setNATPMPEnableState();
            }
        });
        this.natpmp_enable_param.addEnabledOnSelection(this.nat_pmp_router);
        basicPluginConfigModel.addLabelParameter2("upnp.info");
        basicPluginConfigModel.addHyperlinkParameter2("upnp.wiki_link", "http://wiki.vuze.com/w/UPnP");
        this.upnp_enable_param = basicPluginConfigModel.addBooleanParameter2("upnp.enable", "upnp.enable", true);
        this.grab_ports_param = basicPluginConfigModel.addBooleanParameter2("upnp.grabports", "upnp.grabports", false);
        this.release_mappings_param = basicPluginConfigModel.addBooleanParameter2("upnp.releasemappings", "upnp.releasemappings", true);
        ActionParameter actionParameter2 = basicPluginConfigModel.addActionParameter2("upnp.refresh.label", "upnp.refresh.button");
        actionParameter2.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter parameter) {
                UPnPPlugin.this.refreshMappings();
            }
        });
        final BooleanParameter booleanParameter = basicPluginConfigModel.addBooleanParameter2("upnp.refresh_on_bad_nat", "upnp.refresh_mappings_on_bad_nat", false);
        this.plugin_interface.getUtilities().createTimer("upnp mapping auto-refresh", true).addPeriodicEvent(60000L, new UTTimerEventPerformer(){
            private long last_bad_nat = 0L;

            @Override
            public void perform(UTTimerEvent uTTimerEvent) {
                long l;
                if (UPnPPlugin.this.upnp == null) {
                    return;
                }
                if (!booleanParameter.getValue()) {
                    return;
                }
                if (!UPnPPlugin.this.upnp_enable_param.getValue()) {
                    return;
                }
                int n = UPnPPlugin.this.plugin_interface.getConnectionManager().getNATStatus();
                if (n == 3 && this.last_bad_nat + 900000L < (l = UPnPPlugin.this.plugin_interface.getUtilities().getCurrentSystemTime())) {
                    this.last_bad_nat = l;
                    UPnPPlugin.this.log.log(2, "NAT status is firewalled - trying to refresh UPnP mappings");
                    UPnPPlugin.this.refreshMappings(true);
                }
            }
        });
        basicPluginConfigModel.addLabelParameter2("blank.resource");
        this.alert_success_param = basicPluginConfigModel.addBooleanParameter2("upnp.alertsuccess", "upnp.alertsuccess", false);
        this.alert_other_port_param = basicPluginConfigModel.addBooleanParameter2("upnp.alertothermappings", "upnp.alertothermappings", true);
        this.alert_device_probs_param = basicPluginConfigModel.addBooleanParameter2("upnp.alertdeviceproblems", "upnp.alertdeviceproblems", true);
        this.selected_interfaces_param = basicPluginConfigModel.addStringParameter2("upnp.selectedinterfaces", "upnp.selectedinterfaces", "");
        this.selected_addresses_param = basicPluginConfigModel.addStringParameter2("upnp.selectedaddresses", "upnp.selectedaddresses", "");
        this.ignore_bad_devices = basicPluginConfigModel.addBooleanParameter2("upnp.ignorebaddevices", "upnp.ignorebaddevices", true);
        this.ignored_devices_list = basicPluginConfigModel.addLabelParameter2("upnp.ignorebaddevices.info");
        ActionParameter actionParameter3 = basicPluginConfigModel.addActionParameter2("upnp.ignorebaddevices.reset", "upnp.ignorebaddevices.reset.action");
        actionParameter3.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter parameter) {
                PluginConfig pluginConfig = UPnPPlugin.this.plugin_interface.getPluginconfig();
                for (int i = 0; i < STATS_KEYS.length; ++i) {
                    String string = "upnp.device.stats." + STATS_KEYS[i];
                    pluginConfig.setPluginMapParameter(string, new HashMap());
                }
                pluginConfig.setPluginMapParameter("upnp.device.ignorelist", new HashMap());
                UPnPPlugin.this.updateIgnoreList();
            }
        });
        this.trace_to_log = basicPluginConfigModel.addBooleanParameter2("upnp.trace_to_log", "upnp.trace_to_log", false);
        final boolean bl = this.upnp_enable_param.getValue();
        this.upnp_enable_param.addEnabledOnSelection(this.alert_success_param);
        this.upnp_enable_param.addEnabledOnSelection(this.grab_ports_param);
        this.upnp_enable_param.addEnabledOnSelection(actionParameter2);
        this.upnp_enable_param.addEnabledOnSelection(this.alert_other_port_param);
        this.upnp_enable_param.addEnabledOnSelection(this.alert_device_probs_param);
        this.upnp_enable_param.addEnabledOnSelection(this.release_mappings_param);
        this.upnp_enable_param.addEnabledOnSelection(this.selected_interfaces_param);
        this.upnp_enable_param.addEnabledOnSelection(this.selected_addresses_param);
        this.upnp_enable_param.addEnabledOnSelection(this.ignore_bad_devices);
        this.upnp_enable_param.addEnabledOnSelection(this.ignored_devices_list);
        this.upnp_enable_param.addEnabledOnSelection(actionParameter3);
        this.upnp_enable_param.addEnabledOnSelection(this.trace_to_log);
        this.natpmp_enable_param.setEnabled(bl);
        basicPluginViewModel.getStatus().setText(bl ? "Running" : "Disabled");
        this.upnp_enable_param.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter parameter) {
                boolean bl = UPnPPlugin.this.upnp_enable_param.getValue();
                UPnPPlugin.this.natpmp_enable_param.setEnabled(bl);
                basicPluginViewModel.getStatus().setText(bl ? "Running" : "Disabled");
                if (bl) {
                    UPnPPlugin.this.startUp();
                } else {
                    UPnPPlugin.this.closeDown(true);
                }
                UPnPPlugin.this.setNATPMPEnableState();
            }
        });
        basicPluginViewModel.getActivity().setVisible(false);
        basicPluginViewModel.getProgress().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            @Override
            public void messageLogged(int n, String string) {
                basicPluginViewModel.getLogArea().appendText(string + "\n");
            }

            @Override
            public void messageLogged(String string, Throwable throwable) {
                basicPluginViewModel.getLogArea().appendText(throwable.toString() + "\n");
            }
        });
        DelayedTask delayedTask = this.plugin_interface.getUtilities().createDelayedTask(new Runnable(){

            @Override
            public void run() {
                if (bl) {
                    UPnPPlugin.this.updateIgnoreList();
                    UPnPPlugin.this.startUp();
                }
            }
        });
        delayedTask.queue();
        this.plugin_interface.addListener(new PluginListener(){

            @Override
            public void initializationComplete() {
            }

            @Override
            public void closedownInitiated() {
                if (UPnPPlugin.this.services.size() == 0) {
                    UPnPPlugin.this.plugin_interface.getPluginconfig().setPluginParameter("plugin.info", "");
                }
            }

            @Override
            public void closedownComplete() {
                UPnPPlugin.this.closeDown(true);
            }
        });
    }

    protected void updateIgnoreList() {
        try {
            Object object;
            String string = "";
            if (this.ignore_bad_devices.getValue()) {
                object = this.plugin_interface.getPluginconfig();
                Map map = object.getPluginMapParameter("upnp.device.ignorelist", new HashMap());
                for (Map.Entry entry : map.entrySet()) {
                    Map map2 = (Map)entry.getValue();
                    string = string + "\n    " + entry.getKey() + ": " + new String((byte[])map2.get("Location"));
                }
                if (map.size() > 0) {
                    this.log.log("Devices currently being ignored: " + string);
                }
            }
            object = this.plugin_interface.getUtilities().getLocaleUtilities().getLocalisedMessageText("upnp.ignorebaddevices.info", new String[]{string});
            this.ignored_devices_list.setLabelText((String)object);
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    protected void ignoreDevice(String string, URL uRL) {
        if (this.ignore_bad_devices.getValue()) {
            try {
                PluginConfig pluginConfig = this.plugin_interface.getPluginconfig();
                Map map = pluginConfig.getPluginMapParameter("upnp.device.ignorelist", new HashMap());
                HashMap<String, byte[]> hashMap = (HashMap<String, byte[]>)map.get(string);
                if (hashMap == null) {
                    hashMap = new HashMap<String, byte[]>();
                    hashMap.put("Location", uRL.toString().getBytes());
                    map.put(string, hashMap);
                    pluginConfig.setPluginMapParameter("upnp.device.ignorelist", map);
                    this.updateIgnoreList();
                    String string2 = this.plugin_interface.getUtilities().getLocaleUtilities().getLocalisedMessageText("upnp.ignorebaddevices.alert", new String[]{uRL.toString()});
                    this.log.logAlertRepeatable(2, string2);
                }
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected void startUp() {
        if (this.upnp != null) {
            this.refreshMappings();
            return;
        }
        final LoggerChannel loggerChannel = this.plugin_interface.getLogger().getChannel("UPnP Core");
        try {
            this.upnp = UPnPFactory.getSingleton(new UPnPAdapter(){
                Set exception_traces = new HashSet();

                @Override
                public SimpleXMLParserDocument parseXML(String string) throws SimpleXMLParserDocumentException {
                    return UPnPPlugin.this.plugin_interface.getUtilities().getSimpleXMLParserDocumentFactory().create(string);
                }

                @Override
                public ResourceDownloaderFactory getResourceDownloaderFactory() {
                    return UPnPPlugin.this.plugin_interface.getUtilities().getResourceDownloaderFactory();
                }

                @Override
                public UTTimer createTimer(String string) {
                    return UPnPPlugin.this.plugin_interface.getUtilities().createTimer(string, true);
                }

                @Override
                public void createThread(String string, Runnable runnable) {
                    UPnPPlugin.this.plugin_interface.getUtilities().createThread(string, runnable);
                }

                @Override
                public Comparator getAlphanumericComparator() {
                    return UPnPPlugin.this.plugin_interface.getUtilities().getFormatters().getAlphanumericComparator(true);
                }

                @Override
                public void trace(String string) {
                    loggerChannel.log(string);
                    if (UPnPPlugin.this.trace_to_log.getValue()) {
                        UPnPPlugin.this.upnp_log_listener.log(string);
                    }
                }

                @Override
                public void log(Throwable throwable) {
                    String string = Debug.getNestedExceptionMessage(throwable);
                    if (!this.exception_traces.contains(string)) {
                        this.exception_traces.add(string);
                        if (this.exception_traces.size() > 128) {
                            this.exception_traces.clear();
                        }
                        loggerChannel.log(throwable);
                    } else {
                        loggerChannel.log(string);
                    }
                }

                @Override
                public void log(String string) {
                    UPnPPlugin.this.log.log(string);
                }

                @Override
                public String getTraceDir() {
                    return UPnPPlugin.this.plugin_interface.getUtilities().getAzureusUserDir();
                }
            }, this.getSelectedInterfaces());
            this.upnp.addRootDeviceListener(this);
            this.upnp_log_listener = new UPnPLogListener(){

                @Override
                public void log(String string) {
                    UPnPPlugin.this.log.log(string);
                }

                @Override
                public void logAlert(String string, boolean bl, int n) {
                    boolean bl2 = false;
                    if (UPnPPlugin.this.alert_device_probs_param.getValue()) {
                        if (n == 1) {
                            UPnPPlugin.this.log.logAlertRepeatable(bl ? 3 : 2, string);
                            bl2 = true;
                        } else {
                            boolean bl3 = false;
                            if (n == 3) {
                                byte[] byArray = UPnPPlugin.this.plugin_interface.getUtilities().getSecurityManager().calculateSHA1(string.getBytes());
                                String string2 = "upnp.alert.fp." + UPnPPlugin.this.plugin_interface.getUtilities().getFormatters().encodeBytesToString(byArray);
                                PluginConfig pluginConfig = UPnPPlugin.this.plugin_interface.getPluginconfig();
                                if (!pluginConfig.getPluginBooleanParameter(string2, false)) {
                                    pluginConfig.setPluginParameter(string2, true);
                                    bl3 = true;
                                }
                            } else {
                                bl3 = true;
                            }
                            if (bl3) {
                                UPnPPlugin.this.log.logAlert(bl ? 3 : 2, string);
                                bl2 = true;
                            }
                        }
                    }
                    if (!bl2) {
                        UPnPPlugin.this.log.log(string);
                    }
                }
            };
            this.upnp.addLogListener(this.upnp_log_listener);
            this.mapping_manager.addListener(new UPnPMappingManagerListener(){

                @Override
                public void mappingAdded(UPnPMapping uPnPMapping) {
                    UPnPPlugin.this.addMapping(uPnPMapping);
                }
            });
            UPnPMapping[] uPnPMappingArray = this.mapping_manager.getMappings();
            for (int i = 0; i < uPnPMappingArray.length; ++i) {
                this.addMapping(uPnPMappingArray[i]);
            }
            this.setNATPMPEnableState();
        }
        catch (Throwable throwable) {
            this.log.log(throwable);
        }
    }

    protected void closeDown(final boolean bl) {
        final AESemaphore aESemaphore = new AESemaphore("UPnPPlugin:closeTimeout");
        new AEThread("UPnPPlugin:closeTimeout", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runSupport() {
                try {
                    for (int i = 0; i < UPnPPlugin.this.mappings.size(); ++i) {
                        UPnPMapping uPnPMapping = (UPnPMapping)UPnPPlugin.this.mappings.get(i);
                        if (!uPnPMapping.isEnabled()) continue;
                        for (int j = 0; j < UPnPPlugin.this.services.size(); ++j) {
                            UPnPPluginService uPnPPluginService = (UPnPPluginService)UPnPPlugin.this.services.get(j);
                            uPnPPluginService.removeMapping(UPnPPlugin.this.log, uPnPMapping, bl);
                        }
                    }
                }
                finally {
                    aESemaphore.release();
                }
            }
        }.start();
        if (!aESemaphore.reserve(bl ? 15000L : 0L)) {
            String string = "A UPnP device is taking a long time to release its port mappings, consider disabling this via the UPnP configuration.";
            if (this.upnp_log_listener != null) {
                this.upnp_log_listener.logAlert(string, false, 2);
            } else {
                this.log.logAlertRepeatable(2, string);
            }
        }
    }

    @Override
    public boolean deviceDiscovered(String string, URL uRL) {
        int n;
        String[] stringArray = this.getSelectedAddresses();
        if (stringArray.length > 0) {
            String string2 = uRL.getHost();
            boolean bl = false;
            n = 1;
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                boolean bl2 = true;
                if (string3.startsWith("+")) {
                    string3 = string3.substring(1);
                    n = 0;
                } else if (string3.startsWith("-")) {
                    string3 = string3.substring(1);
                    bl2 = false;
                } else {
                    n = 0;
                }
                if (!string3.equals(string2)) continue;
                if (!bl2) {
                    this.logNoRepeat(string, "Device '" + uRL + "' is being ignored as excluded in address list");
                    return false;
                }
                bl = true;
                break;
            }
            if (!bl && n == 0) {
                this.logNoRepeat(string, "Device '" + uRL + "' is being ignored as not in address list");
                return false;
            }
        }
        if (!this.ignore_bad_devices.getValue()) {
            return true;
        }
        this.incrementDeviceStats(string, STATS_DISCOVER);
        boolean bl = this.checkDeviceStats(string, uRL);
        String string4 = "";
        for (n = 0; n < STATS_KEYS.length; ++n) {
            string4 = string4 + (n == 0 ? "" : ",") + STATS_KEYS[n] + "=" + this.getDeviceStats(string, STATS_KEYS[n]);
        }
        if (!bl) {
            this.logNoRepeat(string, "Device '" + uRL + "' is being ignored: " + string4);
        } else {
            this.logNoRepeat(string, "Device '" + uRL + "' is ok: " + string4);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logNoRepeat(String string, String string2) {
        Map<String, String> map = this.log_no_repeat_map;
        synchronized (map) {
            String string3 = this.log_no_repeat_map.get(string);
            if (string3 != null && string3.equals(string2)) {
                return;
            }
            this.log_no_repeat_map.put(string, string2);
        }
        this.log.log(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rootDeviceFound(UPnPRootDevice uPnPRootDevice) {
        block7: {
            this.incrementDeviceStats(uPnPRootDevice.getUSN(), STATS_FOUND);
            this.checkDeviceStats(uPnPRootDevice);
            try {
                int n = this.processDevice(uPnPRootDevice.getDevice());
                if (n <= 0) break block7;
                try {
                    this.this_mon.enter();
                    this.root_info_map.put(uPnPRootDevice.getLocation(), uPnPRootDevice.getInfo());
                    Iterator<String> iterator = this.root_info_map.values().iterator();
                    String string = "";
                    ArrayList<String> arrayList = new ArrayList<String>();
                    while (iterator.hasNext()) {
                        String string2 = iterator.next();
                        if (string2 == null || arrayList.contains(string2)) continue;
                        arrayList.add(string2);
                        string = string + (string.length() == 0 ? "" : ",") + string2;
                    }
                    if (string.length() > 0) {
                        this.plugin_interface.getPluginconfig().setPluginParameter("plugin.info", string);
                    }
                }
                finally {
                    this.this_mon.exit();
                }
            }
            catch (Throwable throwable) {
                this.log.log("Root device processing fails", throwable);
            }
        }
    }

    protected boolean checkDeviceStats(UPnPRootDevice uPnPRootDevice) {
        return this.checkDeviceStats(uPnPRootDevice.getUSN(), uPnPRootDevice.getLocation());
    }

    protected boolean checkDeviceStats(String string, URL uRL) {
        long l = this.getDeviceStats(string, STATS_DISCOVER);
        long l2 = this.getDeviceStats(string, STATS_FOUND);
        if (l > 3L && l2 == 0L) {
            this.ignoreDevice(string, uRL);
            return false;
        }
        if (l2 > 0L) {
            this.setDeviceStats(string, STATS_DISCOVER, 0L);
            this.setDeviceStats(string, STATS_FOUND, 0L);
        }
        long l3 = this.getDeviceStats(string, STATS_MAP_OK);
        long l4 = this.getDeviceStats(string, STATS_MAP_BAD);
        if (l4 > 5L && l3 == 0L) {
            this.ignoreDevice(string, uRL);
            return false;
        }
        if (l3 > 0L) {
            this.setDeviceStats(string, STATS_MAP_OK, 0L);
            this.setDeviceStats(string, STATS_MAP_BAD, 0L);
        }
        return true;
    }

    protected long incrementDeviceStats(String string, String string2) {
        String string3 = "upnp.device.stats." + string2;
        PluginConfig pluginConfig = this.plugin_interface.getPluginconfig();
        Map map = pluginConfig.getPluginMapParameter(string3, new HashMap());
        Long l = (Long)map.get(string);
        l = l == null ? new Long(1L) : new Long(l + 1L);
        map.put(string, l);
        pluginConfig.getPluginMapParameter(string3, map);
        return l;
    }

    protected long getDeviceStats(String string, String string2) {
        String string3 = "upnp.device.stats." + string2;
        PluginConfig pluginConfig = this.plugin_interface.getPluginconfig();
        Map map = pluginConfig.getPluginMapParameter(string3, new HashMap());
        Long l = (Long)map.get(string);
        if (l == null) {
            return 0L;
        }
        return l;
    }

    protected void setDeviceStats(String string, String string2, long l) {
        String string3 = "upnp.device.stats." + string2;
        PluginConfig pluginConfig = this.plugin_interface.getPluginconfig();
        Map map = pluginConfig.getPluginMapParameter(string3, new HashMap());
        map.put(string, new Long(l));
        pluginConfig.getPluginMapParameter(string3, map);
    }

    @Override
    public void mappingResult(UPnPWANConnection uPnPWANConnection, boolean bl) {
        UPnPRootDevice uPnPRootDevice = uPnPWANConnection.getGenericService().getDevice().getRootDevice();
        this.incrementDeviceStats(uPnPRootDevice.getUSN(), bl ? STATS_MAP_OK : STATS_MAP_BAD);
        this.checkDeviceStats(uPnPRootDevice);
    }

    @Override
    public void mappingsReadResult(UPnPWANConnection uPnPWANConnection, boolean bl) {
        UPnPRootDevice uPnPRootDevice = uPnPWANConnection.getGenericService().getDevice().getRootDevice();
        this.incrementDeviceStats(uPnPRootDevice.getUSN(), bl ? STATS_READ_OK : STATS_READ_BAD);
    }

    protected String[] getSelectedInterfaces() {
        String string = this.selected_interfaces_param.getValue().trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() <= 0) continue;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected String[] getSelectedAddresses() {
        String string = this.selected_addresses_param.getValue().trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() <= 0) continue;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected int processDevice(UPnPDevice uPnPDevice) throws UPnPException {
        int n = this.processServices(uPnPDevice, uPnPDevice.getServices());
        UPnPDevice[] uPnPDeviceArray = uPnPDevice.getSubDevices();
        for (int i = 0; i < uPnPDeviceArray.length; ++i) {
            n += this.processDevice(uPnPDeviceArray[i]);
        }
        return n;
    }

    protected int processServices(UPnPDevice uPnPDevice, UPnPService[] uPnPServiceArray) throws UPnPException {
        int n = 0;
        for (int i = 0; i < uPnPServiceArray.length; ++i) {
            UPnPService uPnPService = uPnPServiceArray[i];
            String string = uPnPService.getServiceType();
            if (string.equalsIgnoreCase("urn:schemas-upnp-org:service:WANIPConnection:1") || string.equalsIgnoreCase("urn:schemas-upnp-org:service:WANPPPConnection:1")) {
                final UPnPWANConnection uPnPWANConnection = (UPnPWANConnection)uPnPService.getSpecificService();
                uPnPDevice.getRootDevice().addListener(new UPnPRootDeviceListener(){

                    @Override
                    public void lost(UPnPRootDevice uPnPRootDevice, boolean bl) {
                        UPnPPlugin.this.removeService(uPnPWANConnection, bl);
                    }
                });
                this.addService(uPnPWANConnection);
                ++n;
                continue;
            }
            if (!string.equalsIgnoreCase("urn:schemas-upnp-org:service:WANCommonInterfaceConfig:1")) continue;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addService(UPnPWANConnection uPnPWANConnection) throws UPnPException {
        uPnPWANConnection.addListener(this);
        this.mapping_manager.serviceFound(uPnPWANConnection);
        try {
            UPnPWANConnectionPortMapping[] uPnPWANConnectionPortMappingArray;
            this.this_mon.enter();
            this.log.log("    Found " + (uPnPWANConnection.getGenericService().getServiceType().indexOf("PPP") == -1 ? "WANIPConnection" : "WANPPPConnection"));
            String string = uPnPWANConnection.getGenericService().getDevice().getRootDevice().getUSN();
            if (this.getDeviceStats(string, STATS_READ_OK) == 0L && this.getDeviceStats(string, STATS_READ_BAD) > 2L) {
                uPnPWANConnectionPortMappingArray = new UPnPWANConnectionPortMapping[]{};
                uPnPWANConnection.periodicallyRecheckMappings(false);
                this.log.log("    Not reading port mappings from device due to previous failures");
            } else {
                uPnPWANConnectionPortMappingArray = uPnPWANConnection.getPortMappings();
            }
            for (int i = 0; i < uPnPWANConnectionPortMappingArray.length; ++i) {
                this.log.log("      mapping [" + i + "] " + uPnPWANConnectionPortMappingArray[i].getExternalPort() + "/" + (uPnPWANConnectionPortMappingArray[i].isTCP() ? "TCP" : "UDP") + " [" + uPnPWANConnectionPortMappingArray[i].getDescription() + "] -> " + uPnPWANConnectionPortMappingArray[i].getInternalHost());
            }
            this.services.add(new UPnPPluginService(uPnPWANConnection, uPnPWANConnectionPortMappingArray, this.alert_success_param, this.grab_ports_param, this.alert_other_port_param, this.release_mappings_param));
            if (this.services.size() > 1) {
                PluginConfig pluginConfig;
                Object object;
                String string2 = uPnPWANConnection.getGenericService().getDevice().getRootDevice().getUSN();
                boolean bl = false;
                for (int i = 0; i < this.services.size() - 1; ++i) {
                    object = this.services.get(i);
                    String string3 = ((UPnPPluginService)object).getService().getGenericService().getDevice().getRootDevice().getUSN();
                    if (string2.equals(string3)) continue;
                    bl = true;
                    break;
                }
                if (bl && !(pluginConfig = this.plugin_interface.getPluginconfig()).getPluginBooleanParameter("upnp.device.multipledevices.warned", false)) {
                    pluginConfig.setPluginParameter("upnp.device.multipledevices.warned", true);
                    object = MessageText.getString("upnp.alert.multipledevice.warning");
                    this.log.logAlertRepeatable(2, (String)object);
                }
            }
            this.checkState();
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeService(UPnPWANConnection uPnPWANConnection, boolean bl) {
        try {
            this.this_mon.enter();
            String string = uPnPWANConnection.getGenericService().getServiceType().indexOf("PPP") == -1 ? "WANIPConnection" : "WANPPPConnection";
            String string2 = MessageText.getString("upnp.alert.lostdevice", new String[]{string, uPnPWANConnection.getGenericService().getDevice().getRootDevice().getLocation().getHost()});
            this.log.log(string2);
            if (!bl && this.alert_device_probs_param.getValue()) {
                this.log.logAlertRepeatable(2, string2);
            }
            for (int i = 0; i < this.services.size(); ++i) {
                UPnPPluginService uPnPPluginService = this.services.get(i);
                if (uPnPPluginService.getService() != uPnPWANConnection) continue;
                this.services.remove(i);
                break;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMapping(UPnPMapping uPnPMapping) {
        try {
            this.this_mon.enter();
            this.mappings.add(uPnPMapping);
            this.log.log("Mapping request: " + uPnPMapping.getString() + ", enabled = " + uPnPMapping.isEnabled());
            uPnPMapping.addListener(this);
            this.checkState();
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void mappingChanged(UPnPMapping uPnPMapping) {
        this.checkState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mappingDestroyed(UPnPMapping uPnPMapping) {
        try {
            this.this_mon.enter();
            this.mappings.remove(uPnPMapping);
            this.log.log("Mapping request removed: " + uPnPMapping.getString());
            for (int i = 0; i < this.services.size(); ++i) {
                UPnPPluginService uPnPPluginService = this.services.get(i);
                uPnPPluginService.removeMapping(this.log, uPnPMapping, false);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkState() {
        try {
            this.this_mon.enter();
            for (int i = 0; i < this.mappings.size(); ++i) {
                UPnPMapping uPnPMapping = this.mappings.get(i);
                for (int j = 0; j < this.services.size(); ++j) {
                    UPnPPluginService uPnPPluginService = this.services.get(j);
                    uPnPPluginService.checkMapping(this.log, uPnPMapping);
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getExternalIPAddresses() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            this.this_mon.enter();
            for (int i = 0; i < this.services.size(); ++i) {
                UPnPPluginService uPnPPluginService = this.services.get(i);
                try {
                    String string = uPnPPluginService.getService().getExternalIPAddress();
                    if (string == null) continue;
                    arrayList.add(string);
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UPnPPluginService[] getServices() {
        try {
            this.this_mon.enter();
            UPnPPluginService[] uPnPPluginServiceArray = this.services.toArray(new UPnPPluginService[this.services.size()]);
            return uPnPPluginServiceArray;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UPnPPluginService[] getServices(UPnPDevice uPnPDevice) {
        String string = uPnPDevice.getRootDevice().getUSN();
        ArrayList<UPnPPluginService> arrayList = new ArrayList<UPnPPluginService>();
        try {
            this.this_mon.enter();
            for (UPnPPluginService uPnPPluginService : this.services) {
                String string2 = uPnPPluginService.getService().getGenericService().getDevice().getRootDevice().getUSN();
                if (!string2.equals(string)) continue;
                arrayList.add(uPnPPluginService);
            }
        }
        finally {
            this.this_mon.exit();
        }
        return arrayList.toArray(new UPnPPluginService[arrayList.size()]);
    }

    public UPnPMapping addMapping(String string, boolean bl, int n, boolean bl2) {
        return this.mapping_manager.addMapping(string, bl, n, bl2);
    }

    public UPnPMapping getMapping(boolean bl, int n) {
        return this.mapping_manager.getMapping(bl, n);
    }

    public UPnPMapping[] getMappings() {
        return this.mapping_manager.getMappings();
    }

    public boolean isEnabled() {
        return this.upnp_enable_param.getValue();
    }

    protected void setNATPMPEnableState() {
        boolean bl = this.natpmp_enable_param.getValue() && this.upnp_enable_param.getValue();
        try {
            if (bl) {
                if (this.nat_pmp_upnp == null) {
                    this.nat_pmp_upnp = NatPMPUPnPFactory.create(this.upnp, NatPMPDeviceFactory.getSingleton(new NATPMPDeviceAdapter(){

                        @Override
                        public String getRouterAddress() {
                            return UPnPPlugin.this.nat_pmp_router.getValue();
                        }

                        @Override
                        public void log(String string) {
                            UPnPPlugin.this.log.log("NAT-PMP: " + string);
                        }
                    }));
                    this.nat_pmp_upnp.addListener(this);
                }
                this.nat_pmp_upnp.setEnabled(true);
            } else if (this.nat_pmp_upnp != null) {
                this.nat_pmp_upnp.setEnabled(false);
            }
        }
        catch (Throwable throwable) {
            this.log.log("Failed to initialise NAT-PMP subsystem", throwable);
        }
    }

    protected void logAlert(int n, String string, String[] stringArray) {
        String string2 = this.plugin_interface.getUtilities().getLocaleUtilities().getLocalisedMessageText(string, stringArray);
        this.log.logAlertRepeatable(n, string2);
    }

    public void refreshMappings() {
        this.refreshMappings(false);
    }

    public void refreshMappings(boolean bl) {
        if (bl) {
            this.closeDown(true);
            this.startUp();
        } else {
            this.upnp.reset();
        }
    }
}

