/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.selectedcontent;

import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.TableView;
import org.gudy.azureus2.core3.download.DownloadManager;

public class SelectedContentManager {
    private static List listeners = new ArrayList();
    private static ISelectedContent[] currentlySelectedContent = new ISelectedContent[0];
    private static String viewID = null;
    private static TableView tv = null;

    public static String getCurrentySelectedViewID() {
        return viewID;
    }

    public static void addCurrentlySelectedContentListener(SelectedContentListener selectedContentListener) {
        listeners.add(selectedContentListener);
        selectedContentListener.currentlySelectedContentChanged(currentlySelectedContent, viewID);
    }

    public static void clearCurrentlySelectedContent() {
        SelectedContentManager.changeCurrentlySelectedContent(null, null, null);
    }

    public static void changeCurrentlySelectedContent(String string, ISelectedContent[] iSelectedContentArray) {
        SelectedContentManager.changeCurrentlySelectedContent(string, iSelectedContentArray, null);
    }

    public static void changeCurrentlySelectedContent(String string, ISelectedContent[] iSelectedContentArray, TableView tableView) {
        tv = tableView;
        if (iSelectedContentArray == null) {
            iSelectedContentArray = new ISelectedContent[]{};
        }
        if (iSelectedContentArray.length == 0 && viewID != null && string != null && !string.equals(viewID)) {
            return;
        }
        currentlySelectedContent = iSelectedContentArray == null ? new ISelectedContent[]{} : iSelectedContentArray;
        viewID = string;
        Object[] objectArray = listeners.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            SelectedContentListener selectedContentListener = (SelectedContentListener)objectArray[i];
            selectedContentListener.currentlySelectedContentChanged(currentlySelectedContent, string);
        }
    }

    public static ISelectedContent[] getCurrentlySelectedContent() {
        return currentlySelectedContent;
    }

    public static DownloadManager[] getDMSFromSelectedContent() {
        ISelectedContent[] iSelectedContentArray = SelectedContentManager.getCurrentlySelectedContent();
        if (iSelectedContentArray.length > 0) {
            int n = 0;
            DownloadManager[] downloadManagerArray = new DownloadManager[iSelectedContentArray.length];
            for (int i = 0; i < iSelectedContentArray.length; ++i) {
                ISelectedContent iSelectedContent = iSelectedContentArray[i];
                if (iSelectedContent == null) continue;
                downloadManagerArray[n] = iSelectedContent.getDownloadManager();
                if (downloadManagerArray[n] == null) continue;
                ++n;
            }
            if (n > 0) {
                System.arraycopy(downloadManagerArray, 0, downloadManagerArray, 0, n);
                return downloadManagerArray;
            }
        }
        return null;
    }

    public static TableView getCurrentlySelectedTableView() {
        return tv;
    }
}

