/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.content.RelatedContent;
import com.aelitis.azureus.core.devices.DeviceOfflineDownload;
import com.aelitis.azureus.core.devices.TranscodeFile;
import com.aelitis.azureus.core.devices.TranscodeJob;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.selectedcontent.DownloadUrlInfo;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.util.ConstantsVuze;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

public class DataSourceUtils {
    public static org.gudy.azureus2.core3.disk.DiskManagerFileInfo getFileInfo(Object object) {
        try {
            if (object instanceof DiskManagerFileInfo) {
                return PluginCoreUtils.unwrap((DiskManagerFileInfo)object);
            }
            if (object instanceof org.gudy.azureus2.core3.disk.DiskManagerFileInfo) {
                return (org.gudy.azureus2.core3.disk.DiskManagerFileInfo)object;
            }
            if (object instanceof ISelectedContent && ((ISelectedContent)object).getFileIndex() >= 0) {
                ISelectedContent iSelectedContent = (ISelectedContent)object;
                int n = iSelectedContent.getFileIndex();
                DownloadManager downloadManager = iSelectedContent.getDownloadManager();
                return downloadManager.getDiskManagerFileInfoSet().getFiles()[n];
            }
            if (object instanceof TranscodeJob) {
                TranscodeJob transcodeJob = (TranscodeJob)object;
                try {
                    return PluginCoreUtils.unwrap(transcodeJob.getFile());
                }
                catch (DownloadException downloadException) {
                }
            } else if (object instanceof TranscodeFile) {
                TranscodeFile transcodeFile = (TranscodeFile)object;
                try {
                    DiskManagerFileInfo diskManagerFileInfo = transcodeFile.getSourceFile();
                    return PluginCoreUtils.unwrap(diskManagerFileInfo);
                }
                catch (DownloadException downloadException) {}
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
        }
        return null;
    }

    public static DownloadManager getDM(Object object) {
        block16: {
            try {
                if (object instanceof DownloadManager) {
                    return (DownloadManager)object;
                }
                if (object instanceof VuzeActivitiesEntry) {
                    String string;
                    VuzeActivitiesEntry vuzeActivitiesEntry = (VuzeActivitiesEntry)object;
                    DownloadManager downloadManager = vuzeActivitiesEntry.getDownloadManger();
                    if (downloadManager == null && (string = vuzeActivitiesEntry.getAssetHash()) != null && AzureusCoreFactory.isCoreRunning()) {
                        GlobalManager globalManager = AzureusCoreFactory.getSingleton().getGlobalManager();
                        downloadManager = globalManager.getDownloadManager(new HashWrapper(Base32.decode(string)));
                        vuzeActivitiesEntry.setDownloadManager(downloadManager);
                    }
                    return downloadManager;
                }
                if (object instanceof TOTorrent && AzureusCoreFactory.isCoreRunning()) {
                    GlobalManager globalManager = AzureusCoreFactory.getSingleton().getGlobalManager();
                    return globalManager.getDownloadManager((TOTorrent)object);
                }
                if (object instanceof ISelectedContent) {
                    return DataSourceUtils.getDM(((ISelectedContent)object).getDownloadManager());
                }
                if (object instanceof TranscodeJob) {
                    TranscodeJob transcodeJob = (TranscodeJob)object;
                    try {
                        Download download;
                        DiskManagerFileInfo diskManagerFileInfo = transcodeJob.getFile();
                        if (diskManagerFileInfo != null && (download = transcodeJob.getFile().getDownload()) != null) {
                            return PluginCoreUtils.unwrap(download);
                        }
                        break block16;
                    }
                    catch (DownloadException downloadException) {}
                    break block16;
                }
                if (object instanceof TranscodeFile) {
                    TranscodeFile transcodeFile = (TranscodeFile)object;
                    try {
                        Download download;
                        DiskManagerFileInfo diskManagerFileInfo = transcodeFile.getSourceFile();
                        if (diskManagerFileInfo != null && (download = diskManagerFileInfo.getDownload()) != null) {
                            return PluginCoreUtils.unwrap(download);
                        }
                        break block16;
                    }
                    catch (DownloadException downloadException) {}
                    break block16;
                }
                if (object instanceof DeviceOfflineDownload) {
                    return PluginCoreUtils.unwrap(((DeviceOfflineDownload)object).getDownload());
                }
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
            }
        }
        return null;
    }

    public static TOTorrent getTorrent(Object object) {
        Torrent torrent;
        Object object2;
        Object object3;
        Object object4;
        if (object instanceof TOTorrent) {
            return (TOTorrent)object;
        }
        if (object instanceof DownloadManager && (object4 = ((DownloadManager)object).getTorrent()) != null) {
            return object4;
        }
        if (object instanceof VuzeActivitiesEntry) {
            DownloadManager downloadManager;
            object4 = ((VuzeActivitiesEntry)object).getTorrent();
            if (object4 == null && (downloadManager = DataSourceUtils.getDM(object)) != null) {
                object4 = downloadManager.getTorrent();
            }
            return object4;
        }
        if (object instanceof TranscodeFile) {
            object4 = (TranscodeFile)object;
            try {
                object3 = object4.getSourceFile();
                if (object3 != null && (object2 = object3.getDownload()) != null && (torrent = object2.getTorrent()) != null) {
                    return PluginCoreUtils.unwrap(torrent);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (object instanceof TranscodeJob) {
            object4 = (TranscodeJob)object;
            try {
                object3 = object4.getFile();
                if (object3 != null && (object2 = object4.getFile().getDownload()) != null && (torrent = object2.getTorrent()) != null) {
                    return PluginCoreUtils.unwrap(torrent);
                }
            }
            catch (DownloadException downloadException) {
                // empty catch block
            }
        }
        if (object instanceof DeviceOfflineDownload && (object4 = ((DeviceOfflineDownload)object).getDownload().getTorrent()) != null) {
            return PluginCoreUtils.unwrap((Torrent)object4);
        }
        if (object instanceof ISelectedContent) {
            return ((ISelectedContent)object).getTorrent();
        }
        if (object instanceof String) {
            object4 = (String)object;
            try {
                object3 = AzureusCoreFactory.getSingleton().getGlobalManager();
                object2 = object3.getDownloadManager(new HashWrapper(Base32.decode((String)object4)));
                if (object2 != null) {
                    return object2.getTorrent();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isPlatformContent(Object object) {
        TOTorrent tOTorrent = DataSourceUtils.getTorrent(object);
        if (tOTorrent != null) {
            return PlatformTorrentUtils.isContent(tOTorrent, true);
        }
        return object instanceof VuzeActivitiesEntry && ((VuzeActivitiesEntry)object).isPlatformContent();
    }

    public static String getHash(Object object) {
        try {
            if (object instanceof DownloadManager) {
                return ((DownloadManager)object).getTorrent().getHashWrapper().toBase32String();
            }
            if (object instanceof TOTorrent) {
                return ((TOTorrent)object).getHashWrapper().toBase32String();
            }
            if (object instanceof DeviceOfflineDownload) {
                return DataSourceUtils.getHash(PluginCoreUtils.unwrap(((DeviceOfflineDownload)object).getDownload()));
            }
            if (object instanceof VuzeActivitiesEntry) {
                VuzeActivitiesEntry vuzeActivitiesEntry = (VuzeActivitiesEntry)object;
                return vuzeActivitiesEntry.getAssetHash();
            }
            if (object instanceof ISelectedContent) {
                return ((ISelectedContent)object).getHash();
            }
            if (object instanceof String) {
                return (String)object;
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
        }
        return null;
    }

    public static ContentNetwork getContentNetwork(Object object) {
        Object object2;
        long l;
        block18: {
            l = -1L;
            try {
                if (object instanceof DownloadManager) {
                    l = PlatformTorrentUtils.getContentNetworkID(((DownloadManager)object).getTorrent());
                    break block18;
                }
                if (object instanceof TOTorrent) {
                    l = PlatformTorrentUtils.getContentNetworkID((TOTorrent)object);
                    break block18;
                }
                if (object instanceof DeviceOfflineDownload) {
                    return DataSourceUtils.getContentNetwork(PluginCoreUtils.unwrap(((DeviceOfflineDownload)object).getDownload()));
                }
                if (object instanceof VuzeActivitiesEntry) {
                    VuzeActivitiesEntry vuzeActivitiesEntry = (VuzeActivitiesEntry)object;
                    return vuzeActivitiesEntry.getContentNetwork();
                }
                if (object instanceof ISelectedContent) {
                    return DataSourceUtils.getContentNetwork(((ISelectedContent)object).getDownloadManager());
                }
                if (object instanceof String && ((String)object).length() == 32) {
                    l = ConstantsVuze.getDefaultContentNetwork().getID();
                    break block18;
                }
                if (object instanceof TranscodeJob) {
                    object2 = (TranscodeJob)object;
                    try {
                        Download download;
                        DiskManagerFileInfo diskManagerFileInfo = object2.getFile();
                        if (diskManagerFileInfo != null && (download = object2.getFile().getDownload()) != null) {
                            DownloadManager downloadManager = PluginCoreUtils.unwrap(download);
                            return DataSourceUtils.getContentNetwork(downloadManager);
                        }
                        break block18;
                    }
                    catch (DownloadException downloadException) {}
                    break block18;
                }
                if (object instanceof TranscodeFile) {
                    object2 = (TranscodeFile)object;
                    try {
                        Download download;
                        DiskManagerFileInfo diskManagerFileInfo = object2.getSourceFile();
                        if (diskManagerFileInfo != null && (download = diskManagerFileInfo.getDownload()) != null) {
                            DownloadManager downloadManager = PluginCoreUtils.unwrap(download);
                            return DataSourceUtils.getContentNetwork(downloadManager);
                        }
                        break block18;
                    }
                    catch (Throwable throwable) {}
                    break block18;
                }
                if (object instanceof RelatedContent) {
                    l = ((RelatedContent)object).getContentNetwork();
                } else {
                    Debug.out("Tux: UH OH NO CN for " + object + "\n" + Debug.getCompressedStackTrace());
                }
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
            }
        }
        object2 = ContentNetworkManagerFactory.getSingleton().getContentNetwork(l);
        return object2;
    }

    public static DownloadUrlInfo getDownloadInfo(Object object) {
        if (object instanceof ISelectedContent) {
            return ((ISelectedContent)object).getDownloadInfo();
        }
        return null;
    }
}

