/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.content.AzureusPlatformContentDirectory;
import com.aelitis.azureus.core.content.RelatedContentManager;
import com.aelitis.azureus.core.devices.Device;
import com.aelitis.azureus.core.devices.DeviceManager;
import com.aelitis.azureus.core.devices.DeviceManagerFactory;
import com.aelitis.azureus.core.devices.DeviceMediaRenderer;
import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.download.DownloadManagerEnhancer;
import com.aelitis.azureus.core.metasearch.MetaSearchManagerFactory;
import com.aelitis.azureus.core.metasearch.MetaSearchManagerListener;
import com.aelitis.azureus.core.peer.cache.CacheDiscovery;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionManagerFactory;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.util.AZ3Functions;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.DownloadUtils;
import com.aelitis.azureus.util.ExternalStimulusHandler;
import com.aelitis.azureus.util.NavigationHelper;
import com.aelitis.azureus.util.PlayUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManagerStateAttributeListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadWillBeAddedListener;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

public class InitialisationFunctions {
    private static final String EXTENSION_PREFIX = "azid";

    public static void earlyInitialisation(AzureusCore azureusCore) {
        DownloadUtils.initialise();
        DownloadManagerEnhancer downloadManagerEnhancer = DownloadManagerEnhancer.initialise(azureusCore);
        InitialisationFunctions.hookDownloadAddition();
        AzureusPlatformContentDirectory.register();
        CacheDiscovery.initialise(downloadManagerEnhancer);
        ContentNetworkManagerFactory.preInitialise();
        MetaSearchManagerFactory.preInitialise();
        SubscriptionManagerFactory.preInitialise();
        DeviceManagerFactory.preInitialise();
        NavigationHelper.initialise();
        RelatedContentManager.preInitialise(azureusCore);
        AZ3Functions.setProvider(new AZ3Functions.provider(){

            @Override
            public String getDefaultContentNetworkURL(int n, Object[] objectArray) {
                return ConstantsVuze.getDefaultContentNetwork().getServiceURL(n, objectArray);
            }

            @Override
            public void subscribeToRSS(String string, URL uRL, int n, boolean bl, String string2) throws Exception {
                Subscription subscription = SubscriptionManagerFactory.getSingleton().createSingletonRSS(string, uRL, n);
                if (subscription.isPublic() != bl) {
                    subscription.setPublic(bl);
                }
                if (string2 != null) {
                    subscription.setCreatorRef(string2);
                }
            }

            @Override
            public boolean canPlay(org.gudy.azureus2.core3.download.DownloadManager downloadManager, int n) {
                return PlayUtils.canPlayDS(downloadManager, n);
            }

            @Override
            public void play(org.gudy.azureus2.core3.download.DownloadManager downloadManager, int n) {
                DiskManagerFileInfo[] diskManagerFileInfoArray;
                Object object = downloadManager;
                if (n >= 0 && n < (diskManagerFileInfoArray = downloadManager.getDiskManagerFileInfoSet().getFiles()).length) {
                    object = diskManagerFileInfoArray[n];
                }
            }

            @Override
            public AZ3Functions.provider.TranscodeTarget[] getTranscodeTargets() {
                ArrayList<1> arrayList = new ArrayList<1>();
                if (!COConfigurationManager.getStringParameter("ui").equals("az2")) {
                    try {
                        Device[] deviceArray;
                        DeviceManager deviceManager = DeviceManagerFactory.getSingleton();
                        for (final Device device : deviceArray = deviceManager.getDevices()) {
                            if (!(device instanceof DeviceMediaRenderer)) continue;
                            final DeviceMediaRenderer deviceMediaRenderer = (DeviceMediaRenderer)device;
                            boolean bl = device.isHidden();
                            if (COConfigurationManager.getBooleanParameter("device.sidebar.ui.rend.hidegeneric", true) && deviceMediaRenderer.isNonSimple()) {
                                bl = true;
                            }
                            if (bl) continue;
                            arrayList.add(new AZ3Functions.provider.TranscodeTarget(){

                                @Override
                                public String getName() {
                                    return device.getName();
                                }

                                @Override
                                public AZ3Functions.provider.TranscodeProfile[] getProfiles() {
                                    ArrayList<AZ3Functions.provider.TranscodeProfile> arrayList = new ArrayList<AZ3Functions.provider.TranscodeProfile>();
                                    TranscodeProfile[] transcodeProfileArray = deviceMediaRenderer.getTranscodeProfiles();
                                    if (transcodeProfileArray.length == 0) {
                                        if (deviceMediaRenderer.getTranscodeRequirement() == 1) {
                                            arrayList.add(new AZ3Functions.provider.TranscodeProfile(){

                                                @Override
                                                public String getUID() {
                                                    return deviceMediaRenderer.getID() + "/" + deviceMediaRenderer.getBlankProfile().getName();
                                                }

                                                @Override
                                                public String getName() {
                                                    return MessageText.getString("devices.profile.direct");
                                                }
                                            });
                                        }
                                    } else {
                                        for (final TranscodeProfile transcodeProfile : transcodeProfileArray) {
                                            arrayList.add(new AZ3Functions.provider.TranscodeProfile(){

                                                @Override
                                                public String getUID() {
                                                    return transcodeProfile.getUID();
                                                }

                                                @Override
                                                public String getName() {
                                                    return transcodeProfile.getName();
                                                }
                                            });
                                        }
                                    }
                                    return arrayList.toArray(new AZ3Functions.provider.TranscodeProfile[arrayList.size()]);
                                }
                            });
                        }
                    }
                    catch (Throwable throwable) {
                        Debug.out(throwable);
                    }
                }
                Collections.sort(arrayList, new Comparator<AZ3Functions.provider.TranscodeTarget>(){

                    @Override
                    public int compare(AZ3Functions.provider.TranscodeTarget transcodeTarget, AZ3Functions.provider.TranscodeTarget transcodeTarget2) {
                        return transcodeTarget.getName().compareTo(transcodeTarget2.getName());
                    }
                });
                return arrayList.toArray(new AZ3Functions.provider.TranscodeTarget[arrayList.size()]);
            }
        });
    }

    public static void lateInitialisation(AzureusCore azureusCore) {
        ExternalStimulusHandler.initialise(azureusCore);
        PluginInitializer.getDefaultInterface().getUtilities().createDelayedTask(new Runnable(){

            @Override
            public void run() {
                MetaSearchManagerFactory.getSingleton();
                SubscriptionManagerFactory.getSingleton();
                try {
                    RelatedContentManager.getSingleton();
                }
                catch (Throwable throwable) {
                    Debug.out(throwable);
                }
                try {
                    MetaSearchManagerFactory.getSingleton().addListener(new MetaSearchManagerListener(){

                        @Override
                        public void searchRequest(String string) {
                        }
                    });
                }
                catch (Throwable throwable) {
                    Debug.out(throwable);
                }
            }
        }).queue();
    }

    protected static void hookDownloadAddition() {
        PluginInterface pluginInterface = PluginInitializer.getDefaultInterface();
        DownloadManager downloadManager = pluginInterface.getDownloadManager();
        downloadManager.addDownloadWillBeAddedListener(new DownloadWillBeAddedListener(){

            @Override
            public void initialised(Download download) {
                org.gudy.azureus2.core3.download.DownloadManager downloadManager = PluginCoreUtils.unwrap(download);
                if (PlatformTorrentUtils.getHasBeenOpened(downloadManager)) {
                    PlatformTorrentUtils.setHasBeenOpened(downloadManager, false);
                }
                InitialisationFunctions.register(download);
            }
        });
        downloadManager.addListener(new DownloadManagerListener(){

            @Override
            public void downloadAdded(Download download) {
                InitialisationFunctions.register(download);
            }

            @Override
            public void downloadRemoved(Download download) {
            }
        });
    }

    protected static void register(final Download download) {
        DownloadManagerStateAttributeListener downloadManagerStateAttributeListener = new DownloadManagerStateAttributeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void attributeEventOccurred(org.gudy.azureus2.core3.download.DownloadManager downloadManager, String string, int n) {
                try {
                    Torrent torrent = download.getTorrent();
                    if (torrent == null) {
                        return;
                    }
                    if (!PlatformTorrentUtils.isContent(torrent, true)) {
                        return;
                    }
                    DownloadUtils.addTrackerExtension(download, InitialisationFunctions.EXTENSION_PREFIX, ConstantsVuze.AZID);
                    download.setFlag(32L, true);
                }
                finally {
                    downloadManager.getDownloadState().removeListener(this, "trackerclientextensions", 2);
                }
            }
        };
        PluginCoreUtils.unwrap(download).getDownloadState().addListener(downloadManagerStateAttributeListener, "trackerclientextensions", 2);
    }
}

