/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.udp.mc.impl;

import com.aelitis.net.udp.mc.MCGroup;
import com.aelitis.net.udp.mc.MCGroupAdapter;
import com.aelitis.net.udp.mc.MCGroupException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class MCGroupImpl
implements MCGroup {
    private static final int TTL = 4;
    private static final int PACKET_SIZE = 8192;
    private static Map singletons = new HashMap();
    private static AEMonitor class_mon = new AEMonitor("MCGroup:class");
    private MCGroupAdapter adapter;
    private String group_address_str;
    private int group_port;
    private int control_port;
    protected InetSocketAddress group_address;
    private String[] selected_interfaces;
    private boolean ttl_problem_reported = true;
    private boolean sso_problem_reported = true;
    protected AEMonitor this_mon = new AEMonitor("MCGroup");
    private Map current_registrations = new HashMap();
    private AsyncDispatcher async_dispatcher = new AsyncDispatcher();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MCGroupImpl getSingleton(MCGroupAdapter mCGroupAdapter, String string, int n, int n2, String[] stringArray) throws MCGroupException {
        try {
            class_mon.enter();
            String string2 = string + ":" + n + ":" + n2;
            MCGroupImpl mCGroupImpl = (MCGroupImpl)singletons.get(string2);
            if (mCGroupImpl == null) {
                int n3;
                if (n2 == 0 && (n3 = COConfigurationManager.getIntParameter("mcgroup.ports." + string2, 0)) != 0) {
                    try {
                        DatagramSocket datagramSocket = new DatagramSocket(null);
                        datagramSocket.setReuseAddress(false);
                        datagramSocket.bind(new InetSocketAddress(n3));
                        datagramSocket.close();
                        n2 = n3;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                mCGroupImpl = new MCGroupImpl(mCGroupAdapter, string, n, n2, stringArray);
                if (n2 == 0) {
                    n2 = mCGroupImpl.getControlPort();
                    COConfigurationManager.setParameter("mcgroup.ports." + string2, n2);
                }
                singletons.put(string2, mCGroupImpl);
            }
            MCGroupImpl mCGroupImpl2 = mCGroupImpl;
            return mCGroupImpl2;
        }
        finally {
            class_mon.exit();
        }
    }

    public MCGroupImpl(MCGroupAdapter mCGroupAdapter, String string, int n, int n2, String[] stringArray) throws MCGroupException {
        this.adapter = mCGroupAdapter;
        this.group_address_str = string;
        this.group_port = n;
        this.control_port = n2;
        this.selected_interfaces = stringArray;
        try {
            this.group_address = new InetSocketAddress(InetAddress.getByName(this.group_address_str), 0);
            this.processNetworkInterfaces(true);
            SimpleTimer.addPeriodicEvent("MCGroup:refresher", 60000L, new TimerEventPerformer(){

                @Override
                public void perform(TimerEvent timerEvent2) {
                    try {
                        MCGroupImpl.this.processNetworkInterfaces(false);
                    }
                    catch (Throwable throwable) {
                        MCGroupImpl.this.adapter.log(throwable);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            throw new MCGroupException("Failed to initialise MCGroup", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processNetworkInterfaces(boolean bl) throws SocketException {
        HashMap hashMap = new HashMap();
        ArrayList<NetworkInterface> arrayList = new ArrayList<NetworkInterface>();
        try {
            this.this_mon.enter();
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                final NetworkInterface networkInterface2 = enumeration.nextElement();
                if (!this.interfaceSelected(networkInterface2)) {
                    if (!bl) continue;
                    this.adapter.trace("ignoring interface " + networkInterface2.getName() + ":" + networkInterface2.getDisplayName() + ", not selected");
                    continue;
                }
                HashSet hashSet = (HashSet)this.current_registrations.get(networkInterface2);
                if (hashSet == null) {
                    hashSet = new HashSet();
                }
                HashSet<InetAddress> hashSet2 = new HashSet<InetAddress>();
                hashMap.put(networkInterface2, hashSet2);
                Enumeration<InetAddress> enumeration2 = networkInterface2.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    DatagramSocket datagramSocket;
                    final InetAddress inetAddress = enumeration2.nextElement();
                    hashSet2.add(inetAddress);
                    if (hashSet.contains(inetAddress)) continue;
                    if (inetAddress.isLoopbackAddress()) {
                        if (!bl) continue;
                        this.adapter.trace("ignoring loopback address " + inetAddress + ", interface " + networkInterface2.getName());
                        continue;
                    }
                    if (inetAddress instanceof Inet6Address) {
                        if (!bl) continue;
                        this.adapter.trace("ignoring IPv6 address " + inetAddress + ", interface " + networkInterface2.getName());
                        continue;
                    }
                    if (!bl && !arrayList.contains(networkInterface2)) {
                        arrayList.add(networkInterface2);
                    }
                    try {
                        block19: {
                            datagramSocket = new MulticastSocket(this.group_port);
                            datagramSocket.setReuseAddress(true);
                            try {
                                ((MulticastSocket)datagramSocket).setTimeToLive(4);
                            }
                            catch (Throwable throwable) {
                                if (this.ttl_problem_reported) break block19;
                                this.ttl_problem_reported = true;
                                this.adapter.log(throwable);
                            }
                        }
                        String string = "";
                        Enumeration<InetAddress> enumeration3 = networkInterface2.getInetAddresses();
                        while (enumeration3.hasMoreElements()) {
                            InetAddress inetAddress2 = enumeration3.nextElement();
                            string = string + (string.length() == 0 ? "" : ",") + inetAddress2;
                        }
                        this.adapter.trace("group = " + this.group_address + "/" + networkInterface2.getName() + ":" + networkInterface2.getDisplayName() + "-" + string + ": started");
                        ((MulticastSocket)datagramSocket).joinGroup(this.group_address, networkInterface2);
                        ((MulticastSocket)datagramSocket).setNetworkInterface(networkInterface2);
                        ((MulticastSocket)datagramSocket).setLoopbackMode(false);
                        Runtime.getRuntime().addShutdownHook(new AEThread("MCGroup:VMShutdown", (MulticastSocket)datagramSocket, networkInterface2){
                            final /* synthetic */ MulticastSocket val$mc_sock;
                            final /* synthetic */ NetworkInterface val$network_interface;
                            {
                                this.val$mc_sock = multicastSocket;
                                this.val$network_interface = networkInterface2;
                                super(string);
                            }

                            @Override
                            public void runSupport() {
                                try {
                                    this.val$mc_sock.leaveGroup(MCGroupImpl.this.group_address, this.val$network_interface);
                                }
                                catch (Throwable throwable) {
                                    MCGroupImpl.this.adapter.log(throwable);
                                }
                            }
                        });
                        new AEThread2("MCGroup:MCListener", true, (MulticastSocket)datagramSocket){
                            final /* synthetic */ MulticastSocket val$mc_sock;
                            {
                                this.val$mc_sock = multicastSocket;
                                super(string, bl);
                            }

                            @Override
                            public void run() {
                                MCGroupImpl.this.handleSocket(networkInterface2, inetAddress, this.val$mc_sock, true);
                            }
                        }.start();
                    }
                    catch (Throwable throwable) {
                        this.adapter.log(throwable);
                    }
                    try {
                        datagramSocket = new DatagramSocket(null);
                        datagramSocket.setReuseAddress(true);
                        datagramSocket.bind(new InetSocketAddress(inetAddress, this.control_port));
                        if (this.control_port == 0) {
                            this.control_port = datagramSocket.getLocalPort();
                        }
                        new AEThread2("MCGroup:CtrlListener", true){

                            @Override
                            public void run() {
                                MCGroupImpl.this.handleSocket(networkInterface2, inetAddress, datagramSocket, false);
                            }
                        }.start();
                    }
                    catch (Throwable throwable) {
                        this.adapter.log(throwable);
                    }
                }
            }
        }
        finally {
            this.current_registrations = hashMap;
            this.this_mon.exit();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            this.adapter.interfaceChanged((NetworkInterface)arrayList.get(i));
        }
    }

    @Override
    public int getControlPort() {
        return this.control_port;
    }

    protected boolean interfaceSelected(NetworkInterface networkInterface2) {
        if (this.selected_interfaces != null && this.selected_interfaces.length > 0) {
            boolean bl = false;
            for (int i = 0; i < this.selected_interfaces.length; ++i) {
                if (!networkInterface2.getName().equalsIgnoreCase(this.selected_interfaces[i])) continue;
                bl = true;
                break;
            }
            return bl;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validNetworkAddress(NetworkInterface networkInterface2, InetAddress inetAddress) {
        try {
            this.this_mon.enter();
            Set set = (Set)this.current_registrations.get(networkInterface2);
            if (set == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = set.contains(inetAddress);
            return bl;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void sendToGroup(final byte[] byArray) {
        this.async_dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                MCGroupImpl.this.sendToGroupSupport(byArray);
            }
        });
    }

    private void sendToGroupSupport(byte[] byArray) {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration != null && enumeration.hasMoreElements()) {
                Object object;
                NetworkInterface networkInterface2 = enumeration.nextElement();
                if (!this.interfaceSelected(networkInterface2)) continue;
                Enumeration<InetAddress> enumeration2 = networkInterface2.getInetAddresses();
                boolean bl = false;
                while (enumeration2.hasMoreElements()) {
                    object = enumeration2.nextElement();
                    if (object instanceof Inet6Address || ((InetAddress)object).isLoopbackAddress()) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                try {
                    block8: {
                        object = new MulticastSocket(null);
                        ((DatagramSocket)object).setReuseAddress(true);
                        try {
                            ((MulticastSocket)object).setTimeToLive(4);
                        }
                        catch (Throwable throwable) {
                            if (this.ttl_problem_reported) break block8;
                            this.ttl_problem_reported = true;
                            this.adapter.log(throwable);
                        }
                    }
                    ((DatagramSocket)object).bind(new InetSocketAddress(this.control_port));
                    ((MulticastSocket)object).setNetworkInterface(networkInterface2);
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.group_address.getAddress(), this.group_port);
                    ((DatagramSocket)object).send(datagramPacket);
                    ((DatagramSocket)object).close();
                }
                catch (Throwable throwable) {
                    if (this.sso_problem_reported) continue;
                    this.sso_problem_reported = true;
                    this.adapter.log(throwable);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void sendToGroup(final String string) {
        this.async_dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                MCGroupImpl.this.sendToGroupSupport(string);
            }
        });
    }

    private void sendToGroupSupport(String string) {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration != null && enumeration.hasMoreElements()) {
                Object object;
                NetworkInterface networkInterface2 = enumeration.nextElement();
                if (!this.interfaceSelected(networkInterface2)) continue;
                Enumeration<InetAddress> enumeration2 = networkInterface2.getInetAddresses();
                Object object2 = null;
                while (enumeration2.hasMoreElements()) {
                    object = enumeration2.nextElement();
                    if (object instanceof Inet6Address || ((InetAddress)object).isLoopbackAddress()) continue;
                    object2 = object;
                    break;
                }
                if (object2 == null) continue;
                try {
                    block8: {
                        object = new MulticastSocket(null);
                        ((DatagramSocket)object).setReuseAddress(true);
                        try {
                            ((MulticastSocket)object).setTimeToLive(4);
                        }
                        catch (Throwable throwable) {
                            if (this.ttl_problem_reported) break block8;
                            this.ttl_problem_reported = true;
                            this.adapter.log(throwable);
                        }
                    }
                    ((DatagramSocket)object).bind(new InetSocketAddress(this.control_port));
                    ((MulticastSocket)object).setNetworkInterface(networkInterface2);
                    byte[] byArray = string.replaceAll("%AZINTERFACE%", ((InetAddress)object2).getHostAddress()).getBytes();
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.group_address.getAddress(), this.group_port);
                    ((DatagramSocket)object).send(datagramPacket);
                    ((DatagramSocket)object).close();
                }
                catch (Throwable throwable) {
                    if (this.sso_problem_reported) continue;
                    this.sso_problem_reported = true;
                    this.adapter.log(throwable);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void handleSocket(NetworkInterface var1_1, InetAddress var2_2, DatagramSocket var3_3, boolean var4_4) {
        var5_5 = 0L;
        var7_6 = 0L;
        var9_7 = var3_3.getLocalPort();
        try {
            var3_3.setSoTimeout(30000);
        }
        catch (Throwable var10_8) {
            // empty catch block
        }
        while (true) {
            if (!this.validNetworkAddress(var1_1, var2_2)) {
                if (var4_4) {
                    this.adapter.trace("group = " + this.group_address + "/" + var1_1.getName() + ":" + var1_1.getDisplayName() + " - " + var2_2 + ": stopped");
                }
                return;
            }
            try {
                var10_9 = new byte[8192];
                var11_12 = new DatagramPacket(var10_9, var10_9.length);
                var3_3.receive(var11_12);
                ++var5_5;
                var7_6 = 0L;
                this.receivePacket(var1_1, var2_2, var11_12);
                continue;
            }
            catch (SocketTimeoutException var10_10) {
                continue;
            }
            catch (Throwable var10_11) {
                this.adapter.trace("MCGroup: receive failed on port " + var9_7 + ":" + var10_11.getMessage());
                if (++var7_6 > 100L && var5_5 == 0L || var7_6 > 1000L) ** break;
                continue;
                this.adapter.trace("    too many failures, abandoning");
                return;
            }
            break;
        }
    }

    protected void receivePacket(NetworkInterface networkInterface2, InetAddress inetAddress, DatagramPacket datagramPacket) {
        byte[] byArray = datagramPacket.getData();
        int n = datagramPacket.getLength();
        this.adapter.received(networkInterface2, inetAddress, (InetSocketAddress)datagramPacket.getSocketAddress(), byArray, n);
    }

    @Override
    public void sendToMember(InetSocketAddress inetSocketAddress, byte[] byArray) throws MCGroupException {
        DatagramSocket datagramSocket = null;
        try {
            datagramSocket = new DatagramSocket(null);
            datagramSocket.setReuseAddress(true);
            datagramSocket.bind(new InetSocketAddress(this.group_port));
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetSocketAddress);
            datagramSocket.send(datagramPacket);
        }
        catch (Throwable throwable) {
            throw new MCGroupException("sendToMember failed", throwable);
        }
        finally {
            if (datagramSocket != null) {
                try {
                    datagramSocket.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

