/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.upnp.impl.services;

import com.aelitis.net.upnp.UPnPAction;
import com.aelitis.net.upnp.UPnPDevice;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPService;
import com.aelitis.net.upnp.UPnPStateVariable;
import com.aelitis.net.upnp.impl.device.UPnPDeviceImpl;
import com.aelitis.net.upnp.impl.services.UPnPActionImpl;
import com.aelitis.net.upnp.impl.services.UPnPSSOfflineDownloaderImpl;
import com.aelitis.net.upnp.impl.services.UPnPSSWANCommonInterfaceConfigImpl;
import com.aelitis.net.upnp.impl.services.UPnPSSWANIPConnectionImpl;
import com.aelitis.net.upnp.impl.services.UPnPSSWANPPPConnectionImpl;
import com.aelitis.net.upnp.impl.services.UPnPStateVariableImpl;
import com.aelitis.net.upnp.services.UPnPSpecificService;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;

public class UPnPServiceImpl
implements UPnPService {
    protected UPnPDeviceImpl device;
    protected String service_type;
    protected String local_desc_url;
    protected String local_control_url;
    protected List actions;
    protected List state_vars;
    protected boolean direct_invoke;

    public UPnPServiceImpl(UPnPDeviceImpl uPnPDeviceImpl, String string, SimpleXMLParserDocumentNode simpleXMLParserDocumentNode) {
        this.device = uPnPDeviceImpl;
        this.service_type = simpleXMLParserDocumentNode.getChild("ServiceType").getValue().trim();
        this.local_desc_url = simpleXMLParserDocumentNode.getChild("SCPDURL").getValue();
        this.local_control_url = simpleXMLParserDocumentNode.getChild("controlURL").getValue();
        this.device.getUPnP().log(string + this.service_type + ":desc=" + this.device.getAbsoluteURL(this.local_desc_url) + ", control=" + this.device.getAbsoluteURL(this.local_control_url));
    }

    @Override
    public UPnPDevice getDevice() {
        return this.device;
    }

    @Override
    public String getServiceType() {
        return this.service_type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnectable() {
        boolean bl;
        URL uRL = this.getControlURL();
        Socket socket = new Socket();
        try {
            int n = uRL.getPort();
            if (n <= 0) {
                n = uRL.getDefaultPort();
            }
            socket.connect(new InetSocketAddress(uRL.getHost(), n), 5000);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (Throwable throwable3) {
                return false;
            }
        }
        try {
            socket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    @Override
    public UPnPAction[] getActions() throws UPnPException {
        if (this.actions == null) {
            this.loadDescription();
        }
        UPnPAction[] uPnPActionArray = new UPnPAction[this.actions.size()];
        this.actions.toArray(uPnPActionArray);
        return uPnPActionArray;
    }

    @Override
    public UPnPAction getAction(String string) throws UPnPException {
        UPnPAction[] uPnPActionArray = this.getActions();
        for (int i = 0; i < uPnPActionArray.length; ++i) {
            if (!uPnPActionArray[i].getName().equalsIgnoreCase(string)) continue;
            return uPnPActionArray[i];
        }
        return null;
    }

    @Override
    public UPnPStateVariable[] getStateVariables() throws UPnPException {
        if (this.state_vars == null) {
            this.loadDescription();
        }
        UPnPStateVariable[] uPnPStateVariableArray = new UPnPStateVariable[this.state_vars.size()];
        this.state_vars.toArray(uPnPStateVariableArray);
        return uPnPStateVariableArray;
    }

    @Override
    public UPnPStateVariable getStateVariable(String string) throws UPnPException {
        UPnPStateVariable[] uPnPStateVariableArray = this.getStateVariables();
        for (int i = 0; i < uPnPStateVariableArray.length; ++i) {
            if (!uPnPStateVariableArray[i].getName().equalsIgnoreCase(string)) continue;
            return uPnPStateVariableArray[i];
        }
        return null;
    }

    public URL getDescriptionURL() throws UPnPException {
        return this.getURL(this.device.getAbsoluteURL(this.local_desc_url));
    }

    @Override
    public URL getControlURL() throws UPnPException {
        return this.getURL(this.device.getAbsoluteURL(this.local_control_url));
    }

    protected URL getURL(String string) throws UPnPException {
        try {
            URL uRL;
            String string2 = string.toLowerCase();
            if (string2.startsWith("http") || string2.startsWith("https")) {
                uRL = new URL(string);
            } else {
                URL uRL2 = this.device.getRootDevice().getLocation();
                uRL = new URL(uRL2.getProtocol() + "://" + uRL2.getHost() + (uRL2.getPort() == -1 ? "" : ":" + uRL2.getPort()) + (string.startsWith("/") ? "" : "/") + string);
            }
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            throw new UPnPException("Malformed URL", malformedURLException);
        }
    }

    protected void loadDescription() throws UPnPException {
        SimpleXMLParserDocument simpleXMLParserDocument = this.device.getUPnP().downloadXML(this.device, this.getDescriptionURL());
        this.parseActions(simpleXMLParserDocument.getChild("ActionList"));
        this.parseStateVars(simpleXMLParserDocument.getChild("ServiceStateTable"));
    }

    protected void parseActions(SimpleXMLParserDocumentNode simpleXMLParserDocumentNode) {
        this.actions = new ArrayList();
        SimpleXMLParserDocumentNode[] simpleXMLParserDocumentNodeArray = simpleXMLParserDocumentNode.getChildren();
        for (int i = 0; i < simpleXMLParserDocumentNodeArray.length; ++i) {
            this.actions.add(new UPnPActionImpl(this, simpleXMLParserDocumentNodeArray[i]));
        }
    }

    protected void parseStateVars(SimpleXMLParserDocumentNode simpleXMLParserDocumentNode) {
        this.state_vars = new ArrayList();
        SimpleXMLParserDocumentNode[] simpleXMLParserDocumentNodeArray = simpleXMLParserDocumentNode.getChildren();
        for (int i = 0; i < simpleXMLParserDocumentNodeArray.length; ++i) {
            this.state_vars.add(new UPnPStateVariableImpl(this, simpleXMLParserDocumentNodeArray[i]));
        }
    }

    @Override
    public UPnPSpecificService getSpecificService() {
        if (this.service_type.equalsIgnoreCase("urn:schemas-upnp-org:service:WANIPConnection:1")) {
            return new UPnPSSWANIPConnectionImpl(this);
        }
        if (this.service_type.equalsIgnoreCase("urn:schemas-upnp-org:service:WANPPPConnection:1")) {
            return new UPnPSSWANPPPConnectionImpl(this);
        }
        if (this.service_type.equalsIgnoreCase("urn:schemas-upnp-org:service:WANCommonInterfaceConfig:1")) {
            return new UPnPSSWANCommonInterfaceConfigImpl(this);
        }
        if (this.service_type.equalsIgnoreCase("urn:schemas-upnp-org:service:VuzeOfflineDownloaderService:1")) {
            return new UPnPSSOfflineDownloaderImpl(this);
        }
        return null;
    }

    @Override
    public boolean getDirectInvocations() {
        return this.direct_invoke;
    }

    @Override
    public void setDirectInvocations(boolean bl) {
        this.direct_invoke = bl;
    }
}

