/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERNull;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERNumericString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERTags;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.asn1.DERUnknownTag;
import org.bouncycastle.asn1.DERVisibleString;
import org.bouncycastle.asn1.DefiniteLengthInputStream;

public class ASN1InputStream
extends FilterInputStream
implements DERTags {
    private static final DERObject END_OF_STREAM = new DERObject(){

        @Override
        void encode(DEROutputStream dEROutputStream) throws IOException {
            throw new IOException("Eeek!");
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object object) {
            return object == this;
        }
    };
    boolean eofFound = false;
    int limit = Integer.MAX_VALUE;

    public ASN1InputStream(InputStream inputStream) {
        super(inputStream);
    }

    public ASN1InputStream(byte[] byArray) {
        this(new ByteArrayInputStream(byArray), byArray.length);
    }

    public ASN1InputStream(InputStream inputStream, int n) {
        super(inputStream);
        this.limit = n;
    }

    protected int readLength() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new IOException("EOF found when length expected");
        }
        if (n == 128) {
            return -1;
        }
        if (n > 127) {
            int n2 = n & 0x7F;
            if (n2 > 4) {
                throw new IOException("DER length more than 4 bytes");
            }
            n = 0;
            for (int i = 0; i < n2; ++i) {
                int n3 = this.read();
                if (n3 < 0) {
                    throw new IOException("EOF found reading length");
                }
                n = (n << 8) + n3;
            }
            if (n < 0) {
                throw new IOException("corrupted stream - negative length found");
            }
            if (n >= this.limit) {
                throw new IOException("corrupted stream - out of bounds length found");
            }
        }
        return n;
    }

    protected void readFully(byte[] byArray) throws IOException {
        int n;
        int n2 = byArray.length;
        if (n2 == 0) {
            return;
        }
        while ((n = this.read(byArray, byArray.length - n2, n2)) > 0) {
            if ((n2 -= n) != 0) continue;
            return;
        }
        if (n2 != 0) {
            throw new EOFException("EOF encountered in middle of object");
        }
    }

    protected DERObject buildObject(int n, int n2, int n3) throws IOException {
        boolean bl;
        if ((n & 0x40) != 0) {
            return new DERApplicationSpecific(n2, this.readDefiniteLengthFully(n3));
        }
        boolean bl2 = bl = (n & 0x20) != 0;
        if (bl) {
            switch (n) {
                case 48: {
                    return new DERSequence(this.buildDerEncodableVector(n3));
                }
                case 49: {
                    return new DERSet(this.buildDerEncodableVector(n3), false);
                }
                case 36: {
                    return this.buildDerConstructedOctetString(n3);
                }
            }
            if ((n & 0x80) != 0) {
                if (n3 == 0) {
                    return new DERTaggedObject(false, n2, new DERSequence());
                }
                ASN1EncodableVector aSN1EncodableVector = this.buildDerEncodableVector(n3);
                if (aSN1EncodableVector.size() == 1) {
                    return new DERTaggedObject(n2, aSN1EncodableVector.get(0));
                }
                return new DERTaggedObject(false, n2, new DERSequence(aSN1EncodableVector));
            }
            return new DERUnknownTag(n, this.readDefiniteLengthFully(n3));
        }
        byte[] byArray = this.readDefiniteLengthFully(n3);
        switch (n) {
            case 5: {
                return DERNull.INSTANCE;
            }
            case 1: {
                return new DERBoolean(byArray);
            }
            case 2: {
                return new DERInteger(byArray);
            }
            case 10: {
                return new DEREnumerated(byArray);
            }
            case 6: {
                return new DERObjectIdentifier(byArray);
            }
            case 3: {
                byte by = byArray[0];
                byte[] byArray2 = new byte[byArray.length - 1];
                System.arraycopy(byArray, 1, byArray2, 0, byArray.length - 1);
                return new DERBitString(byArray2, (int)by);
            }
            case 18: {
                return new DERNumericString(byArray);
            }
            case 12: {
                return new DERUTF8String(byArray);
            }
            case 19: {
                return new DERPrintableString(byArray);
            }
            case 22: {
                return new DERIA5String(byArray);
            }
            case 20: {
                return new DERT61String(byArray);
            }
            case 26: {
                return new DERVisibleString(byArray);
            }
            case 27: {
                return new DERGeneralString(byArray);
            }
            case 28: {
                return new DERUniversalString(byArray);
            }
            case 30: {
                return new DERBMPString(byArray);
            }
            case 4: {
                return new DEROctetString(byArray);
            }
            case 23: {
                return new DERUTCTime(byArray);
            }
            case 24: {
                return new DERGeneralizedTime(byArray);
            }
        }
        if ((n & 0x80) != 0) {
            if (byArray.length == 0) {
                return new DERTaggedObject(false, n2, DERNull.INSTANCE);
            }
            return new DERTaggedObject(false, n2, new DEROctetString(byArray));
        }
        return new DERUnknownTag(n, byArray);
    }

    private byte[] readDefiniteLengthFully(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        return byArray;
    }

    private byte[] readIndefiniteLengthFully() throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = this.read();
        while ((n = this.read()) >= 0 && (n2 != 0 || n != 0)) {
            byteArrayOutputStream.write(n2);
            n2 = n;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private BERConstructedOctetString buildConstructedOctetString(DERObject dERObject) throws IOException {
        DERObject dERObject2;
        Vector<DERObject> vector = new Vector<DERObject>();
        while ((dERObject2 = this.readObject()) != dERObject) {
            vector.addElement(dERObject2);
        }
        return new BERConstructedOctetString(vector);
    }

    private BERConstructedOctetString buildDerConstructedOctetString(int n) throws IOException {
        DefiniteLengthInputStream definiteLengthInputStream = new DefiniteLengthInputStream(this, n);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(definiteLengthInputStream, n);
        return aSN1InputStream.buildConstructedOctetString(null);
    }

    private ASN1EncodableVector buildEncodableVector(DERObject dERObject) throws IOException {
        DERObject dERObject2;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        while ((dERObject2 = this.readObject()) != dERObject) {
            aSN1EncodableVector.add(dERObject2);
        }
        return aSN1EncodableVector;
    }

    private ASN1EncodableVector buildDerEncodableVector(int n) throws IOException {
        DefiniteLengthInputStream definiteLengthInputStream = new DefiniteLengthInputStream(this, n);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(definiteLengthInputStream, n);
        return aSN1InputStream.buildEncodableVector(null);
    }

    public DERObject readObject() throws IOException {
        int n;
        int n2 = this.read();
        if (n2 == -1) {
            if (this.eofFound) {
                throw new EOFException("attempt to read past end of file.");
            }
            this.eofFound = true;
            return null;
        }
        int n3 = 0;
        if ((n2 & 0x80) != 0 || (n2 & 0x40) != 0) {
            n3 = this.readTagNumber(n2);
        }
        if ((n = this.readLength()) < 0) {
            switch (n2) {
                case 5: {
                    return BERNull.INSTANCE;
                }
                case 48: {
                    return new BERSequence(this.buildEncodableVector(END_OF_STREAM));
                }
                case 49: {
                    return new BERSet(this.buildEncodableVector(END_OF_STREAM), false);
                }
                case 36: {
                    return this.buildConstructedOctetString(END_OF_STREAM);
                }
            }
            if ((n2 & 0x80) != 0) {
                if ((n2 & 0x20) == 0) {
                    byte[] byArray = this.readIndefiniteLengthFully();
                    return new BERTaggedObject(false, n3, new DEROctetString(byArray));
                }
                ASN1EncodableVector aSN1EncodableVector = this.buildEncodableVector(END_OF_STREAM);
                if (aSN1EncodableVector.size() == 0) {
                    return new DERTaggedObject(n3);
                }
                if (aSN1EncodableVector.size() == 1) {
                    return new BERTaggedObject(n3, aSN1EncodableVector.get(0));
                }
                return new BERTaggedObject(false, n3, new BERSequence(aSN1EncodableVector));
            }
            throw new IOException("unknown BER object encountered");
        }
        if (n2 == 0 && n == 0) {
            return END_OF_STREAM;
        }
        return this.buildObject(n2, n3, n);
    }

    private int readTagNumber(int n) throws IOException {
        int n2 = n & 0x1F;
        if (n2 == 31) {
            int n3 = this.read();
            n2 = 0;
            while (n3 >= 0 && (n3 & 0x80) != 0) {
                n2 |= n3 & 0x7F;
                n2 <<= 7;
                n3 = this.read();
            }
            if (n3 < 0) {
                this.eofFound = true;
                throw new EOFException("EOF found inside tag value.");
            }
            n2 |= n3 & 0x7F;
        }
        return n2;
    }
}

