/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrent;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentCreateImpl;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentDeserialiseImpl;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentXMLDeserialiser;

public class TOTorrentFactory {
    public static final long TO_DEFAULT_FIXED_PIECE_SIZE = 262144L;
    public static final long TO_DEFAULT_VARIABLE_PIECE_SIZE_MIN = 32768L;
    public static final long TO_DEFAULT_VARIABLE_PIECE_SIZE_MAX = 0x200000L;
    public static final long TO_DEFAULT_VARIABLE_PIECE_NUM_LOWER = 1024L;
    public static final long TO_DEFAULT_VARIABLE_PIECE_NUM_UPPER = 2048L;
    public static final long[] STANDARD_PIECE_SIZES = new long[]{32768L, 49152L, 65536L, 98304L, 131072L, 196608L, 262144L, 393216L, 524288L, 786432L, 0x100000L, 0x180000L, 0x200000L, 0x300000L, 0x400000L};

    public static TOTorrent deserialiseFromBEncodedFile(File file) throws TOTorrentException {
        return new TOTorrentDeserialiseImpl(file);
    }

    public static TOTorrent deserialiseFromBEncodedInputStream(InputStream inputStream) throws TOTorrentException {
        return new TOTorrentDeserialiseImpl(inputStream);
    }

    public static TOTorrent deserialiseFromBEncodedByteArray(byte[] byArray) throws TOTorrentException {
        return new TOTorrentDeserialiseImpl(byArray);
    }

    public static TOTorrent deserialiseFromMap(Map map) throws TOTorrentException {
        return new TOTorrentDeserialiseImpl(map);
    }

    public static TOTorrent deserialiseFromXMLFile(File file) throws TOTorrentException {
        return new TOTorrentXMLDeserialiser().deserialise(file);
    }

    public static TOTorrentCreator createFromFileOrDirWithFixedPieceLength(File file, URL uRL) throws TOTorrentException {
        return TOTorrentFactory.createFromFileOrDirWithFixedPieceLength(file, uRL, false, 262144L);
    }

    public static TOTorrentCreator createFromFileOrDirWithFixedPieceLength(File file, URL uRL, boolean bl) throws TOTorrentException {
        return TOTorrentFactory.createFromFileOrDirWithFixedPieceLength(file, uRL, bl, 262144L);
    }

    public static TOTorrentCreator createFromFileOrDirWithFixedPieceLength(File file, URL uRL, long l) throws TOTorrentException {
        return TOTorrentFactory.createFromFileOrDirWithFixedPieceLength(file, uRL, false, l);
    }

    public static TOTorrentCreator createFromFileOrDirWithFixedPieceLength(File file, URL uRL, boolean bl, long l) throws TOTorrentException {
        return TOTorrentCreateImpl.create(file, uRL, bl, l);
    }

    public static TOTorrentCreator createFromFileOrDirWithComputedPieceLength(File file, URL uRL) throws TOTorrentException {
        return TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(file, uRL, false);
    }

    public static TOTorrentCreator createFromFileOrDirWithComputedPieceLength(File file, URL uRL, boolean bl) throws TOTorrentException {
        return TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(file, uRL, bl, 32768L, 0x200000L, 1024L, 2048L);
    }

    public static TOTorrentCreator createFromFileOrDirWithComputedPieceLength(File file, URL uRL, long l, long l2, long l3, long l4) throws TOTorrentException {
        return TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(file, uRL, false, l, l2, l3, l4);
    }

    public static TOTorrentCreator createFromFileOrDirWithComputedPieceLength(File file, URL uRL, boolean bl, long l, long l2, long l3, long l4) throws TOTorrentException {
        return TOTorrentCreateImpl.create(file, uRL, bl, l, l2, l3, l4);
    }

    public static long getTorrentDataSizeFromFileOrDir(File file) {
        return TOTorrentCreateImpl.getTorrentDataSizeFromFileOrDir(file);
    }

    public static long getComputedPieceSize(long l) {
        return TOTorrentCreateImpl.getComputedPieceSize(l, 32768L, 0x200000L, 1024L, 2048L);
    }

    public static long getPieceCount(long l, long l2) {
        return TOTorrentCreateImpl.getPieceCount(l, l2);
    }
}

