/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrentdownloader.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloader;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderCallBackInterface;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.core3.util.protocol.magnet.MagnetConnection;
import org.gudy.azureus2.core3.util.protocol.magnet.MagnetConnection2;

public class TorrentDownloaderImpl
extends AEThread2
implements TorrentDownloader {
    private String original_url;
    private String url_str;
    private String referrer;
    private Map request_properties;
    private String file_str;
    private URL url;
    private HttpURLConnection con;
    private String error = "Ok";
    private String status = "";
    private TorrentDownloaderCallBackInterface iface;
    private int state = -1;
    private int percentDone = 0;
    private int readTotal = 0;
    private boolean cancel = false;
    private String filename;
    private String directoryname;
    private File file = null;
    private byte[] buf = new byte[1020];
    private int bufBytes = 0;
    private boolean deleteFileOnCancel = true;
    private boolean ignoreReponseCode = false;
    private AEMonitor this_mon = new AEMonitor("TorrentDownloader");
    private int errCode;

    public TorrentDownloaderImpl() {
        super("Torrent Downloader");
    }

    public void init(TorrentDownloaderCallBackInterface torrentDownloaderCallBackInterface, String string, String string2, Map map, String string3) {
        this.iface = torrentDownloaderCallBackInterface;
        this.original_url = string;
        string = string.replace('\\', '/');
        string = string.replaceAll(" ", "%20");
        this.setName("TorrentDownloader: " + string);
        this.url_str = string;
        this.referrer = string2;
        this.request_properties = map;
        this.file_str = string3;
    }

    public void notifyListener() {
        if (this.iface != null) {
            this.iface.TorrentDownloaderEvent(this.state, this);
        } else if (this.state == 4) {
            System.err.println(this.error);
        }
    }

    private void cleanUpFile() {
        if (this.file != null && this.file.exists()) {
            this.file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void error(int n, String string) {
        try {
            this.this_mon.enter();
            this.state = 4;
            this.setError(n, string);
            this.cleanUpFile();
            this.notifyListener();
        }
        finally {
            this.this_mon.exit();
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block80: {
            boolean bl;
            int n;
            Object object2;
            Object object3;
            block77: {
                try {
                    new URL(this.url_str);
                }
                catch (Throwable throwable) {
                    String string = UrlUtils.normaliseMagnetURI(this.url_str);
                    if (string == null) break block77;
                    this.url_str = string;
                }
            }
            try {
                Matcher matcher;
                String string;
                Object object;
                int n2;
                this.url = AddressUtils.adjustURL(new URL(this.url_str));
                object3 = this.url.getProtocol().toLowerCase();
                if (((String)object3).equals("magnet") || ((String)object3).equals("dht")) {
                    this.url = AddressUtils.adjustURL(new URL(this.url_str + "&pause_on_error=true"));
                }
                for (n2 = 0; n2 < 2; ++n2) {
                    try {
                        if (((String)object3).equals("https")) {
                            object2 = (HttpsURLConnection)this.url.openConnection();
                            ((HttpsURLConnection)object2).setHostnameVerifier(new HostnameVerifier(){

                                @Override
                                public boolean verify(String string, SSLSession sSLSession) {
                                    return true;
                                }
                            });
                            this.con = object2;
                        } else {
                            this.con = (HttpURLConnection)this.url.openConnection();
                        }
                        this.con.setRequestProperty("User-Agent", "Azureus 4.5.0.4");
                        if (this.referrer != null && this.referrer.length() > 0) {
                            this.con.setRequestProperty("Referer", this.referrer);
                        }
                        if (this.request_properties != null) {
                            for (Map.Entry entry : this.request_properties.entrySet()) {
                                object = (String)entry.getKey();
                                string = (String)entry.getValue();
                                if (((String)object).equalsIgnoreCase("Accept-Encoding")) continue;
                                this.con.setRequestProperty((String)object, string);
                            }
                        }
                        this.con.connect();
                        break;
                    }
                    catch (SSLException sSLException) {
                        if (n2 == 0 && SESecurityManager.installServerCertificates(this.url) != null) continue;
                        throw sSLException;
                    }
                    catch (IOException iOException) {
                        if (n2 == 0) {
                            URL object5 = UrlUtils.getIPV4Fallback(this.url);
                            if (object5 != null) {
                                this.url = object5;
                            } else {
                                throw iOException;
                            }
                        }
                        if (!(iOException instanceof UnknownHostException)) continue;
                        throw iOException;
                    }
                }
                n2 = this.con.getResponseCode();
                if (!this.ignoreReponseCode && n2 != 202 && n2 != 200) {
                    this.error(n2, Integer.toString(n2) + ": " + this.con.getResponseMessage());
                    return;
                }
                this.filename = this.con.getHeaderField("Content-Disposition");
                if (this.filename == null) {
                    this.filename = this.con.getHeaderField("Disposition");
                }
                if (this.filename != null && this.filename.toLowerCase().matches(".*attachment.*")) {
                    while (this.filename.toLowerCase().charAt(0) != 'a') {
                        this.filename = this.filename.substring(1);
                    }
                }
                object2 = Pattern.compile(".*filename=\\\"(.*)\\\"");
                Object var4_17 = null;
                if (this.filename != null && (matcher = ((Pattern)object2).matcher(this.filename)) != null && matcher.matches()) {
                    this.filename = matcher.group(1);
                } else if (this.filename == null || !this.filename.toLowerCase().startsWith("attachment") || this.filename.indexOf(61) == -1) {
                    object = this.url.getFile();
                    if (((String)object).length() == 0 || ((String)object).equals("/")) {
                        this.filename = this.url.getHost();
                    } else if (((String)object).startsWith("?")) {
                        int n3;
                        string = ((String)object).toUpperCase();
                        n = string.indexOf("XT=URN:SHA1:");
                        if (n == -1) {
                            n = string.indexOf("XT=URN:BTIH:");
                        }
                        this.filename = n != -1 ? ((n3 = string.indexOf("&", n += 12)) == -1 ? string.substring(n) : string.substring(n, n3)) : "Torrent" + (long)(Math.random() * 9.223372036854776E18);
                        this.filename = this.filename + ".tmp";
                    } else {
                        int n4;
                        while (((String)object).endsWith("/")) {
                            object = ((String)object).substring(0, ((String)object).length() - 1);
                        }
                        if (((String)object).lastIndexOf(47) != -1) {
                            object = ((String)object).substring(((String)object).lastIndexOf(47) + 1);
                        }
                        if ((n4 = ((String)object).indexOf(63)) != -1) {
                            object = ((String)object).substring(0, n4);
                        }
                        this.filename = URLDecoder.decode((String)object, "UTF8");
                        if (this.filename.length() == 0) {
                            this.filename = "Torrent" + (long)(Math.random() * 9.223372036854776E18);
                        }
                    }
                } else {
                    this.filename = this.filename.substring(this.filename.indexOf(61) + 1);
                    if (this.filename.startsWith("\"") && this.filename.endsWith("\"")) {
                        this.filename = this.filename.substring(1, this.filename.lastIndexOf(34));
                    }
                    this.filename = URLDecoder.decode(this.filename, "UTF8");
                    object = new File(this.filename);
                    this.filename = ((File)object).getName();
                }
                this.filename = FileUtil.convertOSSpecificChars(this.filename, false);
                this.directoryname = COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory");
                bl = COConfigurationManager.getBooleanParameter("Save Torrent Files");
                if (this.file_str != null) {
                    File file = new File(this.file_str);
                    if (!bl || this.directoryname.length() == 0) {
                        this.directoryname = file.isDirectory() ? file.getCanonicalPath() : file.getCanonicalFile().getParent();
                    }
                    if (!file.isDirectory()) {
                        this.filename = file.getName();
                    }
                }
                this.state = 0;
                this.notifyListener();
            }
            catch (MalformedURLException malformedURLException) {
                this.error(0, "Exception while parsing URL '" + this.url + "':" + malformedURLException.getMessage());
            }
            catch (UnknownHostException unknownHostException) {
                this.error(0, "Exception while initializing download of '" + this.url + "': Unknown Host '" + unknownHostException.getMessage() + "'");
            }
            catch (IOException iOException) {
                this.error(0, "I/O Exception while initializing download of '" + this.url + "':" + iOException.toString());
            }
            catch (Throwable throwable) {
                this.error(0, "Exception while initializing download of '" + this.url + "':" + throwable.toString());
            }
            if (this.state == 4) {
                return;
            }
            try {
                block78: {
                    object3 = new boolean[]{true};
                    this.state = 1;
                    this.notifyListener();
                    this.state = 2;
                    this.notifyListener();
                    AEThread2 aEThread2 = new AEThread2("TorrentDownloader:statusreader", (boolean[])object3){
                        final /* synthetic */ boolean[] val$status_reader_run;
                        {
                            this.val$status_reader_run = blArray;
                            super(string);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            boolean bl = false;
                            String string = "";
                            boolean bl2 = false;
                            long l = SystemTime.getMonotonousTime();
                            try {
                                while (true) {
                                    block18: {
                                        if (bl2) {
                                            Thread.sleep(50L);
                                            bl2 = false;
                                        }
                                        try {
                                            TorrentDownloaderImpl.this.this_mon.enter();
                                            if (this.val$status_reader_run[0]) break block18;
                                            break;
                                        }
                                        finally {
                                            TorrentDownloaderImpl.this.this_mon.exit();
                                        }
                                    }
                                    String string2 = TorrentDownloaderImpl.this.con.getResponseMessage();
                                    if (string2.equals(string)) {
                                        bl2 = true;
                                        continue;
                                    }
                                    string = string2;
                                    String string3 = string2.toLowerCase();
                                    if (!string3.startsWith("error:")) {
                                        if (string2.toLowerCase().indexOf("alive") != -1 && TorrentDownloaderImpl.this.percentDone < 10) {
                                            TorrentDownloaderImpl.this.percentDone++;
                                        }
                                        boolean bl3 = false;
                                        int n = string2.indexOf(37);
                                        if (n != -1) {
                                            int n2;
                                            for (n2 = n - 1; n2 >= 0; --n2) {
                                                char c = string2.charAt(n2);
                                                if (Character.isDigit(c) || c == ' ') continue;
                                                ++n2;
                                                break;
                                            }
                                            try {
                                                TorrentDownloaderImpl.this.percentDone = Integer.parseInt(string2.substring(n2, n).trim());
                                                bl3 = true;
                                            }
                                            catch (Throwable throwable) {
                                                // empty catch block
                                            }
                                        }
                                        if (string3.startsWith("received")) {
                                            bl3 = true;
                                        }
                                        if (bl3) {
                                            long l2 = SystemTime.getMonotonousTime();
                                            if (l2 - l < 250L) continue;
                                            l = l2;
                                        }
                                        TorrentDownloaderImpl.this.setStatus(string2);
                                    } else {
                                        TorrentDownloaderImpl.this.error(TorrentDownloaderImpl.this.con.getResponseCode(), string2.substring(6));
                                    }
                                    bl = true;
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            if (bl) {
                                TorrentDownloaderImpl.this.setStatus("");
                            }
                        }
                    };
                    aEThread2.start();
                    try {
                        object2 = this.con.getInputStream();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (this.ignoreReponseCode) {
                            object2 = this.con.getErrorStream();
                            break block78;
                        }
                        throw fileNotFoundException;
                    }
                    finally {
                        try {
                            this.this_mon.enter();
                            object3[0] = false;
                        }
                        finally {
                            this.this_mon.exit();
                        }
                    }
                }
                String string = this.con.getHeaderField("content-encoding");
                if (string != null) {
                    if (string.equalsIgnoreCase("gzip")) {
                        object2 = new GZIPInputStream((InputStream)object2);
                    } else if (string.equalsIgnoreCase("deflate")) {
                        object2 = new InflaterInputStream((InputStream)object2);
                    }
                }
                if (this.state == 4) break block80;
                this.file = new File(this.directoryname, this.filename);
                bl = false;
                try {
                    this.file.createNewFile();
                    bl = !this.file.exists();
                }
                catch (Throwable throwable) {
                    bl = true;
                }
                if (bl) {
                    this.file = File.createTempFile("AZU", ".torrent", new File(this.directoryname));
                    this.file.createNewFile();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(this.file, false);
                this.bufBytes = 0;
                n = (int)UrlUtils.getContentLength(this.con);
                this.percentDone = -1;
                while (!this.cancel) {
                    try {
                        this.bufBytes = ((InputStream)object2).read(this.buf);
                        this.readTotal += this.bufBytes;
                        if (n > 0) {
                            this.percentDone = 100 * this.readTotal / n;
                        }
                        this.notifyListener();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (this.bufBytes > 0) {
                        fileOutputStream.write(this.buf, 0, this.bufBytes);
                    }
                    if (this.bufBytes > 0) continue;
                }
                ((InputStream)object2).close();
                fileOutputStream.flush();
                fileOutputStream.close();
                if (this.cancel) {
                    this.state = 6;
                    if (this.deleteFileOnCancel) {
                        this.cleanUpFile();
                    }
                } else {
                    if (this.readTotal <= 0) {
                        this.error(0, "No data contained in '" + this.url.toString() + "'");
                        return;
                    }
                    try {
                        TOTorrent tOTorrent;
                        String string2;
                        File file;
                        if (!this.filename.toLowerCase().endsWith(".torrent") && !this.filename.toLowerCase().endsWith(".dat") && this.file.renameTo(file = new File(this.directoryname, string2 = TorrentUtils.getLocalisedName(tOTorrent = TorrentUtils.readFromFile(this.file, false)) + ".torrent"))) {
                            this.filename = string2;
                            this.file = file;
                        }
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                    this.state = 3;
                }
                this.notifyListener();
            }
            catch (Exception exception) {
                if (!this.cancel) {
                    Debug.out("'" + this.directoryname + "' '" + this.filename + "'", exception);
                }
                this.error(0, "Exception while downloading '" + this.url.toString() + "':" + exception.getMessage());
            }
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TorrentDownloaderImpl) {
            TorrentDownloaderImpl torrentDownloaderImpl = (TorrentDownloaderImpl)object;
            if (torrentDownloaderImpl.getURL().equals(this.url.toString())) {
                File file;
                File file2 = torrentDownloaderImpl.getFile();
                if (file2 == (file = this.file)) {
                    return true;
                }
                if (file2 == null || file == null) {
                    return false;
                }
                return file2.getAbsolutePath().equals(file.getAbsolutePath());
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    @Override
    public String getError() {
        return this.error;
    }

    public void setError(int n, String string) {
        this.error = string;
        this.errCode = n;
    }

    public int getErrorCode() {
        return this.errCode;
    }

    protected void setStatus(String string) {
        this.status = string;
        this.notifyListener();
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public File getFile() {
        if (!this.isAlive() || this.file == null) {
            this.file = new File(this.directoryname, this.filename);
        }
        return this.file;
    }

    @Override
    public int getPercentDone() {
        return this.percentDone;
    }

    @Override
    public int getDownloadState() {
        return this.state;
    }

    public void setDownloadState(int n) {
        this.state = n;
    }

    @Override
    public String getURL() {
        return this.url.toString();
    }

    @Override
    public void cancel() {
        this.cancel = true;
        this.closeConnection();
    }

    protected void closeConnection() {
        if (this.con instanceof MagnetConnection || this.con instanceof MagnetConnection2) {
            this.con.disconnect();
        }
    }

    @Override
    public void setDownloadPath(String string, String string2) {
        if (!this.isAlive()) {
            if (string != null) {
                this.directoryname = string;
            }
            if (string2 != null) {
                this.filename = string2;
            }
        }
    }

    @Override
    public int getTotalRead() {
        return this.readTotal;
    }

    @Override
    public byte[] getLastReadBytes() {
        if (this.bufBytes <= 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[this.bufBytes];
        System.arraycopy(this.buf, 0, byArray, 0, this.bufBytes);
        return byArray;
    }

    @Override
    public int getLastReadCount() {
        return this.bufBytes;
    }

    @Override
    public void setDeleteFileOnCancel(boolean bl) {
        this.deleteFileOnCancel = bl;
    }

    @Override
    public boolean getDeleteFileOnCancel() {
        return this.deleteFileOnCancel;
    }

    @Override
    public boolean isIgnoreReponseCode() {
        return this.ignoreReponseCode;
    }

    @Override
    public void setIgnoreReponseCode(boolean bl) {
        this.ignoreReponseCode = bl;
    }
}

