/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.tracker.client.DNSTrackerEntry;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.TXTRecord;

public class DNSTracker {
    private static final Pattern BT_TXT_PATTERN = Pattern.compile("(UDP:\\d+|TCP:\\d+)");

    public static List<DNSTrackerEntry> dig(String string) {
        ArrayList<DNSTrackerEntry> arrayList = null;
        try {
            Record[] recordArray = new Lookup(string, 16).run();
            for (int i = 0; recordArray != null && i < recordArray.length; ++i) {
                String string2;
                TXTRecord tXTRecord = (TXTRecord)recordArray[i];
                List list = tXTRecord.getStrings();
                if (list == null || list.size() <= 0 || !(string2 = list.get(0).toString()).startsWith("BITTORRENT")) continue;
                arrayList = new ArrayList<DNSTrackerEntry>();
                Matcher matcher = BT_TXT_PATTERN.matcher(string2);
                while (matcher.find()) {
                    for (int j = 0; j < matcher.groupCount(); ++j) {
                        String string3 = matcher.group(i);
                        if (string3.length() <= 0) continue;
                        DNSTrackerEntry dNSTrackerEntry = new DNSTrackerEntry();
                        dNSTrackerEntry.udp = string3.startsWith("UDP");
                        dNSTrackerEntry.port = Integer.parseInt(string3.split(":")[1]);
                        arrayList.add(dNSTrackerEntry);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return arrayList;
    }

    public static URL fixTrackerURL(URL uRL) {
        try {
            String string = uRL.getProtocol();
            String string2 = uRL.getHost();
            int n = uRL.getPort();
            String string3 = uRL.getFile();
            List<DNSTrackerEntry> list = DNSTracker.dig(string2);
            if (list == null) {
                return uRL;
            }
            DNSTrackerEntry dNSTrackerEntry = list.get(0);
            string = dNSTrackerEntry.udp ? "udp" : "http";
            n = dNSTrackerEntry.port;
            URL uRL2 = new URL(string, string2, n, string3);
            return uRL2;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return uRL;
        }
    }
}

