/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.host.impl;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerFactory;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerFactoryListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperFactory;
import org.gudy.azureus2.core3.tracker.host.TRHost;
import org.gudy.azureus2.core3.tracker.host.TRHostAuthenticationListener;
import org.gudy.azureus2.core3.tracker.host.TRHostException;
import org.gudy.azureus2.core3.tracker.host.TRHostListener;
import org.gudy.azureus2.core3.tracker.host.TRHostListener2;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentFinder;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostConfigImpl;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostExternalTorrent;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostPeerHostImpl;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostTorrentHostImpl;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostTorrentPublishImpl;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostTorrentRequestImpl;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerAuthenticationListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerFactory;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerFactoryListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerListener2;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerRequest;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerRequestListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrent;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.AsyncController;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;

public class TRHostImpl
implements TRHost,
TRTrackerAnnouncerFactoryListener,
TRTrackerServerListener2,
TRTrackerServerListener,
TRTrackerServerFactoryListener,
TRTrackerServerRequestListener,
TRTrackerServerAuthenticationListener {
    private static final LogIDs LOGID = LogIDs.TRACKER;
    private static final int URL_DEFAULT_PORT = 80;
    private static final int URL_DEFAULT_PORT_SSL = 443;
    public static final int STATS_PERIOD_SECS = 60;
    private static final int TICK_PERIOD_SECS = 10;
    private static final int TICKS_PER_STATS_PERIOD = 6;
    private static TRHostImpl singleton;
    private static AEMonitor class_mon;
    private TRHostConfigImpl config;
    private Hashtable server_map = new Hashtable();
    private List host_torrents = new ArrayList();
    private Map host_torrent_hash_map = new HashMap();
    private Map host_torrent_map = new HashMap();
    private Map tracker_client_map = new HashMap();
    private static final int LDT_TORRENT_ADDED = 1;
    private static final int LDT_TORRENT_REMOVED = 2;
    private static final int LDT_TORRENT_CHANGED = 3;
    private ListenerManager<TRHostListener> listeners = ListenerManager.createAsyncManager("TRHost:ListenDispatcher", new ListenerManagerDispatcher<TRHostListener>(){

        @Override
        public void dispatch(TRHostListener tRHostListener, int n, Object object) {
            TRHostListener tRHostListener2 = tRHostListener;
            if (n == 1) {
                tRHostListener2.torrentAdded((TRHostTorrent)object);
            } else if (n == 2) {
                tRHostListener2.torrentRemoved((TRHostTorrent)object);
            } else if (n == 3) {
                tRHostListener2.torrentChanged((TRHostTorrent)object);
            }
        }
    });
    private CopyOnWriteList<TRHostListener2> listeners2 = new CopyOnWriteList();
    private static boolean host_add_announce_urls;
    private List<TRHostAuthenticationListener> auth_listeners = new ArrayList<TRHostAuthenticationListener>();
    private boolean server_factory_listener_added;
    protected AEMonitor this_mon = new AEMonitor("TRHost");
    private volatile boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TRHost create() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new TRHostImpl();
            }
            TRHostImpl tRHostImpl = singleton;
            return tRHostImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TRHostImpl() {
        try {
            this.this_mon.enter();
            this.config = new TRHostConfigImpl(this);
            TRTrackerAnnouncerFactory.addListener(this);
            AEThread aEThread = new AEThread("TRHost::stats.loop"){
                private int tick_count;
                private Set failed_ports;
                {
                    this.tick_count = 0;
                    this.failed_ports = new HashSet();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runSupport() {
                    while (true) {
                        try {
                            Object object;
                            int n;
                            URL[][] uRLArray = TRTrackerUtils.getAnnounceURLs();
                            for (n = 0; n < uRLArray.length; ++n) {
                                object = uRLArray[n];
                                for (int i = 0; i < ((URL[])object).length; ++i) {
                                    URL uRL = object[i];
                                    int n2 = uRL.getPort();
                                    if (n2 == -1) {
                                        n2 = uRL.getDefaultPort();
                                    }
                                    String string = uRL.getProtocol().toLowerCase();
                                    try {
                                        if (string.equals("http")) {
                                            TRHostImpl.this.startServer(1, n2, false);
                                            continue;
                                        }
                                        if (string.equals("udp")) {
                                            TRHostImpl.this.startServer(2, n2, false);
                                            continue;
                                        }
                                        if (string.equals("https")) {
                                            TRHostImpl.this.startServer(1, n2, true);
                                            continue;
                                        }
                                        Debug.out("Unknown protocol '" + string + "'");
                                        continue;
                                    }
                                    catch (Throwable throwable) {
                                        Integer n3 = new Integer(n2);
                                        if (this.failed_ports.contains(n3)) continue;
                                        this.failed_ports.add(n3);
                                        Logger.log(new LogEvent(LOGID, "Tracker Host: failed to start server", throwable));
                                    }
                                }
                            }
                            Thread.sleep(10000L);
                            if (TRHostImpl.this.closed) break;
                            if (this.tick_count % 6 == 0) {
                                try {
                                    TRHostImpl.this.this_mon.enter();
                                    for (n = 0; n < TRHostImpl.this.host_torrents.size(); ++n) {
                                        object = (TRHostTorrent)TRHostImpl.this.host_torrents.get(n);
                                        if (object instanceof TRHostTorrentHostImpl) {
                                            ((TRHostTorrentHostImpl)object).updateStats();
                                            continue;
                                        }
                                        ((TRHostTorrentPublishImpl)object).updateStats();
                                    }
                                }
                                finally {
                                    TRHostImpl.this.this_mon.exit();
                                }
                                TRHostImpl.this.config.saveConfig(true);
                                continue;
                            }
                            TRHostImpl.this.config.saveConfig(false);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            Debug.printStackTrace(interruptedException);
                        }
                        finally {
                            ++this.tick_count;
                            continue;
                        }
                        break;
                    }
                }
            };
            aEThread.setDaemon(true);
            aEThread.setPriority(9);
            aEThread.start();
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void initialise(TRHostTorrentFinder tRHostTorrentFinder) {
        this.config.loadConfig(tRHostTorrentFinder);
    }

    @Override
    public String getName() {
        return TRTrackerServer.DEFAULT_NAME;
    }

    @Override
    public TRHostTorrent hostTorrent(TOTorrent tOTorrent, boolean bl, boolean bl2) throws TRHostException {
        return this.addTorrent(tOTorrent, 2, bl, bl2, SystemTime.getCurrentTime());
    }

    @Override
    public TRHostTorrent publishTorrent(TOTorrent tOTorrent) throws TRHostException {
        return this.addTorrent(tOTorrent, 3, true, false, SystemTime.getCurrentTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TRHostTorrent addTorrent(TOTorrent tOTorrent, int n, boolean bl, boolean bl2, long l) throws TRHostException {
        try {
            Object object;
            Object object2;
            Object object3;
            boolean bl3;
            int n2;
            TRHostTorrent tRHostTorrent;
            this.this_mon.enter();
            if (bl && n != 3 && host_add_announce_urls) {
                this.addTrackerAnnounce(tOTorrent);
            }
            if ((tRHostTorrent = this.lookupHostTorrent(tOTorrent)) != null) {
                TRHostTorrent tRHostTorrent2;
                try {
                    tRHostTorrent = this.lookupHostTorrentViaHash(tOTorrent.getHash());
                    if (tRHostTorrent instanceof TRHostTorrentHostImpl && ((TRHostTorrentHostImpl)(tRHostTorrent2 = (TRHostTorrentHostImpl)tRHostTorrent)).getTorrent() != tOTorrent) {
                        ((TRHostTorrentHostImpl)tRHostTorrent2).setTorrent(tOTorrent);
                        if (bl && !((TRHostTorrentHostImpl)tRHostTorrent2).isPersistent()) {
                            ((TRHostTorrentHostImpl)tRHostTorrent2).setPersistent(true);
                        }
                        if (bl2 && !((TRHostTorrentHostImpl)tRHostTorrent2).isPassive()) {
                            ((TRHostTorrentHostImpl)tRHostTorrent2).setPassive(true);
                        }
                        if (n != 3) {
                            this.startHosting((TRHostTorrentHostImpl)tRHostTorrent2);
                            if (n == 2) {
                                ((TRHostTorrentHostImpl)tRHostTorrent2).start();
                            }
                        }
                        this.listeners.dispatch(3, tRHostTorrent);
                    }
                }
                catch (TOTorrentException tOTorrentException) {
                    Debug.printStackTrace(tOTorrentException);
                }
                tRHostTorrent2 = tRHostTorrent;
                return tRHostTorrent2;
            }
            int n3 = 1;
            if (n == 3) {
                n2 = COConfigurationManager.getIntParameter("Tracker Port", 6969);
                bl3 = false;
            } else {
                String string;
                object3 = tOTorrent.getAnnounceURL();
                object2 = ((URL)object3).getProtocol();
                bl3 = ((String)object2).equalsIgnoreCase("https");
                if (((String)object2).equalsIgnoreCase("udp")) {
                    n3 = 2;
                } else if (TorrentUtils.isDecentralised(tOTorrent)) {
                    n3 = 3;
                }
                boolean bl4 = COConfigurationManager.getBooleanParameter("Tracker Port Force External");
                n2 = ((URL)object3).getPort();
                if (bl4 && (string = COConfigurationManager.getStringParameter("Tracker IP", "")).length() > 0 && !((URL)object3).getHost().equalsIgnoreCase(string)) {
                    n2 = bl3 ? COConfigurationManager.getIntParameter("Tracker Port SSL", 7000) : COConfigurationManager.getIntParameter("Tracker Port", 6969);
                }
                if (n2 == -1) {
                    n2 = bl3 ? 443 : 80;
                }
            }
            object3 = this.startServer(n3, n2, bl3);
            if (n == 3) {
                object = new TRHostTorrentPublishImpl(this, tOTorrent, l);
                ((TRHostTorrentPublishImpl)object).setPersistent(bl);
                object2 = object;
            } else {
                object = new TRHostTorrentHostImpl(this, (TRTrackerServer)object3, tOTorrent, n2, l);
                ((TRHostTorrentHostImpl)object).setPersistent(bl);
                ((TRHostTorrentHostImpl)object).setPassive(bl2);
                object2 = object;
            }
            this.host_torrents.add(object2);
            try {
                this.host_torrent_hash_map.put(new HashWrapper(tOTorrent.getHash()), object2);
            }
            catch (TOTorrentException tOTorrentException) {
                Debug.printStackTrace(tOTorrentException);
            }
            this.host_torrent_map.put(tOTorrent, object2);
            if (n != 3) {
                this.startHosting((TRHostTorrentHostImpl)object2);
                if (n == 2) {
                    object2.start();
                }
                if (!bl) {
                    this.config.recoverStats((TRHostTorrentHostImpl)object2);
                }
            }
            this.listeners.dispatch(1, object2);
            this.config.saveRequired();
            object = object2;
            return object;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public InetAddress getBindIP() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TRTrackerServer startServer(int n, int n2, boolean bl) throws TRHostException {
        try {
            this.this_mon.enter();
            String string = "" + n + ":" + n2;
            TRTrackerServer tRTrackerServer = (TRTrackerServer)this.server_map.get(string);
            if (tRTrackerServer == null) {
                try {
                    tRTrackerServer = bl ? TRTrackerServerFactory.createSSL("tracker", n, n2, true, true) : TRTrackerServerFactory.create("tracker", n, n2, true, true);
                    this.server_map.put(string, tRTrackerServer);
                    if (this.auth_listeners.size() > 0) {
                        tRTrackerServer.addAuthenticationListener(this);
                    }
                    tRTrackerServer.addListener(this);
                    tRTrackerServer.addListener2(this);
                }
                catch (TRTrackerServerException tRTrackerServerException) {
                    throw new TRHostException("startServer failed", tRTrackerServerException);
                }
            }
            TRTrackerServer tRTrackerServer2 = tRTrackerServer;
            return tRTrackerServer2;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected TRHostTorrent lookupHostTorrent(TOTorrent tOTorrent) {
        if (tOTorrent == null) {
            return null;
        }
        try {
            return (TRHostTorrent)this.host_torrent_hash_map.get(tOTorrent.getHashWrapper());
        }
        catch (TOTorrentException tOTorrentException) {
            Debug.printStackTrace(tOTorrentException);
            return null;
        }
    }

    protected void startHosting(TRHostTorrentHostImpl tRHostTorrentHostImpl) {
        TOTorrent tOTorrent = tRHostTorrentHostImpl.getTorrent();
        TRTrackerAnnouncer tRTrackerAnnouncer = (TRTrackerAnnouncer)this.tracker_client_map.get(tOTorrent);
        if (tRTrackerAnnouncer != null) {
            this.startHosting(tRHostTorrentHostImpl, tRTrackerAnnouncer);
        }
    }

    protected void startHosting(TRTrackerAnnouncer tRTrackerAnnouncer) {
        TRHostTorrent tRHostTorrent = (TRHostTorrent)this.host_torrent_map.get(tRTrackerAnnouncer.getTorrent());
        if (tRHostTorrent instanceof TRHostTorrentHostImpl) {
            this.startHosting((TRHostTorrentHostImpl)tRHostTorrent, tRTrackerAnnouncer);
        }
    }

    protected void startHosting(TRHostTorrentHostImpl tRHostTorrentHostImpl, final TRTrackerAnnouncer tRTrackerAnnouncer) {
        final TOTorrent tOTorrent = tRHostTorrentHostImpl.getTorrent();
        URL uRL = tOTorrent.getAnnounceURL();
        if (host_add_announce_urls) {
            tRTrackerAnnouncer.setIPOverride(uRL.getHost());
        } else if (TRTrackerUtils.isHosting(uRL)) {
            tRTrackerAnnouncer.setIPOverride(uRL.getHost());
        }
        TRTrackerAnnouncerListener tRTrackerAnnouncerListener = new TRTrackerAnnouncerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void receivedTrackerResponse(TRTrackerAnnouncerResponse tRTrackerAnnouncerResponse) {
                try {
                    TRTrackerScraperFactory.getSingleton().scrape(tOTorrent, true);
                }
                finally {
                    tRTrackerAnnouncer.removeListener(this);
                }
            }

            @Override
            public void urlChanged(TRTrackerAnnouncer tRTrackerAnnouncer2, URL uRL, URL uRL2, boolean bl) {
            }

            @Override
            public void urlRefresh() {
            }
        };
        tRTrackerAnnouncer.addListener(tRTrackerAnnouncerListener);
        tRTrackerAnnouncer.refreshListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(TRHostTorrent tRHostTorrent) {
        try {
            this.this_mon.enter();
            if (!this.host_torrents.contains(tRHostTorrent)) {
                return;
            }
            this.host_torrents.remove(tRHostTorrent);
            TOTorrent tOTorrent = tRHostTorrent.getTorrent();
            try {
                this.host_torrent_hash_map.remove(new HashWrapper(tOTorrent.getHash()));
            }
            catch (TOTorrentException tOTorrentException) {
                Debug.printStackTrace(tOTorrentException);
            }
            this.host_torrent_map.remove(tOTorrent);
            if (tRHostTorrent instanceof TRHostTorrentHostImpl) {
                this.stopHosting((TRHostTorrentHostImpl)tRHostTorrent);
            }
            this.listeners.dispatch(2, tRHostTorrent);
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void stopHosting(TRHostTorrentHostImpl tRHostTorrentHostImpl) {
        TOTorrent tOTorrent = tRHostTorrentHostImpl.getTorrent();
        TRTrackerAnnouncer tRTrackerAnnouncer = (TRTrackerAnnouncer)this.tracker_client_map.get(tOTorrent);
        if (tRTrackerAnnouncer != null) {
            this.stopHosting(tRHostTorrentHostImpl, tRTrackerAnnouncer);
        }
    }

    protected void stopHosting(TRTrackerAnnouncer tRTrackerAnnouncer) {
        TRHostTorrent tRHostTorrent = (TRHostTorrent)this.host_torrent_map.get(tRTrackerAnnouncer.getTorrent());
        if (tRHostTorrent instanceof TRHostTorrentHostImpl) {
            this.stopHosting((TRHostTorrentHostImpl)tRHostTorrent, tRTrackerAnnouncer);
        }
    }

    protected void stopHosting(final TRHostTorrentHostImpl tRHostTorrentHostImpl, final TRTrackerAnnouncer tRTrackerAnnouncer) {
        AEThread aEThread = new AEThread("StopHosting"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runSupport() {
                try {
                    Thread.sleep(2500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    TRHostImpl.this.this_mon.enter();
                    TRHostTorrent tRHostTorrent = TRHostImpl.this.lookupHostTorrent(tRHostTorrentHostImpl.getTorrent());
                    if (tRHostTorrent == null || tRHostTorrent == tRHostTorrentHostImpl && tRHostTorrent.getStatus() == 1) {
                        tRTrackerAnnouncer.clearIPOverride();
                    }
                }
                finally {
                    TRHostImpl.this.this_mon.exit();
                }
            }
        };
        aEThread.setDaemon(true);
        aEThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TRTrackerAnnouncer getTrackerClient(TRHostTorrent tRHostTorrent) {
        try {
            this.this_mon.enter();
            TRTrackerAnnouncer tRTrackerAnnouncer = (TRTrackerAnnouncer)this.tracker_client_map.get(tRHostTorrent.getTorrent());
            return tRTrackerAnnouncer;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void hostTorrentStateChange(TRHostTorrent tRHostTorrent) {
        try {
            this.this_mon.enter();
            TOTorrent tOTorrent = tRHostTorrent.getTorrent();
            TRTrackerAnnouncer tRTrackerAnnouncer = (TRTrackerAnnouncer)this.tracker_client_map.get(tOTorrent);
            if (tRTrackerAnnouncer != null) {
                tRTrackerAnnouncer.refreshListeners();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TRHostTorrent[] getTorrents() {
        try {
            this.this_mon.enter();
            TRHostTorrent[] tRHostTorrentArray = new TRHostTorrent[this.host_torrents.size()];
            this.host_torrents.toArray(tRHostTorrentArray);
            TRHostTorrent[] tRHostTorrentArray2 = tRHostTorrentArray;
            return tRHostTorrentArray2;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clientCreated(TRTrackerAnnouncer tRTrackerAnnouncer) {
        try {
            this.this_mon.enter();
            this.tracker_client_map.put(tRTrackerAnnouncer.getTorrent(), tRTrackerAnnouncer);
            this.startHosting(tRTrackerAnnouncer);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clientDestroyed(TRTrackerAnnouncer tRTrackerAnnouncer) {
        try {
            this.this_mon.enter();
            this.tracker_client_map.remove(tRTrackerAnnouncer.getTorrent());
            this.stopHosting(tRTrackerAnnouncer);
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected TRHostTorrent lookupHostTorrentViaHash(byte[] byArray) {
        return (TRHostTorrent)this.host_torrent_hash_map.get(new HashWrapper(byArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean permitted(String string, byte[] byArray, boolean bl) {
        try {
            this.this_mon.enter();
            TRHostTorrent tRHostTorrent = this.lookupHostTorrentViaHash(byArray);
            if (tRHostTorrent != null) {
                if (!bl && tRHostTorrent.getStatus() != 2) {
                    boolean bl2 = false;
                    return bl2;
                }
                boolean bl3 = true;
                return bl3;
            }
            this.addExternalTorrent(byArray, 2, SystemTime.getCurrentTime());
            boolean bl4 = true;
            return bl4;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addExternalTorrent(byte[] byArray, int n, long l) {
        try {
            this.this_mon.enter();
            if (this.lookupHostTorrentViaHash(byArray) != null) {
                return;
            }
            String string = COConfigurationManager.getStringParameter("Tracker IP", "127.0.0.1");
            int n2 = COConfigurationManager.getIntParameter("Tracker Port", 6969);
            try {
                TRHostExternalTorrent tRHostExternalTorrent = new TRHostExternalTorrent(byArray, new URL("http://" + UrlUtils.convertIPV6Host(string) + ":" + n2 + "/announce"));
                this.addTorrent(tRHostExternalTorrent, n, true, false, l);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public boolean denied(byte[] byArray, boolean bl) {
        return true;
    }

    @Override
    public boolean handleExternalRequest(InetSocketAddress inetSocketAddress, String string, String string2, URL uRL, String string3, InputStream inputStream, OutputStream outputStream, AsyncController asyncController) throws IOException {
        List<TRHostListener> list = this.listeners.getListenersCopy();
        for (int i = 0; i < list.size(); ++i) {
            TRHostListener tRHostListener = list.get(i);
            try {
                if (!tRHostListener.handleExternalRequest(inetSocketAddress, string, string2, uRL, string3, inputStream, outputStream, asyncController)) continue;
                return true;
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
        }
        return false;
    }

    @Override
    public boolean handleExternalRequest(TRTrackerServerListener2.ExternalRequest externalRequest) throws IOException {
        Iterator<TRHostListener2> iterator = this.listeners2.iterator();
        while (iterator.hasNext()) {
            try {
                if (!iterator.next().handleExternalRequest(externalRequest)) continue;
                return true;
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
        }
        return false;
    }

    @Override
    public TRHostTorrent getHostTorrent(TOTorrent tOTorrent) {
        return this.lookupHostTorrent(tOTorrent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(TRHostListener tRHostListener) {
        try {
            this.this_mon.enter();
            this.listeners.addListener(tRHostListener);
            for (int i = 0; i < this.host_torrents.size(); ++i) {
                this.listeners.dispatch(tRHostListener, 1, this.host_torrents.get(i));
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void removeListener(TRHostListener tRHostListener) {
        this.listeners.removeListener(tRHostListener);
    }

    @Override
    public void addListener2(TRHostListener2 tRHostListener2) {
        this.listeners2.add(tRHostListener2);
    }

    @Override
    public void removeListener2(TRHostListener2 tRHostListener2) {
        this.listeners2.remove(tRHostListener2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void torrentListenerRegistered() {
        try {
            this.this_mon.enter();
            if (!this.server_factory_listener_added) {
                this.server_factory_listener_added = true;
                TRTrackerServerFactory.addListener(this);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void serverCreated(TRTrackerServer tRTrackerServer) {
        tRTrackerServer.addRequestListener(this);
    }

    @Override
    public void serverDestroyed(TRTrackerServer tRTrackerServer) {
        tRTrackerServer.removeRequestListener(this);
    }

    @Override
    public void preProcess(TRTrackerServerRequest tRTrackerServerRequest) throws TRTrackerServerException {
        TRTrackerServerTorrent tRTrackerServerTorrent;
        HashWrapper hashWrapper;
        TRHostTorrent tRHostTorrent;
        if ((tRTrackerServerRequest.getType() == 1 || tRTrackerServerRequest.getType() == 2) && (tRHostTorrent = this.lookupHostTorrentViaHash((hashWrapper = (tRTrackerServerTorrent = tRTrackerServerRequest.getTorrent()).getHash()).getHash())) != null) {
            TRHostTorrentRequestImpl tRHostTorrentRequestImpl = new TRHostTorrentRequestImpl(tRHostTorrent, new TRHostPeerHostImpl(tRTrackerServerRequest.getPeer()), tRTrackerServerRequest);
            try {
                if (tRHostTorrent instanceof TRHostTorrentHostImpl) {
                    ((TRHostTorrentHostImpl)tRHostTorrent).preProcess(tRHostTorrentRequestImpl);
                } else {
                    ((TRHostTorrentPublishImpl)tRHostTorrent).preProcess(tRHostTorrentRequestImpl);
                }
            }
            catch (TRHostException tRHostException) {
                throw new TRTrackerServerException(tRHostException.getMessage(), tRHostException);
            }
            catch (Throwable throwable) {
                throw new TRTrackerServerException("Pre-process fails", throwable);
            }
        }
    }

    @Override
    public void postProcess(TRTrackerServerRequest tRTrackerServerRequest) throws TRTrackerServerException {
        HashWrapper hashWrapper;
        TRHostTorrent tRHostTorrent;
        TRTrackerServerTorrent tRTrackerServerTorrent;
        if ((tRTrackerServerRequest.getType() == 1 || tRTrackerServerRequest.getType() == 2) && (tRTrackerServerTorrent = tRTrackerServerRequest.getTorrent()) != null && (tRHostTorrent = this.lookupHostTorrentViaHash((hashWrapper = tRTrackerServerTorrent.getHash()).getHash())) != null) {
            TRHostTorrentRequestImpl tRHostTorrentRequestImpl = new TRHostTorrentRequestImpl(tRHostTorrent, new TRHostPeerHostImpl(tRTrackerServerRequest.getPeer()), tRTrackerServerRequest);
            try {
                if (tRHostTorrent instanceof TRHostTorrentHostImpl) {
                    ((TRHostTorrentHostImpl)tRHostTorrent).postProcess(tRHostTorrentRequestImpl);
                } else {
                    ((TRHostTorrentPublishImpl)tRHostTorrent).postProcess(tRHostTorrentRequestImpl);
                }
            }
            catch (TRHostException tRHostException) {
                throw new TRTrackerServerException("Post process fails", tRHostException);
            }
        }
    }

    @Override
    public void close() {
        this.closed = true;
        this.config.saveConfig(true);
    }

    @Override
    public boolean authenticate(String string, URL uRL, String string2, String string3) {
        for (int i = 0; i < this.auth_listeners.size(); ++i) {
            try {
                boolean bl = this.auth_listeners.get(i).authenticate(string, uRL, string2, string3);
                if (!bl) continue;
                return true;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        return false;
    }

    @Override
    public byte[] authenticate(URL uRL, String string) {
        for (int i = 0; i < this.auth_listeners.size(); ++i) {
            try {
                byte[] byArray = this.auth_listeners.get(i).authenticate(uRL, string);
                if (byArray == null) continue;
                return byArray;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAuthenticationListener(TRHostAuthenticationListener tRHostAuthenticationListener) {
        try {
            this.this_mon.enter();
            this.auth_listeners.add(tRHostAuthenticationListener);
            if (this.auth_listeners.size() == 1) {
                Iterator iterator = this.server_map.values().iterator();
                while (iterator.hasNext()) {
                    ((TRTrackerServer)iterator.next()).addAuthenticationListener(this);
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAuthenticationListener(TRHostAuthenticationListener tRHostAuthenticationListener) {
        try {
            this.this_mon.enter();
            this.auth_listeners.remove(tRHostAuthenticationListener);
            if (this.auth_listeners.size() == 0) {
                Iterator iterator = this.server_map.values().iterator();
                while (iterator.hasNext()) {
                    ((TRTrackerServer)iterator.next()).removeAuthenticationListener(this);
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startTorrent(TRHostTorrentHostImpl tRHostTorrentHostImpl) {
        try {
            this.this_mon.enter();
            tRHostTorrentHostImpl.startSupport();
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopTorrent(TRHostTorrentHostImpl tRHostTorrentHostImpl) {
        try {
            this.this_mon.enter();
            tRHostTorrentHostImpl.stopSupport();
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void addTrackerAnnounce(TOTorrent tOTorrent) {
        if (TorrentUtils.isDecentralised(tOTorrent)) {
            return;
        }
        URL[][] uRLArray = TRTrackerUtils.getAnnounceURLs();
        if (uRLArray.length == 0) {
            TorrentUtils.setDecentralised(tOTorrent);
        } else {
            URL[] uRLArray2 = uRLArray[0];
            for (int i = uRLArray2.length - 1; i >= 0; --i) {
                String string = uRLArray2[i].toString();
                if (TorrentUtils.announceGroupsContainsURL(tOTorrent, string)) {
                    TorrentUtils.announceGroupsSetFirst(tOTorrent, string);
                    continue;
                }
                TorrentUtils.announceGroupsInsertFirst(tOTorrent, string);
            }
        }
    }

    static {
        class_mon = new AEMonitor("TRHost:class");
        COConfigurationManager.addAndFireParameterListener("Tracker Host Add Our Announce URLs", new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                host_add_announce_urls = COConfigurationManager.getBooleanParameter(string);
            }
        });
    }
}

