/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerPeer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrent;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerPeerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerTorrentImpl;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.ByteEncodedKeyHashMap;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPoolTask;

public abstract class TRTrackerServerProcessor
extends ThreadPoolTask {
    private static final boolean QUEUE_TEST = false;
    private TRTrackerServerImpl server;
    private long start;
    private int request_type;

    protected TRTrackerServerTorrentImpl processTrackerRequest(TRTrackerServerImpl tRTrackerServerImpl, String string, Map[] mapArray, TRTrackerServerPeerImpl[] tRTrackerServerPeerImplArray, int n, byte[][] byArray, String string2, String string3, HashWrapper hashWrapper, boolean bl, byte by, String string4, String string5, boolean bl2, int n2, int n3, int n4, String string6, String string7, long l, long l2, long l3, int n5, byte by2, byte by3, int n6, DHTNetworkPosition dHTNetworkPosition) throws TRTrackerServerException {
        int n7;
        boolean bl3;
        Object object;
        Object object2;
        String string8;
        this.server = tRTrackerServerImpl;
        this.request_type = n;
        if (!this.server.isReady()) {
            throw new TRTrackerServerException("Tracker initialising, please wait");
        }
        this.start = SystemTime.getHighPrecisionCounter();
        boolean bl4 = string6 != string7;
        boolean bl5 = TRTrackerUtils.isLoopback(string6);
        if (bl5) {
            bl4 = false;
        }
        if ((string8 = TRTrackerUtils.adjustHostFromHosting(string7)) != string7 && Logger.isEnabled()) {
            Logger.log(new LogEvent(LogIDs.TRACKER, "    address adjusted: original=" + string7 + ", real=" + string6 + ", adjusted=" + string8 + ", loopback=" + bl5));
        }
        if (!TRTrackerServerImpl.getAllNetworksSupported()) {
            object2 = AENetworkClassifier.categoriseAddress(string8);
            object = TRTrackerServerImpl.getPermittedNetworks();
            bl3 = false;
            for (n7 = 0; n7 < ((String[])object).length; ++n7) {
                if (object2 != object[n7]) continue;
                bl3 = true;
                break;
            }
            if (!bl3) {
                throw new TRTrackerServerException("Network '" + (String)object2 + "' not supported");
            }
        }
        object2 = null;
        if (this.request_type != 3) {
            if (this.request_type == 1) {
                long l4;
                long l5;
                Set set;
                if (byArray == null || byArray.length == 0) {
                    throw new TRTrackerServerException("Hash missing from request ");
                }
                if (byArray.length != 1) {
                    throw new TRTrackerServerException("Too many hashes for announce");
                }
                object = byArray[0];
                object2 = this.server.getTorrent((byte[])object);
                if (object2 == null) {
                    if (!COConfigurationManager.getBooleanParameter("Tracker Public Enable")) {
                        throw new TRTrackerServerException("Torrent unauthorised");
                    }
                    try {
                        object2 = (TRTrackerServerTorrentImpl)this.server.permit(string6, (byte[])object, false);
                    }
                    catch (Throwable throwable) {
                        throw new TRTrackerServerException("Torrent unauthorised", throwable);
                    }
                }
                if (hashWrapper == null) {
                    throw new TRTrackerServerException("peer_id missing from request");
                }
                bl3 = bl2;
                if (bl3 && ((set = this.server.getBiasedPeers()) == null || !set.contains(string6)) && (bl5 || bl4)) {
                    bl3 = false;
                }
                if (bl3) {
                    l5 = this.server.getScrapeRetryInterval((TRTrackerServerTorrentImpl)object2);
                    l4 = this.server.getMinScrapeRetryInterval();
                } else {
                    l5 = this.server.getAnnounceRetryInterval((TRTrackerServerTorrentImpl)object2);
                    l4 = this.server.getMinAnnounceRetryInterval();
                    if (l3 == 0L) {
                        long l6 = this.server.getSeedAnnounceIntervalMultiplier();
                        l5 *= l6;
                        l4 *= l6;
                    }
                }
                TRTrackerServerPeerImpl tRTrackerServerPeerImpl = ((TRTrackerServerTorrentImpl)object2).peerContact(string, string5, hashWrapper, n2, n3, n4, by2, by3, string6, string8, bl4, bl5, string4, l2, l, l3, l5, n6, dHTNetworkPosition);
                if (bl3) {
                    ((TRTrackerServerTorrentImpl)object2).peerQueued(string8, n2, n3, n4, by2, by3, l5, l3 == 0L);
                }
                HashMap hashMap = new HashMap();
                TRTrackerServerPeer tRTrackerServerPeer = tRTrackerServerPeerImpl;
                if (tRTrackerServerPeer == null) {
                    tRTrackerServerPeer = new lightweightPeer(string8, n2, hashWrapper);
                }
                this.server.preProcess(tRTrackerServerPeer, (TRTrackerServerTorrent)object2, this.request_type, string, hashMap);
                boolean bl6 = string5 != null && string5.equalsIgnoreCase("stopped");
                mapArray[0] = ((TRTrackerServerTorrentImpl)object2).exportAnnounceToMap(string8, hashMap, tRTrackerServerPeerImpl, l3 > 0L, bl6 ? 0 : n5, l5, l4, bl, by, by2, dHTNetworkPosition);
                tRTrackerServerPeerImplArray[0] = tRTrackerServerPeerImpl;
            } else if (this.request_type == 4) {
                if (string2 == null) {
                    if (byArray == null || byArray.length == 0) {
                        throw new TRTrackerServerException("Hash missing from request ");
                    }
                    if (byArray.length != 1) {
                        throw new TRTrackerServerException("Too many hashes for query");
                    }
                    object = byArray[0];
                    object2 = this.server.getTorrent((byte[])object);
                } else {
                    object2 = this.server.getTorrent(string2);
                }
                if (object2 == null) {
                    throw new TRTrackerServerException("Torrent unauthorised");
                }
                long l7 = this.server.getAnnounceRetryInterval((TRTrackerServerTorrentImpl)object2);
                mapArray[0] = ((TRTrackerServerTorrentImpl)object2).exportAnnounceToMap(string8, new HashMap(), null, true, n5, l7, this.server.getMinAnnounceRetryInterval(), true, by, by2, dHTNetworkPosition);
            } else {
                char[] cArray;
                HashMap hashMap;
                if (byArray == null || byArray.length == 0) {
                    throw new TRTrackerServerException("Hash missing from request ");
                }
                boolean bl7 = string8.equals("127.0.0.1");
                long l8 = this.server.getMinScrapeRetryInterval();
                mapArray[0] = hashMap = new HashMap();
                ByteEncodedKeyHashMap byteEncodedKeyHashMap = new ByteEncodedKeyHashMap();
                hashMap.put("files", byteEncodedKeyHashMap);
                char[] cArray2 = cArray = string3 == null ? null : string3.toCharArray();
                if (cArray != null && cArray.length != byArray.length) {
                    cArray = null;
                }
                for (int i = 0; i < byArray.length; ++i) {
                    long l9;
                    String string9;
                    byte[] byArray2 = byArray[i];
                    try {
                        string9 = new String(byArray2, "ISO-8859-1");
                        if (i > 0 && byteEncodedKeyHashMap.get(string9) != null) {
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    continue;
                    object2 = this.server.getTorrent(byArray2);
                    if (object2 == null) {
                        if (!COConfigurationManager.getBooleanParameter("Tracker Public Enable")) continue;
                        try {
                            object2 = (TRTrackerServerTorrentImpl)this.server.permit(string6, byArray2, false);
                        }
                        catch (Throwable throwable) {
                            continue;
                        }
                    }
                    if ((l9 = this.server.getScrapeRetryInterval((TRTrackerServerTorrentImpl)object2)) > l8) {
                        l8 = l9;
                    }
                    if (cArray != null && !bl5 && !bl4 && cArray[i] == 'Q') {
                        ((TRTrackerServerTorrentImpl)object2).peerQueued(string8, n2, n3, n4, by2, by3, (int)l9, true);
                    }
                    if (((TRTrackerServerTorrentImpl)object2).getRedirects() != null && byArray.length > 1) continue;
                    this.server.preProcess(new lightweightPeer(string8, n2, hashWrapper), (TRTrackerServerTorrent)object2, this.request_type, string, null);
                    Map map = ((TRTrackerServerTorrentImpl)object2).exportScrapeToMap(string, string8, !bl7);
                    byteEncodedKeyHashMap.put(string9, map);
                }
                if (byArray.length > 1) {
                    object2 = null;
                }
                this.addScrapeInterval(l8, hashMap);
            }
        } else {
            HashMap<String, Object> hashMap;
            if (!TRTrackerServerImpl.isFullScrapeEnabled()) {
                throw new TRTrackerServerException("Full scrape disabled");
            }
            object = new ByteEncodedKeyHashMap();
            TRTrackerServerTorrentImpl[] tRTrackerServerTorrentImplArray = this.server.getTorrents();
            for (n7 = 0; n7 < tRTrackerServerTorrentImplArray.length; ++n7) {
                TRTrackerServerTorrentImpl tRTrackerServerTorrentImpl = tRTrackerServerTorrentImplArray[n7];
                if (tRTrackerServerTorrentImpl.getRedirects() != null) continue;
                this.server.preProcess(new lightweightPeer(string8, n2, hashWrapper), tRTrackerServerTorrentImpl, this.request_type, string, null);
                byte[] byArray3 = tRTrackerServerTorrentImpl.getHash().getHash();
                try {
                    String string10 = new String(byArray3, "ISO-8859-1");
                    Map map = tRTrackerServerTorrentImpl.exportScrapeToMap(string, string8, true);
                    object.put(string10, map);
                    continue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new TRTrackerServerException("Encoding error", unsupportedEncodingException);
                }
            }
            mapArray[0] = hashMap = new HashMap<String, Object>();
            this.addScrapeInterval(null, hashMap);
            hashMap.put("files", object);
        }
        return object2;
    }

    protected void addScrapeInterval(TRTrackerServerTorrentImpl tRTrackerServerTorrentImpl, Map map) {
        long l = this.server.getScrapeRetryInterval(tRTrackerServerTorrentImpl);
        this.addScrapeInterval(l, map);
    }

    protected void addScrapeInterval(long l, Map map) {
        if (l > 0L) {
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            hashMap.put("min_request_interval", new Long(l));
            map.put("flags", hashMap);
        }
    }

    @Override
    public void taskCompleted() {
        if (this.start > 0L) {
            long l = SystemTime.getHighPrecisionCounter() - this.start;
            this.server.updateTime(this.request_type, l);
        }
    }

    protected static class lightweightPeer
    implements TRTrackerServerPeer {
        private String ip;
        private int port;
        private byte[] peer_id;

        public lightweightPeer(String string, int n, HashWrapper hashWrapper) {
            this.ip = string;
            this.port = n;
            this.peer_id = hashWrapper == null ? null : hashWrapper.getBytes();
        }

        @Override
        public long getUploaded() {
            return -1L;
        }

        @Override
        public long getDownloaded() {
            return -1L;
        }

        @Override
        public long getAmountLeft() {
            return -1L;
        }

        @Override
        public String getIP() {
            return this.ip;
        }

        @Override
        public String getIPRaw() {
            return this.ip;
        }

        @Override
        public byte getNATStatus() {
            return 0;
        }

        @Override
        public int getTCPPort() {
            return this.port;
        }

        @Override
        public int getHTTPPort() {
            return 0;
        }

        public int getUDPPort() {
            return 0;
        }

        @Override
        public byte[] getPeerID() {
            return this.peer_id;
        }

        @Override
        public boolean isBiased() {
            return false;
        }

        @Override
        public void setBiased(boolean bl) {
        }

        @Override
        public void setUserData(Object object, Object object2) {
        }

        @Override
        public Object getUserData(Object object) {
            return null;
        }

        @Override
        public int getSecsToLive() {
            return -1;
        }

        @Override
        public Map export() {
            return null;
        }
    }
}

