/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.tcp;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerListener2;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerProcessorTCP;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AsyncController;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;

public abstract class TRTrackerServerTCP
extends TRTrackerServerImpl {
    private static int THREAD_POOL_SIZE = COConfigurationManager.getIntParameter("Tracker Max Threads");
    public static long PROCESSING_GET_LIMIT = COConfigurationManager.getIntParameter("Tracker Max GET Time") * 1000;
    public static int PROCESSING_POST_MULTIPLIER = COConfigurationManager.getIntParameter("Tracker Max POST Time Multiplier");
    private boolean ssl;
    private int port;
    private boolean apply_ip_filter;
    private ThreadPool thread_pool;
    static boolean LOG_DOS_TO_FILE;
    protected static File dos_log_file;
    protected static AEMonitor class_mon;
    Map DOS_map = new LinkedHashMap(1000, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry entry) {
            return TRTrackerServerTCP.this.checkDOSRemove(entry);
        }
    };
    List dos_list = new ArrayList(128);
    long last_dos_check = 0L;
    long MAX_DOS_ENTRIES = 10000L;
    long MAX_DOS_RETENTION = 10000L;
    int DOS_CHECK_DEAD_WOOD_COUNT = 512;
    int DOS_MIN_INTERVAL = 1000;
    int dos_check_count = 0;

    public TRTrackerServerTCP(String string, int n, boolean bl, boolean bl2, boolean bl3) throws TRTrackerServerException {
        super(string, bl3);
        this.port = n;
        this.ssl = bl;
        this.apply_ip_filter = bl2;
        this.thread_pool = new ThreadPool("TrackerServer:TCP:" + this.port, THREAD_POOL_SIZE);
        if (PROCESSING_GET_LIMIT > 0L) {
            this.thread_pool.setExecutionLimit(PROCESSING_GET_LIMIT);
        }
    }

    public void runProcessor(TRTrackerServerProcessorTCP tRTrackerServerProcessorTCP) {
        this.thread_pool.run(tRTrackerServerProcessorTCP);
    }

    protected boolean isIPFilterEnabled() {
        return this.apply_ip_filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean checkDOS(String string) throws UnknownHostException {
        Object object;
        boolean bl;
        InetAddress inetAddress = InetAddress.getByName(string);
        if (inetAddress.isLoopbackAddress() || InetAddress.getLocalHost().equals(inetAddress)) {
            return false;
        }
        this.last_dos_check = SystemTime.getCurrentTime();
        DOSEntry dOSEntry = (DOSEntry)this.DOS_map.get(string);
        if (dOSEntry == null) {
            dOSEntry = new DOSEntry(string);
            this.DOS_map.put(string, dOSEntry);
            bl = false;
        } else {
            boolean bl2 = bl = this.last_dos_check - dOSEntry.last_time < (long)this.DOS_MIN_INTERVAL;
            if (bl && LOG_DOS_TO_FILE) {
                this.dos_list.add(dOSEntry);
            }
            dOSEntry.last_time = this.last_dos_check;
        }
        ++this.dos_check_count;
        if (this.dos_check_count != this.DOS_CHECK_DEAD_WOOD_COUNT) return bl;
        this.dos_check_count = 0;
        Iterator iterator = this.DOS_map.values().iterator();
        while (iterator.hasNext()) {
            object = (DOSEntry)iterator.next();
            if (this.last_dos_check - ((DOSEntry)object).last_time <= this.MAX_DOS_RETENTION) break;
            iterator.remove();
        }
        if (this.dos_list.size() <= 0) return bl;
        try {
            class_mon.enter();
            if (dos_log_file == null) {
                dos_log_file = new File(System.getProperty("user.dir") + File.separator + "dos.log");
            }
            object = null;
            object = new PrintWriter(new FileWriter(dos_log_file, true));
            for (int i = 0; i < this.dos_list.size(); ++i) {
                DOSEntry dOSEntry2 = (DOSEntry)this.dos_list.get(i);
                String string2 = new SimpleDateFormat("hh:mm:ss - ").format(new Date(dOSEntry2.last_time));
                ((PrintWriter)object).println(string2 + dOSEntry2.ip);
            }
            this.dos_list.clear();
            if (object == null) return bl;
            try {
                ((PrintWriter)object).close();
                return bl;
            }
            catch (Throwable throwable) {}
            return bl;
            catch (Throwable throwable) {
                this.dos_list.clear();
                if (object == null) return bl;
                try {
                    ((PrintWriter)object).close();
                    return bl;
                }
                catch (Throwable throwable2) {}
                return bl;
                catch (Throwable throwable3) {
                    this.dos_list.clear();
                    if (object == null) throw throwable3;
                    try {
                        ((PrintWriter)object).close();
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        // empty catch block
                    }
                    throw throwable3;
                }
            }
        }
        finally {
            class_mon.exit();
        }
    }

    protected boolean checkDOSRemove(Map.Entry entry) {
        boolean bl = (long)this.DOS_map.size() > this.MAX_DOS_ENTRIES || this.last_dos_check - ((DOSEntry)entry.getValue()).last_time > this.MAX_DOS_RETENTION;
        return bl;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    protected void setPort(int n) {
        this.port = n;
    }

    @Override
    public String getHost() {
        return COConfigurationManager.getStringParameter("Tracker IP", "");
    }

    @Override
    public boolean isSSL() {
        return this.ssl;
    }

    protected boolean handleExternalRequest(final InetSocketAddress inetSocketAddress, final InetSocketAddress inetSocketAddress2, final String string, final String string2, final URL uRL, final String string3, final InputStream inputStream, final OutputStream outputStream, final AsyncController asyncController, final boolean[] blArray) throws IOException {
        final boolean bl = blArray[0];
        blArray[0] = false;
        for (Object object : this.listeners) {
            if (!object.handleExternalRequest(inetSocketAddress2, string, string2, uRL, string3, inputStream, outputStream, asyncController)) continue;
            return true;
        }
        for (Object object : this.listeners2) {
            TRTrackerServerListener2.ExternalRequest externalRequest;
            if (!object.handleExternalRequest(externalRequest = new TRTrackerServerListener2.ExternalRequest(){

                @Override
                public InetSocketAddress getClientAddress() {
                    return inetSocketAddress2;
                }

                @Override
                public InetSocketAddress getLocalAddress() {
                    return inetSocketAddress;
                }

                @Override
                public String getUser() {
                    return string;
                }

                @Override
                public String getURL() {
                    return string2;
                }

                @Override
                public URL getAbsoluteURL() {
                    return uRL;
                }

                @Override
                public String getHeader() {
                    return string3;
                }

                @Override
                public InputStream getInputStream() {
                    return inputStream;
                }

                @Override
                public OutputStream getOutputStream() {
                    return outputStream;
                }

                @Override
                public AsyncController getAsyncController() {
                    return asyncController;
                }

                @Override
                public boolean canKeepAlive() {
                    return bl;
                }

                @Override
                public void setKeepAlive(boolean bl2) {
                    blArray[0] = bl && bl2;
                }
            })) continue;
            return true;
        }
        return false;
    }

    static {
        if (THREAD_POOL_SIZE <= 0) {
            THREAD_POOL_SIZE = 1;
        }
        if (PROCESSING_GET_LIMIT < 0L) {
            PROCESSING_GET_LIMIT = 0L;
        }
        if (PROCESSING_POST_MULTIPLIER < 0) {
            PROCESSING_POST_MULTIPLIER = 0;
        }
        LOG_DOS_TO_FILE = false;
        LOG_DOS_TO_FILE = System.getProperty("azureus.log.dos") != null;
        class_mon = new AEMonitor("TRTrackerServerTCP:class");
    }

    protected class DOSEntry {
        String ip;
        long last_time;

        protected DOSEntry(String string) {
            this.ip = string;
            this.last_time = TRTrackerServerTCP.this.last_dos_check;
        }
    }
}

