/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.util.Debug;

public class ByteFormatter {
    static final char[] HEXDIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String nicePrint(String string) {
        return ByteFormatter.nicePrint(string.getBytes(), true);
    }

    public static String nicePrint(byte[] byArray) {
        return ByteFormatter.nicePrint(byArray, false);
    }

    public static String nicePrint(byte[] byArray, int n) {
        return ByteFormatter.nicePrint(byArray, false, n);
    }

    public static String nicePrint(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[byteBuffer.limit()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = byteBuffer.get(i);
        }
        return ByteFormatter.nicePrint(byArray);
    }

    public static String nicePrint(byte[] byArray, boolean bl) {
        return ByteFormatter.nicePrint(byArray, bl, 1024);
    }

    public static String nicePrint(byte[] byArray, boolean bl, int n) {
        if (byArray == null) {
            return "";
        }
        int n2 = byArray.length;
        if (n2 > n) {
            n2 = n;
        }
        int n3 = n2 * 2;
        if (!bl) {
            n3 += (n2 - 1) / 4;
        }
        char[] cArray = new char[n3];
        try {
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                if (!bl && i % 4 == 0 && i > 0) {
                    cArray[n4++] = 32;
                }
                cArray[n4++] = HEXDIGITS[(byte)(byArray[i] >> 4 & 0xF)];
                cArray[n4++] = HEXDIGITS[(byte)(byArray[i] & 0xF)];
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
        }
        try {
            return new String(cArray) + (byArray.length > n ? "..." : "");
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            return "";
        }
    }

    public static String nicePrint(byte by) {
        byte by2 = (byte)(by >> 4 & 0xF);
        byte by3 = (byte)(by & 0xF);
        return ByteFormatter.nicePrint2(by2) + ByteFormatter.nicePrint2(by3);
    }

    public static String nicePrint2(byte by) {
        String string = "";
        switch (by) {
            case 0: {
                string = "0";
                break;
            }
            case 1: {
                string = "1";
                break;
            }
            case 2: {
                string = "2";
                break;
            }
            case 3: {
                string = "3";
                break;
            }
            case 4: {
                string = "4";
                break;
            }
            case 5: {
                string = "5";
                break;
            }
            case 6: {
                string = "6";
                break;
            }
            case 7: {
                string = "7";
                break;
            }
            case 8: {
                string = "8";
                break;
            }
            case 9: {
                string = "9";
                break;
            }
            case 10: {
                string = "A";
                break;
            }
            case 11: {
                string = "B";
                break;
            }
            case 12: {
                string = "C";
                break;
            }
            case 13: {
                string = "D";
                break;
            }
            case 14: {
                string = "E";
                break;
            }
            case 15: {
                string = "F";
            }
        }
        return string;
    }

    public static String encodeString(byte[] byArray) {
        return ByteFormatter.nicePrint(byArray, true);
    }

    public static String encodeStringFully(byte[] byArray) {
        return ByteFormatter.nicePrint(byArray, true, Integer.MAX_VALUE);
    }

    public static String encodeString(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return ByteFormatter.nicePrint(byArray2, true);
    }

    public static byte[] decodeString(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length - cArray.length % 2;
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            String string2 = new String(cArray, i, 2);
            byArray[i / 2] = (byte)Integer.parseInt(string2, 16);
        }
        return byArray;
    }

    public static int byteArrayToInt(byte[] byArray) {
        return byArray[0] << 24 & 0xFF000000 | byArray[1] << 16 & 0xFF0000 | byArray[2] << 8 & 0xFF00 | byArray[3] & 0xFF;
    }

    public static long byteArrayToLongMSB(byte[] byArray) {
        return (long)(byArray[0] << 56) & 0xFF000000000000L | (long)(byArray[1] << 48) & 0xFF000000000000L | (long)(byArray[2] << 40) & 0xFF0000000000L | (long)(byArray[3] << 32) & 0xFF00000000L | (long)(byArray[4] << 24) & 0xFF000000L | (long)(byArray[5] << 16) & 0xFF0000L | (long)(byArray[6] << 8) & 0xFF00L | (long)byArray[7] & 0xFFL;
    }

    public static long byteArrayToLongLSB(byte[] byArray) {
        return (long)(byArray[7] << 56) & 0xFF000000000000L | (long)(byArray[6] << 48) & 0xFF000000000000L | (long)(byArray[5] << 40) & 0xFF0000000000L | (long)(byArray[4] << 32) & 0xFF00000000L | (long)(byArray[3] << 24) & 0xFF000000L | (long)(byArray[2] << 16) & 0xFF0000L | (long)(byArray[1] << 8) & 0xFF00L | (long)byArray[0] & 0xFFL;
    }
}

