/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.util.Debug;

public class Constants {
    public static final String EMPTY_STRING = "";
    public static final String SF_WEB_SITE = "http://azureus.sourceforge.net/";
    public static final String AELITIS_TORRENTS = "http://torrent.vuze.com/torrents/";
    public static final String AELITIS_FILES = "http://torrent.vuze.com/files/";
    public static final String AZUREUS_WIKI = "http://wiki.vuze.com/w/";
    public static final String VERSION_SERVER_V4 = "version.vuze.com";
    public static final String VERSION_SERVER_V6 = "version6.vuze.com";
    public static final String DHT_SEED_ADDRESS_V4 = "dht.vuze.com";
    public static final String DHT_SEED_ADDRESS_V6 = "dht6.vuze.com";
    public static final String NAT_TEST_SERVER = "nettest.vuze.com";
    public static final String NAT_TEST_SERVER_HTTP = "http://nettest.vuze.com/";
    public static final String SPEED_TEST_SERVER = "speedtest.vuze.com";
    public static final String PAIRING_URL = "http://pair.vuze.com/pairing";
    public static final String[] AZUREUS_DOMAINS;
    public static final String DEFAULT_ENCODING = "UTF8";
    public static final String BYTE_ENCODING = "ISO-8859-1";
    public static Charset BYTE_CHARSET;
    public static Charset DEFAULT_CHARSET;
    public static final Locale LOCALE_ENGLISH;
    public static final String INFINITY_STRING = "\u221e";
    public static final int CRAPPY_INFINITY_AS_INT = 31536000;
    public static final long CRAPPY_INFINITE_AS_LONG = 1827387392L;
    public static boolean DOWNLOAD_SOURCES_PRETEND_COMPLETE;
    public static String APP_NAME;
    public static final String AZUREUS_NAME = "Azureus";
    public static final String AZUREUS_VERSION = "4.5.0.4";
    public static final String BUILD_VERSION = "@build.version@";
    public static final String AZUREUS_SUBVER = "";
    public static final byte[] VERSION_ID;
    private static final boolean FORCE_NON_CVS;
    public static final boolean IS_CVS_VERSION;
    public static final String OSName;
    public static final boolean isOSX;
    public static final boolean isLinux;
    public static final boolean isSolaris;
    public static final boolean isFreeBSD;
    public static final boolean isWindowsXP;
    public static final boolean isWindows95;
    public static final boolean isWindows98;
    public static final boolean isWindows2000;
    public static final boolean isWindowsME;
    public static final boolean isWindows9598ME;
    public static boolean isSafeMode;
    public static final boolean isWindows;
    public static final boolean isUnix;
    public static final boolean isWindowsVista;
    public static final boolean isWindowsVistaSP2OrHigher;
    public static final boolean isWindowsVistaOrHigher;
    public static final boolean isWindows7OrHigher;
    public static final boolean isOSX_10_5_OrHigher;
    public static final boolean isOSX_10_6_OrHigher;
    public static final String JAVA_VERSION;
    public static final String FILE_WILDCARD;

    public static String getBaseVersion() {
        return Constants.getBaseVersion(AZUREUS_VERSION);
    }

    public static String getBaseVersion(String string) {
        int n = string.indexOf("_");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static boolean isCVSVersion() {
        return IS_CVS_VERSION;
    }

    public static boolean isCVSVersion(String string) {
        return string.indexOf("_") != -1;
    }

    public static int getIncrementalBuild() {
        return Constants.getIncrementalBuild(AZUREUS_VERSION);
    }

    public static int getIncrementalBuild(String string) {
        if (!Constants.isCVSVersion(string)) {
            return 0;
        }
        int n = string.indexOf("_B");
        if (n == -1) {
            return -1;
        }
        try {
            return Integer.parseInt(string.substring(n + 2));
        }
        catch (Throwable throwable) {
            System.out.println("can't parse version");
            return -1;
        }
    }

    public static int compareVersions(String string, String string2) {
        try {
            block7: {
                if (string.startsWith(".")) {
                    string = "0" + string;
                }
                if (string2.startsWith(".")) {
                    string2 = "0" + string2;
                }
                string = string.replaceAll("[^0-9.]", ".");
                string2 = string2.replaceAll("[^0-9.]", ".");
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
                while (true) {
                    int n;
                    if (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens()) {
                        int n2;
                        n = Integer.parseInt(stringTokenizer.nextToken());
                        if (n == (n2 = Integer.parseInt(stringTokenizer2.nextToken()))) continue;
                        return n - n2;
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        n = Integer.parseInt(stringTokenizer.nextToken());
                        if (n == 0) continue;
                        return 1;
                    }
                    if (!stringTokenizer2.hasMoreTokens()) break block7;
                    n = Integer.parseInt(stringTokenizer2.nextToken());
                    if (n != 0) break;
                }
                return -1;
            }
            return 0;
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return 0;
        }
    }

    public static boolean isValidVersionFormat(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c) || c == '.') continue;
            return false;
        }
        return !string.startsWith(".") && !string.endsWith(".") && string.indexOf("..") == -1;
    }

    public static boolean isAzureusDomain(String string) {
        string = string.toLowerCase();
        for (int i = 0; i < AZUREUS_DOMAINS.length; ++i) {
            String string2 = AZUREUS_DOMAINS[i];
            if (string2.equals(string)) {
                return true;
            }
            if (!string.endsWith("." + string2)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        System.out.println(Constants.compareVersions("3.0.0.1", "3.0.0.0"));
        System.out.println(Constants.compareVersions("3.0.0.0_B1", "3.0.0.0"));
        System.out.println(Constants.compareVersions("3.0.0.0", "3.0.0.0_B1"));
        System.out.println(Constants.compareVersions("3.0.0.0_B1", "3.0.0.0_B4"));
        System.out.println(Constants.compareVersions("3.0.0.0..B1", "3.0.0.0_B4"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Object object;
        int n;
        AZUREUS_DOMAINS = new String[]{"azureusplatform.com", "azureus.com", "aelitis.com", "vuze.com"};
        try {
            BYTE_CHARSET = Charset.forName(BYTE_ENCODING);
            DEFAULT_CHARSET = Charset.forName(DEFAULT_ENCODING);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        LOCALE_ENGLISH = new Locale("en", "");
        DOWNLOAD_SOURCES_PRETEND_COMPLETE = false;
        APP_NAME = "Vuze";
        VERSION_ID = "-AZ4504-".getBytes();
        FORCE_NON_CVS = System.getProperty("az.force.noncvs", "0").equals("1");
        IS_CVS_VERSION = Constants.isCVSVersion(AZUREUS_VERSION) && !FORCE_NON_CVS;
        OSName = System.getProperty("os.name");
        isOSX = OSName.toLowerCase().startsWith("mac os");
        isLinux = OSName.equalsIgnoreCase("Linux");
        isSolaris = OSName.equalsIgnoreCase("SunOS");
        isFreeBSD = OSName.equalsIgnoreCase("FreeBSD");
        isWindowsXP = OSName.equalsIgnoreCase("Windows XP");
        isWindows95 = OSName.equalsIgnoreCase("Windows 95");
        isWindows98 = OSName.equalsIgnoreCase("Windows 98");
        isWindows2000 = OSName.equalsIgnoreCase("Windows 2000");
        isWindowsME = OSName.equalsIgnoreCase("Windows ME");
        isWindows9598ME = isWindows95 || isWindows98 || isWindowsME;
        isSafeMode = false;
        isWindows = OSName.toLowerCase().startsWith("windows");
        boolean bl = isUnix = !isWindows && !isOSX;
        if (isWindows) {
            block27: {
                Float f = null;
                try {
                    f = new Float(System.getProperty("os.version"));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                n = 0;
                if (f == null) {
                    isWindowsVista = false;
                    isWindowsVistaOrHigher = false;
                    isWindows7OrHigher = false;
                } else {
                    float f2 = f.floatValue();
                    isWindowsVista = f2 == 6.0f;
                    isWindowsVistaOrHigher = f2 >= 6.0f;
                    boolean bl2 = isWindows7OrHigher = f2 >= 6.1f;
                    if (isWindowsVista) {
                        object = null;
                        try {
                            String string;
                            Process process = Runtime.getRuntime().exec(new String[]{"reg", "query", "HKLM\\Software\\Microsoft\\Windows NT\\CurrentVersion", "/v", "CSDVersion"});
                            object = new LineNumberReader(new InputStreamReader(process.getInputStream()));
                            do {
                                if ((string = ((LineNumberReader)object).readLine()) != null) continue;
                                break block27;
                            } while (!string.matches(".*CSDVersion.*"));
                            n = string.matches(".*Service Pack [2-9]") ? 1 : 0;
                        }
                        catch (Throwable throwable) {
                        }
                        finally {
                            if (object != null) {
                                try {
                                    ((BufferedReader)object).close();
                                }
                                catch (Throwable throwable) {}
                            }
                        }
                    }
                }
            }
            isWindowsVistaSP2OrHigher = n;
        } else {
            isWindowsVista = false;
            isWindowsVistaSP2OrHigher = false;
            isWindowsVistaOrHigher = false;
            isWindows7OrHigher = false;
        }
        if (isOSX) {
            int n2 = 0;
            n = 0;
            try {
                String string = System.getProperty("os.version");
                object = string.split("\\.");
                n2 = Integer.parseInt(object[0]);
                if (((String[])object).length > 1) {
                    n = Integer.parseInt(object[1]);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            isOSX_10_5_OrHigher = n2 > 10 || n2 == 10 && n >= 5;
            isOSX_10_6_OrHigher = n2 > 10 || n2 == 10 && n >= 6;
        } else {
            isOSX_10_5_OrHigher = false;
            isOSX_10_6_OrHigher = false;
        }
        JAVA_VERSION = System.getProperty("java.version");
        FILE_WILDCARD = isWindows ? "*.*" : "*";
    }
}

