/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.Arrays;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.plugins.utils.ByteArrayWrapper;

public class HashWrapper
implements ByteArrayWrapper {
    private byte[] hash;
    private int hash_code;

    public HashWrapper(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public HashWrapper(byte[] byArray, int n, int n2) {
        this.hash = new byte[n2];
        System.arraycopy(byArray, n, this.hash, 0, n2);
        for (int i = 0; i < n2; ++i) {
            this.hash_code = 31 * this.hash_code + this.hash[i];
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof HashWrapper)) {
            return false;
        }
        byte[] byArray = ((HashWrapper)object).getHash();
        return Arrays.equals(this.hash, byArray);
    }

    public byte[] getHash() {
        return this.hash;
    }

    @Override
    public byte[] getBytes() {
        return this.hash;
    }

    public int hashCode() {
        return this.hash_code;
    }

    public String toBase32String() {
        return Base32.encode(this.hash);
    }
}

