/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.aelitis.azureus.core.util.HashCodeUtils;
import java.io.File;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.LightHashSet;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class StringInterner {
    private static final int SCHEDULED_CLEANUP_INTERVAL = 60000;
    private static final boolean TRACE_CLEANUP = false;
    private static final boolean TRACE_MULTIHITS = false;
    private static final int IMMEDIATE_CLEANUP_TRIGGER = 2000;
    private static final int IMMEDIATE_CLEANUP_GOAL = 1500;
    private static final int SCHEDULED_CLEANUP_TRIGGER = 1500;
    private static final int SCHEDULED_CLEANUP_GOAL = 1000;
    private static final int SCHEDULED_AGING_THRESHOLD = 750;
    private static LightHashSet managedInterningSet = new LightHashSet(800);
    private static LightHashSet unmanagedInterningSet = new LightHashSet();
    private static ReadWriteLock managedSetLock = new ReentrantReadWriteLock();
    private static final ReferenceQueue managedRefQueue = new ReferenceQueue();
    private static final ReferenceQueue unmanagedRefQueue = new ReferenceQueue();
    private static final String[] COMMON_KEYS = new String[]{"src", "port", "prot", "ip", "udpport", "azver", "httpport", "downloaded", "Content", "Refresh On", "path.utf-8", "uploaded", "completed", "persistent", "attributes", "encoding", "azureus_properties", "stats.download.added.time", "networks", "p1", "resume data", "dndflags", "blocks", "resume", "primaryfile", "resumecomplete", "data", "peersources", "name.utf-8", "valid", "torrent filename", "parameters", "secrets", "timesincedl", "tracker_cache", "filedownloaded", "timesinceul", "tracker_peers", "trackerclientextensions", "GlobalRating", "comment.utf-8", "Count", "String", "stats.counted", "Thumbnail", "Plugin.<internal>.DDBaseTTTorrent::sha1", "type", "Title", "displayname", "Publisher", "Creation Date", "Revision Date", "Content Hash", "flags", "stats.download.completed.time", "Description", "Progressive", "Content Type", "QOS Class", "DRM", "hash", "ver", "id", "body", "seed", "eip", "rid", "iip", "dp2", "tp", "orig", "dp", "Quality", "private", "dht_backup_enable", "max.uploads", "filelinks", "Speed Bps", "cdn_properties", "sha1", "ed2k", "DRM Key", "Plugin.aeseedingengine.attributes", "initial_seed", "dht_backup_requested", "ta", "size", "DIRECTOR PUBLISH", "Plugin.azdirector.ContentMap", "dateadded", "bytesin", "announces", "status", "bytesout", "scrapes", "passive"};
    private static final ByteArrayHashMap byte_map = new ByteArrayHashMap(COMMON_KEYS.length);
    private static final Comparator savingsComp;

    public static String intern(byte[] byArray) {
        String string = (String)byte_map.get(byArray);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object internObject(Object object) {
        Object object2;
        if (object == null) {
            return null;
        }
        WeakEntry weakEntry = new WeakEntry(object, unmanagedRefQueue);
        LightHashSet lightHashSet = unmanagedInterningSet;
        synchronized (lightHashSet) {
            WeakEntry weakEntry2 = (WeakEntry)unmanagedInterningSet.get(weakEntry);
            if (weakEntry2 == null || (object2 = weakEntry2.get()) == null) {
                object2 = object;
                if (!unmanagedInterningSet.add(weakEntry)) {
                    System.out.println("unexpected modification");
                }
            }
            StringInterner.sanitizeLight();
        }
        if (!object.equals(object2)) {
            System.err.println("mismatch");
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String intern(String string) {
        String string2;
        boolean bl;
        WeakStringEntry weakStringEntry;
        WeakStringEntry weakStringEntry2;
        block11: {
            if (string == null) {
                return null;
            }
            weakStringEntry2 = new WeakStringEntry(string);
            weakStringEntry = null;
            bl = false;
            managedSetLock.readLock().lock();
            try {
                weakStringEntry = (WeakStringEntry)managedInterningSet.get(weakStringEntry2);
                if (weakStringEntry != null && (string2 = weakStringEntry.getString()) != null) {
                    bl = true;
                    break block11;
                }
                managedSetLock.readLock().unlock();
                managedSetLock.writeLock().lock();
                try {
                    StringInterner.sanitize(false);
                    weakStringEntry = (WeakStringEntry)managedInterningSet.get(weakStringEntry2);
                    if (weakStringEntry != null && (string2 = weakStringEntry.getString()) != null) {
                        bl = true;
                    } else {
                        managedInterningSet.add(weakStringEntry2);
                        string2 = string;
                    }
                }
                finally {
                    managedSetLock.readLock().lock();
                    managedSetLock.writeLock().unlock();
                }
            }
            finally {
                managedSetLock.readLock().unlock();
            }
        }
        if (bl) {
            weakStringEntry.incHits();
            weakStringEntry2.destroy();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] internBytes(byte[] byArray) {
        byte[] byArray2;
        boolean bl;
        WeakByteArrayEntry weakByteArrayEntry;
        WeakByteArrayEntry weakByteArrayEntry2;
        block12: {
            if (byArray == null) {
                return null;
            }
            weakByteArrayEntry2 = new WeakByteArrayEntry(byArray);
            weakByteArrayEntry = null;
            bl = false;
            managedSetLock.readLock().lock();
            try {
                weakByteArrayEntry = (WeakByteArrayEntry)managedInterningSet.get(weakByteArrayEntry2);
                if (weakByteArrayEntry != null && (byArray2 = weakByteArrayEntry.getArray()) != null) {
                    bl = true;
                    break block12;
                }
                managedSetLock.readLock().unlock();
                managedSetLock.writeLock().lock();
                try {
                    StringInterner.sanitize(false);
                    weakByteArrayEntry = (WeakByteArrayEntry)managedInterningSet.get(weakByteArrayEntry2);
                    if (weakByteArrayEntry != null && (byArray2 = weakByteArrayEntry.getArray()) != null) {
                        bl = true;
                    } else {
                        managedInterningSet.add(weakByteArrayEntry2);
                        byArray2 = byArray;
                    }
                }
                finally {
                    managedSetLock.readLock().lock();
                    managedSetLock.writeLock().unlock();
                }
            }
            finally {
                managedSetLock.readLock().unlock();
            }
        }
        if (bl) {
            weakByteArrayEntry.incHits();
            weakByteArrayEntry2.destroy();
        }
        if (!Arrays.equals(byArray, byArray2)) {
            System.err.println("mismatch");
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File internFile(File file) {
        File file2;
        boolean bl;
        WeakFileEntry weakFileEntry;
        WeakFileEntry weakFileEntry2;
        block12: {
            if (file == null) {
                return null;
            }
            weakFileEntry2 = new WeakFileEntry(file);
            weakFileEntry = null;
            bl = false;
            managedSetLock.readLock().lock();
            try {
                weakFileEntry = (WeakFileEntry)managedInterningSet.get(weakFileEntry2);
                if (weakFileEntry != null && (file2 = weakFileEntry.getFile()) != null) {
                    bl = true;
                    break block12;
                }
                managedSetLock.readLock().unlock();
                managedSetLock.writeLock().lock();
                try {
                    StringInterner.sanitize(false);
                    weakFileEntry = (WeakFileEntry)managedInterningSet.get(weakFileEntry2);
                    if (weakFileEntry != null && (file2 = weakFileEntry.getFile()) != null) {
                        bl = true;
                    } else {
                        managedInterningSet.add(weakFileEntry2);
                        file2 = file;
                    }
                }
                finally {
                    managedSetLock.readLock().lock();
                    managedSetLock.writeLock().unlock();
                }
            }
            finally {
                managedSetLock.readLock().unlock();
            }
        }
        if (bl) {
            weakFileEntry.incHits();
            weakFileEntry2.destroy();
        }
        if (!file.equals(file2)) {
            System.err.println("mismatch");
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL internURL(URL uRL) {
        URL uRL2;
        boolean bl;
        WeakURLEntry weakURLEntry;
        WeakURLEntry weakURLEntry2;
        block12: {
            if (uRL == null) {
                return null;
            }
            weakURLEntry2 = new WeakURLEntry(uRL);
            weakURLEntry = null;
            bl = false;
            managedSetLock.readLock().lock();
            try {
                weakURLEntry = (WeakURLEntry)managedInterningSet.get(weakURLEntry2);
                if (weakURLEntry != null && (uRL2 = weakURLEntry.getURL()) != null) {
                    bl = true;
                    break block12;
                }
                managedSetLock.readLock().unlock();
                managedSetLock.writeLock().lock();
                try {
                    StringInterner.sanitize(false);
                    weakURLEntry = (WeakURLEntry)managedInterningSet.get(weakURLEntry2);
                    if (weakURLEntry != null && (uRL2 = weakURLEntry.getURL()) != null) {
                        bl = true;
                    } else {
                        managedInterningSet.add(weakURLEntry2);
                        uRL2 = uRL;
                    }
                }
                finally {
                    managedSetLock.readLock().lock();
                    managedSetLock.writeLock().unlock();
                }
            }
            finally {
                managedSetLock.readLock().unlock();
            }
        }
        if (bl) {
            weakURLEntry.incHits();
            weakURLEntry2.destroy();
        }
        if (!uRL.toExternalForm().equals(uRL2.toExternalForm())) {
            System.err.println("mismatch");
        }
        return uRL2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sanitizeLight() {
        LightHashSet lightHashSet = unmanagedInterningSet;
        synchronized (lightHashSet) {
            WeakEntry weakEntry;
            while ((weakEntry = (WeakEntry)unmanagedRefQueue.poll()) != null) {
                unmanagedInterningSet.remove(weakEntry);
            }
            unmanagedInterningSet.compactify(-1.0f);
        }
    }

    private static void sanitize(boolean bl) {
        block14: {
            WeakWeightedEntry weakWeightedEntry;
            while ((weakWeightedEntry = (WeakWeightedEntry)managedRefQueue.poll()) != null) {
                if (!weakWeightedEntry.isDestroyed()) {
                    managedInterningSet.remove(weakWeightedEntry);
                    continue;
                }
                System.err.println("double removal " + weakWeightedEntry);
            }
            int n = managedInterningSet.size();
            if (n >= 2000 || bl) {
                WeakWeightedEntry weakWeightedEntry2;
                Object object = new ArrayList<WeakWeightedEntry>();
                Iterator iterator = managedInterningSet.iterator();
                while (iterator.hasNext()) {
                    if (managedInterningSet.size() >= 1500 || bl) {
                        weakWeightedEntry2 = (WeakWeightedEntry)iterator.next();
                        if (weakWeightedEntry2.hits == 0) {
                            iterator.remove();
                            continue;
                        }
                        ((ArrayList)object).add(weakWeightedEntry2);
                        continue;
                    }
                    break block14;
                }
                n = managedInterningSet.size();
                if (n >= 1500 || !bl) {
                    if (n >= 1500 || bl) {
                        Collections.sort(object, savingsComp);
                        for (int i = 0; !(i >= ((ArrayList)object).size() || (n = managedInterningSet.size()) < 1000 && bl); ++i) {
                            if (n >= 1500 || bl) {
                                weakWeightedEntry2 = (WeakWeightedEntry)((ArrayList)object).get(i);
                                managedInterningSet.remove(weakWeightedEntry2);
                                continue;
                            }
                            break;
                        }
                    }
                } else if (!((n = managedInterningSet.size()) < 750 && bl || n < 1500 && !bl)) {
                    object = managedInterningSet.iterator();
                    while (object.hasNext()) {
                        ((WeakWeightedEntry)object.next()).decHits();
                    }
                }
            }
        }
        if (bl) {
            managedInterningSet.compactify(-1.0f);
        }
    }

    static {
        try {
            for (int i = 0; i < COMMON_KEYS.length; ++i) {
                byte_map.put(COMMON_KEYS[i].getBytes("ISO-8859-1"), COMMON_KEYS[i]);
                managedInterningSet.add(new WeakStringEntry(COMMON_KEYS[i]));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        new AEThread2("asyncify", true){

            @Override
            public void run() {
                SimpleTimer.addPeriodicEvent("StringInterner:cleaner", 60000L, new TimerEventPerformer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void perform(TimerEvent timerEvent2) {
                        managedSetLock.writeLock().lock();
                        try {
                            StringInterner.sanitize(true);
                        }
                        finally {
                            managedSetLock.writeLock().unlock();
                        }
                        StringInterner.sanitizeLight();
                    }
                });
            }
        }.start();
        savingsComp = new Comparator(){

            public int compare(Object object, Object object2) {
                WeakWeightedEntry weakWeightedEntry = (WeakWeightedEntry)object;
                WeakWeightedEntry weakWeightedEntry2 = (WeakWeightedEntry)object2;
                return weakWeightedEntry.hits * weakWeightedEntry.size - weakWeightedEntry2.hits * weakWeightedEntry2.size;
            }
        };
    }

    private static class WeakURLEntry
    extends WeakWeightedEntry {
        public WeakURLEntry(URL uRL) {
            super((Object)uRL, uRL.toExternalForm().hashCode(), 176 + uRL.toString().length() * 2);
        }

        public URL getURL() {
            return (URL)this.get();
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof WeakURLEntry) {
                URL uRL;
                URL uRL2 = this.getURL();
                if (uRL2 == (uRL = ((WeakURLEntry)object).getURL())) {
                    return true;
                }
                if (uRL2 == null || uRL == null) {
                    return false;
                }
                return uRL2.toExternalForm().equals(uRL.toExternalForm());
            }
            return false;
        }

        @Override
        public String toString() {
            return super.toString() + " " + this.getURL();
        }
    }

    private static class WeakFileEntry
    extends WeakWeightedEntry {
        public WeakFileEntry(File file) {
            super((Object)file, file.hashCode(), 40 + file.getPath().length() * 2);
        }

        public File getFile() {
            return (File)this.get();
        }

        @Override
        public String toString() {
            return super.toString() + " " + this.getFile();
        }
    }

    private static class WeakStringEntry
    extends WeakWeightedEntry {
        public WeakStringEntry(String string) {
            super((Object)string, string.hashCode(), 24 + string.length() * 2);
        }

        public String getString() {
            return (String)this.get();
        }

        @Override
        public String toString() {
            return super.toString() + " " + this.getString();
        }
    }

    private static class WeakByteArrayEntry
    extends WeakWeightedEntry {
        public WeakByteArrayEntry(byte[] byArray) {
            super((Object)byArray, HashCodeUtils.hashCode(byArray), byArray.length + 8);
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof WeakByteArrayEntry) {
                byte[] byArray = this.getArray();
                byte[] byArray2 = ((WeakByteArrayEntry)object).getArray();
                return byArray == null ? false : Arrays.equals(byArray, byArray2);
            }
            return false;
        }

        public byte[] getArray() {
            return (byte[])this.get();
        }

        @Override
        public String toString() {
            return super.toString() + " " + (this.getArray() == null ? "null" : new String(this.getArray()));
        }
    }

    private static abstract class WeakWeightedEntry
    extends WeakEntry {
        final short size;
        short hits;

        public WeakWeightedEntry(Object object, int n, int n2) {
            super(object, managedRefQueue, n);
            this.size = (short)(n2 & Short.MAX_VALUE);
        }

        public void incHits() {
            if (this.hits < Short.MAX_VALUE) {
                this.hits = (short)(this.hits + 1);
            }
        }

        public void decHits() {
            if (this.hits > 0) {
                this.hits = (short)(this.hits - 1);
            }
        }

        public String toString() {
            return this.getClass().getName().replaceAll("^.*\\..\\w+$", "") + " h=" + this.hits + ";s=" + this.size;
        }

        public void destroy() {
            this.hits = (short)-1;
        }

        public boolean isDestroyed() {
            return this.hits == -1;
        }
    }

    private static class WeakEntry
    extends WeakReference {
        private final int hash;

        protected WeakEntry(Object object, ReferenceQueue referenceQueue, int n) {
            super(object, referenceQueue);
            this.hash = n;
        }

        public WeakEntry(Object object, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this.hash = object.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof WeakEntry) {
                Object t = this.get();
                Object t2 = ((WeakEntry)object).get();
                return t == null ? false : t.equals(t2);
            }
            return false;
        }

        public final int hashCode() {
            return this.hash;
        }
    }
}

