/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Properties;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerFactory;

public class SystemProperties {
    private static final LogIDs LOGID = LogIDs.CORE;
    public static final String SYS_PROP_CONFIG_OVERRIDE = "azureus.config.path";
    public static final String SEP = System.getProperty("file.separator");
    public static final String AZ_APP_ID = "az";
    public static String APPLICATION_NAME = "Azureus";
    private static String APPLICATION_ID = "az";
    private static String APPLICATION_VERSION = "4.5.0.4";
    private static String APPLICATION_ENTRY_POINT = "org.gudy.azureus2.ui.swt.Main";
    private static final String WIN_DEFAULT = "Application Data";
    private static final String OSX_DEFAULT = "Library" + SEP + "Application Support";
    private static String user_path;
    private static String app_path;

    public static void determineApplicationName() {
        if (Constants.isOSX && !System.getProperty("azureus.infer.app.name", "true").equals("false")) {
            String string = System.getProperty("java.class.path");
            if (string == null) {
                System.out.println("SystemProperties: determineApplicationName - class path is null");
            } else {
                int n = string.indexOf(".app/Contents");
                if (n == -1) {
                    System.out.println("SystemProperties: determineApplicationName -  can't determine application name from " + string);
                } else {
                    int n2;
                    for (n2 = n; n2 >= 0 && string.charAt(n2) != '/'; --n2) {
                    }
                    String string2 = string.substring(n2 + 1, n);
                    SystemProperties.setApplicationName(string2);
                }
            }
        }
    }

    public static void setApplicationName(String string) {
        if (string != null && string.trim().length() > 0) {
            string = string.trim();
            if (user_path != null && !string.equals(APPLICATION_NAME)) {
                System.out.println("**** SystemProperties::setApplicationName called too late! ****");
            }
            APPLICATION_NAME = string;
        }
    }

    public static void setApplicationIdentifier(String string) {
        if (string != null && string.trim().length() > 0) {
            APPLICATION_ID = string.trim();
        }
    }

    public static void setApplicationEntryPoint(String string) {
        if (string != null && string.trim().length() > 0) {
            APPLICATION_ENTRY_POINT = string.trim();
        }
    }

    public static String getApplicationName() {
        return APPLICATION_NAME;
    }

    public static void setApplicationVersion(String string) {
        APPLICATION_VERSION = string;
    }

    public static String getApplicationVersion() {
        return APPLICATION_VERSION;
    }

    public static String getApplicationIdentifier() {
        return APPLICATION_ID;
    }

    public static String getApplicationEntryPoint() {
        return APPLICATION_ENTRY_POINT;
    }

    public static void setUserPath(String string) {
        user_path = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserPath() {
        if (user_path != null) {
            return user_path;
        }
        String string = System.getProperty(SYS_PROP_CONFIG_OVERRIDE);
        try {
            Object object;
            block25: {
                if (string != null) {
                    File file;
                    if (!string.endsWith(SEP)) {
                        string = string + SEP;
                    }
                    if (!(file = new File(string)).exists()) {
                        FileUtil.mkdirs(file);
                    }
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "SystemProperties::getUserPath(Custom): user_path = " + string));
                    }
                    String string2 = string;
                    return string2;
                }
                try {
                    object = PlatformManagerFactory.getPlatformManager();
                    string = object.getLocation(1L).getPath() + SEP;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "SystemProperties::getUserPath: user_path = " + string));
                    }
                }
                catch (Throwable throwable) {
                    if (!Logger.isEnabled()) break block25;
                    Logger.log(new LogEvent(LOGID, "Unable to retrieve user config path from the platform manager. Make sure aereg.dll is present."));
                }
            }
            if (string == null) {
                object = System.getProperty("user.home");
                if (Constants.isWindows) {
                    string = SystemProperties.getEnvironmentalVariable("APPDATA");
                    if (string != null && string.length() > 0) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "Using user config path from APPDATA env var instead: " + string));
                        }
                    } else {
                        string = (String)object + SEP + WIN_DEFAULT;
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "Using user config path from java user.home var instead: " + string));
                        }
                    }
                    string = string + SEP + APPLICATION_NAME + SEP;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "SystemProperties::getUserPath(Win): user_path = " + string));
                    }
                } else if (Constants.isOSX) {
                    string = (String)object + SEP + OSX_DEFAULT + SEP + APPLICATION_NAME + SEP;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "SystemProperties::getUserPath(Mac): user_path = " + string));
                    }
                } else {
                    string = (String)object + SEP + "." + APPLICATION_NAME.toLowerCase() + SEP;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "SystemProperties::getUserPath(Unix): user_path = " + string));
                    }
                }
            }
            if (!((File)(object = new File(string))).exists()) {
                FileUtil.mkdirs((File)object);
            }
            String string3 = string;
            return string3;
        }
        finally {
            user_path = string;
        }
    }

    public static String getApplicationPath() {
        if (app_path != null) {
            return app_path;
        }
        String string = System.getProperty("azureus.install.path", System.getProperty("user.dir"));
        if (!string.endsWith(SEP)) {
            string = string + SEP;
        }
        app_path = string;
        return app_path;
    }

    public static boolean isJavaWebStartInstance() {
        try {
            String string = System.getProperty("azureus.javaws");
            return string != null && string.equals("true");
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String getEnvironmentalVariable(String string) {
        Properties properties;
        block8: {
            if (Constants.isWindows9598ME) {
                return "";
            }
            String string2 = System.getenv(string);
            if (string2 != null) {
                return string2;
            }
            properties = new Properties();
            BufferedReader bufferedReader = null;
            try {
                String string3;
                Process process = null;
                Runtime runtime = Runtime.getRuntime();
                process = Constants.isWindows ? runtime.exec("cmd.exe /c set") : runtime.exec("env");
                String string4 = LocaleUtil.getSingleton().getSystemEncoding();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "SystemProperties::getEnvironmentalVariable - " + string + ", system encoding = " + string4));
                }
                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), string4), 8192);
                while ((string3 = bufferedReader.readLine()) != null) {
                    int n = string3.indexOf(61);
                    if (n < 0) continue;
                    String string5 = string3.substring(0, n);
                    String string6 = string3.substring(n + 1);
                    properties.setProperty(string5, string6);
                }
                bufferedReader.close();
            }
            catch (Throwable throwable) {
                if (bufferedReader == null) break block8;
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return properties.getProperty(string, "");
    }

    public static String getDocPath() {
        File file = null;
        try {
            PlatformManager platformManager = PlatformManagerFactory.getPlatformManager();
            file = platformManager.getLocation(3L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (file == null) {
            file = new File(SystemProperties.getUserPath(), "Documents");
        }
        return file.getAbsolutePath();
    }

    public static String getAzureusJarPath() {
        String string = SystemProperties.getApplicationPath();
        if (Constants.isOSX) {
            string = string + SystemProperties.getApplicationName() + ".app/Contents/Resources/Java/";
        }
        return string + "Azureus2.jar";
    }
}

