/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util.jar;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;

public class AEJarSigner2 {
    protected static Class JarSigner_class;
    protected String keystore_name;
    protected String keystore_password;
    protected String alias;

    public AEJarSigner2(String string, String string2, String string3) {
        this.alias = string;
        this.keystore_name = string2;
        this.keystore_password = string3;
    }

    protected void loadJarSigner() throws IOException {
        File file;
        Object object;
        Object object2;
        String string = COConfigurationManager.getStringParameter("Security.JAR.tools.dir");
        if (string.length() == 0) {
            object2 = System.getProperty("java.home");
            object = new File((String)object2);
            if (((File)object).getName().equalsIgnoreCase("jre")) {
                object = ((File)object).getParentFile();
            } else {
                String string2 = ((File)object).getName();
                if (string2.startsWith("jre")) {
                    string2 = "jdk" + string2.substring(3);
                    object = new File(((File)object).getParentFile(), string2);
                }
            }
            file = new File((File)object, "lib");
        } else {
            file = new File(string);
        }
        object2 = new File(file, "tools.jar");
        if (((File)object2).exists()) {
            try {
                object = new URLClassLoader(new URL[]{((File)object2).toURL()}, AEJarSigner2.class.getClassLoader());
                JarSigner_class = ((ClassLoader)object).loadClass("sun.security.tools.JarSigner");
            }
            catch (Throwable throwable) {
                Logger.logTextResource(new LogAlert(false, 3, "Security.jar.signfail"), new String[]{throwable.getMessage()});
                Debug.printStackTrace(throwable);
                throw new IOException("JAR signing fails: " + throwable.getMessage());
            }
        } else {
            Logger.logTextResource(new LogAlert(false, 3, "Security.jar.tools_not_found"), new String[]{file.toString()});
            throw new IOException("JAR signing fails: tools.jar not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void signJarFile(File file) throws IOException {
        String string;
        block10: {
            if (JarSigner_class == null) {
                this.loadJarSigner();
            }
            PrintStream printStream = null;
            PrintStream printStream2 = null;
            string = null;
            try {
                Object t = JarSigner_class.newInstance();
                String[] stringArray = new String[]{"-keystore", this.keystore_name, "-storepass", this.keystore_password, file.toString(), this.alias};
                printStream = System.err;
                printStream2 = System.out;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintStream printStream3 = new PrintStream(byteArrayOutputStream);
                System.setErr(printStream3);
                System.setOut(printStream3);
                try {
                    JarSigner_class.getMethod("run", String[].class).invoke(t, new Object[]{stringArray});
                }
                catch (Throwable throwable) {
                    printStream3.close();
                    String string2 = byteArrayOutputStream.toString();
                    if (string2.length() > 0) {
                        string = string2;
                    }
                    Debug.printStackTrace(throwable);
                    string = throwable.getMessage();
                }
                if (printStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    Debug.printStackTrace(throwable);
                    string = throwable.getMessage();
                    break block10;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (printStream != null) {
                        System.setErr(printStream);
                        System.setOut(printStream2);
                    }
                }
            }
            System.setErr(printStream);
            System.setOut(printStream2);
        }
        if (string == null) return;
        Debug.out("JAR signing fails '" + string + "'");
        Logger.logTextResource(new LogAlert(false, 3, "Security.jar.signfail"), new String[]{string});
        throw new IOException("JAR signing fails: " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signJarFile(File file, OutputStream outputStream) throws IOException {
        this.signJarFile(file);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            FileUtil.copyFile(file, outputStream, false);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signJarStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        File file = AETemporaryFileHandler.createTempFile();
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            byte[] byArray = new byte[8192];
            fileOutputStream = new FileOutputStream(file);
            while ((n = inputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
            fileOutputStream = null;
            this.signJarFile(file, outputStream);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
            file.delete();
        }
    }
}

