/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.installer;

import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.installer.InstallablePlugin;
import org.gudy.azureus2.plugins.installer.PluginInstallationListener;
import org.gudy.azureus2.plugins.installer.PluginInstaller;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.pluginsimpl.local.installer.PluginInstallerImpl;
import org.gudy.azureus2.pluginsimpl.update.PluginUpdatePlugin;

public abstract class InstallablePluginImpl
implements InstallablePlugin {
    private PluginInstallerImpl installer;

    protected InstallablePluginImpl(PluginInstallerImpl pluginInstallerImpl) {
        this.installer = pluginInstallerImpl;
    }

    @Override
    public boolean isAlreadyInstalled() {
        PluginInterface pluginInterface = this.getAlreadyInstalledPlugin();
        if (pluginInterface == null) {
            return false;
        }
        String string = this.getVersion();
        if (string == null || string.length() == 0) {
            return false;
        }
        String string2 = pluginInterface.getPluginVersion();
        if (string2 == null) {
            return true;
        }
        return Constants.compareVersions(string2, string) >= 0;
    }

    @Override
    public PluginInterface getAlreadyInstalledPlugin() {
        return this.installer.getAlreadyInstalledPlugin(this.getId());
    }

    @Override
    public void install(boolean bl) throws PluginException {
        this.installer.install(this, bl);
    }

    @Override
    public void install(boolean bl, boolean bl2, final boolean bl3) throws PluginException {
        final AESemaphore aESemaphore = new AESemaphore("FPI");
        final PluginException[] pluginExceptionArray = new PluginException[]{null};
        this.installer.install(new InstallablePlugin[]{this}, bl, bl2, null, new PluginInstallationListener(){

            @Override
            public void completed() {
                aESemaphore.release();
            }

            @Override
            public void cancelled() {
                this.failed(new PluginException("Install cancelled"));
            }

            @Override
            public void failed(PluginException pluginException) {
                pluginExceptionArray[0] = pluginException;
                aESemaphore.release();
                if (!bl3) {
                    Debug.out("Install failed", pluginException);
                }
            }
        });
        if (bl3) {
            aESemaphore.reserve();
            if (pluginExceptionArray[0] != null) {
                throw pluginExceptionArray[0];
            }
        }
    }

    @Override
    public void uninstall() throws PluginException {
        this.installer.uninstall(this);
    }

    @Override
    public PluginInstaller getInstaller() {
        return this.installer;
    }

    public abstract void addUpdate(UpdateCheckInstance var1, PluginUpdatePlugin var2, Plugin var3, PluginInterface var4);
}

