/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.launch;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.plugins.PluginManagerArgumentHandler;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;

public class PluginSingleInstanceHandler {
    private static boolean active;
    private static int port;
    private static PluginManagerArgumentHandler handler;

    public static void initialise(int n, PluginManagerArgumentHandler pluginManagerArgumentHandler) {
        port = n;
        handler = pluginManagerArgumentHandler;
        String string = System.getProperty("MULTI_INSTANCE");
        if (string != null && string.equalsIgnoreCase("true")) {
            return;
        }
        active = true;
    }

    protected static boolean process(LoggerChannelListener loggerChannelListener, String[] stringArray) {
        if (active) {
            if (PluginSingleInstanceHandler.startListener(loggerChannelListener)) {
                return false;
            }
            PluginSingleInstanceHandler.sendArguments(loggerChannelListener, stringArray);
            return true;
        }
        return false;
    }

    protected static boolean startListener(final LoggerChannelListener loggerChannelListener) {
        try {
            final ServerSocket serverSocket = new ServerSocket(port, 50, InetAddress.getByName("127.0.0.1"));
            loggerChannelListener.messageLogged(1, "SingleInstanceHandler: listening on 127.0.0.1:" + port + " for passed arguments");
            Thread thread = new Thread("Single Instance Handler"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        Socket socket = null;
                        ObjectInputStream objectInputStream = null;
                        try {
                            socket = serverSocket.accept();
                            String string = socket.getInetAddress().getHostAddress();
                            if (!string.equals("localhost") && !string.equals("127.0.0.1")) {
                                socket.close();
                                continue;
                            }
                            objectInputStream = new ObjectInputStream(socket.getInputStream());
                            objectInputStream.readInt();
                            String string2 = (String)objectInputStream.readObject();
                            if (!string2.equals(PluginSingleInstanceHandler.getHeader())) {
                                loggerChannelListener.messageLogged(3, "SingleInstanceHandler: invalid header - " + string2);
                                continue;
                            }
                            String[] stringArray = (String[])objectInputStream.readObject();
                            handler.processArguments(stringArray);
                            continue;
                        }
                        catch (Throwable throwable) {
                            loggerChannelListener.messageLogged("SingleInstanceHandler: receive error", throwable);
                            continue;
                        }
                        finally {
                            if (objectInputStream != null) {
                                try {
                                    objectInputStream.close();
                                }
                                catch (Throwable throwable) {}
                            }
                            if (socket == null) continue;
                            try {
                                socket.close();
                            }
                            catch (Throwable throwable) {}
                            continue;
                        }
                        break;
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void sendArguments(LoggerChannelListener loggerChannelListener, String[] stringArray) {
        Socket socket = null;
        try {
            socket = new Socket("127.0.0.1", port);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
            objectOutputStream.writeInt(0);
            objectOutputStream.writeObject(PluginSingleInstanceHandler.getHeader());
            objectOutputStream.writeObject(stringArray);
            loggerChannelListener.messageLogged(1, "SingleInstanceHandler: arguments passed to existing process");
        }
        catch (Throwable throwable) {
            loggerChannelListener.messageLogged("SingleInstanceHandler: send error", throwable);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected static String getHeader() {
        return SystemProperties.getApplicationName() + " Single Instance Handler";
    }
}

