/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.peers;

import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionBase;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItem;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItemFactory;
import com.aelitis.azureus.core.peermanager.piecepicker.util.BitFlags;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.peer.PEPeerListener;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.network.Connection;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerEvent;
import org.gudy.azureus2.plugins.peers.PeerListener;
import org.gudy.azureus2.plugins.peers.PeerListener2;
import org.gudy.azureus2.plugins.peers.PeerReadRequest;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.pluginsimpl.local.messaging.MessageAdapter;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerForeignNetworkConnection;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerStatsImpl;

public class PeerForeignDelegate
implements PEPeerTransport {
    protected volatile int _lastPiece = -1;
    private PeerManagerImpl manager;
    private Peer foreign;
    private NetworkConnectionBase network_connection;
    private long create_time = SystemTime.getCurrentTime();
    private long last_data_received_time = -1L;
    private long last_data_message_received_time = -1L;
    private int[] reserved_pieces = null;
    private int consecutive_no_requests;
    private BitFlags bit_flags;
    private boolean priority_connection;
    private Map data;
    private HashMap peer_listeners;
    protected AEMonitor this_mon = new AEMonitor("PeerForeignDelegate");

    protected PeerForeignDelegate(PeerManagerImpl peerManagerImpl, Peer peer) {
        this.manager = peerManagerImpl;
        this.foreign = peer;
        PEPeerManager pEPeerManager = this.manager.getDelegate();
        this.network_connection = new PeerForeignNetworkConnection(this.foreign);
        this.network_connection.addRateLimiter(pEPeerManager.getUploadLimitedRateGroup(), true);
        this.network_connection.addRateLimiter(pEPeerManager.getDownloadLimitedRateGroup(), false);
    }

    @Override
    public void start() {
        NetworkManager.getSingleton().startTransferProcessing(this.network_connection);
        NetworkManager.getSingleton().upgradeTransferProcessing(this.network_connection, this.manager.getPartitionID());
    }

    protected void stop() {
        NetworkManager.getSingleton().stopTransferProcessing(this.network_connection);
    }

    @Override
    public void sendChoke() {
    }

    @Override
    public void sendHave(int n) {
    }

    @Override
    public void sendUnChoke() {
    }

    @Override
    public InetAddress getAlternativeIPv6() {
        return null;
    }

    @Override
    public boolean transferAvailable() {
        return this.foreign.isTransferAvailable();
    }

    @Override
    public boolean isDownloadPossible() {
        return this.foreign.isDownloadPossible();
    }

    @Override
    public void sendCancel(DiskManagerReadRequest diskManagerReadRequest) {
        this.foreign.cancelRequest(diskManagerReadRequest);
    }

    @Override
    public DiskManagerReadRequest request(int n, int n2, int n3) {
        DiskManagerReadRequest diskManagerReadRequest = this.manager.getDelegate().getDiskManager().createReadRequest(n, n2, n3);
        if (this.foreign.addRequest(diskManagerReadRequest)) {
            return diskManagerReadRequest;
        }
        return null;
    }

    @Override
    public int getRequestIndex(DiskManagerReadRequest diskManagerReadRequest) {
        return this.foreign.getRequests().indexOf(diskManagerReadRequest);
    }

    protected void dataReceived() {
        this.last_data_received_time = SystemTime.getCurrentTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeConnection(String string) {
        try {
            this.foreign.close(string, false, false);
        }
        finally {
            this.stop();
        }
    }

    @Override
    public List getExpiredRequests() {
        return this.foreign.getExpiredRequests();
    }

    @Override
    public int getMaxNbRequests() {
        return this.foreign.getMaximumNumberOfRequests();
    }

    @Override
    public int getNbRequests() {
        return this.foreign.getNumberOfRequests();
    }

    @Override
    public int[] getPriorityOffsets() {
        return this.foreign.getPriorityOffsets();
    }

    @Override
    public boolean requestAllocationStarts(int[] nArray) {
        return this.foreign.requestAllocationStarts(nArray);
    }

    @Override
    public void requestAllocationComplete() {
        this.foreign.requestAllocationComplete();
    }

    @Override
    public PEPeerControl getControl() {
        return (PEPeerControl)this.manager.getDelegate();
    }

    @Override
    public void updatePeerExchange() {
    }

    @Override
    public PeerItem getPeerItemIdentity() {
        return PeerItemFactory.createPeerItem(this.foreign.getIp(), this.foreign.getTCPListenPort(), (byte)3, (byte)0, this.foreign.getUDPListenPort(), (byte)1, 0);
    }

    @Override
    public int getConnectionState() {
        int n = this.getPeerState();
        if (n == 10) {
            return 1;
        }
        if (n == 20) {
            return 2;
        }
        if (n == 30) {
            return 4;
        }
        return 4;
    }

    @Override
    public void doKeepAliveCheck() {
    }

    @Override
    public boolean doTimeoutChecks() {
        return false;
    }

    @Override
    public void doPerformanceTuningCheck() {
    }

    @Override
    public void setSuspendedLazyBitFieldEnabled(boolean bl) {
    }

    @Override
    public long getTimeSinceConnectionEstablished() {
        long l = SystemTime.getCurrentTime();
        if (l > this.create_time) {
            return l - this.create_time;
        }
        return 0L;
    }

    @Override
    public long getTimeSinceLastDataMessageReceived() {
        if (this.last_data_message_received_time == -1L) {
            return -1L;
        }
        long l = SystemTime.getCurrentTime();
        if (this.last_data_message_received_time < l) {
            this.last_data_message_received_time = l;
        }
        return l - this.last_data_message_received_time;
    }

    @Override
    public long getTimeSinceGoodDataReceived() {
        if (this.last_data_received_time == -1L) {
            return -1L;
        }
        long l = SystemTime.getCurrentTime();
        long l2 = l - this.last_data_received_time;
        if (l2 < 0L) {
            this.last_data_received_time = l;
            l2 = 0L;
        }
        return l2;
    }

    @Override
    public long getTimeSinceLastDataMessageSent() {
        return 0L;
    }

    @Override
    public long getUnchokedForMillis() {
        return 0L;
    }

    @Override
    public int getConsecutiveNoRequestCount() {
        return this.consecutive_no_requests;
    }

    @Override
    public void setConsecutiveNoRequestCount(int n) {
        this.consecutive_no_requests = n;
    }

    @Override
    public PEPeerManager getManager() {
        return this.manager.getDelegate();
    }

    @Override
    public String getPeerSource() {
        return "Plugin";
    }

    @Override
    public int getPeerState() {
        int n = this.foreign.getState();
        return n;
    }

    @Override
    public byte[] getId() {
        return this.foreign.getId();
    }

    @Override
    public String getIp() {
        return this.foreign.getIp();
    }

    @Override
    public String getIPHostName() {
        return this.foreign.getIp();
    }

    @Override
    public int getPort() {
        return this.foreign.getPort();
    }

    @Override
    public int getTCPListenPort() {
        return this.foreign.getTCPListenPort();
    }

    @Override
    public int getUDPListenPort() {
        return this.foreign.getUDPListenPort();
    }

    @Override
    public int getUDPNonDataListenPort() {
        return this.foreign.getUDPNonDataListenPort();
    }

    @Override
    public BitFlags getAvailable() {
        boolean[] blArray = this.foreign.getAvailable();
        if (this.bit_flags == null || this.bit_flags.flags != blArray) {
            this.bit_flags = new BitFlags(blArray);
        }
        return this.bit_flags;
    }

    @Override
    public boolean hasReceivedBitField() {
        return true;
    }

    @Override
    public boolean isPieceAvailable(int n) {
        return this.foreign.isPieceAvailable(n);
    }

    @Override
    public void setSnubbed(boolean bl) {
        this.foreign.setSnubbed(bl);
    }

    @Override
    public boolean isChokingMe() {
        return this.foreign.isChoked();
    }

    @Override
    public boolean isChokedByMe() {
        return this.foreign.isChoking();
    }

    @Override
    public boolean isUnchokeOverride() {
        return false;
    }

    @Override
    public boolean isInteresting() {
        return this.foreign.isInteresting();
    }

    @Override
    public boolean isInterested() {
        return this.foreign.isInterested();
    }

    @Override
    public boolean isSeed() {
        return this.foreign.isSeed();
    }

    @Override
    public boolean isRelativeSeed() {
        return false;
    }

    @Override
    public boolean isSnubbed() {
        return this.foreign.isSnubbed();
    }

    @Override
    public long getSnubbedTime() {
        return this.foreign.getSnubbedTime();
    }

    @Override
    public boolean isLANLocal() {
        return AddressUtils.isLANLocalAddress(this.foreign.getIp()) == 1;
    }

    @Override
    public boolean sendRequestHint(int n, int n2, int n3, int n4) {
        return false;
    }

    @Override
    public int[] getRequestHint() {
        return null;
    }

    @Override
    public void clearRequestHint() {
    }

    @Override
    public void sendRejectRequest(DiskManagerReadRequest diskManagerReadRequest) {
    }

    @Override
    public void sendBadPiece(int n) {
    }

    @Override
    public void sendStatsRequest(Map map) {
    }

    @Override
    public void sendStatsReply(Map map) {
    }

    @Override
    public boolean isTCP() {
        return true;
    }

    @Override
    public PEPeerStats getStats() {
        return ((PeerStatsImpl)this.foreign.getStats()).getDelegate();
    }

    @Override
    public boolean isIncoming() {
        return this.foreign.isIncoming();
    }

    @Override
    public int getPercentDoneInThousandNotation() {
        return this.foreign.getPercentDoneInThousandNotation();
    }

    @Override
    public long getBytesRemaining() {
        int n = 1000 - this.getPercentDoneInThousandNotation();
        if (n == 0) {
            return 0L;
        }
        try {
            Torrent torrent = this.manager.getDownload().getTorrent();
            if (torrent == null) {
                return Long.MAX_VALUE;
            }
            return torrent.getSize() * (long)n / 1000L;
        }
        catch (Throwable throwable) {
            return Long.MAX_VALUE;
        }
    }

    @Override
    public String getClient() {
        return this.foreign.getClient();
    }

    @Override
    public byte[] getHandshakeReservedBytes() {
        return this.foreign.getHandshakeReservedBytes();
    }

    @Override
    public boolean isOptimisticUnchoke() {
        return this.foreign.isOptimisticUnchoke();
    }

    @Override
    public void setOptimisticUnchoke(boolean bl) {
        this.foreign.setOptimisticUnchoke(bl);
    }

    @Override
    public int getUniqueAnnounce() {
        return -1;
    }

    @Override
    public int getUploadHint() {
        return 0;
    }

    @Override
    public void setUniqueAnnounce(int n) {
    }

    @Override
    public void setUploadHint(int n) {
    }

    @Override
    public boolean isStalledPendingLoad() {
        return false;
    }

    @Override
    public void addListener(final PEPeerListener pEPeerListener) {
        final PeerForeignDelegate peerForeignDelegate = this;
        PeerListener2 peerListener2 = new PeerListener2(){

            @Override
            public void eventOccurred(PeerEvent peerEvent) {
                Object object = peerEvent.getData();
                switch (peerEvent.getType()) {
                    case 1: {
                        pEPeerListener.stateChanged(peerForeignDelegate, (Integer)object);
                        break;
                    }
                    case 2: {
                        Integer[] integerArray = (Integer[])object;
                        pEPeerListener.sentBadChunk(peerForeignDelegate, integerArray[0], integerArray[1]);
                        break;
                    }
                    case 3: {
                        pEPeerListener.addAvailability(peerForeignDelegate, new BitFlags((boolean[])object));
                        break;
                    }
                    case 4: {
                        pEPeerListener.removeAvailability(peerForeignDelegate, new BitFlags((boolean[])object));
                    }
                }
            }
        };
        this.foreign.addListener(peerListener2);
        if (this.peer_listeners == null) {
            this.peer_listeners = new HashMap();
        }
        this.peer_listeners.put(pEPeerListener, peerListener2);
    }

    @Override
    public void removeListener(PEPeerListener pEPeerListener) {
        Object v;
        if (this.peer_listeners != null && (v = this.peer_listeners.remove(pEPeerListener)) != null) {
            if (v instanceof PeerListener) {
                this.foreign.removeListener((PeerListener)v);
            } else {
                this.foreign.removeListener((PeerListener2)v);
            }
        }
    }

    @Override
    public Connection getPluginConnection() {
        return this.foreign.getConnection();
    }

    @Override
    public int getPercentDoneOfCurrentIncomingRequest() {
        return this.foreign.getPercentDoneOfCurrentIncomingRequest();
    }

    @Override
    public int getPercentDoneOfCurrentOutgoingRequest() {
        return this.foreign.getPercentDoneOfCurrentOutgoingRequest();
    }

    @Override
    public boolean supportsMessaging() {
        return this.foreign.supportsMessaging();
    }

    @Override
    public int getMessagingMode() {
        return 4;
    }

    @Override
    public String getEncryption() {
        return "";
    }

    @Override
    public com.aelitis.azureus.core.peermanager.messaging.Message[] getSupportedMessages() {
        Message[] messageArray = this.foreign.getSupportedMessages();
        com.aelitis.azureus.core.peermanager.messaging.Message[] messageArray2 = new com.aelitis.azureus.core.peermanager.messaging.Message[messageArray.length];
        for (int i = 0; i < messageArray.length; ++i) {
            messageArray2[i] = new MessageAdapter(messageArray[i]);
        }
        return messageArray2;
    }

    @Override
    public Object getData(String string) {
        return this.getUserData(string);
    }

    @Override
    public void setData(String string, Object object) {
        this.setUserData(string, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getUserData(Object object) {
        try {
            this.this_mon.enter();
            if (this.data == null) {
                Object var2_2 = null;
                return var2_2;
            }
            Object v = this.data.get(object);
            return v;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserData(Object object, Object object2) {
        try {
            this.this_mon.enter();
            if (this.data == null) {
                this.data = new LightHashMap();
            }
            if (object2 == null) {
                if (this.data.containsKey(object)) {
                    this.data.remove(object);
                    if (this.data.size() == 0) {
                        this.data = null;
                    }
                }
            } else {
                this.data.put(object, object2);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public boolean equals(Object object) {
        if (object instanceof PeerForeignDelegate) {
            return this.foreign.equals(((PeerForeignDelegate)object).foreign);
        }
        return false;
    }

    public int hashCode() {
        return this.foreign.hashCode();
    }

    @Override
    public int[] getReservedPieceNumbers() {
        return this.reserved_pieces;
    }

    @Override
    public void addReservedPieceNumber(int n) {
        int[] nArray = this.reserved_pieces;
        if (nArray == null) {
            this.reserved_pieces = new int[]{n};
        } else {
            int[] nArray2 = new int[nArray.length + 1];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray2[nArray.length] = n;
            this.reserved_pieces = nArray2;
        }
    }

    @Override
    public void removeReservedPieceNumber(int n) {
        int[] nArray = this.reserved_pieces;
        if (nArray != null) {
            if (nArray.length == 1) {
                if (nArray[0] == n) {
                    this.reserved_pieces = null;
                }
            } else {
                int[] nArray2 = new int[nArray.length - 1];
                int n2 = 0;
                boolean bl = false;
                for (int i = 0; i < nArray.length; ++i) {
                    int n3 = nArray[i];
                    if (bl || n3 != n) {
                        if (n2 == nArray2.length) {
                            return;
                        }
                        nArray2[n2++] = n3;
                        continue;
                    }
                    bl = true;
                }
                this.reserved_pieces = nArray2;
            }
        }
    }

    @Override
    public int[] getIncomingRequestedPieceNumbers() {
        return new int[0];
    }

    @Override
    public int getIncomingRequestCount() {
        return 0;
    }

    @Override
    public int getOutgoingRequestCount() {
        return this.foreign.getRequests().size();
    }

    @Override
    public int[] getOutgoingRequestedPieceNumbers() {
        List list = this.foreign.getRequests();
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            nArray[i] = ((PeerReadRequest)list.get(i)).getPieceNumber();
        }
        return nArray;
    }

    @Override
    public int getOutboundDataQueueSize() {
        return this.getOutgoingRequestCount() * 16384;
    }

    @Override
    public int getLastPiece() {
        return this._lastPiece;
    }

    @Override
    public void setLastPiece(int n) {
        this._lastPiece = n;
    }

    @Override
    public void checkInterested() {
    }

    public boolean isAvailabilityAdded() {
        return false;
    }

    public void clearAvailabilityAdded() {
    }

    @Override
    public PEPeerTransport reconnect(boolean bl, boolean bl2) {
        return null;
    }

    @Override
    public boolean isSafeForReconnect() {
        return false;
    }

    @Override
    public void setUploadRateLimitBytesPerSecond(int n) {
        this.network_connection.setUploadLimit(n);
    }

    @Override
    public void setDownloadRateLimitBytesPerSecond(int n) {
        this.network_connection.setDownloadLimit(n);
    }

    @Override
    public int getUploadRateLimitBytesPerSecond() {
        return this.network_connection.getUploadLimit();
    }

    @Override
    public int getDownloadRateLimitBytesPerSecond() {
        return this.network_connection.getDownloadLimit();
    }

    @Override
    public void addRateLimiter(LimitedRateGroup limitedRateGroup, boolean bl) {
        this.network_connection.addRateLimiter(limitedRateGroup, bl);
    }

    @Override
    public void removeRateLimiter(LimitedRateGroup limitedRateGroup, boolean bl) {
        this.network_connection.removeRateLimiter(limitedRateGroup, bl);
    }

    @Override
    public void setHaveAggregationEnabled(boolean bl) {
    }

    @Override
    public void setPriorityConnection(boolean bl) {
        this.priority_connection = bl;
    }

    @Override
    public boolean isPriorityConnection() {
        return this.priority_connection;
    }

    @Override
    public void generateEvidence(IndentWriter indentWriter) {
        indentWriter.println("delegate: ip=" + this.getIp() + ",tcp=" + this.getTCPListenPort() + ",udp=" + this.getUDPListenPort() + ",state=" + this.foreign.getState() + ",foreign=" + this.foreign);
    }

    @Override
    public String getClientNameFromExtensionHandshake() {
        return null;
    }

    @Override
    public String getClientNameFromPeerID() {
        return null;
    }
}

