/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.sharing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareResourceImpl;

public class ShareConfigImpl {
    protected ShareManagerImpl manager;
    protected int suspend_level;
    protected boolean save_outstanding;
    protected AEMonitor this_mon = new AEMonitor("ShareConfig");

    protected void loadConfig(ShareManagerImpl shareManagerImpl) {
        this.manager = shareManagerImpl;
        try {
            Map map = FileUtil.readResilientConfigFile("sharing.config");
            List list = (List)map.get("resources");
            if (list == null) {
                return;
            }
            for (Map map2 : list) {
                this.manager.deserialiseResource(map2);
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveConfig() throws ShareException {
        try {
            this.this_mon.enter();
            if (this.suspend_level > 0) {
                this.save_outstanding = true;
                return;
            }
            HashMap hashMap = new HashMap();
            ArrayList arrayList = new ArrayList();
            hashMap.put("resources", arrayList);
            ShareResource[] shareResourceArray = this.manager.getShares();
            for (int i = 0; i < shareResourceArray.length; ++i) {
                HashMap hashMap2 = new HashMap();
                ((ShareResourceImpl)shareResourceArray[i]).serialiseResource(hashMap2);
                arrayList.add(hashMap2);
            }
            FileUtil.writeResilientConfigFile("sharing.config", hashMap);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspendSaving() {
        try {
            this.this_mon.enter();
            ++this.suspend_level;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resumeSaving() throws ShareException {
        try {
            this.this_mon.enter();
            --this.suspend_level;
            if (this.suspend_level == 0 && this.save_outstanding) {
                this.save_outstanding = false;
                this.saveConfig();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }
}

