/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui;

import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.plugins.ui.UIInputReceiver;
import org.gudy.azureus2.plugins.ui.UIInputReceiverListener;
import org.gudy.azureus2.plugins.ui.UIInputValidator;

public abstract class AbstractUIInputReceiver
implements UIInputReceiver {
    private boolean prompted = false;
    protected String[] messages = new String[0];
    protected String title = null;
    protected boolean multiline_mode = false;
    protected String preentered_text = null;
    protected boolean preentered_text_is_old_value = false;
    protected UIInputValidator validator = null;
    private boolean result_recorded = false;
    protected UIInputReceiverListener receiver_listener;
    private boolean result_input_submitted = false;
    private String result_input = null;
    protected boolean maintain_whitespace = false;
    protected boolean allow_empty_input = true;

    protected final void assertPrePrompt() {
        if (this.prompted) {
            throw new RuntimeException("cannot invoke after prompt has been called");
        }
    }

    protected final void assertPostPrompt() {
        if (!this.prompted) {
            throw new RuntimeException("cannot before after prompt has been called");
        }
    }

    @Override
    public void setLocalisedMessage(String string) {
        this.setLocalisedMessages(new String[]{string});
    }

    @Override
    public void setLocalisedMessages(String[] stringArray) {
        this.assertPrePrompt();
        this.messages = stringArray;
    }

    @Override
    public void setLocalisedTitle(String string) {
        this.assertPrePrompt();
        this.title = string;
    }

    @Override
    public void setMessage(String string) {
        this.setLocalisedMessage(this.localise(string));
    }

    @Override
    public void setMessages(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = this.localise(stringArray[i]);
        }
        this.setLocalisedMessages(stringArray2);
    }

    @Override
    public void setMultiLine(boolean bl) {
        this.assertPrePrompt();
        this.multiline_mode = bl;
    }

    @Override
    public void setPreenteredText(String string, boolean bl) {
        this.assertPrePrompt();
        this.preentered_text = string;
        this.preentered_text_is_old_value = !bl;
    }

    @Override
    public void setTitle(String string) {
        this.setLocalisedTitle(this.localise(string));
    }

    @Override
    public void setInputValidator(UIInputValidator uIInputValidator) {
        this.assertPrePrompt();
        this.validator = uIInputValidator;
    }

    @Override
    public final void prompt() {
        this.assertPrePrompt();
        this.promptForInput();
        if (!this.result_recorded) {
            throw new RuntimeException(this.toString() + " did not record a result.");
        }
        this.prompted = true;
    }

    @Override
    public final void prompt(UIInputReceiverListener uIInputReceiverListener) {
        this.assertPrePrompt();
        this.receiver_listener = uIInputReceiverListener;
        this.promptForInput();
    }

    public final void triggerReceiverListener() {
        if (!this.result_recorded) {
            throw new RuntimeException(this.toString() + " did not record a result.");
        }
        this.prompted = true;
        if (this.receiver_listener != null) {
            this.receiver_listener.UIInputReceiverClosed(this);
        }
    }

    protected abstract void promptForInput();

    protected final void recordUserInput(String string) {
        this.result_recorded = true;
        this.result_input_submitted = true;
        this.result_input = string;
        if (!this.maintain_whitespace) {
            this.result_input = string.trim();
        }
    }

    protected final void recordUserAbort() {
        this.result_recorded = true;
        this.result_input_submitted = false;
        this.result_input = null;
    }

    @Override
    public boolean hasSubmittedInput() {
        this.assertPostPrompt();
        return this.result_input_submitted;
    }

    @Override
    public String getSubmittedInput() {
        this.assertPostPrompt();
        return this.result_input;
    }

    @Override
    public void maintainWhitespace(boolean bl) {
        this.maintain_whitespace = bl;
    }

    @Override
    public void allowEmptyInput(boolean bl) {
        this.allow_empty_input = bl;
    }

    protected final String localise(String string) {
        return MessageText.getString(string);
    }
}

