/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;

public class PooledByteBufferImpl
implements PooledByteBuffer {
    private DirectByteBuffer buffer;

    public PooledByteBufferImpl(DirectByteBuffer directByteBuffer) {
        this.buffer = directByteBuffer;
    }

    public PooledByteBufferImpl(int n) {
        this.buffer = DirectByteBufferPool.getBuffer((byte)1, n);
    }

    public PooledByteBufferImpl(byte[] byArray) {
        this.buffer = DirectByteBufferPool.getBuffer((byte)1, byArray.length);
        this.buffer.put((byte)1, byArray);
        this.buffer.position((byte)1, 0);
    }

    public PooledByteBufferImpl(byte[] byArray, int n, int n2) {
        this.buffer = DirectByteBufferPool.getBuffer((byte)1, n2);
        this.buffer.put((byte)1, byArray, n, n2);
        this.buffer.position((byte)1, 0);
    }

    @Override
    public byte[] toByteArray() {
        this.buffer.position((byte)1, 0);
        int n = this.buffer.limit((byte)1);
        byte[] byArray = new byte[n];
        this.buffer.get((byte)1, byArray);
        this.buffer.position((byte)1, 0);
        return byArray;
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return this.buffer.getBuffer((byte)1);
    }

    @Override
    public Map toMap() throws IOException {
        return BDecoder.decode(this.toByteArray());
    }

    public DirectByteBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public void returnToPool() {
        this.buffer.returnToPool();
    }
}

