/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import com.aelitis.azureus.core.util.HTTPUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderCancelledException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderBaseImpl;

public class ResourceDownloaderFileImpl
extends ResourceDownloaderBaseImpl {
    protected boolean cancelled;
    protected File file;
    protected Object result;
    protected AESemaphore done_sem = new AESemaphore("RDTimeout");
    protected long size = -2L;

    public ResourceDownloaderFileImpl(ResourceDownloaderBaseImpl resourceDownloaderBaseImpl, File file) {
        super(resourceDownloaderBaseImpl);
        this.file = file;
    }

    @Override
    public String getName() {
        return this.file.toString();
    }

    @Override
    protected void setSize(long l) {
    }

    @Override
    public long getSize() throws ResourceDownloaderException {
        String string = this.file.toString();
        int n = string.lastIndexOf(".");
        String string2 = n != -1 ? string.substring(n + 1) : null;
        this.setProperty("ContentType", HTTPUtils.guessContentTypeFromFileType(string2));
        return FileUtil.getFileOrDirectorySize(this.file);
    }

    @Override
    public void setProperty(String string, Object object) {
        this.setPropertySupport(string, object);
    }

    @Override
    public ResourceDownloaderBaseImpl getClone(ResourceDownloaderBaseImpl resourceDownloaderBaseImpl) {
        ResourceDownloaderFileImpl resourceDownloaderFileImpl = new ResourceDownloaderFileImpl(this.getParent(), this.file);
        return resourceDownloaderFileImpl;
    }

    @Override
    public InputStream download() throws ResourceDownloaderException {
        this.asyncDownload();
        this.done_sem.reserve();
        if (this.result instanceof ResourceDownloaderException) {
            throw (ResourceDownloaderException)this.result;
        }
        return (InputStream)this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncDownload() {
        try {
            this.this_mon.enter();
            if (!this.cancelled) {
                this.informActivity(this.getLogIndent() + (this.file.isDirectory() ? "Processing: " : "Downloading: ") + this.getName());
                final Object object = TorrentUtils.getTLS();
                AEThread2 aEThread2 = new AEThread2("ResourceDownloaderTimeout", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object2 = TorrentUtils.getTLS();
                        TorrentUtils.setTLS(object);
                        try {
                            if (ResourceDownloaderFileImpl.this.file.isDirectory()) {
                                ResourceDownloaderFileImpl.this.completed(ResourceDownloaderFileImpl.this, null);
                            } else {
                                ResourceDownloaderFileImpl.this.completed(ResourceDownloaderFileImpl.this, new FileInputStream(ResourceDownloaderFileImpl.this.file));
                            }
                        }
                        catch (Throwable throwable) {
                            ResourceDownloaderFileImpl.this.failed(ResourceDownloaderFileImpl.this, new ResourceDownloaderException(ResourceDownloaderFileImpl.this, "Failed to read file", throwable));
                            Debug.printStackTrace(throwable);
                        }
                        finally {
                            TorrentUtils.setTLS(object2);
                        }
                    }
                };
                aEThread2.start();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void cancel() {
        this.cancel(new ResourceDownloaderCancelledException(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel(ResourceDownloaderException resourceDownloaderException) {
        this.setCancelled();
        try {
            this.this_mon.enter();
            this.result = resourceDownloaderException;
            this.cancelled = true;
            this.informFailed((ResourceDownloaderException)this.result);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public boolean completed(ResourceDownloader resourceDownloader, InputStream inputStream) {
        if (this.informComplete(inputStream)) {
            this.result = inputStream;
            this.done_sem.release();
            return true;
        }
        return false;
    }

    public void failed(ResourceDownloader resourceDownloader, ResourceDownloaderException resourceDownloaderException) {
        this.result = resourceDownloaderException;
        this.done_sem.release();
        this.informFailed(resourceDownloaderException);
    }
}

