/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import java.io.InputStream;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderCancelledException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderListener;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderBaseImpl;

public class ResourceDownloaderRetryImpl
extends ResourceDownloaderBaseImpl
implements ResourceDownloaderListener {
    protected ResourceDownloaderBaseImpl delegate;
    protected int retry_count;
    protected boolean cancelled;
    protected ResourceDownloader current_downloader;
    protected int done_count;
    protected Object result;
    protected AESemaphore done_sem = new AESemaphore("RDRretry");
    protected long size = -2L;

    public ResourceDownloaderRetryImpl(ResourceDownloaderBaseImpl resourceDownloaderBaseImpl, ResourceDownloader resourceDownloader, int n) {
        super(resourceDownloaderBaseImpl);
        this.delegate = (ResourceDownloaderBaseImpl)resourceDownloader;
        this.delegate.setParent(this);
        this.retry_count = n;
    }

    @Override
    public String getName() {
        return this.delegate.getName() + ", retry=" + this.retry_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long getSize() throws ResourceDownloaderException {
        if (this.size != -2L) {
            return this.size;
        }
        try {
            for (int i = 0; i < this.retry_count; ++i) {
                try {
                    ResourceDownloaderBaseImpl resourceDownloaderBaseImpl = this.delegate.getClone(this);
                    this.addReportListener(resourceDownloaderBaseImpl);
                    this.size = resourceDownloaderBaseImpl.getSize();
                    this.setProperties(resourceDownloaderBaseImpl);
                    long l = this.size;
                    return l;
                }
                catch (ResourceDownloaderException resourceDownloaderException) {
                    try {
                        if (i != this.retry_count - 1) continue;
                        throw resourceDownloaderException;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return this.size;
                    }
                }
            }
        }
        finally {
            if (this.size == -2L) {
                this.size = -1L;
            }
            this.setSize(this.size);
        }
    }

    @Override
    protected void setSize(long l) {
        this.size = l;
        if (this.size >= 0L) {
            this.delegate.setSize(this.size);
        }
    }

    @Override
    public void setProperty(String string, Object object) throws ResourceDownloaderException {
        this.setPropertySupport(string, object);
        this.delegate.setProperty(string, object);
    }

    @Override
    public ResourceDownloaderBaseImpl getClone(ResourceDownloaderBaseImpl resourceDownloaderBaseImpl) {
        ResourceDownloaderRetryImpl resourceDownloaderRetryImpl = new ResourceDownloaderRetryImpl(resourceDownloaderBaseImpl, this.delegate.getClone(this), this.retry_count);
        resourceDownloaderRetryImpl.setSize(this.size);
        resourceDownloaderRetryImpl.setProperties(this);
        return resourceDownloaderRetryImpl;
    }

    @Override
    public InputStream download() throws ResourceDownloaderException {
        this.asyncDownload();
        this.done_sem.reserve();
        if (this.result instanceof InputStream) {
            return (InputStream)this.result;
        }
        throw (ResourceDownloaderException)this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncDownload() {
        try {
            this.this_mon.enter();
            if (this.done_count == this.retry_count || this.cancelled) {
                this.done_sem.release();
                this.informFailed((ResourceDownloaderException)this.result);
            } else {
                ++this.done_count;
                if (this.done_count > 1) {
                    this.informActivity(this.getLogIndent() + "  attempt " + this.done_count + " of " + this.retry_count);
                }
                this.current_downloader = this.delegate.getClone(this);
                this.current_downloader.addListener(this);
                this.current_downloader.asyncDownload();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        this.setCancelled();
        try {
            this.this_mon.enter();
            this.result = new ResourceDownloaderCancelledException(this);
            this.cancelled = true;
            this.informFailed((ResourceDownloaderException)this.result);
            this.done_sem.release();
            if (this.current_downloader != null) {
                this.current_downloader.cancel();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public boolean completed(ResourceDownloader resourceDownloader, InputStream inputStream) {
        if (this.informComplete(inputStream)) {
            this.result = inputStream;
            this.done_sem.release();
            return true;
        }
        return false;
    }

    @Override
    public void failed(ResourceDownloader resourceDownloader, ResourceDownloaderException resourceDownloaderException) {
        this.result = resourceDownloaderException;
        this.asyncDownload();
    }
}

