/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.remote;

import java.io.Serializable;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;
import org.gudy.azureus2.pluginsimpl.remote.RPPluginInterface;

public class RPRequest
implements Serializable {
    public RPObject object;
    public String method;
    public Object[] params;
    protected transient PluginInterface plugin_interface;
    protected transient LoggerChannel channel;
    public long connection_id;
    public long request_id;
    protected transient String client_ip;

    public RPRequest() {
    }

    public RPRequest(RPObject rPObject, String string, Object[] objectArray) {
        this.object = rPObject;
        this.method = string;
        this.params = objectArray;
        if (this.object != null) {
            RPPluginInterface rPPluginInterface = this.object.getDispatcher().getPlugin();
            this.connection_id = rPPluginInterface._getConectionId();
            this.request_id = rPPluginInterface._getNextRequestId();
            this.plugin_interface = (PluginInterface)rPPluginInterface._getDelegate();
        }
    }

    public void setClientIP(String string) {
        this.client_ip = string;
    }

    public String getClientIP() {
        return this.client_ip;
    }

    public long getConnectionId() {
        return this.connection_id;
    }

    public long getRequestId() {
        return this.request_id;
    }

    public String getString() {
        return "object=" + this.object + ", method=" + this.method + ", params=" + this.params;
    }

    public RPObject getObject() {
        return this.object;
    }

    public String getMethod() {
        return this.method;
    }

    public Object[] getParams() {
        return this.params;
    }

    public PluginInterface getPluginInterface() {
        return this.plugin_interface;
    }

    public void setPluginInterface(PluginInterface pluginInterface) {
        this.plugin_interface = pluginInterface;
    }

    public LoggerChannel getRPLoggerChannel() {
        return this.channel;
    }

    public void setRPLoggerChannel(LoggerChannel loggerChannel) {
        this.channel = loggerChannel;
    }

    public RPPluginInterface createRemotePluginInterface(PluginInterface pluginInterface) {
        return RPPluginInterface.create(pluginInterface);
    }
}

