/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.remote.torrent;

import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentDownloader;
import org.gudy.azureus2.plugins.torrent.TorrentException;
import org.gudy.azureus2.pluginsimpl.remote.RPException;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;
import org.gudy.azureus2.pluginsimpl.remote.RPReply;
import org.gudy.azureus2.pluginsimpl.remote.RPRequest;
import org.gudy.azureus2.pluginsimpl.remote.torrent.RPTorrent;

public class RPTorrentDownloader
extends RPObject
implements TorrentDownloader {
    protected transient TorrentDownloader delegate;

    public static RPTorrentDownloader create(TorrentDownloader torrentDownloader) {
        RPTorrentDownloader rPTorrentDownloader = (RPTorrentDownloader)RPTorrentDownloader._lookupLocal(torrentDownloader);
        if (rPTorrentDownloader == null) {
            rPTorrentDownloader = new RPTorrentDownloader(torrentDownloader);
        }
        return rPTorrentDownloader;
    }

    protected RPTorrentDownloader(TorrentDownloader torrentDownloader) {
        super(torrentDownloader);
    }

    @Override
    protected void _setDelegate(Object object) {
        this.delegate = (TorrentDownloader)object;
    }

    @Override
    public Object _setLocal() throws RPException {
        return this._fixupLocal();
    }

    @Override
    public RPReply _process(RPRequest rPRequest) {
        String string = rPRequest.getMethod();
        if (string.equals("download")) {
            try {
                Torrent torrent = this.delegate.download();
                RPTorrent rPTorrent = RPTorrent.create(torrent);
                return new RPReply(rPTorrent);
            }
            catch (TorrentException torrentException) {
                return new RPReply(torrentException);
            }
        }
        if (string.equals("download[String]")) {
            try {
                Torrent torrent = this.delegate.download((String)rPRequest.getParams()[0]);
                RPTorrent rPTorrent = RPTorrent.create(torrent);
                return new RPReply(rPTorrent);
            }
            catch (TorrentException torrentException) {
                return new RPReply(torrentException);
            }
        }
        throw new RPException("Unknown method: " + string);
    }

    @Override
    public Torrent download() throws TorrentException {
        try {
            RPTorrent rPTorrent = (RPTorrent)this._dispatcher.dispatch(new RPRequest(this, "download", null)).getResponse();
            rPTorrent._setRemote(this._dispatcher);
            return rPTorrent;
        }
        catch (RPException rPException) {
            if (rPException.getCause() instanceof TorrentException) {
                throw (TorrentException)rPException.getCause();
            }
            throw rPException;
        }
    }

    @Override
    public Torrent download(String string) throws TorrentException {
        try {
            RPTorrent rPTorrent = (RPTorrent)this._dispatcher.dispatch(new RPRequest(this, "download[String]", new Object[]{string})).getResponse();
            rPTorrent._setRemote(this._dispatcher);
            return rPTorrent;
        }
        catch (RPException rPException) {
            if (rPException.getCause() instanceof TorrentException) {
                throw (TorrentException)rPException.getCause();
            }
            throw rPException;
        }
    }
}

