/*
 * Decompiled with CFR 0.152.
 */
package org.pf.file;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.pf.text.StringPattern;

public class ExtendedFileFilter
implements FilenameFilter {
    protected static final int DIR_CHECK_NAME = 1;
    protected static final int DIR_INCLUDE = 2;
    protected static final int DIR_EXCLUDE = 3;
    private List stringPatterns = new Vector();
    private int dirHandling = 1;

    protected List getStringPatterns() {
        return this.stringPatterns;
    }

    protected void setStringPatterns(List list) {
        this.stringPatterns = list;
    }

    protected int getDirHandling() {
        return this.dirHandling;
    }

    protected void setDirHandling(int n) {
        this.dirHandling = n;
    }

    public void addPattern(String string) {
        StringPattern stringPattern = null;
        stringPattern = new StringPattern(string, false);
        this.getStringPatterns().add(stringPattern);
    }

    public void addPattern(String string, char c) {
        StringPattern stringPattern = null;
        stringPattern = new StringPattern(string, false, c);
        this.getStringPatterns().add(stringPattern);
    }

    public void addPattern(String string, boolean bl) {
        StringPattern stringPattern = null;
        stringPattern = new StringPattern(string, bl);
        this.getStringPatterns().add(stringPattern);
    }

    public void addPattern(String string, boolean bl, char c) {
        StringPattern stringPattern = null;
        stringPattern = new StringPattern(string, bl, c);
        this.getStringPatterns().add(stringPattern);
    }

    public void checkNameOfDirectories() {
        this.setDirHandling(1);
    }

    public void alwaysIncludeDirectories() {
        this.setDirHandling(2);
    }

    public void alwaysExcludeDirectories() {
        this.setDirHandling(3);
    }

    @Override
    public boolean accept(File file, String string) {
        File file2 = null;
        file2 = new File(file, string);
        if (file2.isDirectory()) {
            if (this.mustIncludeDirectories()) {
                return true;
            }
            if (this.mustExcludeDirectories()) {
                return false;
            }
        }
        return this.checkAgainstPatterns(string);
    }

    protected boolean checkAgainstPatterns(String string) {
        Iterator iterator = null;
        StringPattern stringPattern2 = null;
        for (StringPattern stringPattern2 : this.getStringPatterns()) {
            if (!stringPattern2.matches(string)) continue;
            return true;
        }
        return false;
    }

    public boolean mustIncludeDirectories() {
        return this.getDirHandling() == 2;
    }

    public boolean mustExcludeDirectories() {
        return this.getDirHandling() == 3;
    }
}

