/*
 * Decompiled with CFR 0.152.
 */
package org.pf.text;

import java.io.Serializable;
import org.pf.text.StringExaminer;
import org.pf.text.StringUtil;

public class StringPattern
implements Serializable {
    protected static final String MULTI_WILDCARD = "*";
    protected static final char MULTICHAR_WILDCARD = '*';
    protected static final char SINGLECHAR_WILDCARD = '?';
    private boolean ignoreCase = false;
    private String pattern = null;
    private Character digitWildcard = null;

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    protected Character digitWildcard() {
        return this.digitWildcard;
    }

    protected void digitWildcard(Character c) {
        this.digitWildcard = c;
    }

    public static boolean match(String string, String string2) {
        StringPattern stringPattern = new StringPattern(string2, false);
        return stringPattern.matches(string);
    }

    public static boolean matchIgnoreCase(String string, String string2) {
        StringPattern stringPattern = new StringPattern(string2, true);
        return stringPattern.matches(string);
    }

    public StringPattern(String string, boolean bl) {
        this.setPattern(string);
        this.setIgnoreCase(bl);
    }

    public StringPattern(String string) {
        this(string, false);
    }

    public StringPattern(String string, char c) {
        this(string, false, c);
    }

    public StringPattern(String string, boolean bl, char c) {
        this.setPattern(string);
        this.setIgnoreCase(bl);
        this.setDigitWildcardChar(c);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(String string) {
        StringExaminer stringExaminer = null;
        StringExaminer stringExaminer2 = null;
        char c = '-';
        char c2 = '-';
        String string2 = null;
        String string3 = null;
        int n = 0;
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        stringExaminer = this.newExaminer(this.getPattern());
        stringExaminer2 = this.newExaminer(string);
        c2 = stringExaminer2.nextChar();
        c = this.getPatternChar(stringExaminer, c2);
        while (this.endNotReached(c) && this.endNotReached(c2)) {
            if (c == '*') {
                c = this.skipWildcards(stringExaminer);
                if (this.endReached(c)) {
                    return true;
                }
                stringExaminer.skip(-1);
                string2 = this.upToEnd(stringExaminer);
                n = string2.indexOf(42);
                if (n >= 0) {
                    string3 = string2.substring(0, n);
                    if (!this.skipAfter(stringExaminer2, string3)) return false;
                    stringExaminer = this.newExaminer(string2.substring(n));
                    c = c2;
                } else {
                    stringExaminer2.skip(-1);
                    return this.matchReverse(string2, stringExaminer2);
                }
            }
            if (this.charsAreEqual(c2, c)) {
                if (!this.endNotReached(c)) continue;
                c2 = stringExaminer2.nextChar();
                c = this.getPatternChar(stringExaminer, c2);
                continue;
            }
            if (c == 42) continue;
            return false;
        }
        if (!this.endReached(c)) return false;
        if (!this.endReached(c2)) return false;
        return true;
    }

    public String toString() {
        if (this.getPattern() == null) {
            return super.toString();
        }
        return this.getPattern();
    }

    public boolean hasWildcard() {
        if (this.getPattern() == null) {
            return false;
        }
        if (this.hasDigitWildcard() && this.getPattern().indexOf(this.digitWildcardChar()) >= 0) {
            return true;
        }
        return this.getPattern().indexOf(MULTI_WILDCARD) >= 0 || this.getPattern().indexOf(63) >= 0;
    }

    public void setDigitWildcardChar(char c) {
        if (c <= '\u0000') {
            this.digitWildcard(null);
        } else {
            this.digitWildcard(new Character(c));
        }
    }

    protected boolean hasDigitWildcard() {
        return this.digitWildcard() != null;
    }

    protected char digitWildcardChar() {
        if (this.hasDigitWildcard()) {
            return this.digitWildcard().charValue();
        }
        return '\u0000';
    }

    protected char skipWildcards(StringExaminer stringExaminer) {
        char c = '-';
        while ((c = (char)stringExaminer.nextChar()) == '*' || c == '?') {
        }
        return c;
    }

    protected boolean skipAfter(StringExaminer stringExaminer, String string) {
        char c = '-';
        char c2 = ' ';
        boolean bl = false;
        int n = 0;
        if (string == null || string.length() == 0) {
            return false;
        }
        c = stringExaminer.nextChar();
        while (stringExaminer.endNotReached(c) && !bl) {
            c2 = string.charAt(n);
            if (this.charsAreEqual(c, c2)) {
                if (++n >= string.length()) {
                    bl = true;
                    continue;
                }
                c = stringExaminer.nextChar();
                continue;
            }
            if (n == 0) {
                c = stringExaminer.nextChar();
                continue;
            }
            n = 0;
        }
        return bl;
    }

    protected String upToEnd(StringExaminer stringExaminer) {
        return stringExaminer.upToEnd();
    }

    protected boolean matchReverse(String string, StringExaminer stringExaminer) {
        String string2 = MULTI_WILDCARD + string;
        String string3 = this.upToEnd(stringExaminer);
        string2 = this.strUtil().reverse(string2);
        string3 = this.strUtil().reverse(string3);
        StringPattern stringPattern = new StringPattern(string2, this.getIgnoreCase());
        if (this.hasDigitWildcard()) {
            stringPattern.setDigitWildcardChar(this.digitWildcardChar());
        }
        return stringPattern.matches(string3);
    }

    protected boolean charsAreEqual(char c, char c2) {
        if (this.hasDigitWildcard() && c2 == this.digitWildcardChar()) {
            return Character.isDigit(c);
        }
        if (this.getIgnoreCase()) {
            return Character.toUpperCase(c) == Character.toUpperCase(c2);
        }
        return c == c2;
    }

    protected boolean endReached(char c) {
        return c == '\uffff';
    }

    protected boolean endNotReached(char c) {
        return !this.endReached(c);
    }

    protected char getPatternChar(StringExaminer stringExaminer, char c) {
        char c2 = stringExaminer.nextChar();
        return c2 == '?' ? c : c2;
    }

    protected StringExaminer newExaminer(String string) {
        return new StringExaminer(string, this.getIgnoreCase());
    }

    protected StringUtil strUtil() {
        return StringUtil.current();
    }
}

