/**
 ** colortbl.c ---- Define some useful color tables
 **
 ** Copyright (C) 2019, 2022 Mariano Alvarez Fernandez
 ** [e-mail: malfer at telefonica.net]
 **
 ** This file is part of the GRX graphics library.
 **
 ** The GRX graphics library is free software; you can redistribute it
 ** and/or modify it under some conditions; see the "copying.grx" file
 ** for details.
 **
 ** This library is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 **
 ** 220108 Added the ANSI color table
 **
 **/

#include "libgrx.h"
#include "mgrxcolr.h"

GrColorTableDef GrEgaColorTable[NUM_EGA_COLORS] = {
    {"BLACK", EGAR_BLACK, 0},
    {"BLUE", EGAR_BLUE, 0},
    {"GREEN", EGAR_GREEN, 0},
    {"CYAN", EGAR_CYAN, 0},
    {"RED", EGAR_RED, 0},
    {"MAGENTA", EGAR_MAGENTA, 0},
    {"BROWN", EGAR_BROWN, 0},
    {"LIGHTGRAY", EGAR_LIGHTGRAY, 0},
    {"DARKGRAY", EGAR_DARKGRAY, 0},
    {"LIGHTBLUE", EGAR_LIGHTBLUE, 0},
    {"LIGHTGREEN", EGAR_LIGHTGREEN, 0},
    {"LIGHTCYAN", EGAR_LIGHTCYAN, 0},
    {"LIGHTRED", EGAR_LIGHTRED, 0},
    {"LIGHTMAGENTA", EGAR_LIGHTMAGENTA, 0},
    {"YELLOW", EGAR_YELLOW, 0},
    {"WHITE", EGAR_WHITE, 0}};

GrColorTableDef GrWebColorTable[NUM_WEB_COLORS] = {
    {"ALICEBLUE", WEBR_ALICEBLUE, 0},
    {"ANTIQUEWHITE", WEBR_ANTIQUEWHITE, 0},
    {"AQUAMARINE", WEBR_AQUAMARINE, 0},
    {"AZURE", WEBR_AZURE, 0},
    {"BEIGE", WEBR_BEIGE, 0},
    {"BISQUE", WEBR_BISQUE, 0},
    {"BLACK", WEBR_BLACK, 0},
    {"BLANCHEDALMOND", WEBR_BLANCHEDALMOND, 0},
    {"BLUE", WEBR_BLUE, 0},
    {"BLUEVIOLET", WEBR_BLUEVIOLET, 0},
    {"BROWN", WEBR_BROWN, 0},
    {"BURLYWOOD", WEBR_BURLYWOOD, 0},
    {"CADETBLUE", WEBR_CADETBLUE, 0},
    {"CHARTREUSE", WEBR_CHARTREUSE, 0},
    {"CHOCOLATE", WEBR_CHOCOLATE, 0},
    {"CORAL", WEBR_CORAL, 0},
    {"CORNFLOWERBLUE", WEBR_CORNFLOWERBLUE, 0},
    {"CORNSILK", WEBR_CORNSILK, 0},
    {"CRIMSON", WEBR_CRIMSON, 0},
    {"CYAN", WEBR_CYAN, 0},
    {"DARKBLUE", WEBR_DARKBLUE, 0},
    {"DARKCYAN", WEBR_DARKCYAN, 0},
    {"DARKGOLDENROD", WEBR_DARKGOLDENROD, 0},
    {"DARKGRAY", WEBR_DARKGRAY, 0},
    {"DARKGREEN", WEBR_DARKGREEN, 0},
    {"DARKKHAKI", WEBR_DARKKHAKI, 0},
    {"DARKMAGENTA", WEBR_DARKMAGENTA, 0},
    {"DARKOLIVEGREEN", WEBR_DARKOLIVEGREEN, 0},
    {"DARKORANGE", WEBR_DARKORANGE, 0},
    {"DARKORCHID", WEBR_DARKORCHID, 0},
    {"DARKRED", WEBR_DARKRED, 0},
    {"DARKSALMON", WEBR_DARKSALMON, 0},
    {"DARKSEAGREEN", WEBR_DARKSEAGREEN, 0},
    {"DARKSLATEBLUE", WEBR_DARKSLATEBLUE, 0},
    {"DARKSLATEGRAY", WEBR_DARKSLATEGRAY, 0},
    {"DARKTURQUOISE", WEBR_DARKTURQUOISE, 0},
    {"DARKVIOLET", WEBR_DARKVIOLET, 0},
    {"DEEPPINK", WEBR_DEEPPINK, 0},
    {"DEEPSKYBLUE", WEBR_DEEPSKYBLUE, 0},
    {"DIMGRAY", WEBR_DIMGRAY, 0},
    {"DODGERBLUE", WEBR_DODGERBLUE, 0},
    {"FIREBRICK", WEBR_FIREBRICK, 0},
    {"FLORALWHITE", WEBR_FLORALWHITE, 0},
    {"FORESTGREEN", WEBR_FORESTGREEN, 0},
    {"GAINSBORO", WEBR_GAINSBORO, 0},
    {"GHOSTWHITE", WEBR_GHOSTWHITE, 0},
    {"GOLD", WEBR_GOLD, 0},
    {"GOLDENROD", WEBR_GOLDENROD, 0},
    {"GRAY", WEBR_GRAY, 0},
    {"GREEN", WEBR_GREEN, 0},
    {"GREENYELLOW", WEBR_GREENYELLOW, 0},
    {"HONEYDEW", WEBR_HONEYDEW, 0},
    {"HOTPINK", WEBR_HOTPINK, 0},
    {"INDIANRED", WEBR_INDIANRED, 0},
    {"INDIGO", WEBR_INDIGO, 0},
    {"IVORY", WEBR_IVORY, 0},
    {"KHAKI", WEBR_KHAKI, 0},
    {"LAVENDER", WEBR_LAVENDER, 0},
    {"LAVENDERBLUSH", WEBR_LAVENDERBLUSH, 0},
    {"LAWNGREEN", WEBR_LAWNGREEN, 0},
    {"LEMONCHIFFON", WEBR_LEMONCHIFFON, 0},
    {"LIGHTBLUE", WEBR_LIGHTBLUE, 0},
    {"LIGHTCORAL", WEBR_LIGHTCORAL, 0},
    {"LIGHTCYAN", WEBR_LIGHTCYAN, 0},
    {"LIGHTGOLDENRODYELLOW", WEBR_LIGHTGOLDENRODYELLOW, 0},
    {"LIGHTGRAY", WEBR_LIGHTGRAY, 0},
    {"LIGHTGREEN", WEBR_LIGHTGREEN, 0},
    {"LIGHTPINK", WEBR_LIGHTPINK, 0},
    {"LIGHTSALMON", WEBR_LIGHTSALMON, 0},
    {"LIGHTSEAGREEN", WEBR_LIGHTSEAGREEN, 0},
    {"LIGHTSKYBLUE", WEBR_LIGHTSKYBLUE, 0},
    {"LIGHTSLATEGRAY", WEBR_LIGHTSLATEGRAY, 0},
    {"LIGHTSTEELBLUE", WEBR_LIGHTSTEELBLUE, 0},
    {"LIGHTYELLOW", WEBR_LIGHTYELLOW, 0},
    {"LIME", WEBR_LIME, 0},
    {"LIMEGREEN", WEBR_LIMEGREEN, 0},
    {"LINEN", WEBR_LINEN, 0},
    {"MAGENTA", WEBR_MAGENTA, 0},
    {"MAROON", WEBR_MAROON, 0},
    {"MEDIUMAQUAMARINE", WEBR_MEDIUMAQUAMARINE, 0},
    {"MEDIUMBLUE", WEBR_MEDIUMBLUE, 0},
    {"MEDIUMORCHID", WEBR_MEDIUMORCHID, 0},
    {"MEDIUMPURPLE", WEBR_MEDIUMPURPLE, 0},
    {"MEDIUMSEAGREEN", WEBR_MEDIUMSEAGREEN, 0},
    {"MEDIUMSLATEBLUE", WEBR_MEDIUMSLATEBLUE, 0},
    {"MEDIUMSPRINGGREEN", WEBR_MEDIUMSPRINGGREEN, 0},
    {"MEDIUMTURQUOISE", WEBR_MEDIUMTURQUOISE, 0},
    {"MEDIUMVIOLETRED", WEBR_MEDIUMVIOLETRED, 0},
    {"MIDNIGHTBLUE", WEBR_MIDNIGHTBLUE, 0},
    {"MINTCREAM", WEBR_MINTCREAM, 0},
    {"MISTYROSE", WEBR_MISTYROSE, 0},
    {"MOCCASIN", WEBR_MOCCASIN, 0},
    {"NAVAJOWHITE", WEBR_NAVAJOWHITE, 0},
    {"NAVY", WEBR_NAVY, 0},
    {"OLDLACE", WEBR_OLDLACE, 0},
    {"OLIVE", WEBR_OLIVE, 0},
    {"OLIVEDRAB", WEBR_OLIVEDRAB, 0},
    {"ORANGE", WEBR_ORANGE, 0},
    {"ORANGERED", WEBR_ORANGERED, 0},
    {"ORCHID", WEBR_ORCHID, 0},
    {"PALEGOLDENROD", WEBR_PALEGOLDENROD, 0},
    {"PALEGREEN", WEBR_PALEGREEN, 0},
    {"PALETURQUOISE", WEBR_PALETURQUOISE, 0},
    {"PALEVIOLETRED", WEBR_PALEVIOLETRED, 0},
    {"PAPAYAWHIP", WEBR_PAPAYAWHIP, 0},
    {"PEACHPUFF", WEBR_PEACHPUFF, 0},
    {"PERU", WEBR_PERU, 0},
    {"PINK", WEBR_PINK, 0},
    {"PLUM", WEBR_PLUM, 0},
    {"POWDERBLUE", WEBR_POWDERBLUE, 0},
    {"PURPLE", WEBR_PURPLE, 0},
    {"RED", WEBR_RED, 0},
    {"ROSYBROWN", WEBR_ROSYBROWN, 0},
    {"ROYALBLUE", WEBR_ROYALBLUE, 0},
    {"SADDLEBROWN", WEBR_SADDLEBROWN, 0},
    {"SALMON", WEBR_SALMON, 0},
    {"SANDYBROWN", WEBR_SANDYBROWN, 0},
    {"SEAGREEN", WEBR_SEAGREEN, 0},
    {"SEASHELL", WEBR_SEASHELL, 0},
    {"SIENNA", WEBR_SIENNA, 0},
    {"SILVER", WEBR_SILVER, 0},
    {"SKYBLUE", WEBR_SKYBLUE, 0},
    {"SLATEBLUE", WEBR_SLATEBLUE, 0},
    {"SLATEGRAY", WEBR_SLATEGRAY, 0},
    {"SNOW", WEBR_SNOW, 0},
    {"SPRINGGREEN", WEBR_SPRINGGREEN, 0},
    {"STEELBLUE", WEBR_STEELBLUE, 0},
    {"TAN", WEBR_TAN, 0},
    {"TEAL", WEBR_TEAL, 0},
    {"THISTLE", WEBR_THISTLE, 0},
    {"TOMATO", WEBR_TOMATO, 0},
    {"TURQUOISE", WEBR_TURQUOISE, 0},
    {"VIOLET", WEBR_VIOLET, 0},
    {"WHEAT", WEBR_WHEAT, 0},
    {"WHITE", WEBR_WHITE, 0},
    {"WHITESMOKE", WEBR_WHITESMOKE, 0},
    {"YELLOW", WEBR_YELLOW, 0},
    {"YELLOWGREEN", WEBR_YELLOWGREEN, 0}};

GrColorTableDef GrAnsColorTable[NUM_ANS_COLORS] = {
    {"BLACK", ANSR_BLACK, 0},
    {"MAROON", ANSR_MAROON, 0},
    {"GREEN", ANSR_GREEN, 0},
    {"OLIVE", ANSR_OLIVE, 0},
    {"NAVY", ANSR_NAVY, 0},
    {"PURPLE", ANSR_PURPLE, 0},
    {"TEAL", ANSR_TEAL, 0},
    {"SILVER", ANSR_SILVER, 0},
    {"GREY", ANSR_GREY, 0},
    {"RED", ANSR_RED, 0},
    {"LIME", ANSR_LIME, 0},
    {"YELLOW", ANSR_YELLOW, 0},
    {"BLUE", ANSR_BLUE, 0},
    {"FUCHSIA", ANSR_FUCHSIA, 0},
    {"AQUA", ANSR_AQUA, 0},
    {"WHITE", ANSR_WHITE, 0},
    {"GREY0", ANSR_GREY0, 0},
    {"NAVYBLUE", ANSR_NAVYBLUE, 0},
    {"DARKBLUE", ANSR_DARKBLUE, 0},
    {"BLUE2", ANSR_BLUE2, 0},
    {"BLUE3", ANSR_BLUE3, 0},
    {"BLUE4", ANSR_BLUE4, 0},
    {"DARKGREEN", ANSR_DARKGREEN, 0},
    {"DEEPSKYBLUE", ANSR_DEEPSKYBLUE, 0},
    {"DEEPSKYBLUE2", ANSR_DEEPSKYBLUE2, 0},
    {"DEEPSKYBLUE3", ANSR_DEEPSKYBLUE3, 0},
    {"DODGERBLUE", ANSR_DODGERBLUE, 0},
    {"DODGERBLUE2", ANSR_DODGERBLUE2, 0},
    {"GREEN2", ANSR_GREEN2, 0},
    {"SPRINGGREEN", ANSR_SPRINGGREEN, 0},
    {"TURQUOISE", ANSR_TURQUOISE, 0},
    {"DEEPSKYBLUE4", ANSR_DEEPSKYBLUE4, 0},
    {"DEEPSKYBLUE5", ANSR_DEEPSKYBLUE5, 0},
    {"DODGERBLUE3", ANSR_DODGERBLUE3, 0},
    {"GREEN3", ANSR_GREEN3, 0},
    {"SPRINGGREEN2", ANSR_SPRINGGREEN2, 0},
    {"DARKCYAN", ANSR_DARKCYAN, 0},
    {"LIGHTSEAGREEN", ANSR_LIGHTSEAGREEN, 0},
    {"DEEPSKYBLUE6", ANSR_DEEPSKYBLUE6, 0},
    {"DEEPSKYBLUE7", ANSR_DEEPSKYBLUE7, 0},
    {"GREEN4", ANSR_GREEN4, 0},
    {"SPRINGGREEN3", ANSR_SPRINGGREEN3, 0},
    {"SPRINGGREEN4", ANSR_SPRINGGREEN4, 0},
    {"CYAN", ANSR_CYAN, 0},
    {"DARKTURQUOISE", ANSR_DARKTURQUOISE, 0},
    {"TURQUOISE2", ANSR_TURQUOISE2, 0},
    {"GREEN5", ANSR_GREEN5, 0},
    {"SPRINGGREEN5", ANSR_SPRINGGREEN5, 0},
    {"SPRINGGREEN6", ANSR_SPRINGGREEN6, 0},
    {"MEDIUMSPRINGGREEN", ANSR_MEDIUMSPRINGGREEN, 0},
    {"CYAN2", ANSR_CYAN2, 0},
    {"CYAN3", ANSR_CYAN3, 0},
    {"DARKRED", ANSR_DARKRED, 0},
    {"DEEPPINK", ANSR_DEEPPINK, 0},
    {"PURPLE2", ANSR_PURPLE2, 0},
    {"PURPLE3", ANSR_PURPLE3, 0},
    {"PURPLE4", ANSR_PURPLE4, 0},
    {"BLUEVIOLET", ANSR_BLUEVIOLET, 0},
    {"ORANGE", ANSR_ORANGE, 0},
    {"GREY37", ANSR_GREY37, 0},
    {"MEDIUMPURPLE", ANSR_MEDIUMPURPLE, 0},
    {"SLATEBLUE", ANSR_SLATEBLUE, 0},
    {"SLATEBLUE2", ANSR_SLATEBLUE2, 0},
    {"ROYALBLUE", ANSR_ROYALBLUE, 0},
    {"CHARTREUSE", ANSR_CHARTREUSE, 0},
    {"DARKSEAGREEN", ANSR_DARKSEAGREEN, 0},
    {"PALETURQUOISE", ANSR_PALETURQUOISE, 0},
    {"STEELBLUE", ANSR_STEELBLUE, 0},
    {"STEELBLUE2", ANSR_STEELBLUE2, 0},
    {"CORNFLOWERBLUE", ANSR_CORNFLOWERBLUE, 0},
    {"CHARTREUSE2", ANSR_CHARTREUSE2, 0},
    {"DARKSEAGREEN2", ANSR_DARKSEAGREEN2, 0},
    {"CADETBLUE", ANSR_CADETBLUE, 0},
    {"CADETBLUE2", ANSR_CADETBLUE2, 0},
    {"SKYBLUE", ANSR_SKYBLUE, 0},
    {"STEELBLUE3", ANSR_STEELBLUE3, 0},
    {"CHARTREUSE3", ANSR_CHARTREUSE3, 0},
    {"PALEGREEN", ANSR_PALEGREEN, 0},
    {"SEAGREEN", ANSR_SEAGREEN, 0},
    {"AQUAMARINE", ANSR_AQUAMARINE, 0},
    {"MEDIUMTURQUOISE", ANSR_MEDIUMTURQUOISE, 0},
    {"STEELBLUE4", ANSR_STEELBLUE4, 0},
    {"CHARTREUSE4", ANSR_CHARTREUSE4, 0},
    {"SEAGREEN2", ANSR_SEAGREEN2, 0},
    {"SEAGREEN3", ANSR_SEAGREEN3, 0},
    {"SEAGREEN4", ANSR_SEAGREEN4, 0},
    {"AQUAMARINE2", ANSR_AQUAMARINE2, 0},
    {"DARKSLATEGRAY", ANSR_DARKSLATEGRAY, 0},
    {"DARKRED2", ANSR_DARKRED2, 0},
    {"DEEPPINK2", ANSR_DEEPPINK2, 0},
    {"DARKMAGENTA", ANSR_DARKMAGENTA, 0},
    {"DARKMAGENTA2", ANSR_DARKMAGENTA2, 0},
    {"DARKVIOLET", ANSR_DARKVIOLET, 0},
    {"PURPLE5", ANSR_PURPLE5, 0},
    {"ORANGE2", ANSR_ORANGE2, 0},
    {"LIGHTPINK", ANSR_LIGHTPINK, 0},
    {"PLUM", ANSR_PLUM, 0},
    {"MEDIUMPURPLE2", ANSR_MEDIUMPURPLE2, 0},
    {"MEDIUMPURPLE3", ANSR_MEDIUMPURPLE3, 0},
    {"SLATEBLUE3", ANSR_SLATEBLUE3, 0},
    {"YELLOW2", ANSR_YELLOW2, 0},
    {"WHEAT", ANSR_WHEAT, 0},
    {"GREY53", ANSR_GREY53, 0},
    {"LIGHTSLATEGREY", ANSR_LIGHTSLATEGREY, 0},
    {"MEDIUMPURPLE4", ANSR_MEDIUMPURPLE4, 0},
    {"LIGHTSLATEBLUE", ANSR_LIGHTSLATEBLUE, 0},
    {"YELLOW3", ANSR_YELLOW3, 0},
    {"DARKOLIVEGREEN", ANSR_DARKOLIVEGREEN, 0},
    {"DARKSEAGREEN3", ANSR_DARKSEAGREEN3, 0},
    {"LIGHTSKYBLUE", ANSR_LIGHTSKYBLUE, 0},
    {"LIGHTSKYBLUE2", ANSR_LIGHTSKYBLUE2, 0},
    {"SKYBLUE2", ANSR_SKYBLUE2, 0},
    {"CHARTREUSE5", ANSR_CHARTREUSE5, 0},
    {"DARKOLIVEGREEN2", ANSR_DARKOLIVEGREEN2, 0},
    {"PALEGREEN2", ANSR_PALEGREEN2, 0},
    {"DARKSEAGREEN4", ANSR_DARKSEAGREEN4, 0},
    {"DARKSLATEGRAY2", ANSR_DARKSLATEGRAY2, 0},
    {"SKYBLUE3", ANSR_SKYBLUE3, 0},
    {"CHARTREUSE6", ANSR_CHARTREUSE6, 0},
    {"LIGHTGREEN", ANSR_LIGHTGREEN, 0},
    {"LIGHTGREEN2", ANSR_LIGHTGREEN2, 0},
    {"PALEGREEN3", ANSR_PALEGREEN3, 0},
    {"AQUAMARINE3", ANSR_AQUAMARINE3, 0},
    {"DARKSLATEGRAY3", ANSR_DARKSLATEGRAY3, 0},
    {"RED2", ANSR_RED2, 0},
    {"DEEPPINK3", ANSR_DEEPPINK3, 0},
    {"MEDIUMVIOLETRED", ANSR_MEDIUMVIOLETRED, 0},
    {"MAGENTA", ANSR_MAGENTA, 0},
    {"DARKVIOLET2", ANSR_DARKVIOLET2, 0},
    {"PURPLE6", ANSR_PURPLE6, 0},
    {"DARKORANGE", ANSR_DARKORANGE, 0},
    {"INDIANRED", ANSR_INDIANRED, 0},
    {"HOTPINK", ANSR_HOTPINK, 0},
    {"MEDIUMORCHID", ANSR_MEDIUMORCHID, 0},
    {"MEDIUMORCHID2", ANSR_MEDIUMORCHID2, 0},
    {"MEDIUMPURPLE5", ANSR_MEDIUMPURPLE5, 0},
    {"DARKGOLDENROD", ANSR_DARKGOLDENROD, 0},
    {"LIGHTSALMON", ANSR_LIGHTSALMON, 0},
    {"ROSYBROWN", ANSR_ROSYBROWN, 0},
    {"GREY63", ANSR_GREY63, 0},
    {"MEDIUMPURPLE6", ANSR_MEDIUMPURPLE6, 0},
    {"MEDIUMPURPLE7", ANSR_MEDIUMPURPLE7, 0},
    {"GOLD", ANSR_GOLD, 0},
    {"DARKKHAKI", ANSR_DARKKHAKI, 0},
    {"NAVAJOWHITE", ANSR_NAVAJOWHITE, 0},
    {"GREY69", ANSR_GREY69, 0},
    {"LIGHTSTEELBLUE", ANSR_LIGHTSTEELBLUE, 0},
    {"LIGHTSTEELBLUE2", ANSR_LIGHTSTEELBLUE2, 0},
    {"YELLOW4", ANSR_YELLOW4, 0},
    {"DARKOLIVEGREEN3", ANSR_DARKOLIVEGREEN3, 0},
    {"DARKSEAGREEN5", ANSR_DARKSEAGREEN5, 0},
    {"DARKSEAGREEN6", ANSR_DARKSEAGREEN6, 0},
    {"LIGHTCYAN", ANSR_LIGHTCYAN, 0},
    {"LIGHTSKYBLUE3", ANSR_LIGHTSKYBLUE3, 0},
    {"GREENYELLOW", ANSR_GREENYELLOW, 0},
    {"DARKOLIVEGREEN4", ANSR_DARKOLIVEGREEN4, 0},
    {"PALEGREEN4", ANSR_PALEGREEN4, 0},
    {"DARKSEAGREEN7", ANSR_DARKSEAGREEN7, 0},
    {"DARKSEAGREEN8", ANSR_DARKSEAGREEN8, 0},
    {"PALETURQUOISE2", ANSR_PALETURQUOISE2, 0},
    {"RED3", ANSR_RED3, 0},
    {"DEEPPINK4", ANSR_DEEPPINK4, 0},
    {"DEEPPINK5", ANSR_DEEPPINK5, 0},
    {"MAGENTA2", ANSR_MAGENTA2, 0},
    {"MAGENTA3", ANSR_MAGENTA3, 0},
    {"MAGENTA4", ANSR_MAGENTA4, 0},
    {"DARKORANGE2", ANSR_DARKORANGE2, 0},
    {"INDIANRED2", ANSR_INDIANRED2, 0},
    {"HOTPINK2", ANSR_HOTPINK2, 0},
    {"HOTPINK3", ANSR_HOTPINK3, 0},
    {"ORCHID", ANSR_ORCHID, 0},
    {"MEDIUMORCHID3", ANSR_MEDIUMORCHID3, 0},
    {"ORANGE3", ANSR_ORANGE3, 0},
    {"LIGHTSALMON2", ANSR_LIGHTSALMON2, 0},
    {"LIGHTPINK2", ANSR_LIGHTPINK2, 0},
    {"PINK", ANSR_PINK, 0},
    {"PLUM2", ANSR_PLUM2, 0},
    {"VIOLET", ANSR_VIOLET, 0},
    {"GOLD2", ANSR_GOLD2, 0},
    {"LIGHTGOLDENROD", ANSR_LIGHTGOLDENROD, 0},
    {"TAN", ANSR_TAN, 0},
    {"MISTYROSE", ANSR_MISTYROSE, 0},
    {"THISTLE", ANSR_THISTLE, 0},
    {"PLUM3", ANSR_PLUM3, 0},
    {"YELLOW5", ANSR_YELLOW5, 0},
    {"KHAKI", ANSR_KHAKI, 0},
    {"LIGHTGOLDENROD2", ANSR_LIGHTGOLDENROD2, 0},
    {"LIGHTYELLOW", ANSR_LIGHTYELLOW, 0},
    {"GREY84", ANSR_GREY84, 0},
    {"LIGHTSTEELBLUE3", ANSR_LIGHTSTEELBLUE3, 0},
    {"YELLOW6", ANSR_YELLOW6, 0},
    {"DARKOLIVEGREEN5", ANSR_DARKOLIVEGREEN5, 0},
    {"DARKOLIVEGREEN6", ANSR_DARKOLIVEGREEN6, 0},
    {"DARKSEAGREEN9", ANSR_DARKSEAGREEN9, 0},
    {"HONEYDEW", ANSR_HONEYDEW, 0},
    {"LIGHTCYAN2", ANSR_LIGHTCYAN2, 0},
    {"RED4", ANSR_RED4, 0},
    {"DEEPPINK6", ANSR_DEEPPINK6, 0},
    {"DEEPPINK7", ANSR_DEEPPINK7, 0},
    {"DEEPPINK8", ANSR_DEEPPINK8, 0},
    {"MAGENTA5", ANSR_MAGENTA5, 0},
    {"MAGENTA6", ANSR_MAGENTA6, 0},
    {"ORANGERED", ANSR_ORANGERED, 0},
    {"INDIANRED3", ANSR_INDIANRED3, 0},
    {"INDIANRED4", ANSR_INDIANRED4, 0},
    {"HOTPINK4", ANSR_HOTPINK4, 0},
    {"HOTPINK5", ANSR_HOTPINK5, 0},
    {"MEDIUMORCHID4", ANSR_MEDIUMORCHID4, 0},
    {"DARKORANGE3", ANSR_DARKORANGE3, 0},
    {"SALMON", ANSR_SALMON, 0},
    {"LIGHTCORAL", ANSR_LIGHTCORAL, 0},
    {"PALEVIOLETRED", ANSR_PALEVIOLETRED, 0},
    {"ORCHID2", ANSR_ORCHID2, 0},
    {"ORCHID3", ANSR_ORCHID3, 0},
    {"ORANGE4", ANSR_ORANGE4, 0},
    {"SANDYBROWN", ANSR_SANDYBROWN, 0},
    {"LIGHTSALMON3", ANSR_LIGHTSALMON3, 0},
    {"LIGHTPINK3", ANSR_LIGHTPINK3, 0},
    {"PINK2", ANSR_PINK2, 0},
    {"PLUM4", ANSR_PLUM4, 0},
    {"GOLD3", ANSR_GOLD3, 0},
    {"LIGHTGOLDENROD3", ANSR_LIGHTGOLDENROD3, 0},
    {"LIGHTGOLDENROD4", ANSR_LIGHTGOLDENROD4, 0},
    {"NAVAJOWHITE2", ANSR_NAVAJOWHITE2, 0},
    {"MISTYROSE2", ANSR_MISTYROSE2, 0},
    {"THISTLE2", ANSR_THISTLE2, 0},
    {"YELLOW7", ANSR_YELLOW7, 0},
    {"LIGHTGOLDENROD5", ANSR_LIGHTGOLDENROD5, 0},
    {"KHAKI2", ANSR_KHAKI2, 0},
    {"WHEAT2", ANSR_WHEAT2, 0},
    {"CORNSILK", ANSR_CORNSILK, 0},
    {"GREY100", ANSR_GREY100, 0},
    {"GREY3", ANSR_GREY3, 0},
    {"GREY7", ANSR_GREY7, 0},
    {"GREY11", ANSR_GREY11, 0},
    {"GREY15", ANSR_GREY15, 0},
    {"GREY19", ANSR_GREY19, 0},
    {"GREY23", ANSR_GREY23, 0},
    {"GREY27", ANSR_GREY27, 0},
    {"GREY30", ANSR_GREY30, 0},
    {"GREY35", ANSR_GREY35, 0},
    {"GREY39", ANSR_GREY39, 0},
    {"GREY42", ANSR_GREY42, 0},
    {"GREY46", ANSR_GREY46, 0},
    {"GREY50", ANSR_GREY50, 0},
    {"GREY54", ANSR_GREY54, 0},
    {"GREY58", ANSR_GREY58, 0},
    {"GREY62", ANSR_GREY62, 0},
    {"GREY66", ANSR_GREY66, 0},
    {"GREY70", ANSR_GREY70, 0},
    {"GREY74", ANSR_GREY74, 0},
    {"GREY78", ANSR_GREY78, 0},
    {"GREY82", ANSR_GREY82, 0},
    {"GREY85", ANSR_GREY85, 0},
    {"GREY89", ANSR_GREY89, 0},
    {"GREY93", ANSR_GREY93, 0}};

int GrGenEgaColorTable(void)
{
    int i;
    
    if (GrNumColors() < 16) return -1;
    
    // set first black & white in case we run out of cells
    GrEgaColorTable[0].color = GrBlack();
    GrEgaColorTable[NUM_EGA_COLORS-1].color = GrWhite();

    for (i=1; i<NUM_EGA_COLORS-1; i++)
        GrEgaColorTable[i].color = GrAllocColor2(GrEgaColorTable[i].rgbcolor);
    
    return 0;
}

int GrGenWebColorTable(void)
{
    int i;
    
    if (GrNumColors() < 256) return -1;
    
    for (i=0; i<NUM_WEB_COLORS; i++)
        GrWebColorTable[i].color = GrAllocColor2(GrWebColorTable[i].rgbcolor);
    
    return 0;
}

int GrGenAnsColorTable(void)
{
    int i;
    
    if (GrNumColors() < 256) return -1;
    
    for (i=0; i<NUM_ANS_COLORS; i++)
        GrAnsColorTable[i].color = GrAllocColor2(GrAnsColorTable[i].rgbcolor);
    
    return 0;
}
