/**
 ** patrtest.c ---- test pattern filled and patterned functions
 **
 ** Copyright (C) 2020 Mariano Alvarez Fernandez
 ** [e-mail: malfer@telefonica.net]
 **
 ** This is a test/demo file of the GRX graphics library.
 ** You can use GRX test/demo files as you want.
 **
 ** The GRX graphics library is free software; you can redistribute it
 ** and/or modify it under some conditions; see the "copying.grx" file
 ** for details.
 **
 ** This library is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 **
 **/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "mgrx.h"

unsigned char leaves_pat[] = {
 80,54,10,35,32,67,82,69,65,84,79,82,58,32,71,73,77,80,32,80,78,77,32,70,105,
 108,116,101,114,32,86,101,114,115,105,111,110,32,49,46,49,10,53,48,32,53,48,
 10,50,53,53,10,45,89,4,54,99,8,52,97,6,48,92,6,53,90,7,49,92,6,48,93,4,55,96,
 4,64,98,22,27,44,8,25,39,1,27,46,0,35,58,2,67,82,19,103,116,41,108,126,36,94,
 122,26,82,109,30,77,104,32,72,102,22,54,91,7,37,70,4,28,57,3,26,54,2,36,64,
 6,73,106,27,58,94,17,34,70,5,35,74,0,37,75,1,57,97,13,68,110,8,54,100,3,54,
 103,10,56,106,3,62,100,19,31,49,10,16,38,3,20,40,11,9,24,1,11,37,3,17,43,6,
 24,49,11,70,100,29,52,76,15,17,33,7,30,56,3,44,83,8,46,87,10,41,91,5,51,97,
 1,64,111,10,48,93,1,47,90,5,45,85,9,47,92,4,51,95,1,61,99,4,56,79,17,24,40,
 1,32,48,0,49,68,12,69,91,27,94,112,42,108,126,50,93,117,35,72,104,14,69,104,
 17,66,104,10,66,109,4,72,116,10,71,112,19,60,96,19,45,78,10,34,67,4,68,106,
 22,67,108,16,65,106,22,40,79,2,42,80,5,67,106,21,66,109,6,60,103,13,52,99,4,
 62,105,15,29,56,12,17,35,1,15,39,1,27,50,14,19,36,7,17,44,2,24,53,2,26,55,9,
 43,75,11,69,90,28,20,37,2,24,54,2,29,73,0,55,94,11,54,91,10,48,95,0,63,110,
 8,49,95,1,49,93,7,53,95,14,48,94,2,56,100,4,65,98,12,30,47,5,39,59,16,64,89,
 25,82,105,42,87,110,32,91,114,28,82,109,24,50,85,8,50,77,17,58,90,21,56,97,
 10,57,105,4,59,109,2,63,111,4,66,110,12,68,109,20,60,100,19,63,107,12,60,107,
 4,65,113,12,61,102,18,42,80,5,61,101,19,68,110,14,59,102,4,63,109,2,62,95,23,
 21,39,2,17,37,0,16,44,0,31,58,11,22,42,8,22,48,5,36,68,5,30,66,5,34,73,5,61,
 89,23,26,50,0,23,53,4,33,76,1,63,96,16,80,105,28,50,95,4,56,102,7,49,94,2,52,
 96,11,42,87,3,50,96,6,65,104,17,59,87,18,65,88,21,81,115,37,79,118,21,77,110,
 26,90,114,20,88,114,12,69,104,8,47,89,10,50,71,15,49,77,9,56,96,9,53,99,2,50,
 101,6,54,104,3,57,105,1,59,105,6,57,104,5,60,109,4,56,108,2,57,109,3,71,114,
 15,47,86,9,47,85,11,61,101,16,66,108,11,55,94,12,27,50,14,23,37,4,18,40,2,21,
 51,1,36,66,11,24,46,8,17,41,5,39,72,6,43,83,8,36,80,4,38,79,9,38,71,4,29,57,
 10,39,73,1,69,95,17,87,105,31,48,89,0,51,93,7,45,87,2,56,96,12,61,103,12,98,
 125,39,99,121,33,91,122,25,82,121,23,80,115,26,82,113,26,79,107,16,88,114,11,
 89,120,12,60,94,4,48,83,14,48,76,8,40,71,1,52,90,9,55,99,8,44,99,1,47,99,0,
 52,101,2,60,106,6,51,100,2,49,100,1,54,105,3,54,105,0,65,112,5,57,99,19,34,
 70,11,57,97,10,69,115,8,36,58,12,14,25,7,23,44,7,23,49,4,25,61,8,39,75,10,36,
 59,18,18,40,1,25,60,0,46,87,8,51,90,7,36,82,6,37,79,6,35,73,2,35,71,1,63,90,
 21,87,109,28,41,85,0,40,80,1,42,82,5,46,89,6,51,91,8,57,87,15,43,73,10,49,88,
 14,52,87,9,64,96,15,83,112,20,83,111,8,82,110,4,83,110,27,62,89,23,50,80,9,
 55,81,2,54,83,2,50,84,4,56,92,14,54,95,13,52,97,8,47,98,1,46,99,0,49,100,2,
 54,105,4,49,100,0,50,101,0,53,103,2,67,113,9,27,58,12,63,94,14,72,109,24,15,
 33,1,9,20,6,21,40,11,34,59,4,34,73,1,44,85,5,42,68,18,15,39,3,22,55,2,36,79,
 7,49,93,12,45,89,7,41,84,5,37,78,6,36,74,6,66,91,21,80,105,22,35,82,3,31,70,
 0,44,82,13,36,82,2,50,93,2,58,99,13,49,88,11,44,86,7,67,100,24,77,108,20,81,
 109,8,82,108,1,84,112,6,58,81,13,52,73,21,50,74,7,56,81,4,63,93,5,75,110,20,
 66,102,19,53,88,10,51,92,8,49,98,3,46,101,1,43,93,0,43,93,0,51,102,3,54,105,
 6,50,104,9,61,109,6,52,81,15,59,80,12,59,82,28,12,28,2,9,22,6,15,31,8,41,61,
 15,48,87,9,51,97,4,51,82,25,26,46,17,29,53,14,32,68,9,35,83,5,51,92,10,48,90,
 10,42,85,9,40,82,10,74,101,27,79,104,21,29,79,3,28,64,0,39,75,10,30,80,4,48,
 94,2,50,93,7,54,91,11,70,102,20,75,109,16,74,105,3,78,106,1,78,103,3,84,112,
 10,65,88,14,50,70,13,46,66,7,54,82,17,64,98,9,63,107,2,61,107,5,63,103,12,56,
 98,7,51,97,3,50,98,3,42,90,4,42,91,2,44,93,3,40,90,0,34,92,2,54,98,11,87,117,
 13,90,103,39,38,53,18,14,29,4,10,24,3,21,36,11,20,35,12,53,88,19,62,108,10,
 44,77,20,23,36,13,33,45,19,35,61,15,38,82,11,43,82,5,50,91,13,47,91,10,43,88,
 7,77,106,28,80,103,18,36,78,9,37,66,9,36,66,4,36,83,3,45,94,0,50,92,10,75,110,
 32,76,109,20,69,105,4,71,99,3,76,104,6,76,111,5,86,112,13,62,81,24,39,58,11,
 36,58,10,42,80,5,53,97,1,57,106,0,58,108,1,58,106,5,53,101,1,51,98,3,49,95,
 3,44,88,2,48,95,2,47,98,3,46,100,6,39,98,3,54,101,2,83,115,6,99,122,19,52,83,
 21,24,40,9,14,29,3,17,46,1,36,63,19,20,43,7,61,91,18,54,89,19,7,21,0,14,26,
 3,22,41,6,40,70,18,40,84,7,35,83,2,53,96,16,60,95,17,76,104,17,76,103,17,56,
 85,21,34,59,8,32,66,1,35,85,0,47,90,5,66,105,25,71,106,20,71,106,8,62,95,1,
 72,101,8,75,105,3,77,112,0,77,102,12,33,52,3,27,48,1,34,59,5,49,82,4,58,97,
 1,63,106,1,63,107,3,65,109,4,65,109,4,62,106,3,63,106,7,58,104,7,49,98,4,41,
 91,0,37,86,0,53,91,2,58,108,8,61,108,9,77,106,17,90,114,22,62,101,15,49,90,
 22,48,78,29,52,87,25,21,46,12,47,74,22,71,106,28,10,27,3,14,28,4,22,43,3,31,
 65,4,32,79,5,30,81,5,36,81,6,65,103,23,76,107,13,74,104,10,73,97,28,33,58,5,
 26,60,3,38,83,5,65,101,21,71,106,22,69,104,11,68,104,3,68,98,5,69,102,6,73,
 107,3,82,114,1,72,96,18,27,48,4,25,50,0,37,65,3,54,89,4,68,107,5,65,108,1,61,
 105,2,62,107,0,59,103,0,57,101,0,56,101,0,49,100,1,43,93,0,45,94,2,51,98,5,
 55,107,11,48,95,1,76,106,22,94,105,35,79,104,21,49,100,1,49,106,4,58,99,11,
 58,101,20,56,88,31,34,61,15,72,105,28,29,49,12,17,33,6,23,47,6,33,69,3,32,77,
 2,27,74,2,30,74,1,73,109,21,73,106,9,69,102,5,76,106,24,30,59,6,28,58,8,62,
 95,21,77,109,26,71,105,17,64,99,6,62,98,3,72,102,5,69,104,3,67,104,1,76,106,
 1,54,79,13,24,45,6,27,54,2,39,70,1,52,94,1,63,109,2,61,110,1,58,107,3,58,107,
 1,57,105,0,54,103,2,57,105,5,47,100,4,45,94,3,52,97,5,64,108,9,63,100,10,92,
 112,26,101,118,38,72,104,25,51,98,5,41,90,2,44,91,6,51,97,7,52,101,13,57,98,
 10,63,94,32,68,101,27,37,63,13,18,39,4,24,48,10,33,71,7,44,85,7,47,88,15,61,
 99,18,77,108,12,67,101,8,66,100,6,73,102,19,45,64,15,38,61,13,72,105,26,66,
 103,15,56,96,7,60,95,5,70,96,8,67,100,2,67,99,6,71,104,3,73,100,12,29,43,13,
 22,38,12,33,53,10,48,74,6,61,99,7,69,111,8,65,109,4,61,107,5,62,104,2,53,96,
 1,51,96,6,51,99,7,61,103,14,71,109,14,83,115,17,89,114,20,98,116,28,90,118,
 33,57,97,16,44,88,11,43,89,7,40,85,1,49,90,7,50,88,10,50,96,13,51,97,12,55,
 98,16,63,104,26,44,80,24,23,50,5,29,61,8,27,78,3,27,80,5,38,83,12,70,106,26,
 67,95,5,63,96,6,66,99,6,67,99,12,45,67,15,60,85,25,65,101,18,59,99,9,61,100,
 8,59,94,4,68,96,5,66,100,2,70,103,5,64,97,2,79,105,20,22,28,9,11,18,3,21,32,
 8,33,48,10,45,68,17,43,71,11,55,86,16,66,99,23,74,107,15,82,116,27,80,115,23,
 76,112,14,84,118,12,90,122,14,92,119,17,93,119,25,69,103,18,47,88,8,40,83,5,
 44,83,11,36,80,3,39,83,4,38,80,6,39,78,11,44,75,13,61,89,27,59,91,27,64,99,
 32,69,101,45,51,79,28,32,65,6,35,82,5,45,91,13,57,99,20,70,105,21,68,98,7,61,
 93,7,61,94,6,61,95,5,65,93,15,65,95,19,57,95,8,54,97,4,59,95,3,69,100,8,69,
 101,6,61,96,1,75,109,5,78,110,6,56,79,18,14,18,2,23,28,4,28,39,3,50,64,12,56,
 77,10,75,100,18,84,113,23,82,113,21,88,120,9,87,117,9,90,119,6,89,119,1,92,
 121,4,94,123,10,83,113,15,65,96,15,38,80,5,35,80,7,35,76,4,46,79,12,35,77,4,
 37,81,5,33,79,3,40,85,16,34,62,16,25,41,11,18,32,11,25,47,15,40,64,19,47,72,
 22,42,74,14,43,81,12,55,89,21,69,103,25,71,104,16,63,97,5,56,89,5,58,91,4,57,
 93,1,60,92,4,59,94,5,56,97,6,50,94,1,59,95,3,64,94,3,63,97,1,65,100,1,71,106,
 2,77,107,16,21,39,6,28,36,9,49,63,12,77,99,17,87,113,13,84,114,6,85,118,3,82,
 116,1,78,114,1,80,116,0,83,116,4,86,115,4,93,120,4,88,117,2,84,116,10,45,81,
 0,33,70,6,38,74,9,29,69,3,33,71,4,40,70,8,35,75,8,37,82,6,35,85,3,35,87,2,48,
 90,19,27,46,8,15,22,2,17,30,5,25,41,6,32,55,10,36,64,11,48,76,21,52,73,28,71,
 97,29,70,103,14,60,96,1,64,97,10,60,94,1,62,97,2,50,89,2,54,94,2,60,96,2,53,
 91,2,65,102,9,60,98,2,64,102,5,67,105,5,75,111,2,57,79,19,45,62,11,67,89,12,
 85,113,6,86,120,1,80,115,6,76,115,1,82,117,3,79,111,1,81,112,1,84,118,2,86,
 116,9,87,116,0,92,120,5,80,106,16,48,75,6,31,62,2,26,59,3,35,66,6,28,66,1,36,
 69,3,28,46,9,33,78,5,36,83,2,37,89,7,35,90,5,48,95,11,37,57,17,19,24,8,26,34,
 8,34,49,18,53,68,29,45,60,17,35,50,8,31,45,8,68,94,28,72,109,6,61,96,1,65,96,
 7,66,97,3,62,96,6,47,86,4,51,90,3,58,92,2,71,104,11,65,99,3,67,101,1,68,103,
 2,69,107,3,68,104,1,63,91,12,79,108,9,79,113,6,77,112,5,75,112,3,76,114,3,76,
 111,0,75,110,0,83,116,4,86,118,6,81,114,3,85,117,0,91,122,0,90,114,20,36,56,
 4,25,49,1,22,51,1,20,53,0,31,63,4,31,71,1,38,74,2,32,50,14,45,82,9,46,92,6,
 42,94,6,35,88,5,47,96,7,51,74,24,22,30,5,23,35,2,34,51,3,55,74,18,77,98,37,
 42,62,7,34,50,3,73,100,29,67,104,3,59,94,1,65,96,8,62,93,2,61,95,5,50,89,4,
 51,90,4,62,96,8,70,103,10,65,98,3,67,101,2,65,100,1,64,101,4,57,93,2,73,109,
 5,72,111,0,74,113,0,72,109,3,71,105,6,73,107,2,81,114,4,84,118,6,77,111,1,79,
 115,2,83,118,0,86,119,0,92,121,8,60,80,14,25,41,8,21,44,2,23,52,1,23,56,1,36,
 71,6,34,79,0,47,87,5,32,52,14,47,71,17,53,95,15,40,92,3,41,90,10,44,94,6,50,
 77,21,26,37,5,26,40,6,43,61,3,60,83,11,84,112,29,77,107,23,51,70,7,66,94,18,
 73,110,8,64,99,5,70,101,11,67,98,4,61,96,4,49,88,1,56,96,6,72,106,12,58,96,
 4,57,95,2,63,102,6,58,96,1,51,85,3,70,106,7,70,110,0,70,109,5,76,110,8,74,106,
 1,81,111,4,83,110,7,84,114,4,79,111,1,76,111,0,78,116,3,85,119,5,77,103,18,
 48,68,9,15,27,7,18,34,2,25,49,1,27,58,0,31,65,5,33,72,3,42,89,4,56,98,9,35,
 56,17,30,42,13,58,95,28,44,95,6,45,92,10,45,96,10,54,82,26,29,41,11,23,37,9,
 46,63,11,65,89,15,80,113,18,73,110,6,76,97,22,59,87,10,68,104,3,62,97,3,67,
 99,9,62,93,1,57,95,0,49,90,0,61,97,6,75,102,8,65,104,2,60,99,2,57,95,4,47,85,
 4,57,97,5,69,108,2,77,114,3,75,109,2,80,107,4,83,112,5,76,109,2,74,109,0,76,
 115,0,80,117,3,81,115,2,85,119,5,88,116,11,42,58,17,14,23,6,11,16,5,26,42,13,
 28,57,1,28,66,2,38,80,4,25,77,1,43,95,7,56,99,8,22,43,9,20,31,1,49,73,20,58,
 97,20,48,98,4,53,102,7,58,89,24,33,46,22,28,42,10,31,61,5,59,90,19,81,111,33,
 76,111,8,68,100,16,66,99,13,68,102,8,70,104,9,66,101,9,62,98,1,57,97,1,56,95,
 1,73,109,13,67,97,1,64,101,0,69,107,6,56,92,1,66,103,7,69,108,2,71,107,0,83,
 112,2,90,115,4,84,113,6,75,106,2,75,108,1,73,108,0,78,113,1,80,112,5,85,115,
 7,90,120,7,50,63,14,8,12,5,7,9,2,6,9,0,33,51,13,33,66,1,34,76,4,40,84,5,36,
 91,0,47,99,2,60,97,19,14,29,5,19,38,1,31,56,3,60,96,21,62,104,14,54,101,5,60,
 93,17,27,45,9,29,48,5,28,62,0,52,88,7,76,111,25,77,113,8,71,107,6,68,103,5,
 63,98,1,72,107,11,61,96,5,62,98,1,59,98,2,72,107,7,72,106,5,62,99,0,67,104,
 3,65,101,1,66,102,1,69,106,0,76,111,0,85,116,7,87,115,7,82,108,0,71,107,0,77,
 112,3,80,114,4,77,109,1,84,114,4,89,118,2,71,94,11,36,47,19,10,12,5,12,13,12,
 9,14,1,9,16,4,40,63,11,42,80,1,37,82,3,47,93,7,43,99,0,55,105,4,53,81,21,21,
 27,5,22,41,1,33,59,3,41,76,3,60,102,16,62,109,10,63,98,16,21,45,1,25,51,1,34,
 67,1,47,90,3,74,115,23,78,112,9,75,113,2,65,103,0,65,103,2,73,110,11,60,95,
 2,76,113,9,62,101,2,78,111,7,69,105,1,63,105,1,67,102,3,69,105,1,74,110,2,81,
 118,3,87,116,5,77,107,3,70,105,1,72,110,0,73,114,2,75,113,2,77,111,1,82,113,
 4,84,110,6,64,80,21,23,31,10,14,18,6,14,19,4,16,24,5,10,24,0,14,29,10,50,76,
 16,48,90,2,43,91,5,48,97,5,44,98,0,61,109,4,41,62,11,30,31,4,31,43,2,39,62,
 7,43,81,6,44,92,6,59,104,12,69,104,22,19,46,0,21,50,1,37,69,5,42,89,0,63,109,
 17,75,108,13,72,111,6,70,110,6,67,106,4,69,108,5,68,106,3,69,108,0,75,109,8,
 69,104,5,66,104,1,69,110,1,72,110,0,77,111,2,88,121,8,82,113,1,76,111,3,70,
 105,1,66,101,2,64,99,3,67,106,2,76,112,1,79,109,2,77,100,9,51,64,16,8,12,3,
 15,18,6,21,25,3,29,34,9,24,34,6,18,35,0,24,45,7,51,81,24,60,106,2,50,99,10,
 49,99,2,49,104,1,65,104,11,35,51,13,32,40,11,38,52,6,43,65,6,48,81,5,50,92,
 7,52,90,11,72,110,13,31,57,9,28,52,1,46,77,16,53,95,9,52,99,2,69,110,18,70,
 106,12,71,109,6,69,108,1,72,110,8,75,115,9,66,106,3,65,105,7,64,103,3,67,103,
 0,76,112,1,85,118,3,83,117,5,73,108,2,71,108,3,72,109,3,69,105,3,67,103,5,59,
 95,3,52,95,0,61,100,4,61,94,10,47,74,14,31,49,8,32,48,12,35,49,9,37,48,20,44,
 56,20,46,62,19,43,64,13,39,65,9,68,99,29,62,108,2,54,103,8,57,105,2,63,106,
 12,41,64,11,29,37,14,41,50,13,51,68,11,63,85,23,66,95,27,67,102,29,57,97,12,
 73,113,16,45,73,19,22,45,2,41,72,12,66,108,20,66,113,13,63,105,13,75,108,22,
 70,105,13,72,107,11,68,104,10,65,103,1,68,107,3,56,96,0,70,109,3,79,116,5,80,
 115,5,72,106,0,73,109,1,68,106,3,64,103,3,65,103,0,65,102,4,56,92,1,55,91,2,
 56,95,7,54,94,1,56,97,0,61,102,1,69,107,4,71,107,7,75,110,8,76,105,19,66,92,
 22,52,81,9,69,99,20,81,111,30,78,109,27,64,106,9,56,103,3,63,107,8,60,89,18,
 19,32,8,28,36,13,37,51,8,46,71,12,66,96,21,70,106,10,73,114,5,73,118,18,76,
 118,21,61,93,23,27,53,5,35,67,7,59,101,13,66,113,12,69,110,17,79,113,16,77,
 110,13,76,110,9,75,110,6,68,104,5,67,102,6,80,115,7,78,116,4,69,109,0,65,105,
 3,67,107,4,66,105,3,66,102,0,67,102,0,64,103,2,64,102,3,57,94,0,59,96,3,62,
 98,1,63,99,2,59,96,2,63,101,3,62,108,2,62,103,7,68,109,6,69,108,5,73,111,7,
 77,114,10,79,114,14,82,117,20,86,117,29,66,105,16,61,107,7,67,107,17,41,66,
 14,29,43,20,31,49,6,35,59,12,37,76,3,56,97,15,68,112,21,59,104,7,62,109,5,64,
 108,9,69,107,15,44,74,10,39,71,9,56,98,11,60,108,7,71,113,19,76,107,18,79,108,
 25,76,105,17,83,113,13,81,117,5,74,111,1,66,101,2,64,100,0,70,107,1,70,107,
 1,75,108,3,75,107,3,69,101,0,70,102,0,68,104,1,68,104,3,66,102,2,68,103,3,61,
 97,3,59,95,1,63,99,2,64,101,2,65,105,1,66,105,2,63,103,1,65,104,2,63,100,0,
 72,109,4,71,109,1,79,117,4,75,113,2,79,116,11,79,110,25,49,75,13,23,44,1,24,
 45,7,30,54,9,39,68,7,46,85,3,52,98,2,68,113,17,52,91,9,50,94,5,54,104,3,56,
 103,2,47,84,1,40,77,0,53,96,7,54,105,3,58,113,4,73,113,18,66,95,31,76,105,31,
 112,120,16,93,116,1,82,114,3,80,110,5,80,110,4,76,107,2,77,108,2,76,111,1,75,
 110,2,79,114,3,75,110,2,78,115,3,79,117,3,80,117,3,77,114,3,73,105,7,70,102,
 4,75,107,6,75,107,6,75,109,7,72,106,4,71,105,4,71,106,3,66,103,2,69,106,1,70,
 107,2,66,104,1,68,105,3,73,108,8,77,109,18,76,104,25,67,91,24,41,65,10,38,64,
 6,41,71,3,50,91,2,50,99,0,63,113,10,62,104,14,37,78,0,46,96,2,51,103,4,50,97,
 7,41,82,0,43,87,0,54,104,4,53,107,1,69,112,9,71,102,32,72,103,35,101,112,26,
 97,122,5,80,114,3,57,101,4,53,96,0,60,103,5,57,99,2,67,102,4,67,103,4,67,103,
 5,64,100,2,65,100,2,73,108,6,67,102,2,63,99,1,73,106,2,69,101,0,70,102,1,67,
 99,0,68,103,1,72,107,1,73,107,1,70,105,0,71,109,3,74,112,5,75,112,6,78,115,
 8,78,116,6,74,111,3,76,110,10,77,106,18,82,108,24,81,109,26,83,113,30,80,113,
 27,70,107,19,69,112,17,67,111,12,74,112,16,38,68,4,40,82,4,44,96,4,44,97,2,
 47,93,3,48,94,1,49,98,0,50,100,0,58,106,4,73,106,29,63,96,31,72,91,22,97,124,
 11,74,109,5,72,111,5,69,107,2,62,100,1,64,101,1,63,101,0,65,103,0,66,104,3,
 64,102,0,69,105,2,70,105,4,70,106,4,69,105,2,68,106,1,69,107,4,68,105,5,67,
 104,5,73,113,4,69,110,1,69,110,0,70,111,1,68,105,3,76,113,7,74,112,2,74,112,
 3,75,112,10,76,110,18,74,102,30,48,71,20,51,74,20,61,87,24,63,92,23,77,108,
 35,85,112,34,91,124,41,93,128,38,101,130,39,60,77,25,36,65,3,44,90,6,46,98,
 1,41,90,0,44,92,0,54,101,4,57,104,3,57,106,9,72,106,28,57,94,27,56,81,19,89,
 117,14,71,107,3,70,108,1,68,107,1,75,114,6,69,108,4,63,101,1,60,98,0,63,101,
 1,65,103,4,59,96,2,60,98,4,64,103,2,69,110,2,66,108,1,68,110,4,68,109,4,66,
 107,1,74,113,5,72,112,0,74,114,3,71,110,4,78,113,6,83,119,3,81,115,12,66,93,
 23,53,71,21,52,68,20,30,45,7,14,28,2,14,33,1,20,44,2,24,54,0,32,68,0,39,75,
 4,41,80,5,44,88,4,47,94,2,73,104,22,56,71,16,51,86,17,44,93,1,40,93,0,40,91,
 0,42,93,3,39,89,2,49,95,11,62,102,26,64,97,32,59,86,32,73,104,20,76,114,4,70,
 109,3,67,106,2,66,105,0,65,104,2,66,104,4,65,103,4,60,98,0,58,96,0,56,97,2,
 61,98,0,68,100,6,62,86,13,70,98,15,71,103,5,74,105,7,75,105,17,78,106,16,81,
 109,20,70,96,18,59,82,17,62,85,14,55,76,14,39,58,6,30,49,3,35,52,7,35,53,7,
 24,40,1,19,34,4,17,33,1,23,45,0,27,55,0,30,63,0,29,68,0,31,72,0,30,73,0,36,
 80,3,67,99,8,91,110,24,46,81,5,43,83,6,45,88,0,48,96,2,47,100,6,42,97,7,57,
 99,24,56,96,22,49,83,12,65,96,25,64,95,17,74,111,2,70,108,7,61,100,0,65,103,
 1,65,104,1,61,99,1,65,103,5,63,101,3,59,97,1,57,97,3,62,100,1,67,98,7,64,86,
 20,38,53,7,35,50,4,37,51,10,39,52,19,37,52,9,43,59,14,33,47,9,32,45,15,27,45,
 2,26,43,6,26,43,6,28,47,1,41,62,8,36,57,2,30,51,0,25,44,0,25,45,2,32,58,1,36,
 68,2,40,77,7,36,79,4,33,75,2,33,75,2,41,81,2,58,96,2,71,101,5,63,107,13,63,
 102,22,67,108,17,56,100,10,40,90,2,36,88,2,56,94,22,54,91,17,51,88,8,59,95,
 12,58,87,24,70,105,8,70,108,6,66,104,4,65,103,3,59,97,1,62,99,3,62,100,2,56,
 95,0,63,101,4,61,99,4,56,93,2,55,93,1,58,96,3,68,92,10,37,54,5,32,46,9,33,48,
 5,39,56,20,39,58,13,34,55,2,35,55,4,31,55,8,32,58,1,34,61,0,39,65,4,48,73,9,
 41,67,0,38,64,0,35,60,1,33,63,2,41,78,1,44,86,1,36,80,2,31,77,3,35,78,1,44,
 85,1,47,88,1,45,89,2,49,88,4,46,98,7,57,103,5,57,102,14,56,101,16,57,102,19,
 59,102,22,64,100,25,47,83,6,48,87,6,56,95,11,43,69,23,66,98,17,67,104,16,65,
 104,5,60,100,0,60,98,3,62,91,14,65,99,15,61,102,2,57,98,1,61,97,1,61,98,4,54,
 94,1,57,97,3,65,105,4,69,101,17,51,71,9,56,71,16,45,71,13,43,71,9,42,70,4,42,
 71,3,36,67,3,37,69,1,41,74,0,45,79,0,45,81,0,44,80,1,37,75,0,35,73,0,37,77,
 0,45,89,0,49,97,1,42,93,0,40,92,1,53,98,4,57,99,4,44,89,0,49,95,9,45,88,8,51,
 98,5,44,91,1,46,101,3,51,102,8,56,102,16,59,101,21,63,101,30,42,80,14,46,86,
 13,52,93,4,59,90,30,49,79,23,53,83,23,68,101,27,66,103,9,68,106,4,58,88,14,
 43,69,18,67,96,25,64,100,9,61,100,5,52,94,1,57,100,7,57,101,8,56,96,3,67,104,
 9,68,95,19,42,61,14,48,73,21,50,76,18,54,81,16,55,84,14,53,89,12,51,89,5,54,
 93,1,56,96,0,54,97,0,51,92,0,49,86,1,46,81,3,42,84,2,54,99,6,53,102,3,49,98,
 1,56,104,3,56,102,4,43,91,0,38,90,1,49,97,9,46,92,13,49,98,4,47,96,4,47,96,
 2,48,96,2,51,99,6,53,100,10,56,101,16,60,104,26,43,86,12,41,85,0,47,90,12,42,
 78,18,26,52,11,44,70,24,60,91,22,70,105,11,61,93,13,29,44,12,43,58,20,58,83,
 21,65,100,15,62,100,8,63,104,6,57,101,2,57,98,7,57,97,2,65,101,10,63,93,24,
 44,68,13,49,73,16,42,68,7,51,77,13,46,79,10,54,88,13,67,102,21,66,102,16,64,
 100,19,62,100,10,57,97,6,46,86,2,37,84,0,48,96,1,52,99,2,61,106,9,57,104,4,
 45,96,1,40,93,1,47,99,10,38,88,3,48,95,18,47,97,6,47,97,8,44,93,4,49,96,9,50,
 91,12,54,92,17,58,98,21,63,102,29,64,103,32,45,84,13,47,93,8,55,96,25,33,59,
 15,30,54,21,18,41,7,59,89,18,72,105,22,30,42,6,31,38,10,40,57,25,43,65,20,52,
 76,21,61,91,16,66,100,11,59,102,6,60,102,7,62,103,5,62,103,2,63,88,22,54,77,
 19,56,78,24,48,71,17,41,63,15,30,52,7,24,47,3,21,43,2,23,44,4,45,77,9,54,98,
 5,44,95,1,42,92,1,47,96,1,61,107,6,55,99,3,45,96,3,40,95,6,36,89,2,50,95,8,
 42,92,4,48,96,19,45,95,5,48,100,11,35,90,5,42,89,15,34,66,12,44,66,23,49,77,
 27,53,83,29,63,93,37,67,97,40,48,88,9,51,90,17,53,82,21,26,52,12,27,49,15,16,
 29,8,55,81,22,52,70,24,32,47,10,41,67,7,41,68,7,38,55,6,39,53,8,55,75,25,59,
 91,20,63,97,12,69,106,7,71,108,5,68,102,12,58,80,20,55,75,24,51,80,12,45,63,
 17,36,54,14,32,52,9,39,64,8,56,90,10,64,107,5,53,103,0,45,96,4,47,93,1,64,106,
 7,54,99,3,46,95,2,50,100,4,44,94,0,40,89,0,50,99,10,45,97,1,54,101,13,44,91,
 4,44,95,3,39,92,2,37,90,8,48,88,17,26,43,10,19,39,2,14,38,0,15,40,5,17,43,4,
 35,67,4,48,82,7,59,88,27,17,44,5,35,58,16,14,26,2,26,36,5,63,76,34,36,54,11,
 43,72,4,51,80,6,47,70,3,47,66,11,26,42,5,18,33,13,25,43,6,52,73,16,62,85,16,
 72,102,18,73,99,22,60,85,20,58,84,28,61,92,10,47,76,15,47,78,16,65,102,14,62,
 108,6,58,103,8,52,96,3,53,97,0,62,106,9,56,98,1,54,99,2,44,94,1,51,101,5,45,
 95,1,48,97,7,44,93,5,44,95,3,47,88,12,42,83,11,43,93,6,45,95,7,35,89,5,49,94,
 15,34,56,13,21,43,3,19,44,1,21,48,6,17,46,1,28,59,0,43,76,4,59,90,19,25,53,
 7,36,59,14,22,34,6,44,54,21,52,73,15,39,65,6,42,70,2,55,83,11,61,94,4,59,85,
 12,36,53,17,26,38,2,41,55,11,37,50,9,33,46,9,43,64,20,67,94,30,77,107,30,73,
 100,22,64,101,4,62,99,15,62,103,14,66,113,3,56,108,0,54,101,6,59,101,7,65,107,
 4,52,96,3,56,98,0,53,97,1,48,98,4,44,94,0,40,90,0,49,98,9,42,92,2,45,96,5,40,
 76,12,46,80,17,41,91,6,45,94,6,32,87,3,47,96,7,48,79,22,22,48,2,24,52,3,32,
 63,10,21,55,1,30,62,0,40,74,1,58,91,8,45,74,19,27,50,7,29,42,16,68,95,32,60,
 96,7,45,79,3,43,69,5,53,81,9,68,105,3,71,104,15,38,55,15,23,37,4,36,52,7,61,
 78,26,54,72,20,37,58,8,27,54,5,48,77,19,83,108,38,78,111,32,74,110,16,71,113,
 6,68,112,3,59,106,2,62,109,3,60,106,4,53,99,1,56,101,3,63,104,4,59,103,5,47,
 96,2,46,96,0,41,91,0,50,99,11,41,90,1,46,99,4,48,79,16,45,74,15,50,100,11,44,
 92,5,37,92,7,42,94,2,51,87,21,18,46,0,26,56,3,40,74,14,29,66,4,42,76,2,44,80,
 1,57,96,12,54,83,18,24,46,8,48,74,31,64,103,14,65,104,8,52,88,3,49,81,10,52,
 87,1,68,103,5,73,98,27,45,64,12,46,72,17,60,90,22,58,92,14,49,85,6,42,75,4,
 41,72,5,39,68,4,38,67,6,65,90,22,78,109,28,66,105,6,64,110,0,66,111,2,62,106,
 2,60,105,3,61,110,0,61,112,3,64,97,20,42,72,7,52,97,4,46,97,1,39,89,0,47,97,
 8,45,96,1,51,101,4,55,87,15,36,58,18,57,92,24,45,94,8,40,93,7,42,91,10,51,89,
 22,16,38,2,26,54,2,32,70,3,39,82,12,38,85,1,46,93,4,57,99,6,56,86,22,26,51,
 11,61,94,23,64,105,7,60,101,2,58,94,6,78,112,25,82,112,19,87,121,11,84,116,
 21,80,112,20,70,110,13,65,109,6,65,110,7,59,105,7,49,94,2,48,91,2,48,86,4,49,
 79,6,52,78,10,54,85,6,58,96,1,66,109,2,62,109,8,64,113,2,68,116,2,68,113,9,
 66,93,21,35,55,8,43,71,13,53,99,8,45,96,0,40,91,0,44,95,8,46,98,2,52,100,4,
 46,75,15,21,40,8,48,77,28,54,98,21,45,95,8,49,97,11,57,96,23,21,41,3,24,51,
 1,32,68,2,44,86,11,41,90,0,44,92,0,54,99,4,60,95,20,34,63,7,63,101,8,62,104,
 2,56,95,0,75,112,22,80,116,21,78,110,8,82,114,16,62,88,28,46,70,22,57,86,32,
 63,97,22,70,110,14,67,110,6,70,109,9,59,105,6,60,104,9,63,97,9,61,94,9,57,92,
 2,58,94,0,63,101,1,64,110,1,68,112,6,66,102,20,32,60,9,29,44,4,22,39,3,44,74,
 17,56,100,7,46,97,1,46,97,9,35,86,1,43,95,0,56,101,8,39,63,16,25,41,7,29,55,
 14,56,92,26,54,101,13,47,97,5,57,98,18,21,39,2,22,45,1,30,63,1,46,87,10,43,
 92,1,47,95,1,51,96,8,58,97,8,56,92,9,63,104,5,55,97,1,52,91,1,62,98,12,59,95,
 2,61,98,2,64,95,13,25,45,6,20,35,2,31,46,5,42,60,6,57,79,12,78,100,29,92,112,
 34,68,104,17,78,121,26,77,114,16,74,113,3,66,104,0,62,99,3,65,99,9,68,105,16,
 50,80,16,25,46,3,25,43,2,22,42,2,18,43,0,44,79,14,59,102,5,45,96,0,49,100,10,
 39,90,1,49,101,3,59,102,13,26,46,8,24,40,0,29,53,9,46,78,18,61,105,18,61,110,
 10,57,101,14,33,50,10,22,43,1,33,64,3,49,88,11,39,87,2,40,88,2,46,92,2,54,99,
 6,52,95,2,59,100,4,56,96,2,59,98,10,51,90,1,59,99,1,64,100,2,60,88,21,18,35,
 0,23,37,1,30,47,2,34,55,1,50,68,8,87,97,37,42,60,7,65,89,19,81,112,18,79,113,
 5,74,109,14,74,114,17,55,93,13,33,60,7,32,50,9,20,38,0,24,45,4,22,45,2,18,49,
 2,21,55,3,50,91,18,57,103,6,48,97,0,47,97,6,46,96,0,55,106,2,57,94,20,16,30,
 5,18,27,7,30,49,19,45,76,27,61,90,35,67,103,19,66,109,17,26,48,8,23,41,1,27,
 62,2,48,83,10,39,85,4,46,95,7,45,91,1,47,93,2,53,97,4,51,92,1,57,96,4,54,93,
 8,55,95,4,61,101,4,62,95,12,41,66,15,18,35,0,28,43,4,35,54,5,74,95,31,92,109,
 38,99,110,43,77,99,24,88,116,16,82,114,12,76,105,27,57,89,16,47,84,8,30,66,
 3,23,49,4,41,61,15,52,73,24,26,49,0,26,53,2,27,60,3,27,63,3,52,93,14,61,108,
 6,47,97,0,49,99,5,47,97,0,59,109,5,41,76,10,19,35,8,12,23,4,7,23,1,13,34,4,
 24,44,5,42,66,11,70,105,25,35,57,17,22,40,0,25,60,1,47,82,10,39,86,5,43,92,
 5
};

#define LWH 30
#define LWH2 15

/* default mode */

static int gwidth = 1024;
static int gheight = 768;
static int gbpp = 24;

static int show_coments = 1;

void gentriangle(int p[][2], int xl, int yl)
{
    p[0][0] = xl;
    p[0][1] = yl;
    p[1][0] = xl + GrMaxX()/2;
    p[1][1] = yl;
    p[2][0] = xl + GrMaxX()/4;
    p[2][1] = yl - GrMaxY()/2;
}
    
void gentriangle2(int p[][2], int xl, int yl)
{
    p[0][0] = xl + LWH2;
    p[0][1] = yl - LWH2;
    p[1][0] = xl + GrMaxX()/2 - LWH2;
    p[1][1] = yl - LWH2;
    p[2][0] = xl + GrMaxX()/4;
    p[2][1] = yl - GrMaxY()/2 + LWH2;
}
    
void genstar(int p[][2], int xl, int yl)
{
    p[0][0] = xl;
    p[0][1] = yl;
    p[1][0] = xl + GrMaxX()/4;
    p[1][1] = yl - GrMaxY()/2;
    p[2][0] = xl + GrMaxX()/2;
    p[2][1] = yl;
    p[3][0] = xl;
    p[3][1] = yl - 3*GrMaxY()/8;
    p[4][0] = xl + GrMaxX()/2;
    p[4][1] = yl - 3*GrMaxY()/8;
}
    
void genstar2(int p[][2], int xl, int yl)
{
    p[0][0] = xl + LWH2;
    p[0][1] = yl - LWH2;
    p[1][0] = xl + GrMaxX()/4;
    p[1][1] = yl - GrMaxY()/2 + LWH2;
    p[2][0] = xl + GrMaxX()/2 - LWH2;
    p[2][1] = yl - LWH2;
    p[3][0] = xl + LWH2;
    p[3][1] = yl - 3*GrMaxY()/8;
    p[4][0] = xl + GrMaxX()/2 - LWH2;
    p[4][1] = yl - 3*GrMaxY()/8;
}

int printandwait(char *s)
{
    GrContext ctx;
    GrEvent ev;

    GrSaveContext(&ctx);
    GrSetContext(NULL);
    if (show_coments) GrTextXY(0, 0, s, GrWhite(), GrBlack());
    GrSetContext(&ctx);
    GrEventWaitKeyOrClick(&ev);
    if (ev.type == GREV_KEY && ev.p1 == 'q') return 1;
    return 0;
}

void dotest(GrPattern *ptt, GrContext *sctx)
{
    int ptri[3][2];
    int pstar[5][2];
    GrLineOption lo;
    GrLinePattern glp;

    GrPatternFilledBox(0, 0, GrMaxX()/2, GrMaxY()/2, ptt);
    GrPatternFilledBox(0, GrMaxY()/2, GrMaxX()/2, GrMaxY(), ptt);
    GrPatternFilledBox(GrMaxX()/2, 0, GrMaxX(), GrMaxY()/2, ptt);
    GrPatternFilledBox(GrMaxX()/2, GrMaxY()/2, GrMaxX(), GrMaxY(), ptt);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternFilledBox")) return;

    GrPatAlignFilledBox(0, 0, 0, 0, GrMaxX()/2, GrMaxY()/2, ptt);
    GrPatAlignFilledBox(0, GrMaxY()/2, 0, GrMaxY()/2, GrMaxX()/2, GrMaxY(), ptt);
    GrPatAlignFilledBox(GrMaxX()/2, 0, GrMaxX()/2, 0, GrMaxX(), GrMaxY()/2, ptt);
    GrPatAlignFilledBox(GrMaxX()/2, GrMaxY()/2, GrMaxX()/2, GrMaxY()/2, GrMaxX(), GrMaxY(), ptt);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatAlignFilledBox")) return;

    GrClearContext(GrBlack());
    GrSetContext(sctx);
    
    GrPatternFilledBox(0, 0, GrMaxX()/2, GrMaxY()/2, ptt);
    GrPatternFilledBox(0, GrMaxY()/2, GrMaxX()/2, GrMaxY(), ptt);
    GrPatternFilledBox(GrMaxX()/2, 0, GrMaxX(), GrMaxY()/2, ptt);
    GrPatternFilledBox(GrMaxX()/2, GrMaxY()/2, GrMaxX(), GrMaxY(), ptt);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternFilledBox in subcontext")) return;


    GrPatAlignFilledBox(0, 0, 0, 0, GrMaxX()/2, GrMaxY()/2, ptt);
    GrPatAlignFilledBox(0, GrMaxY()/2, 0, GrMaxY()/2, GrMaxX()/2, GrMaxY(), ptt);
    GrPatAlignFilledBox(GrMaxX()/2, 0, GrMaxX()/2, 0, GrMaxX(), GrMaxY()/2, ptt);
    GrPatAlignFilledBox(GrMaxX()/2, GrMaxY()/2, GrMaxX()/2, GrMaxY()/2, GrMaxX(), GrMaxY(), ptt);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatAlignFilledBox in subcontext")) return;


    GrSetContext( NULL );
    GrClearContext(GrBlack());
    
    GrPatternFilledCircle(GrMaxX()/4, GrMaxY()/4, GrMaxY()/4, ptt);
    GrPatternFilledCircle(3*GrMaxX()/4, GrMaxY()/4, GrMaxY()/4, ptt);
    GrPatternFilledCircle(GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4, ptt);
    GrPatternFilledCircle(3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4, ptt);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternFilledCircle")) return;


    GrPatAlignFilledCircle(0, 0, GrMaxX()/4, GrMaxY()/4, GrMaxY()/4, ptt);
    GrPatAlignFilledCircle(GrMaxX()/2, 0, 3*GrMaxX()/4, GrMaxY()/4, GrMaxY()/4, ptt);
    GrPatAlignFilledCircle(0, GrMaxY()/2, GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4, ptt);
    GrPatAlignFilledCircle(GrMaxX()/2, GrMaxY()/2, 3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4, ptt);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatAlignFilledCircle")) return;


    GrClearContext(GrBlack());
    GrSetContext(sctx);

    GrPatternFilledCircle(GrMaxX()/4, GrMaxY()/4, GrMaxY()/4, ptt);
    GrPatternFilledCircle(3*GrMaxX()/4, GrMaxY()/4, GrMaxY()/4, ptt);
    GrPatternFilledCircle(GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4, ptt);
    GrPatternFilledCircle(3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4, ptt);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternFilledCircle in subcontext")) return;


    GrPatAlignFilledCircle(0, 0, GrMaxX()/4, GrMaxY()/4, GrMaxY()/4, ptt);
    GrPatAlignFilledCircle(GrMaxX()/2, 0, 3*GrMaxX()/4, GrMaxY()/4, GrMaxY()/4, ptt);
    GrPatAlignFilledCircle(0, GrMaxY()/2, GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4, ptt);
    GrPatAlignFilledCircle(GrMaxX()/2, GrMaxY()/2, 3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4, ptt);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatAlignFilledCircle in subcontext")) return;


    GrSetContext( NULL );
    GrClearContext(GrBlack());
    
    GrPatternFilledEllipse(GrMaxX()/4, GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, ptt);
    GrPatternFilledEllipse(3*GrMaxX()/4, GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, ptt);
    GrPatternFilledEllipse(GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, ptt);
    GrPatternFilledEllipse(3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, ptt);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternFilledEllipse")) return;


    GrPatAlignFilledEllipse(0, 0, GrMaxX()/4, GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, ptt);
    GrPatAlignFilledEllipse(GrMaxX()/2, 0, 3*GrMaxX()/4, GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, ptt);
    GrPatAlignFilledEllipse(0, GrMaxY()/2, GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, ptt);
    GrPatAlignFilledEllipse(GrMaxX()/2, GrMaxY()/2, 3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, ptt);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatAlignFilledEllipse")) return;


    GrClearContext(GrBlack());
    GrSetContext(sctx);

    GrPatternFilledEllipse(GrMaxX()/4, GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, ptt);
    GrPatternFilledEllipse(3*GrMaxX()/4, GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, ptt);
    GrPatternFilledEllipse(GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, ptt);
    GrPatternFilledEllipse(3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, ptt);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternFilledEllipse in subcontext")) return;


    GrPatAlignFilledEllipse(0, 0, GrMaxX()/4, GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, ptt);
    GrPatAlignFilledEllipse(GrMaxX()/2, 0, 3*GrMaxX()/4, GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, ptt);
    GrPatAlignFilledEllipse(0, GrMaxY()/2, GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, ptt);
    GrPatAlignFilledEllipse(GrMaxX()/2, GrMaxY()/2, 3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, ptt);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatAlignFilledEllipse in subcontext")) return;


    GrSetContext( NULL );
    GrClearContext(GrBlack());

    gentriangle(ptri, 0, GrMaxY()/2);
    GrPatternFilledConvexPolygon(3, ptri, ptt);
    gentriangle(ptri, GrMaxX()/2, GrMaxY()/2);
    GrPatternFilledConvexPolygon(3, ptri, ptt);
    gentriangle(ptri, 0, GrMaxY());
    GrPatternFilledConvexPolygon(3, ptri, ptt);
    gentriangle(ptri, GrMaxX()/2, GrMaxY());
    GrPatternFilledConvexPolygon(3, ptri, ptt);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternFilledConvexPolygon")) return;


    gentriangle(ptri, 0, GrMaxY()/2);
    GrPatAlignFilledConvexPolygon(0, 0, 3, ptri, ptt);
    gentriangle(ptri, GrMaxX()/2, GrMaxY()/2);
    GrPatAlignFilledConvexPolygon(GrMaxX()/2, 0, 3, ptri, ptt);
    gentriangle(ptri, 0, GrMaxY());
    GrPatAlignFilledConvexPolygon(0, GrMaxY()/2, 3, ptri, ptt);
    gentriangle(ptri, GrMaxX()/2, GrMaxY());
    GrPatAlignFilledConvexPolygon(GrMaxX()/2, GrMaxY()/2, 3, ptri, ptt);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatAlignFilledConvexPolygon")) return;


    GrClearContext(GrBlack());
    GrSetContext(sctx);

    gentriangle(ptri, 0, GrMaxY()/2);
    GrPatternFilledConvexPolygon(3, ptri, ptt);
    gentriangle(ptri, GrMaxX()/2, GrMaxY()/2);
    GrPatternFilledConvexPolygon(3, ptri, ptt);
    gentriangle(ptri, 0, GrMaxY());
    GrPatternFilledConvexPolygon(3, ptri, ptt);
    gentriangle(ptri, GrMaxX()/2, GrMaxY());
    GrPatternFilledConvexPolygon(3, ptri, ptt);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternFilledConvexPolygon in subcontext")) return;


    gentriangle(ptri, 0, GrMaxY()/2);
    GrPatAlignFilledConvexPolygon(0, 0, 3, ptri, ptt);
    gentriangle(ptri, GrMaxX()/2, GrMaxY()/2);
    GrPatAlignFilledConvexPolygon(GrMaxX()/2, 0, 3, ptri, ptt);
    gentriangle(ptri, 0, GrMaxY());
    GrPatAlignFilledConvexPolygon(0, GrMaxY()/2, 3, ptri, ptt);
    gentriangle(ptri, GrMaxX()/2, GrMaxY());
    GrPatAlignFilledConvexPolygon(GrMaxX()/2, GrMaxY()/2, 3, ptri, ptt);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatAlignFilledConvexPolygon in subcontext")) return;


    GrSetContext( NULL );
    GrClearContext(GrBlack());

    genstar(pstar, 0, GrMaxY()/2);
    GrPatternFilledPolygon(5, pstar, ptt);
    genstar(pstar, GrMaxX()/2, GrMaxY()/2);
    GrPatternFilledPolygon(5, pstar, ptt);
    genstar(pstar, 0, GrMaxY());
    GrPatternFilledPolygon(5, pstar, ptt);
    genstar(pstar, GrMaxX()/2, GrMaxY());
    GrPatternFilledPolygon(5, pstar, ptt);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternFilledPolygon")) return;


    genstar(pstar, 0, GrMaxY()/2);
    GrPatAlignFilledPolygon(0, 0, 5, pstar, ptt);
    genstar(pstar, GrMaxX()/2, GrMaxY()/2);
    GrPatAlignFilledPolygon(GrMaxX()/2, 0, 5, pstar, ptt);
    genstar(pstar, 0, GrMaxY());
    GrPatAlignFilledPolygon(0, GrMaxY()/2, 5, pstar, ptt);
    genstar(pstar, GrMaxX()/2, GrMaxY());
    GrPatAlignFilledPolygon(GrMaxX()/2, GrMaxY()/2, 5, pstar, ptt);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatAlignFilledPolygon")) return;


    GrClearContext(GrBlack());
    GrSetContext(sctx);

    genstar(pstar, 0, GrMaxY()/2);
    GrPatternFilledPolygon(5, pstar, ptt);
    genstar(pstar, GrMaxX()/2, GrMaxY()/2);
    GrPatternFilledPolygon(5, pstar, ptt);
    genstar(pstar, 0, GrMaxY());
    GrPatternFilledPolygon(5, pstar, ptt);
    genstar(pstar, GrMaxX()/2, GrMaxY());
    GrPatternFilledPolygon(5, pstar, ptt);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternFilledPolygon in subcontext")) return;


    genstar(pstar, 0, GrMaxY()/2);
    GrPatAlignFilledPolygon(0, 0, 5, pstar, ptt);
    genstar(pstar, GrMaxX()/2, GrMaxY()/2);
    GrPatAlignFilledPolygon(GrMaxX()/2, 0, 5, pstar, ptt);
    genstar(pstar, 0, GrMaxY());
    GrPatAlignFilledPolygon(0, GrMaxY()/2, 5, pstar, ptt);
    genstar(pstar, GrMaxX()/2, GrMaxY());
    GrPatAlignFilledPolygon(GrMaxX()/2, GrMaxY()/2, 5, pstar, ptt);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatAlignFilledPolygon in subcontext")) return;


    GrSetContext( NULL );
    GrClearContext(GrBlack());
    
    GrPatternFilledCircleArc(GrMaxX()/4, GrMaxY()/4, GrMaxY()/4, 300, 3000, GR_ARC_STYLE_OPEN, ptt);
    GrPatternFilledCircleArc(3*GrMaxX()/4, GrMaxY()/4, GrMaxY()/4, 0, 2000, GR_ARC_STYLE_CLOSE2, ptt);
    GrPatternFilledCircleArc(GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4, 0, 3000, GR_ARC_STYLE_CLOSE2, ptt);
    GrPatternFilledCircleArc(3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4, 600, 3000, GR_ARC_STYLE_CLOSE1, ptt);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternFilledCircleArc")) return;


    GrPatAlignFilledCircleArc(0, 0, GrMaxX()/4, GrMaxY()/4, GrMaxY()/4, 300, 3000, GR_ARC_STYLE_OPEN, ptt);
    GrPatAlignFilledCircleArc(GrMaxX()/2, 0, 3*GrMaxX()/4, GrMaxY()/4, GrMaxY()/4, 0, 2000, GR_ARC_STYLE_CLOSE2, ptt);
    GrPatAlignFilledCircleArc(0, GrMaxY()/2, GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4, 0, 3000, GR_ARC_STYLE_CLOSE2, ptt);
    GrPatAlignFilledCircleArc(GrMaxX()/2, GrMaxY()/2, 3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4, 600, 3000, GR_ARC_STYLE_CLOSE1, ptt);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatAlignFilledCircleArc")) return;


    GrClearContext(GrBlack());
    GrSetContext(sctx);

    GrPatternFilledCircleArc(GrMaxX()/4, GrMaxY()/4, GrMaxY()/4, 300, 3000, GR_ARC_STYLE_OPEN, ptt);
    GrPatternFilledCircleArc(3*GrMaxX()/4, GrMaxY()/4, GrMaxY()/4, 0, 2000, GR_ARC_STYLE_CLOSE2, ptt);
    GrPatternFilledCircleArc(GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4, 0, 3000, GR_ARC_STYLE_CLOSE2, ptt);
    GrPatternFilledCircleArc(3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4, 600, 3000, GR_ARC_STYLE_CLOSE1, ptt);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternFilledCircleArc in subcontext")) return;


    GrPatAlignFilledCircleArc(0, 0, GrMaxX()/4, GrMaxY()/4, GrMaxY()/4, 300, 3000, GR_ARC_STYLE_OPEN, ptt);
    GrPatAlignFilledCircleArc(GrMaxX()/2, 0, 3*GrMaxX()/4, GrMaxY()/4, GrMaxY()/4, 0, 2000, GR_ARC_STYLE_CLOSE2, ptt);
    GrPatAlignFilledCircleArc(0, GrMaxY()/2, GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4, 0, 3000, GR_ARC_STYLE_CLOSE2, ptt);
    GrPatAlignFilledCircleArc(GrMaxX()/2, GrMaxY()/2, 3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4, 600, 3000, GR_ARC_STYLE_CLOSE1, ptt);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatAlignFilledCircleArc in subcontext")) return;


    GrSetContext( NULL );
    GrClearContext(GrBlack());
    
    GrPatternFilledEllipseArc(GrMaxX()/4, GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, 300, 3000, GR_ARC_STYLE_OPEN, ptt);
    GrPatternFilledEllipseArc(3*GrMaxX()/4, GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, 0, 2000, GR_ARC_STYLE_CLOSE2, ptt);
    GrPatternFilledEllipseArc(GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, 0, 3000, GR_ARC_STYLE_CLOSE2, ptt);
    GrPatternFilledEllipseArc(3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, 600, 3000, GR_ARC_STYLE_CLOSE1, ptt);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternFilledEllipseArc")) return;


    GrPatAlignFilledEllipseArc(0, 0, GrMaxX()/4, GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, 300, 3000, GR_ARC_STYLE_OPEN, ptt);
    GrPatAlignFilledEllipseArc(GrMaxX()/2, 0, 3*GrMaxX()/4, GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, 0, 2000, GR_ARC_STYLE_CLOSE2, ptt);
    GrPatAlignFilledEllipseArc(0, GrMaxY()/2, GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, 0, 3000, GR_ARC_STYLE_CLOSE2, ptt);
    GrPatAlignFilledEllipseArc(GrMaxX()/2, GrMaxY()/2, 3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, 600, 3000, GR_ARC_STYLE_CLOSE1, ptt);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatAlignFilledEllipseArc")) return;


    GrClearContext(GrBlack());
    GrSetContext(sctx);

    GrPatternFilledEllipseArc(GrMaxX()/4, GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, 300, 3000, GR_ARC_STYLE_OPEN, ptt);
    GrPatternFilledEllipseArc(3*GrMaxX()/4, GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, 0, 2000, GR_ARC_STYLE_CLOSE2, ptt);
    GrPatternFilledEllipseArc(GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, 0, 3000, GR_ARC_STYLE_CLOSE2, ptt);
    GrPatternFilledEllipseArc(3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, 600, 3000, GR_ARC_STYLE_CLOSE1, ptt);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternFilledEllipseArc in subcontext")) return;


    GrPatAlignFilledEllipseArc(0, 0, GrMaxX()/4, GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, 300, 3000, GR_ARC_STYLE_OPEN, ptt);
    GrPatAlignFilledEllipseArc(GrMaxX()/2, 0, 3*GrMaxX()/4, GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, 0, 2000, GR_ARC_STYLE_CLOSE2, ptt);
    GrPatAlignFilledEllipseArc(0, GrMaxY()/2, GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, 0, 3000, GR_ARC_STYLE_CLOSE2, ptt);
    GrPatAlignFilledEllipseArc(GrMaxX()/2, GrMaxY()/2, 3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4, GrMaxY()/4, 600, 3000, GR_ARC_STYLE_CLOSE1, ptt);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatAlignFilledEllipseArc in subcontext")) return;


    GrSetContext( NULL );
    GrClearContext(GrBlack());

    GrBox(20, 20, GrMaxX()-20, GrMaxY()-20, GrWhite());
    GrPatAlignFloodFill(0, 0, 80, 80, GrWhite(), ptt);
    if (printandwait("GrPatAlignFloodFill 0, 0")) return;

    GrPatAlignFloodFill(12, 12, 80, 80, GrWhite(), ptt);
    if (printandwait("GrPatAlignFloodFill 12, 12")) return;

    GrPatAlignFloodFill(92, 92, 80, 80, GrWhite(), ptt);
    if (printandwait("GrPatAlignFloodFill 92, 92")) return;


    GrClearContext(GrBlack());
    GrSetContext(sctx);

    GrBox(20, 20, GrMaxX()-20, GrMaxY()-20, GrWhite());
    GrPatAlignFloodFill(0, 0, 80, 80, GrWhite(), ptt);
    if (printandwait("GrPatAlignFloodFill 0, 0 in subcontext")) return;

    GrPatAlignFloodFill(12, 12, 80, 80, GrWhite(), ptt);
    if (printandwait("GrPatAlignFloodFill 12, 12 in subcontext")) return;

    GrPatAlignFloodFill(92, 92, 80, 80, GrWhite(), ptt);
    if (printandwait("GrPatAlignFloodFill 92, 92 in subcontext")) return;


    lo.lno_color = GrNOCOLOR;
    lo.lno_width = LWH;
    lo.lno_pattlen = 0;
    glp.lnp_pattern = ptt;
    glp.lnp_option = &lo;
    GrSetContext( NULL );
    GrClearContext(GrBlack());

    GrPatternedLine(0, 0, GrMaxX()/2, GrMaxY()/2, &glp);
    GrPatternedLine(0, GrMaxY()/2, GrMaxX()/2, GrMaxY(), &glp);
    GrPatternedLine(GrMaxX()/2, 0, GrMaxX(), GrMaxY()/2, &glp);
    GrPatternedLine(GrMaxX()/2, GrMaxY()/2, GrMaxX(), GrMaxY(), &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternedLine")) return;


    GrPatndAlignLine(0, 0, 0, 0, GrMaxX()/2, GrMaxY()/2, &glp);
    GrPatndAlignLine(0, GrMaxY()/2, 0, GrMaxY()/2, GrMaxX()/2, GrMaxY(), &glp);
    GrPatndAlignLine(GrMaxX()/2, 0, GrMaxX()/2, 0, GrMaxX(), GrMaxY()/2, &glp);
    GrPatndAlignLine(GrMaxX()/2, GrMaxY()/2, GrMaxX()/2, GrMaxY()/2, GrMaxX(), GrMaxY(), &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatndAlignLine")) return;


    GrClearContext(GrBlack());
    GrSetContext(sctx);

    GrPatternedLine(0, 0, GrMaxX()/2, GrMaxY()/2, &glp);
    GrPatternedLine(0, GrMaxY()/2, GrMaxX()/2, GrMaxY(), &glp);
    GrPatternedLine(GrMaxX()/2, 0, GrMaxX(), GrMaxY()/2, &glp);
    GrPatternedLine(GrMaxX()/2, GrMaxY()/2, GrMaxX(), GrMaxY(), &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternedLine in subcontext")) return;


    GrPatndAlignLine(0, 0, 0, 0, GrMaxX()/2, GrMaxY()/2, &glp);
    GrPatndAlignLine(0, GrMaxY()/2, 0, GrMaxY()/2, GrMaxX()/2, GrMaxY(), &glp);
    GrPatndAlignLine(GrMaxX()/2, 0, GrMaxX()/2, 0, GrMaxX(), GrMaxY()/2, &glp);
    GrPatndAlignLine(GrMaxX()/2, GrMaxY()/2, GrMaxX()/2, GrMaxY()/2, GrMaxX(), GrMaxY(), &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatndAlignLine in subcontext")) return;


    GrSetContext( NULL );
    GrClearContext(GrBlack());

    GrPatternedBox(LWH2, LWH2, GrMaxX()/2-LWH2, GrMaxY()/2-LWH2, &glp);
    GrPatternedBox(LWH2, GrMaxY()/2+LWH2, GrMaxX()/2-LWH2, GrMaxY()-LWH2, &glp);
    GrPatternedBox(GrMaxX()/2+LWH2, LWH2, GrMaxX()-LWH2, GrMaxY()/2-LWH2, &glp);
    GrPatternedBox(GrMaxX()/2+LWH2, GrMaxY()/2+LWH2, GrMaxX()-LWH2, GrMaxY()-LWH2, &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternedBox")) return;


    GrPatndAlignBox(0, 0, LWH2, LWH2, GrMaxX()/2-LWH2, GrMaxY()/2-LWH2, &glp);
    GrPatndAlignBox(0, GrMaxY()/2, LWH2, GrMaxY()/2+LWH2, GrMaxX()/2-LWH2, GrMaxY()-LWH2, &glp);
    GrPatndAlignBox(GrMaxX()/2, 0, GrMaxX()/2+LWH2, LWH2, GrMaxX()-LWH2, GrMaxY()/2-LWH2, &glp);
    GrPatndAlignBox(GrMaxX()/2, GrMaxY()/2, GrMaxX()/2+LWH2, GrMaxY()/2+LWH2, GrMaxX()-LWH2, GrMaxY()-LWH2, &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatndAlignBox")) return;


    GrClearContext(GrBlack());
    GrSetContext(sctx);

    GrPatternedBox(LWH2, LWH2, GrMaxX()/2-LWH2, GrMaxY()/2-LWH2, &glp);
    GrPatternedBox(LWH2, GrMaxY()/2+LWH2, GrMaxX()/2-LWH2, GrMaxY()-LWH2, &glp);
    GrPatternedBox(GrMaxX()/2+LWH2, LWH2, GrMaxX()-LWH2, GrMaxY()/2-LWH2, &glp);
    GrPatternedBox(GrMaxX()/2+LWH2, GrMaxY()/2+LWH2, GrMaxX()-LWH2, GrMaxY()-LWH2, &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternedBox in subcontext")) return;


    GrPatndAlignBox(0, 0, LWH2, LWH2, GrMaxX()/2-LWH2, GrMaxY()/2-LWH2, &glp);
    GrPatndAlignBox(0, GrMaxY()/2, LWH2, GrMaxY()/2+LWH2, GrMaxX()/2-LWH2, GrMaxY()-LWH2, &glp);
    GrPatndAlignBox(GrMaxX()/2, 0, GrMaxX()/2+LWH2, LWH2, GrMaxX()-LWH2, GrMaxY()/2-LWH2, &glp);
    GrPatndAlignBox(GrMaxX()/2, GrMaxY()/2, GrMaxX()/2+LWH2, GrMaxY()/2+LWH2, GrMaxX()-LWH2, GrMaxY()-LWH2, &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatndAlignBox in subcontext")) return;


    GrSetContext( NULL );
    GrClearContext(GrBlack());
    
    GrPatternedCircle(GrMaxX()/4, GrMaxY()/4, GrMaxY()/4-LWH2, &glp);
    GrPatternedCircle(3*GrMaxX()/4, GrMaxY()/4, GrMaxY()/4-LWH2, &glp);
    GrPatternedCircle(GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4-LWH2, &glp);
    GrPatternedCircle(3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4-LWH2, &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternedCircle")) return;


    GrPatndAlignCircle(0, 0, GrMaxX()/4, GrMaxY()/4, GrMaxY()/4-LWH2, &glp);
    GrPatndAlignCircle(GrMaxX()/2, 0, 3*GrMaxX()/4, GrMaxY()/4, GrMaxY()/4-LWH2, &glp);
    GrPatndAlignCircle(0, GrMaxY()/2, GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4-LWH2, &glp);
    GrPatndAlignCircle(GrMaxX()/2, GrMaxY()/2, 3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4-LWH2, &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatndAlignCircle")) return;


    GrClearContext(GrBlack());
    GrSetContext(sctx);

    GrPatternedCircle(GrMaxX()/4, GrMaxY()/4, GrMaxY()/4-LWH2, &glp);
    GrPatternedCircle(3*GrMaxX()/4, GrMaxY()/4, GrMaxY()/4-LWH2, &glp);
    GrPatternedCircle(GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4-LWH2, &glp);
    GrPatternedCircle(3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4-LWH2, &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternedCircle in subcontext")) return;


    GrPatndAlignCircle(0, 0, GrMaxX()/4, GrMaxY()/4, GrMaxY()/4-LWH2, &glp);
    GrPatndAlignCircle(GrMaxX()/2, 0, 3*GrMaxX()/4, GrMaxY()/4, GrMaxY()/4-LWH2, &glp);
    GrPatndAlignCircle(0, GrMaxY()/2, GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4-LWH2, &glp);
    GrPatndAlignCircle(GrMaxX()/2, GrMaxY()/2, 3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4-LWH2, &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatndAlignCircle in subcontext")) return;


    GrSetContext( NULL );
    GrClearContext(GrBlack());
    
    GrPatternedEllipse(GrMaxX()/4, GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, &glp);
    GrPatternedEllipse(3*GrMaxX()/4, GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, &glp);
    GrPatternedEllipse(GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, &glp);
    GrPatternedEllipse(3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternedEllipse")) return;


    GrPatndAlignEllipse(0, 0, GrMaxX()/4, GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, &glp);
    GrPatndAlignEllipse(GrMaxX()/2, 0, 3*GrMaxX()/4, GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, &glp);
    GrPatndAlignEllipse(0, GrMaxY()/2, GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, &glp);
    GrPatndAlignEllipse(GrMaxX()/2, GrMaxY()/2, 3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatndAlignEllipse")) return;


    GrClearContext(GrBlack());
    GrSetContext(sctx);

    GrPatternedEllipse(GrMaxX()/4, GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, &glp);
    GrPatternedEllipse(3*GrMaxX()/4, GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, &glp);
    GrPatternedEllipse(GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, &glp);
    GrPatternedEllipse(3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternedEllipse in subcontext")) return;


    GrPatndAlignEllipse(0, 0, GrMaxX()/4, GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, &glp);
    GrPatndAlignEllipse(GrMaxX()/2, 0, 3*GrMaxX()/4, GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, &glp);
    GrPatndAlignEllipse(0, GrMaxY()/2, GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, &glp);
    GrPatndAlignEllipse(GrMaxX()/2, GrMaxY()/2, 3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatndAlignEllipse in subcontext")) return;


    GrSetContext( NULL );
    GrClearContext(GrBlack());

    gentriangle2(ptri, 0, GrMaxY()/2);
    GrPatternedPolygon(3, ptri, &glp);
    gentriangle2(ptri, GrMaxX()/2, GrMaxY()/2);
    GrPatternedPolygon(3, ptri, &glp);
    gentriangle2(ptri, 0, GrMaxY());
    GrPatternedPolygon(3, ptri, &glp);
    gentriangle2(ptri, GrMaxX()/2, GrMaxY());
    GrPatternedPolygon(3, ptri, &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternedPolygon")) return;


    gentriangle2(ptri, 0, GrMaxY()/2);
    GrPatndAlignPolygon(0, 0, 3, ptri, &glp);
    gentriangle2(ptri, GrMaxX()/2, GrMaxY()/2);
    GrPatndAlignPolygon(GrMaxX()/2, 0, 3, ptri, &glp);
    gentriangle2(ptri, 0, GrMaxY());
    GrPatndAlignPolygon(0, GrMaxY()/2, 3, ptri, &glp);
    gentriangle2(ptri, GrMaxX()/2, GrMaxY());
    GrPatndAlignPolygon(GrMaxX()/2, GrMaxY()/2, 3, ptri, &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatndAlignPolygon")) return;


    GrClearContext(GrBlack());
    GrSetContext(sctx);

    gentriangle2(ptri, 0, GrMaxY()/2);
    GrPatternedPolygon(3, ptri, &glp);
    gentriangle2(ptri, GrMaxX()/2, GrMaxY()/2);
    GrPatternedPolygon(3, ptri, &glp);
    gentriangle2(ptri, 0, GrMaxY());
    GrPatternedPolygon(3, ptri, &glp);
    gentriangle2(ptri, GrMaxX()/2, GrMaxY());
    GrPatternedPolygon(3, ptri, &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternedPolygon in subcontext")) return;


    gentriangle2(ptri, 0, GrMaxY()/2);
    GrPatndAlignPolygon(0, 0, 3, ptri, &glp);
    gentriangle2(ptri, GrMaxX()/2, GrMaxY()/2);
    GrPatndAlignPolygon(GrMaxX()/2, 0, 3, ptri, &glp);
    gentriangle2(ptri, 0, GrMaxY());
    GrPatndAlignPolygon(0, GrMaxY()/2, 3, ptri, &glp);
    gentriangle2(ptri, GrMaxX()/2, GrMaxY());
    GrPatndAlignPolygon(GrMaxX()/2, GrMaxY()/2, 3, ptri, &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatndAlignPolygon in subcontext")) return;


    GrSetContext( NULL );
    GrClearContext(GrBlack());

    genstar2(pstar, 0, GrMaxY()/2);
    GrPatternedPolyLine(5, pstar, &glp);
    genstar2(pstar, GrMaxX()/2, GrMaxY()/2);
    GrPatternedPolyLine(5, pstar, &glp);
    genstar2(pstar, 0, GrMaxY());
    GrPatternedPolyLine(5, pstar, &glp);
    genstar2(pstar, GrMaxX()/2, GrMaxY());
    GrPatternedPolyLine(5, pstar, &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternedPolyLine")) return;


    genstar2(pstar, 0, GrMaxY()/2);
    GrPatndAlignPolyLine(0, 0, 5, pstar, &glp);
    genstar2(pstar, GrMaxX()/2, GrMaxY()/2);
    GrPatndAlignPolyLine(GrMaxX()/2, 0, 5, pstar, &glp);
    genstar2(pstar, 0, GrMaxY());
    GrPatndAlignPolyLine(0, GrMaxY()/2, 5, pstar, &glp);
    genstar2(pstar, GrMaxX()/2, GrMaxY());
    GrPatndAlignPolyLine(GrMaxX()/2, GrMaxY()/2, 5, pstar, &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatndAlignPolyLine")) return;


    GrClearContext(GrBlack());
    GrSetContext(sctx);

    genstar2(pstar, 0, GrMaxY()/2);
    GrPatternedPolyLine(5, pstar, &glp);
    genstar2(pstar, GrMaxX()/2, GrMaxY()/2);
    GrPatternedPolyLine(5, pstar, &glp);
    genstar2(pstar, 0, GrMaxY());
    GrPatternedPolyLine(5, pstar, &glp);
    genstar2(pstar, GrMaxX()/2, GrMaxY());
    GrPatternedPolyLine(5, pstar, &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternedPolyLine in subcontext")) return;


    genstar2(pstar, 0, GrMaxY()/2);
    GrPatndAlignPolyLine(0, 0, 5, pstar, &glp);
    genstar2(pstar, GrMaxX()/2, GrMaxY()/2);
    GrPatndAlignPolyLine(GrMaxX()/2, 0, 5, pstar, &glp);
    genstar2(pstar, 0, GrMaxY());
    GrPatndAlignPolyLine(0, GrMaxY()/2, 5, pstar, &glp);
    genstar2(pstar, GrMaxX()/2, GrMaxY());
    GrPatndAlignPolyLine(GrMaxX()/2, GrMaxY()/2, 5, pstar, &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatndAlignPolyLine in subcontext")) return;


    GrSetContext( NULL );
    GrClearContext(GrBlack());
    
    GrPatternedCircleArc(GrMaxX()/4, GrMaxY()/4, GrMaxY()/4-LWH2, 300, 3000, GR_ARC_STYLE_OPEN, &glp);
    GrPatternedCircleArc(3*GrMaxX()/4, GrMaxY()/4, GrMaxY()/4-LWH2, 0, 2000, GR_ARC_STYLE_CLOSE2, &glp);
    GrPatternedCircleArc(GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4-LWH2, 0, 3000, GR_ARC_STYLE_CLOSE2, &glp);
    GrPatternedCircleArc(3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4-LWH2, 600, 3000, GR_ARC_STYLE_CLOSE1, &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternedCircleArc")) return;


    GrPatndAlignCircleArc(0, 0, GrMaxX()/4, GrMaxY()/4, GrMaxY()/4-LWH2, 300, 3000, GR_ARC_STYLE_OPEN, &glp);
    GrPatndAlignCircleArc(GrMaxX()/2, 0, 3*GrMaxX()/4, GrMaxY()/4, GrMaxY()/4-LWH2, 0, 2000, GR_ARC_STYLE_CLOSE2, &glp);
    GrPatndAlignCircleArc(0, GrMaxY()/2, GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4-LWH2, 0, 3000, GR_ARC_STYLE_CLOSE2, &glp);
    GrPatndAlignCircleArc(GrMaxX()/2, GrMaxY()/2, 3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4-LWH2, 600, 3000, GR_ARC_STYLE_CLOSE1, &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatndAlignCircleArc")) return;


    GrClearContext(GrBlack());
    GrSetContext(sctx);

    GrPatternedCircleArc(GrMaxX()/4, GrMaxY()/4, GrMaxY()/4-LWH2, 300, 3000, GR_ARC_STYLE_OPEN, &glp);
    GrPatternedCircleArc(3*GrMaxX()/4, GrMaxY()/4, GrMaxY()/4-LWH2, 0, 2000, GR_ARC_STYLE_CLOSE2, &glp);
    GrPatternedCircleArc(GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4-LWH2, 0, 3000, GR_ARC_STYLE_CLOSE2, &glp);
    GrPatternedCircleArc(3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4-LWH2, 600, 3000, GR_ARC_STYLE_CLOSE1, &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternedCircleArc in subcontext")) return;


    GrPatndAlignCircleArc(0, 0, GrMaxX()/4, GrMaxY()/4, GrMaxY()/4-LWH2, 300, 3000, GR_ARC_STYLE_OPEN, &glp);
    GrPatndAlignCircleArc(GrMaxX()/2, 0, 3*GrMaxX()/4, GrMaxY()/4, GrMaxY()/4-LWH2, 0, 2000, GR_ARC_STYLE_CLOSE2, &glp);
    GrPatndAlignCircleArc(0, GrMaxY()/2, GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4-LWH2, 0, 3000, GR_ARC_STYLE_CLOSE2, &glp);
    GrPatndAlignCircleArc(GrMaxX()/2, GrMaxY()/2, 3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxY()/4-LWH2, 600, 3000, GR_ARC_STYLE_CLOSE1, &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatndAlignCircleArc in subcontext")) return;


    GrSetContext( NULL );
    GrClearContext(GrBlack());
    
    GrPatternedEllipseArc(GrMaxX()/4, GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, 300, 3000, GR_ARC_STYLE_OPEN, &glp);
    GrPatternedEllipseArc(3*GrMaxX()/4, GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, 0, 2000, GR_ARC_STYLE_CLOSE2, &glp);
    GrPatternedEllipseArc(GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, 0, 3000, GR_ARC_STYLE_CLOSE2, &glp);
    GrPatternedEllipseArc(3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, 600, 3000, GR_ARC_STYLE_CLOSE1, &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternedEllipseArc")) return;


    GrPatndAlignEllipseArc(0, 0, GrMaxX()/4, GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, 300, 3000, GR_ARC_STYLE_OPEN, &glp);
    GrPatndAlignEllipseArc(GrMaxX()/2, 0, 3*GrMaxX()/4, GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, 0, 2000, GR_ARC_STYLE_CLOSE2, &glp);
    GrPatndAlignEllipseArc(0, GrMaxY()/2, GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, 0, 3000, GR_ARC_STYLE_CLOSE2, &glp);
    GrPatndAlignEllipseArc(GrMaxX()/2, GrMaxY()/2, 3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, 600, 3000, GR_ARC_STYLE_CLOSE1, &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatndAlignEllipseArc")) return;


    GrClearContext(GrBlack());
    GrSetContext(sctx);

    GrPatternedEllipseArc(GrMaxX()/4, GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, 300, 3000, GR_ARC_STYLE_OPEN, &glp);
    GrPatternedEllipseArc(3*GrMaxX()/4, GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, 0, 2000, GR_ARC_STYLE_CLOSE2, &glp);
    GrPatternedEllipseArc(GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, 0, 3000, GR_ARC_STYLE_CLOSE2, &glp);
    GrPatternedEllipseArc(3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, 600, 3000, GR_ARC_STYLE_CLOSE1, &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatternedEllipseArc in subcontext")) return;


    GrPatndAlignEllipseArc(0, 0, GrMaxX()/4, GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, 300, 3000, GR_ARC_STYLE_OPEN, &glp);
    GrPatndAlignEllipseArc(GrMaxX()/2, 0, 3*GrMaxX()/4, GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, 0, 2000, GR_ARC_STYLE_CLOSE2, &glp);
    GrPatndAlignEllipseArc(0, GrMaxY()/2, GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, 0, 3000, GR_ARC_STYLE_CLOSE2, &glp);
    GrPatndAlignEllipseArc(GrMaxX()/2, GrMaxY()/2, 3*GrMaxX()/4, 3*GrMaxY()/4, GrMaxX()/4-LWH2, GrMaxY()/4-LWH2, 600, 3000, GR_ARC_STYLE_CLOSE1, &glp);
    GrHLine(0, GrMaxX(), GrMaxY()/2, GrWhite());
    GrVLine(GrMaxX()/2, 0, GrMaxY(), GrWhite());
    if (printandwait("GrPatndAlignEllipseArc in subcontext")) return;
}

int main(int argc, char **argv)
{
    unsigned char bmpdata[8] = {0x00, 0x7E, 0x82, 0x82, 0x82, 0x82, 0x7E, 0x00};
    GrBitmap bm1 = {0, 8, NULL, 0, 0, 0};
    GrPattern *pm1 = NULL;
    GrPattern *lg1 = NULL;
    GrPattern *rg1 = NULL;

    int w, h, maxval;
    GrContext *pm1_ctx = NULL;
    GrContext *sct1 = NULL;
    GrEvent ev;

    if (argc >= 4) {
        gwidth = atoi(argv[1]);
        gheight = atoi(argv[2]);
        gbpp = atoi(argv[3]);
    }

    GrSetMode(GR_width_height_bpp_graphics, gwidth, gheight, gbpp);
    GrSetRGBcolorMode();
    GrEventInit();
    GrMouseDisplayCursor();
    GrSetDefaultFont(&GrFont_PX8x18);

    bm1.bmp_fgcolor = GrWhite();
    bm1.bmp_bgcolor = GrBlack();
    bm1.bmp_data = (char *)bmpdata;

    if (GrQueryPnmBuffer((char *)leaves_pat, &w, &h, &maxval) < 1) goto end;
    pm1_ctx = GrCreateContext(w, h, NULL, NULL);
    if (pm1_ctx == NULL) goto end;
    if (GrLoadContextFromPnmBuffer(pm1_ctx, (char *)leaves_pat) < 0) goto end;
    pm1 = GrConvertToPixmap(pm1_ctx);
    if (pm1 == NULL) goto end;

    lg1 = GrCreateLinGradient(0, GrMaxY(), GrMaxX(), 0);
    if (lg1 == NULL) goto end;
    GrAddGradientStop(lg1, 0, GrAllocColor(255, 0, 0));
    GrAddGradientStop(lg1, 80, GrAllocColor(0, 255, 0));
    GrAddGradientStop(lg1, 100, GrAllocColor(0, 255, 0));
    GrAddGradientStop(lg1, 200, GrAllocColor(0, 0, 255));
    GrAddGradientStop(lg1, 255, GrAllocColor(0, 255, 255));
    GrGenGradientColorTbl(lg1);

    rg1 = GrCreateRadGradient(GrMaxX()/2, GrMaxY()/2, GrMaxX()/2);
    if (rg1 == NULL) goto end;
    GrAddGradientStop(rg1, 0, GrAllocColor(255, 0, 0));
    GrAddGradientStop(rg1, 128, GrAllocColor(0, 0, 255));
    GrAddGradientStop(rg1, 255, GrAllocColor(0, 255, 0));
    GrGenGradientColorTbl(rg1);

    sct1 = GrCreateSubContext(GrMaxX()/4, GrMaxY()/4, 3*GrMaxX()/4, 3*GrMaxY()/4, NULL, NULL);
    if (sct1 == NULL) goto end;

    while (1) {
        GrSetContext( NULL );
        GrClearContext(GrBlack());
        GrTextXY(10, 10, "Select one option:", GrWhite(), GrBlack());
        GrTextXY(10, 30, "  1 Bitmap", GrWhite(), GrBlack());
        GrTextXY(10, 50, "  2 Pixmap", GrWhite(), GrBlack());
        GrTextXY(10, 70, "  3 Linear gradient", GrWhite(), GrBlack());
        GrTextXY(10, 90, "  4 Radial gradient", GrWhite(), GrBlack());
        GrTextXY(10, 110, "any other key to finish", GrWhite(), GrBlack());
        GrTextXY(10, 150, "during test press 'q' to return", GrWhite(), GrBlack());
        GrTextXY(10, 170, "any other key to continue", GrWhite(), GrBlack());
        if (GrNumColors() < 256) {
            GrTextXY(10, 210, "8bpp or more is needed to run options 3 & 4",
                     GrBlack(), GrWhite());
        }
        GrEventWait(&ev);
        if (ev.type == GREV_KEY && ev.p1 == '1')
            dotest((GrPattern *)&bm1, sct1);
        else if (ev.type == GREV_KEY && ev.p1 == '2')
            dotest(pm1, sct1);
        else if (ev.type == GREV_KEY && ev.p1 == '3') {
            if (GrNumColors() >= 256)
                dotest(lg1, sct1);
        } else if (ev.type == GREV_KEY && ev.p1 == '4') {
            if (GrNumColors() >= 256)
                dotest(rg1, sct1);
        } else
            break;
    }

end:
    if (pm1) GrDestroyPattern(pm1);
    if (rg1) GrDestroyPattern(rg1);
    if (lg1) GrDestroyPattern(lg1);
    if (sct1) GrDestroyContext(sct1);
    if (pm1_ctx) GrDestroyContext(pm1_ctx);

    GrEventUnInit();
    GrSetMode(GR_default_text);
    return 0;
}
