/*
 * Copyright (c) 2001-2006 MUSIC TECHNOLOGY GROUP (MTG)
 *                         UNIVERSITAT POMPEU FABRA
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <QtGui/QPainter>
#include <QtGui/QResizeEvent>
#include "vmColorScale.hxx"

namespace CLAM
{
    namespace VM
    {
		ColorScale::ColorScale(QWidget* parent)
			: QWidget(parent)
		{
			InitColorScale();
		}

		ColorScale::~ColorScale()
		{
		}

		void ColorScale::SetScale(const std::vector<QColor>& scale)
		{
			mScale = scale;
			update();
		}
	    
		void ColorScale::paintEvent(QPaintEvent* e)
		{
			if(!mScale.size())
			{
				QWidget::paintEvent(e);
				return;
			}

			QPainter painter(this);
			for(unsigned i = 0; i < mScale.size(); i++)
			{
				painter.setPen(mScale[i]);
				painter.drawLine(int(i),rect().bottom(),i,rect().top());
			}
		}

		void ColorScale::resizeEvent(QResizeEvent* e)
		{
			emit widthChanged(e->size().width());
		}

		void ColorScale::InitColorScale()
		{
			setFixedHeight(20);
			setMinimumWidth(151);
			setMaximumWidth(302);
		}		
    }
}

// END

