/*
 *  error.h
 *  
 *  This file is part of the WFA compression project
 *  Copyright (C) 1994-1998 Ullrich Hafner <hafner@bigfoot.de>,
 *                          department of computer science, chair II 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 */

/*
 *  $Date: 1999/04/21 05:55:08 $
 *  $Author: hafner $
 *  $Revision: 1.13 $
 *  $State: Exp $
 */

#ifndef _ERROR_H
#define _ERROR_H

/* I18n */
#include <libintl.h>
#define  _(string)	gettext(string)
#define  D_(string)     dgettext ("wmakerconf-data", string)
#define  N_(string)	(string)
/* I18n */

#define error     error_line=__LINE__,error_file=__FILE__,_error
#define warning   error_line=__LINE__,error_file=__FILE__,_warning
#define MAXSTRLEN 1024

#undef NO
#undef YES
#undef TRUE
#undef FALSE

enum boolean {NO = 0, FALSE = 0, YES = 1, TRUE = 1};
enum verbosity {NOVERBOSITY, SOMEVERBOSITY, ULTIMATEVERBOSITY};

#ifdef _ERROR_C
int	error_line;
char	*error_file;
enum verbosity verboselevel;
#else  /* not _ERROR_C */
extern int	error_line;
extern char	*error_file;
extern enum verbosity verboselevel;
#endif /* not _ERROR_H */

void
message (const char *format, ...);
void
_error (const char *format, ...);
void
_warning (const char *format, ...);

#if HAVE_ASSERT_H
#	include <assert.h>
#else /* not HAVE_ASSERT_H */
#	define assert(exp)	{if (!(exp)) error ("Assertion `" #exp " != NULL' failed.");}
#endif /* not HAVE_ASSERT_H */

#endif /* not _ERROR_H */

