/*
 * Decompiled with CFR 0.152.
 */
package jpen.demo;

import java.util.EnumMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JTextField;
import jpen.PScroll;
import jpen.PScrollEvent;
import jpen.Pen;
import jpen.demo.DataDisplay;
import jpen.demo.Utils;
import jpen.event.PenAdapter;

class ScrollsPanel {
    private final Map<PScroll.Type, Display> scrollTypeToDisplay = new EnumMap<PScroll.Type, Display>(PScroll.Type.class);
    Box panel;

    ScrollsPanel(Pen pen) {
        for (PScroll.Type scrollType : PScroll.Type.VALUES) {
            this.scrollTypeToDisplay.put(scrollType, new Display());
        }
        this.panel = Box.createVerticalBox();
        for (PScroll.Type scrollType : PScroll.Type.VALUES) {
            this.panel.add(Utils.labelComponent(scrollType.toString(), this.scrollTypeToDisplay.get((Object)((Object)scrollType)).component));
        }
        pen.addListener(new PenAdapter(){
            private Pen pen;

            public void penScrollEvent(PScrollEvent ev) {
                this.pen = ev.pen;
                Display display = (Display)ScrollsPanel.this.scrollTypeToDisplay.get(ev.scroll.getType());
                if (display != null) {
                    display.increase((Integer)ev.scroll.value);
                }
            }

            public void penTock(long availableMillis) {
                if (this.pen == null) {
                    return;
                }
                for (Display display : ScrollsPanel.this.scrollTypeToDisplay.values()) {
                    display.update(this.pen);
                }
                this.pen = null;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Display
    extends DataDisplay<JTextField> {
        private int value = 0;

        Display() {
            super(new JTextField(3));
            ((JTextField)this.component).setHorizontalAlignment(4);
            ((JTextField)this.component).setEditable(false);
        }

        @Override
        void updateImp(Pen pen) {
            ((JTextField)this.component).setText(String.valueOf(this.value));
        }

        void increase(int value) {
            this.value += value;
            this.setIsDirty(true);
        }
    }
}

