/*
 * Decompiled with CFR 0.152.
 */
package jpen.owner.awt;

import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;

class ActiveWindow
implements PropertyChangeListener,
Runnable {
    private final Listener listener;
    private final KeyboardFocusManager keyboardFocusManager;
    private Window activeWindow;
    private final ScheduledExecutorService nullWindowScheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        public Thread newThread(Runnable runnable) {
            Thread t = new Thread(runnable, "jpen-ActiveWindow-filter");
            t.setDaemon(true);
            return t;
        }
    });
    private ScheduledFuture nullWindowTask;
    private final Runnable nullWindowRunnable = new Runnable(){

        public void run() {
            ActiveWindow.this.setActiveWindow(null);
        }
    };

    ActiveWindow(Listener listener) {
        this.listener = listener;
        this.keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.keyboardFocusManager.addPropertyChangeListener("activeWindow", this);
    }

    public void propertyChange(PropertyChangeEvent ev) {
        Window activeWindow = (Window)ev.getNewValue();
        if (activeWindow == null) {
            if (this.nullWindowTask == null || this.nullWindowTask.isDone()) {
                this.nullWindowTask = this.nullWindowScheduler.schedule(this, 50L, TimeUnit.MILLISECONDS);
            }
            return;
        }
        if (this.activeWindow == activeWindow) {
            return;
        }
        if (this.nullWindowTask != null) {
            this.nullWindowTask.cancel(false);
        }
        this.setActiveWindow(activeWindow);
    }

    public void run() {
        try {
            SwingUtilities.invokeAndWait(this.nullWindowRunnable);
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private synchronized void setActiveWindow(Window activeWindow) {
        this.activeWindow = activeWindow;
        this.listener.activeWindowChanged(activeWindow);
    }

    static interface Listener {
        public void activeWindowChanged(Window var1);
    }
}

