/*
 * Decompiled with CFR 0.152.
 */
package jpen.owner.awt;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.SwingUtilities;
import jpen.PenProvider;
import jpen.owner.AbstractPenOwner;
import jpen.owner.PenClip;
import jpen.owner.awt.ActiveWindow;
import jpen.owner.awt.PenClipOnComponent;
import jpen.provider.osx.CocoaProvider;
import jpen.provider.system.SystemProvider;
import jpen.provider.wintab.WintabProvider;
import jpen.provider.xinput.XinputProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AwtPenOwner
extends AbstractPenOwner {
    public final Component component;
    final PenClipOnComponent penClipOnComponent;
    private final MouseListener mouseListener = new MouseAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseExited(MouseEvent ev) {
            Object object = AwtPenOwner.this.penManagerHandle.getPenSchedulerLock();
            synchronized (object) {
                if (!AwtPenOwner.this.startDraggingOut()) {
                    AwtPenOwner.this.pause();
                    AwtPenOwner.this.unpauser.disable();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseEntered(MouseEvent ev) {
            Object object = AwtPenOwner.this.penManagerHandle.getPenSchedulerLock();
            synchronized (object) {
                if (!AwtPenOwner.this.stopDraggingOut()) {
                    AwtPenOwner.this.unpauser.enable();
                }
            }
        }
    };
    Unpauser unpauser = new Unpauser();
    private final ActiveWindowListener activeWindowListener = new ActiveWindowListener();

    public AwtPenOwner(Component component) {
        this.component = component;
        this.penClipOnComponent = new PenClipOnComponent(component);
    }

    @Override
    public Collection<PenProvider.Constructor> getPenProviderConstructors() {
        return Arrays.asList(new SystemProvider.Constructor(), new XinputProvider.Constructor(), new WintabProvider.Constructor(), new CocoaProvider.Constructor());
    }

    private void pause() {
        if (this.penManagerHandle.getPenManager().getPaused()) {
            return;
        }
        this.activeWindowListener.setEnabled(false);
        this.penManagerHandle.setPenManagerPaused(true);
    }

    @Override
    public PenClip getPenClip() {
        return this.penClipOnComponent;
    }

    @Override
    protected void init() {
        this.component.addMouseListener(this.mouseListener);
    }

    private class ActiveWindowListener
    implements ActiveWindow.Listener {
        private boolean enabled;
        private ActiveWindow activeWindow;

        private ActiveWindowListener() {
        }

        void setEnabled(boolean enabled) {
            if (this.activeWindow == null) {
                this.activeWindow = new ActiveWindow(this);
            }
            this.enabled = enabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void activeWindowChanged(Window activeWindow) {
            if (!this.enabled) {
                return;
            }
            Object object = AwtPenOwner.this.penManagerHandle.getPenSchedulerLock();
            synchronized (object) {
                Dialog activeDialog;
                if (activeWindow == null) {
                    this.pauseAMoment();
                    return;
                }
                Window componentWindow = SwingUtilities.getWindowAncestor(AwtPenOwner.this.component);
                if (componentWindow == null) {
                    return;
                }
                if (activeWindow != componentWindow && activeWindow instanceof Dialog && (activeDialog = (Dialog)activeWindow).isModal()) {
                    this.pauseAMoment();
                }
            }
        }

        private void pauseAMoment() {
            AwtPenOwner.this.pause();
            AwtPenOwner.this.unpauser.enable();
        }
    }

    final class Unpauser
    implements MouseMotionListener {
        private volatile boolean enabled;

        Unpauser() {
        }

        void enable() {
            if (this.enabled) {
                return;
            }
            AwtPenOwner.this.component.addMouseMotionListener(AwtPenOwner.this.unpauser);
            this.enabled = true;
        }

        void disable() {
            if (!this.enabled) {
                return;
            }
            AwtPenOwner.this.component.removeMouseMotionListener(AwtPenOwner.this.unpauser);
            this.enabled = false;
        }

        public void mouseMoved(MouseEvent ev) {
            this.unpause();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unpause() {
            Object object = AwtPenOwner.this.penManagerHandle.getPenSchedulerLock();
            synchronized (object) {
                if (!AwtPenOwner.this.penManagerHandle.getPenManager().getPaused()) {
                    return;
                }
                if (this.enabled) {
                    AwtPenOwner.this.activeWindowListener.setEnabled(true);
                    AwtPenOwner.this.penManagerHandle.setPenManagerPaused(false);
                    this.disable();
                }
            }
        }

        public void mouseDragged(MouseEvent ev) {
        }
    }
}

