/*
 * Decompiled with CFR 0.152.
 */
package jpen.provider.osx;

import java.util.EnumMap;
import java.util.Map;
import jpen.PKind;
import jpen.PenManager;
import jpen.PenProvider;
import jpen.Utils;
import jpen.provider.AbstractPenProvider;
import jpen.provider.NativeLibraryLoader;
import jpen.provider.osx.CocoaAccess;
import jpen.provider.osx.CocoaDevice;

public class CocoaProvider
extends AbstractPenProvider {
    private static final NativeLibraryLoader LIB_LOADER = new NativeLibraryLoader(Integer.valueOf(Utils.getModuleProperties().getString("jpen.provider.osx.nativeVersion")));
    private final CocoaAccess cocoaAccess;
    private final Map<PKind.Type, CocoaDevice> deviceMap;

    private CocoaProvider(Constructor _constructor, CocoaAccess _cocoaAccess) {
        super(_constructor);
        this.cocoaAccess = _cocoaAccess;
        this.cocoaAccess.setProvider(this);
        this.deviceMap = new EnumMap<PKind.Type, CocoaDevice>(PKind.Type.class);
        for (PKind.Type type : PKind.Type.VALUES) {
            CocoaDevice device = new CocoaDevice(this, type);
            this.deviceMap.put(type, device);
            this.devices.add(device);
        }
        this.cocoaAccess.start();
    }

    public CocoaDevice getDevice(PKind.Type type) {
        return this.deviceMap.get((Object)type);
    }

    public void penManagerPaused(boolean paused) {
        if (!paused) {
            this.cocoaAccess.enable();
        } else {
            this.cocoaAccess.disable();
        }
    }

    public void dispose() {
        this.cocoaAccess.stop();
    }

    public static class Constructor
    extends AbstractPenProvider.AbstractConstructor {
        public String getName() {
            return "Cocoa";
        }

        public boolean constructable(PenManager penManager) {
            return System.getProperty("os.name").toLowerCase().contains("mac");
        }

        public PenProvider constructProvider() throws Throwable {
            LIB_LOADER.load();
            CocoaAccess cocoaAccess = new CocoaAccess();
            return new CocoaProvider(this, cocoaAccess);
        }

        public int getNativeVersion() {
            return LIB_LOADER.nativeVersion;
        }

        public int getNativeBuild() {
            LIB_LOADER.load();
            return CocoaAccess.getNativeBuild();
        }

        public int getExpectedNativeBuild() {
            return Integer.valueOf(Utils.getModuleProperties().getString("jpen.provider.osx.nativeBuild"));
        }
    }
}

