/*
 * Decompiled with CFR 0.152.
 */
package jpen.provider.wintab;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jpen.PLevel;
import jpen.PenManager;
import jpen.PenProvider;
import jpen.Utils;
import jpen.provider.AbstractPenProvider;
import jpen.provider.NativeLibraryLoader;
import jpen.provider.VirtualScreenBounds;
import jpen.provider.wintab.WintabAccess;
import jpen.provider.wintab.WintabDevice;

public class WintabProvider
extends AbstractPenProvider {
    private static final Logger L = Logger.getLogger(WintabProvider.class.getName());
    public static final int PERIOD = 10;
    private static final NativeLibraryLoader LIB_LOADER = new NativeLibraryLoader(new String[]{""}, new String[]{"64"}, Integer.valueOf(Utils.getModuleProperties().getString("jpen.provider.wintab.nativeVersion")));
    final WintabAccess wintabAccess;
    private final Map<Integer, WintabDevice> cursorToDevice = new HashMap<Integer, WintabDevice>();
    private final PLevel.Range[] levelRanges = new PLevel.Range[PLevel.Type.VALUES.size()];
    final VirtualScreenBounds screenBounds = VirtualScreenBounds.getInstance();
    private final Thread thread;
    private boolean paused = true;

    static void loadLibrary() {
        LIB_LOADER.load();
    }

    private WintabProvider(Constructor constructor, WintabAccess wintabAccess) {
        super(constructor);
        L.fine("start");
        this.wintabAccess = wintabAccess;
        int i = PLevel.Type.VALUES.size();
        while (--i >= 0) {
            PLevel.Type levelType = PLevel.Type.VALUES.get(i);
            this.levelRanges[levelType.ordinal()] = wintabAccess.getLevelRange(levelType);
        }
        this.thread = new Thread("jpen-WintabProvider"){

            private long getPeriod() {
                return 10L;
            }

            public void run() {
                block0: while (true) {
                    WintabProvider.this.processQuedEvents();
                    Utils.synchronizedWait(this, this.getPeriod());
                    while (true) {
                        if (!WintabProvider.this.getPaused()) continue block0;
                        L.fine("going to wait...");
                        Utils.synchronizedWait(this, 0L);
                        L.fine("notified");
                    }
                    break;
                }
            }
        };
        this.thread.setDaemon(true);
        this.thread.setPriority(10);
        this.thread.start();
        L.fine("end");
    }

    PLevel.Range getLevelRange(PLevel.Type type) {
        return this.levelRanges[type.ordinal()];
    }

    private void processQuedEvents() {
        L.finer("start");
        while (this.wintabAccess.nextPacket()) {
            WintabDevice device = this.getDevice(this.wintabAccess.getCursor());
            if (L.isLoggable(Level.FINE)) {
                L.finer("device: ");
                L.finer(device.getName());
            }
            device.scheduleEvents();
        }
        L.finer("end");
    }

    private WintabDevice getDevice(int cursor) {
        WintabDevice wintabDevice = this.cursorToDevice.get(cursor);
        if (wintabDevice == null) {
            wintabDevice = new WintabDevice(this, cursor);
            this.cursorToDevice.put(cursor, wintabDevice);
            this.devices.clear();
            this.devices.addAll(this.cursorToDevice.values());
            this.getPenManager().firePenDeviceAdded(this.getConstructor(), wintabDevice);
        }
        return wintabDevice;
    }

    public void penManagerPaused(boolean paused) {
        this.setPaused(paused);
    }

    private synchronized boolean getPaused() {
        return this.paused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setPaused(boolean paused) {
        L.fine("start");
        if (paused == this.paused) {
            return;
        }
        this.paused = paused;
        if (!paused) {
            L.fine("false paused value");
            this.screenBounds.reset();
            Thread thread = this.thread;
            synchronized (thread) {
                L.fine("going to notify all...");
                this.thread.notifyAll();
                L.fine("done notifying ");
            }
        }
        this.wintabAccess.setEnabled(!paused);
        L.fine("end");
    }

    public static class Constructor
    extends AbstractPenProvider.AbstractConstructor {
        public String getName() {
            return "Wintab";
        }

        public boolean constructable(PenManager penManager) {
            return System.getProperty("os.name").toLowerCase().contains("windows");
        }

        public PenProvider constructProvider() throws Throwable {
            WintabProvider.loadLibrary();
            WintabAccess wintabAccess = new WintabAccess();
            return new WintabProvider(this, wintabAccess);
        }

        public int getNativeVersion() {
            return LIB_LOADER.nativeVersion;
        }

        public int getNativeBuild() {
            WintabProvider.loadLibrary();
            return WintabAccess.getNativeBuild();
        }

        public int getExpectedNativeBuild() {
            return Integer.valueOf(Utils.getModuleProperties().getString("jpen.provider.wintab.nativeBuild"));
        }
    }
}

